/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.table.ColumnFactory;
import org.jdesktop.swingx.table.TableColumnExt;

public class CustomColumnFactory
extends ColumnFactory {
    List<Object> excludes;
    List<Object> hidden;
    private StringValue titleStringValue;

    public void addExcludeNames(Object ... names) {
        for (Object object : names) {
            this.getExcludeNames().add(object);
        }
    }

    public void addHiddenNames(Object ... names) {
        for (Object object : names) {
            this.getHiddenNames().add(object);
        }
    }

    public void setTitleStringValue(StringValue sv) {
        this.titleStringValue = sv;
    }

    @Override
    public TableColumnExt createAndConfigureTableColumn(TableModel model, int modelIndex) {
        if (this.getExcludeNames().contains(model.getColumnName(modelIndex))) {
            return null;
        }
        return super.createAndConfigureTableColumn(model, modelIndex);
    }

    @Override
    public void configureTableColumn(TableModel model, TableColumnExt columnExt) {
        super.configureTableColumn(model, columnExt);
        columnExt.setIdentifier(model.getColumnName(columnExt.getModelIndex()));
        this.beautifyColumnTitle(columnExt);
        if (this.getHiddenNames().contains(columnExt.getIdentifier())) {
            columnExt.setVisible(false);
        }
    }

    @Override
    protected int getRowCount(JXTable table) {
        if (table.getClientProperty("ColumnFactory.maxRowCount") instanceof Integer) {
            return Math.min(table.getRowCount(), (Integer)table.getClientProperty("ColumnFactory.maxRowCount"));
        }
        return super.getRowCount(table);
    }

    private void beautifyColumnTitle(TableColumnExt columnExt) {
        if (this.titleStringValue != null) {
            columnExt.setTitle(this.titleStringValue.getString(columnExt.getTitle()));
        }
    }

    private List<Object> getExcludeNames() {
        if (this.excludes == null) {
            this.excludes = new ArrayList<Object>();
        }
        return this.excludes;
    }

    private List<Object> getHiddenNames() {
        if (this.hidden == null) {
            this.hidden = new ArrayList<Object>();
        }
        return this.hidden;
    }
}

