/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.plaf.basic.BasicMonthViewUI;
import org.jdesktop.swingx.plaf.basic.CalendarHeaderHandler;
import org.jdesktop.swingx.plaf.basic.CalendarRenderingHandler;
import org.jdesktop.swingx.plaf.basic.DemoCalendarRenderingHandler;

public class DemoMonthViewUI
extends BasicMonthViewUI {
    public static final String RENDERING_HANDLER_KEY = "monthView.renderingHandler";
    public static final String RENDERING_HANDLER_CLASS_NAME_KEY = "monthView.renderingHandlerClassName";

    @Override
    protected CalendarRenderingHandler createRenderingHandler() {
        Object handler;
        String handlerClass = null;
        if (this.monthView != null && (handler = this.monthView.getClientProperty(RENDERING_HANDLER_KEY)) instanceof CalendarRenderingHandler) {
            return (CalendarRenderingHandler)handler;
        }
        handlerClass = UIManager.getString(RENDERING_HANDLER_CLASS_NAME_KEY);
        if (handlerClass != null) {
            try {
                Class<?> clazz = Class.forName(handlerClass);
                return (CalendarRenderingHandler)clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new DemoCalendarRenderingHandler();
    }

    @Override
    protected CalendarHeaderHandler createCalendarHeaderHandler() {
        Object handler;
        if (this.monthView != null && (handler = this.monthView.getClientProperty("CalendarHeaderHandler")) instanceof CalendarHeaderHandler) {
            return (CalendarHeaderHandler)handler;
        }
        return super.createCalendarHeaderHandler();
    }

    protected void updateRenderingHandler() {
        this.setRenderingHandler(this.createRenderingHandler());
        this.monthView.revalidate();
        this.monthView.repaint();
    }

    protected void updateHeaderHandler() {
        if (this.monthView.isZoomable()) {
            this.monthView.remove(this.getCalendarHeaderHandler().getHeaderComponent());
            this.getCalendarHeaderHandler().uninstall(this.monthView);
            this.setCalendarHeaderHandler(this.createCalendarHeaderHandler());
            this.getCalendarHeaderHandler().install(this.monthView);
            this.updateZoomable();
        }
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        final PropertyChangeListener r = super.createPropertyChangeListener();
        PropertyChangeListener ml = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (DemoMonthViewUI.RENDERING_HANDLER_KEY.equals(evt.getPropertyName())) {
                    DemoMonthViewUI.this.updateRenderingHandler();
                } else if ("CalendarHeaderHandler".equals(evt.getPropertyName())) {
                    DemoMonthViewUI.this.updateHeaderHandler();
                } else {
                    r.propertyChange(evt);
                }
            }
        };
        return ml;
    }

    public static ComponentUI createUI(JComponent c) {
        return new DemoMonthViewUI();
    }
}

