/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import jv.number.PdColor;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.objectGui.PsScanline;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvCameraIf;
import jv.project.PvDisplayIf;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.rsrc.PsJavaView;
import jv.vecmath.P_Vector;
import jv.vecmath.PdBary;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuProj;
import jv.vecmath.PuVectorGeom;
import jv.viewer.PvCamera;
import jv.viewer.PvDisplay;
import jv.viewer.PvLight;
import jv.viewer.PvScene;

public final class PvGeometry
extends PgJvxSrc
implements PvGeometryIf {
    protected PvDisplayIf m_display;
    protected PgGeometryIf m_geometry;
    private int m_maxSizeOfElements;
    protected static int PS_ZOOM = 1;
    private int m_offFac = 1;
    private static final int SCALE_COL_EXP = 16;
    private static final int SCALE_COL_VAL = 65536;
    private static final int SCALE_TEX_EXP = 20;
    private static final int SCALE_TEX_VAL = 0x100000;
    protected int m_sceneZFac = 1;
    protected boolean m_bSpecial = false;
    protected Color m_backColor;
    protected boolean m_bShowEdgeAura;
    protected int m_drawingOrder = 0;
    protected PdVector[] m_bndBox;
    protected PiVector[] m_bndBoxTrans;
    protected Color m_globalBndboxColor;
    protected PiVector m_centerTrans;
    private int m_dimTrans;
    protected int m_dimOfColors;
    protected int m_pickedVertex;
    protected int m_pickedPolygon;
    protected int m_pickedElement;
    protected int[] m_texturePix;
    protected int m_textureWidth;
    protected int m_textureHeight;
    private int m_textureTilingWidth;
    private int m_textureTilingHeight;
    protected int m_textureDepth = 256;
    protected boolean m_bEnableZBuffer;
    protected PiVector[] m_faceTextureBnd;
    protected PiVector[] m_faceDestBnd;
    protected int[][] m_colDestBnd;
    protected int[][] m_lightDestBnd;
    protected PiVector m_bndIdentifier;
    private int m_imgWidth;
    private int m_imgHeight;
    protected int m_alpha;
    protected static int m_alphaOpaque = -16777216;
    protected static int m_alphaTransp = 0;
    protected int m_iTransparency;
    protected int m_locTransparencyOrig;
    protected boolean m_bShowLocTransparency;
    protected boolean m_bShowLocTransparencyOrig;
    protected boolean m_bShowVectors;
    private boolean m_bHasTaggedVertices;
    protected int m_numPolygonEdges;
    protected boolean m_bHasTaggedPolygons;
    protected boolean m_bHasTaggedEdges;
    protected boolean m_bHasTaggedBoundaries;
    protected boolean m_bHasTaggedElements;
    private boolean m_bHasNeighbours;
    protected PiVector[] m_vertexTrans;
    protected PiVector[] m_vertexNormalTrans;
    protected PiVector[] m_elementNormalTrans;
    protected PiVector[][] m_vectorTrans;
    protected boolean m_useVertices;
    protected boolean m_useUnusedVertices;
    protected boolean m_useElements;
    protected boolean m_usePolygons;
    private Color[] m_vertexColorFromElement;
    private int[] m_xv;
    private int[] m_yv;
    private int[] m_zv;
    protected PdVector[] m_clipBounds;
    private PdVector[] m_vd;
    private PdVector[] m_vdClip;
    private int[][] m_cv;
    private int[][] m_cvClip;
    private int[][] m_lv;
    private int[][] m_lvTmp;
    private int[][] m_lvClip;
    private PiVector[] m_tvClip;
    private int[] m_origInd;
    private int[] m_origIndClip;
    private double[] m_tPos;
    private int[] m_cd;
    private int[] m_cdInc;
    private int[] m_ld;
    private int[] m_ldInc;
    private int[] m_td;
    private int[] m_tdInc;
    private boolean m_bShowSmoothShading;
    protected boolean m_bShowLighting = false;
    private boolean m_bLocShowSmoothLighting;
    private boolean m_bLocShowSmoothElementColors;
    private boolean m_bLocShowElementColorFromVertices;
    private boolean m_bLocShowEdgeColorFromVertices;
    private int m_grey = 200;
    private boolean m_bElemIsClipped;
    private int[] m_pixData;
    protected boolean m_bShowDepthcue;
    protected boolean m_bShowEdgeOnce;
    protected boolean m_bIsClippable;
    protected boolean m_bEnableClip;
    protected boolean m_bEnableClipBounds;
    protected boolean m_bEnableClipCamera;
    protected double m_clipFar;
    protected double m_clipNear;
    protected PvScene m_scene;
    protected Dimension m_dispSize;
    protected Dimension m_dispSizePS_ZOOM;
    private float m_heightFac;
    private float m_itemHeight;
    private PdVector m_vt;
    private PdVector m_vtSrc;
    private PdVector m_vtMod;
    private PdVector m_vtTipMod;
    private PdVector m_vnMod;
    private PdVector m_vlMod;
    private PdVector vtMod1;
    private PdVector vtSrc1;
    private PdVector vtSrc;
    private boolean m_bUseVertexNormals;
    private boolean m_bUseElementNormals;
    private boolean m_bUseElementCenters;
    private PdVector[] m_elemCenter;
    private PiVector[] m_elemCenterTrans;
    protected int[][] m_tpBuffer;
    protected int[][] m_colBuffer;
    protected int[][] m_zBuffer;
    protected boolean m_bEnable3DLook = false;
    protected boolean m_bAdaptiveSize = false;
    private boolean[] m_bCreaseEdge;
    private boolean m_bHasCreaseEdge = false;
    private PiVector m_unusedVertex = new PiVector();
    private int m_numUnusedVertices = 0;
    private PiVector m_edgePolygon = new PiVector();
    private PiVector m_edgeOffset = new PiVector();
    public boolean m_bPerspectivity = false;
    protected PdVector m_cameraPos;
    protected PdVector m_cameraDir;
    private PdMatrix m_projviewMat;
    private PdMatrix m_viewMat;
    private boolean m_bModAmb;
    private static final double ROUND = 0.3;
    private int[] m_position = null;
    protected int m_zMin = Integer.MAX_VALUE;
    protected int m_zMax = Integer.MIN_VALUE;
    private int[] m_c1d = new int[3];
    private int[] m_c2d = new int[3];
    private int m_outCol = Color.black.getRGB();
    private static final int m_colorWhite = Color.white.getRGB();
    private transient Image m_imageString;
    private transient Graphics m_gImageString;
    private int m_defWidthString;
    private int m_defHeightString;
    private int m_widthString;
    private int m_heightString;
    private transient PixelGrabber m_pgString;
    private transient int[] m_pixString;
    private int[] m_xvSub;
    private int[] m_yvSub;
    private int[] m_zvSub;
    private int[][] m_cvSub;
    private int[][] m_lvSub;
    private PiVector[] m_tvSub;
    private int[][] m_elemSub;
    private int[] m_indVec;
    private PdVector[] m_currVertexArr;
    private double[] m_angleArr;
    private boolean m_bShowCurrElement = false;
    private boolean m_bShowCurrEdge = false;
    private boolean m_bDrawingEdge = false;
    private boolean m_bHasEdgeColors = false;
    private boolean m_bDepthcueEdge = false;
    private boolean m_bUse_m_heightFac = false;
    private PiVector[] m_tv;
    protected boolean m_bShowTexture = false;
    protected boolean m_bUseTexture;
    protected boolean m_bAutoClip = true;
    protected int m_autoClip = 0;
    private double[] m_bary;
    private double[] m_baryDelta;
    private boolean m_bIsTaggedElement = false;
    private boolean m_bIsBackface = true;
    private boolean m_bHasHighlight = false;
    protected PvLight[] m_light;
    protected PvCameraIf m_camera = null;
    protected int[] m_specular = new int[3];
    private int[] m_color = new int[3];
    private int[] m_matCol = new int[3];
    protected int[] m_lightAttMat = new int[3];
    protected int[] m_lightAttSpec = new int[3];
    private PdVector m_vertexEye = new PdVector(3);
    private PdVector m_halfVector = new PdVector(3);
    private int m_currElementCol = -16777216;
    private int m_currEdgeCol = -16777216;
    private static final int m_colMark = -33554432;
    private static final int NNW = 1;
    private static final int NWW = 2;
    private static final int SWW = 3;
    private static final int SSW = 4;
    private static final int SSE = 5;
    private static final int SEE = 6;
    private static final int NEE = 7;
    private static final int NNE = 8;
    private int[][] m_cvTmp;
    private int[] m_cvTmpOne;
    private int[] m_cvTmpTwo;
    private int m_zTol = 5 * PvCamera.Z_STRETCH_FAC;
    private int m_zTolFace = -10 * PvCamera.Z_STRETCH_FAC;
    private int m_zTolLine = -30 * PvCamera.Z_STRETCH_FAC;
    private int m_zTolVertex = -60 * PvCamera.Z_STRETCH_FAC;
    private int[] m_rgb;
    private int[] m_poss;
    private int[] m_xCorner = new int[4];
    private int[] m_yCorner = new int[4];
    private int[] m_zCorner = new int[4];
    protected boolean m_bDirtyClipping = false;
    protected boolean m_bFastClipping = false;
    protected boolean m_bFastScanline = false;
    PdVector m_currVertex = null;
    PdVector m_currNormal = null;
    PdVector m_sphNormal = new PdVector(3);
    PdVector m_camPos3D = null;
    PdVector m_camView3D = null;
    PdVector m_camUp3D = null;
    PdVector m_camHor3D = new PdVector(3);
    int m_cx = 0;
    int m_cy = 0;
    int m_cSize = 1;
    protected int m_z3DLookFac = 0;
    private short[][] m_heightArr = null;
    private int m_cacheRadius = 256;
    protected boolean m_bElementDrawn = false;
    private PdVector m_tmpNormal = new PdVector(3);
    private PdVector edgeB;
    private PdVector edgeC;
    protected boolean m_bLightsSymmetric = true;
    static boolean bDebug = false;

    public PvGeometry(int n) {
        super(n);
        if (PsConfig.getOSId() == 0) {
            this.m_defWidthString = 30;
            this.m_defHeightString = 25;
        } else {
            this.m_defWidthString = 90;
            this.m_defHeightString = 31;
        }
        this.m_widthString = this.m_defWidthString;
        this.m_heightString = this.m_defHeightString;
        this.m_dimTrans = 3;
        this.m_dimOfColors = 3;
        this.vtSrc1 = new PdVector(this.m_dim + 1);
        this.vtSrc = new PdVector(this.m_dim);
        this.vtMod1 = new PdVector(this.m_dimTrans + 1);
        this.m_cameraPos = new PdVector(this.m_dimTrans);
        this.m_cameraDir = new PdVector(this.m_dimTrans);
        this.setMaxSizeElements(6);
        this.m_vtSrc = new PdVector(this.m_dim);
        this.m_vtMod = new PdVector(this.m_dimTrans);
        this.m_vtTipMod = new PdVector(this.m_dimTrans);
        this.m_vnMod = new PdVector(this.m_dimTrans);
        this.m_vlMod = new PdVector(this.m_dimTrans);
        this.m_vt = new PdVector(this.m_dimTrans + 1);
        this.m_bShowBackface = true;
        this.m_bShowDepthcue = true;
        this.m_bShowEdgeOnce = true;
        this.m_bIsClippable = true;
        this.m_bEnableClip = false;
        this.m_bEnableClipBounds = false;
        this.m_bEnableClipCamera = false;
        this.m_clipFar = Double.NEGATIVE_INFINITY;
        this.m_clipNear = Double.MAX_VALUE;
        this.m_bEnableZBuffer = false;
        this.m_bUseElementNormals = false;
        this.m_bUseElementCenters = false;
        this.init();
    }

    public void init() {
        super.init();
        this.m_useVertices = true;
        this.m_useElements = true;
        this.m_bHasNeighbours = false;
        this.m_bShowLocTransparency = false;
        this.m_alpha = m_alphaOpaque;
        this.m_iTransparency = 0;
        this.m_bHasTaggedVertices = false;
        this.m_bHasTaggedPolygons = false;
        this.m_bHasTaggedEdges = false;
        this.m_bHasTaggedBoundaries = false;
        this.m_bHasTaggedElements = false;
        this.m_bHasEdgeColors = false;
        this.m_vertexTrans = null;
        this.m_vertexNormalTrans = null;
        this.m_elementNormalTrans = null;
        this.m_vectorTrans = null;
        this.m_globalBndboxColor = Color.magenta;
        this.m_bndBox = PdVector.realloc(this.m_bndBox, 2, this.m_dim);
        this.m_bndBox[0].setConstant(-1.0);
        this.m_bndBox[1].setConstant(1.0);
        this.m_centerTrans = new PiVector(this.m_dimTrans);
    }

    protected void setMaxSizeElements(int n) {
        this.m_maxSizeOfElements = n;
        this.m_xv = new int[this.m_maxSizeOfElements];
        this.m_yv = new int[this.m_maxSizeOfElements];
        this.m_zv = new int[this.m_maxSizeOfElements];
        this.m_cvTmp = new int[this.m_maxSizeOfElements][];
        this.m_elemSub = new int[this.m_maxSizeOfElements][3];
        this.m_indVec = new int[this.m_maxSizeOfElements];
        this.m_angleArr = new double[this.m_maxSizeOfElements];
        this.assureClip(this.m_bEnableClip);
        boolean bl = this.m_bShowLighting;
        this.setEnabledLighting(false);
        this.setEnabledLighting(bl);
        if (this.m_tv != null) {
            this.assureTexture(true);
        }
        this.m_vd = PdVector.realloc(null, this.m_maxSizeOfElements, this.m_dimTrans);
        this.m_cv = new int[this.m_maxSizeOfElements][3];
        this.m_origInd = new int[this.m_maxSizeOfElements];
    }

    protected void assureTexture(boolean bl) {
        if (!bl) {
            this.m_tv = null;
            this.m_tvSub = null;
            this.m_faceTextureBnd = null;
            this.m_td = null;
            this.m_tdInc = null;
            this.m_rgb = null;
            this.m_poss = null;
        } else {
            this.m_tv = PiVector.realloc(this.m_tv, this.m_maxSizeOfElements, this.m_dimOfTextures + 1);
            this.m_tvSub = new PiVector[3];
            if (this.m_dispSize != null) {
                int n = (this.m_dispSize.height + this.m_dispSize.width) * 2;
                this.m_faceTextureBnd = PiVector.realloc(this.m_faceTextureBnd, n, this.m_dimOfTextures + 1);
            }
            this.m_td = new int[3];
            this.m_tdInc = new int[3];
            this.m_rgb = new int[3];
            this.m_poss = new int[8];
        }
    }

    private void assureClip(boolean bl) {
        this.m_bEnableClip = bl;
        if (!bl) {
            this.m_vdClip = null;
            this.m_cvClip = null;
            this.m_origIndClip = null;
            this.m_tvClip = null;
            this.m_lvClip = null;
        } else {
            this.m_vdClip = PdVector.realloc(null, this.m_maxSizeOfElements, this.m_dimTrans);
            this.m_cvClip = new int[this.m_maxSizeOfElements][3];
            this.m_origIndClip = new int[this.m_maxSizeOfElements];
            this.m_tvClip = PiVector.realloc(null, this.m_maxSizeOfElements, this.m_dimOfTextures + 1);
            this.m_lvClip = new int[this.m_maxSizeOfElements][6];
        }
    }

    protected void setEnabledClipBounds(boolean bl) {
        if (this.m_bEnableClipBounds == bl) {
            return;
        }
        this.m_bEnableClipBounds = bl;
        this.assureClip(this.m_bEnableClipBounds || this.m_bEnableClipCamera);
        if (!bl) {
            this.m_clipBounds = null;
            this.m_tPos = null;
        } else {
            this.m_clipBounds = PdVector.realloc(null, 2, this.m_dimTrans);
            this.m_tPos = new double[2];
        }
    }

    protected void setEnabledClipCamera(boolean bl) {
        if (this.m_bEnableClipCamera == bl) {
            return;
        }
        this.m_bEnableClipCamera = bl;
        this.assureClip(this.m_bEnableClipBounds || this.m_bEnableClipCamera);
    }

    protected void setEnabledLighting(boolean bl) {
        if (this.m_dim > 3) {
            bl = false;
        }
        this.m_bShowLighting = bl;
        if (bl) {
            this.m_lv = new int[this.m_maxSizeOfElements][6];
            this.m_lvTmp = new int[this.m_maxSizeOfElements][];
            this.m_lvSub = new int[6][];
        } else {
            this.m_lv = null;
            this.m_lvTmp = null;
            this.m_lvSub = null;
        }
        if (this.m_usePolygons) {
            this.m_bShowLighting = this.m_bShowLighting && (this.m_polygonNormal != null || this.m_vertexNormal != null || this.m_bEnable3DLook);
            this.m_bLocShowSmoothLighting = this.m_bLocShowSmoothLighting && (this.m_polygonNormal != null || this.m_vertexNormal != null);
        } else if (!this.m_useElements) {
            this.m_bShowLighting = this.m_bShowLighting && this.m_vertexNormal != null;
            this.m_bLocShowSmoothLighting = false;
        }
    }

    protected void setLights(PvLight[] pvLightArray) {
        this.m_light = pvLightArray;
        this.m_bHasHighlight = false;
        if (this.m_light == null || this.m_light.length == 0) {
            return;
        }
        for (int i = 0; i < this.m_light.length; ++i) {
            if (!this.m_light[i].m_bSwitchedOn || !pvLightArray[i].isHighlight()) continue;
            this.m_bHasHighlight = true;
            break;
        }
    }

    public void setDimOfVertices(int n) {
        if (this.m_dim == n) {
            return;
        }
        super.setDimOfVertices(n);
        this.m_bndBox = PdVector.realloc(this.m_bndBox, 2, this.m_dim);
        if (this.m_bUseElementCenters) {
            this.m_elemCenter = PdVector.realloc(this.m_elemCenter, this.m_numElements, this.m_dim);
        }
        if (this.vtSrc1 != null) {
            this.vtSrc1.setSize(this.m_dim + 1);
        }
        if (this.vtSrc != null) {
            this.vtSrc.setSize(this.m_dim);
        }
        if (this.m_vtSrc != null) {
            this.m_vtSrc.setSize(this.m_dim);
        }
    }

    public boolean setLabelAttributes(PiVector[] piVectorArray) {
        PiVector.copy(this.m_labelAttribute, 0, piVectorArray, 0, piVectorArray.length);
        return true;
    }

    public void setLabelColors(Color[] colorArray) {
        if (colorArray == null || colorArray.length < 7) {
            PsDebug.warning("missing font colors");
            return;
        }
        for (int i = 0; i < 7; ++i) {
            this.m_labelColor[i] = colorArray[i];
        }
    }

    public void setLabelSizes(PdVector pdVector) {
        if (pdVector == null || pdVector.getSize() < 7) {
            PsDebug.warning("missing font sizes");
            return;
        }
        this.m_labelSize.copyArray(pdVector);
    }

    public void setLabelStyles(PiVector piVector) {
        if (piVector == null || piVector.getSize() < 7) {
            PsDebug.warning("missing font styles");
            return;
        }
        this.m_labelStyle.copyArray(piVector);
    }

    public void setLabelFonts(String[] stringArray) {
        if (stringArray == null || stringArray.length < 7) {
            PsDebug.warning("missing font names");
            return;
        }
        for (int i = 0; i < 7; ++i) {
            this.m_labelFont[i] = stringArray[i];
        }
    }

    protected void setDisplay(PvDisplayIf pvDisplayIf) {
        this.m_display = pvDisplayIf;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.m_geometry != null && this.m_geometry.isVisible() != bl) {
            this.m_geometry.setVisible(bl);
        }
    }

    public int getDrawingOrder() {
        return this.m_drawingOrder;
    }

    public void setDrawingOrder(int n) {
        this.m_drawingOrder = n;
    }

    public boolean isSpecial() {
        return this.m_bSpecial;
    }

    public void setSpecial(boolean bl) {
        this.m_bSpecial = bl;
    }

    public void setGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            PsDebug.warning("missing geometry");
            return;
        }
        this.m_geometry = pgGeometryIf;
        this.setType(this.m_geometry.getType());
        this.setName(pgGeometryIf.getName() + "_" + PsConfig.getMessage(15024));
        this.update(this.m_geometry);
    }

    public PgGeometryIf getGeometry() {
        return this.m_geometry;
    }

    public boolean getState(int n) {
        switch (n) {
            case 50: {
                return this.m_bShowVertices;
            }
            case 69: {
                return this.m_bShowBndBox;
            }
            case 75: {
                return this.m_bShowLocTransparency;
            }
            case 100: {
                return this.m_bShowSmoothShading;
            }
            case 103: {
                return this.m_bLocShowSmoothLighting;
            }
        }
        return super.getState(n);
    }

    public void setState(int n, boolean bl) {
        switch (n) {
            case 85: {
                this.m_bEnabledIndexLabels = bl;
                break;
            }
            case 87: {
                this.m_bShowTitle = bl;
                if (!this.m_bShowTitle) break;
                this.m_bndBoxTrans = PiVector.realloc(this.m_bndBoxTrans, 2, this.m_dimTrans);
                break;
            }
            case 86: {
                this.m_bShowName = bl;
                if (!this.m_bShowName) break;
                this.m_bndBoxTrans = PiVector.realloc(this.m_bndBoxTrans, 2, this.m_dimTrans);
                break;
            }
            case 80: {
                this.m_bShowIndices = bl;
                break;
            }
            case 69: {
                this.m_bShowBndBox = bl;
                break;
            }
            case 70: {
                this.m_bShowCenter = bl;
                break;
            }
            case 50: {
                this.m_bShowVertices = bl;
                break;
            }
            case 51: {
                this.m_bShowTaggedVertices = bl;
                break;
            }
            case 91: {
                this.m_bShowVertexColors = bl;
                break;
            }
            case 81: {
                this.m_bShowVertexLabels = bl;
                break;
            }
            case 60: {
                this.m_bShowVertexNormals = bl;
                break;
            }
            case 61: {
                this.m_bShowVertexNormalArrow = bl;
                break;
            }
            case 99: {
                this.m_bShowVertexOutline = bl;
                break;
            }
            case 76: {
                this.m_bShowVertexSizes = bl;
                break;
            }
            case 71: {
                this.m_bShowVertexTexture = bl;
                break;
            }
            case 54: {
                this.m_bShowPolygons = bl;
                break;
            }
            case 55: {
                this.m_bShowTaggedPolygons = bl;
                break;
            }
            case 93: {
                this.m_bShowPolygonColors = bl;
                break;
            }
            case 82: {
                this.m_bShowPolygonLabels = bl;
                break;
            }
            case 64: {
                this.m_bShowPolygonNormals = bl;
                break;
            }
            case 65: {
                this.m_bShowPolygonNormalArrow = bl;
                break;
            }
            case 89: {
                this.m_bShowPolygonStartArrow = bl;
                break;
            }
            case 90: {
                this.m_bShowPolygonEndArrow = bl;
                break;
            }
            case 108: {
                this.m_bShowPolygonSizes = bl;
                break;
            }
            case 52: {
                this.m_bShowEdges = bl;
                break;
            }
            case 53: {
                this.m_bShowTaggedEdges = bl;
                break;
            }
            case 94: {
                this.m_bShowEdgeColors = bl;
                break;
            }
            case 104: {
                this.m_bShowSmoothEdgeColors = bl;
                break;
            }
            case 95: {
                this.m_bShowEdgeColorFromElements = bl;
                break;
            }
            case 96: {
                this.m_bLocShowEdgeColorFromVertices = bl;
                break;
            }
            case 83: {
                this.m_bShowEdgeLabels = bl;
                break;
            }
            case 97: {
                this.m_bShowEdgeSizes = bl;
                break;
            }
            case 56: {
                this.m_bShowElements = bl;
                break;
            }
            case 57: {
                this.m_bShowTaggedElements = bl;
                break;
            }
            case 98: {
                this.m_bShowElementColors = bl;
                break;
            }
            case 105: {
                this.m_bLocShowSmoothElementColors = bl;
                break;
            }
            case 106: {
                this.m_bLocShowElementColorFromVertices = bl;
                break;
            }
            case 101: {
                this.m_bShowElementBackColor = bl;
                break;
            }
            case 102: {
                this.m_bShowElementBackColors = bl;
                break;
            }
            case 84: {
                this.m_bShowElementLabels = bl;
                break;
            }
            case 62: {
                this.m_bShowElementNormals = bl;
                break;
            }
            case 63: {
                this.m_bShowElementNormalArrow = bl;
                break;
            }
            case 72: {
                this.m_bShowElementTexture = bl;
                break;
            }
            case 68: {
                this.m_bShowBackface = bl;
                break;
            }
            case 75: {
                this.m_bShowLocTransparency = bl;
                this.m_bShowLocTransparencyOrig = bl;
                break;
            }
            case 103: {
                this.m_bLocShowSmoothLighting = bl;
                if (!this.m_bLocShowSmoothLighting) break;
                this.m_ld = new int[6];
                this.m_ldInc = new int[6];
                break;
            }
            case 58: {
                this.m_bShowBoundaries = bl;
                break;
            }
            case 59: {
                this.m_bShowTaggedBoundaries = bl;
                break;
            }
            case 88: {
                this.m_bShowSilhouette = bl;
                break;
            }
            case 107: {
                this.m_bHasNeighbours = bl;
                break;
            }
            case 100: {
                this.m_bShowSmoothShading = bl;
                break;
            }
            default: {
                super.setState(n, bl);
            }
        }
        if (this.m_bShowSmoothShading || this.m_bShowSmoothEdgeColors || this.m_bLocShowSmoothElementColors) {
            this.m_cd = new int[3];
            this.m_cdInc = new int[3];
            this.m_cvTmpOne = new int[3];
            this.m_cvTmpTwo = new int[3];
        }
    }

    public void setStateFromDisplay(int n, boolean bl) {
        if (this.m_geometry == null) {
            return;
        }
        switch (n) {
            case 50: {
                break;
            }
            default: {
                PsDebug.warning("invalid key = " + n);
            }
        }
        this.setState(n, bl);
        this.m_geometry.setState(n, bl);
    }

    public PdVector[] getBounds(boolean bl) {
        int n;
        boolean bl2;
        if (this.m_numVertices == 0) {
            return null;
        }
        PdVector[] pdVectorArray = super.getBounds();
        this.m_bndBox[0].copyArray(pdVectorArray[0]);
        this.m_bndBox[1].copyArray(pdVectorArray[1]);
        boolean bl3 = this.hasModelMatrix();
        boolean bl4 = this.hasAmbientMatrix();
        boolean bl5 = bl2 = bl3 || bl4 || this.m_ambientSpace != 3 && this.m_ambientSpace != 1;
        if (!bl2) {
            return pdVectorArray;
        }
        PdVector pdVector = (PdVector)pdVectorArray[0].clone();
        PdVector pdVector2 = (PdVector)pdVectorArray[1].clone();
        pdVector.setConstant(Double.MAX_VALUE);
        pdVector2.setConstant(Double.NEGATIVE_INFINITY);
        this.m_vt.setConstant(0.0);
        for (n = 0; n < this.m_numVertices; ++n) {
            if (bl2) {
                this.m_vtSrc.copyArray(this.m_vertex[n]);
                this.project(this.m_vtMod, this.m_vtSrc, this.m_modelMatrix, this.m_ambientMatrix);
            } else {
                this.m_vtMod.copyArray(this.m_vertex[n]);
            }
            for (int i = 0; i < this.m_dimTrans; ++i) {
                if (pdVector.m_data[i] > this.m_vtMod.m_data[i]) {
                    pdVector.m_data[i] = this.m_vtMod.m_data[i];
                }
                if (!(pdVector2.m_data[i] < this.m_vtMod.m_data[i])) continue;
                pdVector2.m_data[i] = this.m_vtMod.m_data[i];
            }
        }
        for (n = this.m_dimTrans - 1; n >= this.m_dim; --n) {
            this.m_bndBox[0].setEntry(n, 0.0);
            this.m_bndBox[1].setEntry(n, 0.0);
        }
        return new PdVector[]{pdVector, pdVector2};
    }

    protected int getNumTaggedVertices() {
        int n = 0;
        for (int i = 0; i < this.m_numVertices; ++i) {
            if (!this.m_vertex[i].hasTag(1)) continue;
            ++n;
        }
        return n;
    }

    protected PiVector getTaggedVertices() {
        int n = this.getNumTaggedVertices();
        if (n == 0) {
            return null;
        }
        PiVector piVector = new PiVector(n);
        n = 0;
        for (int i = 0; i < this.m_numVertices; ++i) {
            if (!this.m_vertex[i].hasTag(1)) continue;
            piVector.setEntry(n++, i);
        }
        return piVector;
    }

    protected int pickVertex(Rectangle rectangle, int n) {
        this.m_pickedVertex = -1;
        for (int i = 0; i < this.m_numVertices; ++i) {
            if (!rectangle.contains(this.m_vertexTrans[i].m_data[0], this.m_vertexTrans[i].m_data[1])) continue;
            PsDebug.notify("You selected vertex no. " + i);
            if (!this.m_bInstanceSharing) {
                this.m_vertex[i].setTag(n);
            }
            this.m_geometry.setTagVertex(i, n);
            this.m_bHasTaggedVertices = true;
            this.m_pickedVertex = i;
            return this.m_pickedVertex;
        }
        return -1;
    }

    protected int releaseVertex(int n, int n2) {
        if (0 <= n && n < this.m_numVertices) {
            if (!this.m_bInstanceSharing) {
                this.m_vertex[n].clearTag(n2);
            }
            this.m_geometry.clearTagVertex(n, n2);
        }
        this.m_pickedVertex = -1;
        return -1;
    }

    protected boolean tagVertices(Rectangle rectangle, int n) {
        for (int i = 0; i < this.m_numVertices; ++i) {
            if (!rectangle.contains(this.m_vertexTrans[i].m_data[0], this.m_vertexTrans[i].m_data[1])) continue;
            PsDebug.notify("You selected vertex no. " + i);
            if (!this.m_bInstanceSharing) {
                this.m_vertex[i].setTag(n);
            }
            this.m_geometry.setTagVertex(i, n);
        }
        return true;
    }

    protected boolean untagVertices(Rectangle rectangle) {
        for (int i = 0; i < this.m_numVertices; ++i) {
            if (!rectangle.contains(this.m_vertexTrans[i].m_data[0], this.m_vertexTrans[i].m_data[1])) continue;
            PsDebug.notify("You unselected vertex no. " + i);
            if (!this.m_bInstanceSharing) {
                this.m_vertex[i].clearTag(1);
                this.m_vertex[i].clearTag(12);
                this.m_vertex[i].clearTag(11);
            }
            this.m_geometry.clearTagVertex(i, 1);
            this.m_geometry.clearTagVertex(i, 12);
            this.m_geometry.clearTagVertex(i, 11);
        }
        return true;
    }

    protected boolean untagAllVertices() {
        for (int i = 0; i < this.m_numVertices; ++i) {
            if (!this.m_bInstanceSharing) {
                this.m_vertex[i].clearTag(1);
                this.m_vertex[i].clearTag(12);
                this.m_vertex[i].clearTag(11);
            }
            this.m_geometry.clearTagVertex(i, 1);
            this.m_geometry.clearTagVertex(i, 12);
            this.m_geometry.clearTagVertex(i, 11);
        }
        return true;
    }

    protected void tagPolygons(Rectangle rectangle) {
        int n = this.getNumPolygons();
        if (n == 0) {
            return;
        }
        block0: for (int i = 0; i < n; ++i) {
            int n2 = this.m_polygon[i].getSize();
            for (int j = 0; j < n2; ++j) {
                int n3 = this.m_polygon[i].m_data[j];
                if (!rectangle.contains(this.m_vertexTrans[n3].m_data[0], this.m_vertexTrans[n3].m_data[1])) continue;
                if (!this.m_bInstanceSharing) {
                    this.m_polygon[i].setTag(1);
                }
                this.m_geometry.setTagPolygon(i, 1);
                continue block0;
            }
        }
    }

    protected int pickPolygon(int n, int n2) {
        if (0 <= n && n < this.m_numPolygons) {
            if (!this.m_bInstanceSharing) {
                this.m_polygon[n].setTag(n2);
            }
            this.m_geometry.setTagPolygon(n, n2);
        }
        this.m_pickedPolygon = n;
        return this.m_pickedPolygon;
    }

    protected int releasePolygon(int n, int n2) {
        if (0 <= n && n < this.m_numPolygons) {
            if (!this.m_bInstanceSharing) {
                this.m_polygon[n].clearTag(n2);
            }
            this.m_geometry.clearTagPolygon(n, n2);
        }
        this.m_pickedPolygon = -1;
        return -1;
    }

    protected void untagPolygons(Rectangle rectangle) {
        int n = this.getNumPolygons();
        if (n == 0) {
            return;
        }
        block0: for (int i = 0; i < n; ++i) {
            if (!this.m_polygon[i].hasTag(1)) continue;
            int n2 = this.m_polygon[i].getSize();
            for (int j = 0; j < n2; ++j) {
                int n3 = this.m_polygon[i].m_data[j];
                if (!rectangle.contains(this.m_vertexTrans[n3].m_data[0], this.m_vertexTrans[n3].m_data[1])) continue;
                if (!this.m_bInstanceSharing) {
                    this.m_polygon[i].clearTag(1);
                    this.m_polygon[i].clearTag(12);
                    this.m_polygon[i].clearTag(11);
                }
                this.m_geometry.clearTagPolygon(i, 1);
                this.m_geometry.clearTagPolygon(i, 12);
                this.m_geometry.clearTagPolygon(i, 11);
                continue block0;
            }
        }
    }

    protected void tagElements(Rectangle rectangle) {
        int n = this.getNumElements();
        if (n == 0) {
            return;
        }
        block0: for (int i = 0; i < n; ++i) {
            int n2 = this.m_element[i].getSize();
            for (int j = 0; j < n2; ++j) {
                int n3 = this.m_element[i].m_data[j];
                if (!rectangle.contains(this.m_vertexTrans[n3].m_data[0], this.m_vertexTrans[n3].m_data[1])) continue;
                if (!this.m_bInstanceSharing) {
                    this.m_element[i].setTag(1);
                }
                this.m_geometry.setTagElement(i, 1);
                continue block0;
            }
        }
    }

    protected PvPickEvent intersectionWithLine(int n, int n2, PdVector pdVector, PdVector pdVector2, boolean bl) {
        if (this.m_dim != 2 && this.m_dim != 3) {
            return null;
        }
        if (pdVector == null || pdVector.getSize() != 3 || pdVector2 == null || pdVector2.getSize() != 3) {
            PsDebug.warning("missing or wrong dimension of ray");
            return null;
        }
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        PgGeometry.convertWorldToModel(this, pdVector, pdVector2, pdVector3, pdVector4);
        pdVector4.normalize();
        PdVector pdVector5 = new PdVector(3);
        PdVector pdVector6 = new PdVector(3);
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        PdVector pdVector7 = new PdVector(3);
        PdVector pdVector8 = this.m_dim == 2 ? new PdVector(2) : pdVector7;
        PdVector pdVector9 = new PdVector(3);
        PdBary pdBary = new PdBary(3);
        PdBary pdBary2 = new PdBary(3);
        PdVector pdVector10 = null;
        if (this.m_dim == 2) {
            pdVector10 = new PdVector(3);
        }
        PdVector[] pdVectorArray = new PdVector[this.m_maxDimOfElements];
        boolean bl2 = this.m_elementNormal != null;
        for (int i = 0; i < this.m_numElements; ++i) {
            int n6;
            int n7 = this.m_element[i].getSize();
            if (n7 < 3) continue;
            if (bl) {
                n6 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                for (int j = 0; j < n7; ++j) {
                    int n11 = this.m_element[i].m_data[j];
                    if (this.m_vertexTrans[n11].m_data[0] < n) {
                        ++n6;
                    }
                    if (this.m_vertexTrans[n11].m_data[0] > n) {
                        ++n8;
                    }
                    if (this.m_vertexTrans[n11].m_data[1] < n2) {
                        ++n9;
                    }
                    if (this.m_vertexTrans[n11].m_data[1] <= n2) continue;
                    ++n10;
                }
                if (n6 == n7 || n8 == n7 || n9 == n7 || n10 == n7) continue;
            }
            pdVectorArray[0] = this.m_vertex[this.m_element[i].m_data[0]];
            if (this.m_dim == 2) {
                pdVector10.copyArray(pdVectorArray[0]);
                pdVector5.set(0.0, 0.0, 1.0);
            } else {
                pdVector10 = pdVectorArray[0];
            }
            for (n6 = 1; n6 < n7 - 1; ++n6) {
                pdVectorArray[1] = this.m_vertex[this.m_element[i].m_data[n6]];
                pdVectorArray[2] = this.m_vertex[this.m_element[i].m_data[n6 + 1]];
                if (this.m_dim != 2) {
                    if (bl2) {
                        pdVector5 = this.m_elementNormal[i];
                    } else if (!pdVector5.normalOfPlane(pdVectorArray[0], pdVectorArray[1], pdVectorArray[2])) continue;
                }
                if ((d = PuVectorGeom.intersectionOfLineAndPlane(pdVector7, pdVector3, pdVector4, pdVector10, pdVector5)) >= d2) continue;
                if (this.m_dim == 2) {
                    pdVector8.m_data[0] = pdVector7.m_data[0];
                    pdVector8.m_data[1] = pdVector7.m_data[1];
                }
                PdBary.getBary(pdBary, pdVector8, pdVectorArray);
                if (!pdBary.isInside()) continue;
                d2 = d;
                n4 = i;
                n5 = n6;
                pdBary2.copy(pdBary);
                pdBary2.setElementInd(n4);
                pdVector6.copy(pdVector5);
                pdVector9.copy(pdVector7);
                if (Math.abs(1.0 - pdBary.getEntry(0)) < 0.1) {
                    n3 = this.m_element[i].getEntry(0);
                    continue;
                }
                if (Math.abs(1.0 - pdBary.getEntry(1)) < 0.1) {
                    n3 = this.m_element[i].getEntry(n6);
                    continue;
                }
                if (!(Math.abs(1.0 - pdBary.getEntry(2)) < 0.1)) continue;
                n3 = this.m_element[i].getEntry(n6 + 1);
            }
        }
        if (n4 == -1) {
            return null;
        }
        PvPickEvent pvPickEvent = new PvPickEvent(this.m_dim);
        pvPickEvent.setGeometry(this.getGeometry());
        pvPickEvent.setVertex(pdVector9);
        pvPickEvent.setDistance(d2);
        pvPickEvent.setHorDistance(0.0);
        pvPickEvent.setElementInd(n4);
        pvPickEvent.setElementSubInd(n5);
        pvPickEvent.setBary(pdBary2);
        pvPickEvent.setVertexInd(n3);
        pvPickEvent.setViewBase(pdVector);
        pvPickEvent.setViewDir(pdVector2);
        pvPickEvent.setNormal(pdVector6);
        return pvPickEvent;
    }

    protected int pickElement(int n, int n2) {
        if (0 <= n && n < this.m_numElements) {
            if (!this.m_bInstanceSharing) {
                this.m_element[n].setTag(n2);
            }
            this.m_geometry.setTagElement(n, n2);
        }
        this.m_pickedElement = n;
        return this.m_pickedElement;
    }

    protected int releaseElement(int n, int n2) {
        if (0 <= n && n < this.m_numElements) {
            if (!this.m_bInstanceSharing) {
                this.m_element[n].clearTag(n2);
            }
            this.m_geometry.clearTagElement(n, n2);
        }
        this.m_pickedElement = -1;
        return -1;
    }

    protected void untagElements(Rectangle rectangle) {
        int n = this.getNumElements();
        if (n == 0) {
            return;
        }
        block0: for (int i = 0; i < n; ++i) {
            if (!this.m_element[i].hasTag(1)) continue;
            int n2 = this.m_element[i].getSize();
            for (int j = 0; j < n2; ++j) {
                int n3 = this.m_element[i].m_data[j];
                if (!rectangle.contains(this.m_vertexTrans[n3].m_data[0], this.m_vertexTrans[n3].m_data[1])) continue;
                if (!this.m_bInstanceSharing) {
                    this.m_element[i].clearTag(1);
                    this.m_element[i].clearTag(12);
                    this.m_element[i].clearTag(11);
                }
                this.m_geometry.clearTagElement(i, 1);
                this.m_geometry.clearTagElement(i, 12);
                this.m_geometry.clearTagElement(i, 11);
                continue block0;
            }
        }
    }

    public void clearTagVertex(int n, int n2) {
        if (!this.m_bInstanceSharing) {
            this.m_vertex[n].clearTag(n2);
        }
        this.m_geometry.clearTagVertex(n, n2);
    }

    public boolean hasTagVertex(int n, int n2) {
        return this.m_vertex[n].hasTag(n2);
    }

    public void setTagVertex(int n, int n2) {
        if (!this.m_bInstanceSharing) {
            this.m_vertex[n].setTag(n2);
        }
        this.m_geometry.setTagVertex(n, n2);
    }

    public void clearTagPolygon(int n, int n2) {
        if (!this.m_bInstanceSharing) {
            this.m_polygon[n].clearTag(n2);
        }
        this.m_geometry.clearTagPolygon(n, n2);
    }

    public boolean hasTagPolygon(int n, int n2) {
        return this.m_polygon[n].hasTag(n2);
    }

    public void setTagPolygon(int n, int n2) {
        if (!this.m_bInstanceSharing) {
            this.m_polygon[n].setTag(n2);
        }
        this.m_geometry.setTagPolygon(n, n2);
    }

    public void clearTagElement(int n, int n2) {
        if (!this.m_bInstanceSharing) {
            this.m_element[n].clearTag(n2);
        }
        this.m_geometry.clearTagElement(n, n2);
    }

    public boolean hasTagElement(int n, int n2) {
        return this.m_element[n].hasTag(n2);
    }

    public void setTagElement(int n, int n2) {
        if (!this.m_bInstanceSharing) {
            this.m_element[n].setTag(n2);
        }
        this.m_geometry.setTagElement(n, n2);
    }

    public boolean update(Object object) {
        int n;
        Object object2;
        int n2;
        if (object != this.m_geometry) {
            return false;
        }
        PsDebug.notify("updating geometry");
        if (this.m_geometry == null) {
            PsDebug.warning("missing associated geometry");
            return false;
        }
        try {
            this.m_geometry.paint(this);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            PsDebug.outOfMemory(outOfMemoryError);
        }
        String string = this.m_geometry.getName();
        if (this.m_numPolygons > 0) {
            for (n2 = 0; n2 < this.m_numPolygons; n2 += 1) {
                object2 = this.m_polygon[n2].m_data;
                for (n = 0; n < ((int[])object2).length; ++n) {
                    if (object2[n] >= 0 && object2[n] < this.m_numVertices) continue;
                    this.m_numPolygons = 0;
                    this.m_usePolygons = false;
                    PsDebug.error("geometry[" + string + "] has polygon which refers a void vertex,\n\tpolygon[" + n2 + "].m_data[" + n + "]==" + (int)object2[n]);
                    return false;
                }
            }
        }
        if (this.m_numElements > 0) {
            for (n2 = 0; n2 < this.m_numElements; n2 += 1) {
                object2 = this.m_element[n2].m_data;
                for (n = 0; n < ((int[])object2).length; ++n) {
                    if (object2[n] >= 0 && object2[n] < this.m_numVertices) continue;
                    this.m_numElements = 0;
                    this.m_useElements = false;
                    PsDebug.error("geometry[" + string + "] has element which refers a void vertex,\n\telement[" + n2 + "].m_data[" + n + "]==" + (int)object2[n]);
                    return false;
                }
            }
        }
        if (!this.getName().startsWith(string)) {
            this.setName(string + "_Container");
        }
        this.getBounds(true);
        if (this.m_bShowTaggedVertices) {
            this.m_bHasTaggedVertices = false;
            for (n2 = 0; n2 < this.m_numVertices; n2 += 1) {
                object2 = this.m_vertex[n2];
                if (!((P_Vector)object2).hasTag(1) && !((P_Vector)object2).hasTag(11) && !((P_Vector)object2).hasTag(12) && ((P_Vector)object2).getURL() == null) continue;
                this.m_bHasTaggedVertices = true;
                break;
            }
        }
        if (this.m_bShowTaggedPolygons) {
            this.m_bHasTaggedPolygons = false;
            for (n2 = 0; n2 < this.m_numPolygons; n2 += 1) {
                object2 = this.m_polygon[n2];
                if (!((P_Vector)object2).hasTag(1) && !((P_Vector)object2).hasTag(11) && !((P_Vector)object2).hasTag(12) && ((P_Vector)object2).getURL() == null) continue;
                this.m_bHasTaggedPolygons = true;
                break;
            }
        }
        if (this.m_bShowTaggedElements) {
            this.m_bHasTaggedElements = false;
            for (n2 = 0; n2 < this.m_numElements; n2 += 1) {
                object2 = this.m_element[n2];
                if (!((P_Vector)object2).hasTag(1) && !((P_Vector)object2).hasTag(11) && !((P_Vector)object2).hasTag(12) && ((P_Vector)object2).getURL() == null) continue;
                this.m_bHasTaggedElements = true;
                break;
            }
        }
        this.m_numUnusedVertices = 0;
        if (this.m_numVertices > 0 && this.m_bShowVertices && (this.m_numElements > 0 || this.m_numPolygonEdges > 0)) {
            this.updateUnusedVertices();
        }
        this.m_useVertices = false;
        this.m_useUnusedVertices = false;
        this.m_useElements = false;
        this.m_usePolygons = false;
        this.m_bShowVectors = false;
        if (this.m_bShowVectorFields) {
            for (n2 = 0; n2 < this.m_numVectorFields; n2 += 1) {
                if (!this.m_bShowVectorField[n2]) continue;
                this.m_bShowVectors = true;
                break;
            }
        }
        if (this.m_numElements == 0 && this.m_numPolygonEdges == 0 && (this.m_bShowVertices || this.m_bShowTaggedVertices && this.m_bHasTaggedVertices || this.m_bShowVertexNormals || this.m_bShowVectors) || (this.m_numElements > 0 && !this.m_bShowElements && !this.m_bShowEdges && !this.m_bShowBoundaries && !this.m_bShowElementNormals && !this.m_bShowVectors && !this.m_bShowPolygons || this.m_numPolygonEdges > 0 && !this.m_bShowPolygons && !this.m_bShowPolygonNormals) && (this.m_bShowVertices || this.m_bShowTaggedVertices && this.m_bHasTaggedVertices || this.m_bShowVertexNormals || this.m_bShowVectors)) {
            this.m_useVertices = true;
        } else if (this.m_bShowVertices && this.m_numUnusedVertices > 0 && (this.m_numElements > 0 || this.m_numPolygonEdges > 0)) {
            this.m_useUnusedVertices = true;
        }
        if (this.m_numPolygonEdges > 0 && (this.m_bShowPolygons || this.m_bShowTaggedPolygons && this.m_bHasTaggedPolygons || this.m_bShowPolygonNormals)) {
            this.m_usePolygons = true;
        }
        if (this.m_numElements > 0 && (this.m_bShowElements || this.m_bShowEdges || this.m_bShowSilhouette || this.m_bShowBoundaries || this.m_bShowElementNormals || this.m_bShowVectors || this.m_bShowTaggedElements && this.m_bHasTaggedElements || this.m_bShowTaggedEdges && this.m_bHasTaggedEdges)) {
            this.m_useElements = true;
            if (this.m_neighbour == null || this.m_neighbour.length < this.m_numElements || this.m_neighbour[0] == null || this.m_neighbour[0].getSize() != this.m_element[0].getSize()) {
                this.m_bHasNeighbours = false;
            }
        }
        if (this.m_bShowVertexColors && this.m_vertexColor == null) {
            this.m_bShowVertexColors = false;
        }
        if (this.m_bLocShowEdgeColorFromVertices && this.m_vertexColor == null) {
            this.m_bLocShowEdgeColorFromVertices = false;
        }
        if (this.m_bLocShowElementColorFromVertices && this.m_vertexColor == null) {
            this.m_bLocShowElementColorFromVertices = false;
        }
        if (this.m_bShowPolygonColors && this.m_polygonColor == null && !this.m_bLocShowEdgeColorFromVertices) {
            this.m_bShowPolygonColors = false;
        }
        if (this.m_bShowElementColors && this.m_elementColor == null && !this.m_bLocShowElementColorFromVertices) {
            this.m_bShowElementColors = false;
        }
        if (this.m_bShowElementBackColors && this.m_elementBackColor == null) {
            this.m_bShowElementBackColors = false;
        }
        if (this.m_bShowEdgeColors && this.m_edgeColor == null && this.m_elementColor == null && this.m_vertexColor == null) {
            this.m_bShowEdgeColors = false;
        }
        boolean bl = this.m_bHasEdgeColors = this.m_edgeColor != null && this.m_elementEdge != null;
        if (this.m_bShowEdgeColorFromElements && this.m_elementColor == null) {
            this.m_bShowEdgeColorFromElements = false;
        }
        if (this.m_bShowVertexTexture && this.m_vertexTexture == null) {
            this.m_bShowVertexTexture = false;
        }
        if (this.m_bShowElementTexture && this.m_elementTexture == null) {
            this.m_bShowElementTexture = false;
        }
        this.m_bUseTexture = this.m_bShowTexture = (this.m_bShowVertexTexture || this.m_bShowElementTexture) && this.m_texturePix != null;
        this.assureTexture(this.m_bShowTexture);
        if (!(this.m_bShowBackface || this.m_elementNormal != null && this.m_elementNormal.length >= this.m_numElements)) {
            this.m_bShowBackface = true;
            PsDebug.warning("missing normals, backelement culling switched off");
        }
        if (this.m_numVertices > 0 && this.m_vertexNormal != null && !this.m_bShowBackface) {
            for (n2 = 0; n2 < this.m_numVertices; n2 += 1) {
                this.m_vertexNormalTrans[n2].clearTag(15);
            }
        }
        this.m_bUseVertexNormals = this.m_bShowVertexNormals || this.m_bShowEdgeAura || this.m_bShowSilhouette || !this.m_bShowBackface || this.m_bShowElementBackColor || this.m_bShowElementBackColors;
        this.m_bUseElementNormals = this.m_bShowElementNormals || this.m_bShowEdgeAura || this.m_bShowSilhouette || !this.m_bShowBackface || this.m_bShowElementBackColor || this.m_bShowElementBackColors || this.m_bShowTexture && this.m_textureSide != 3;
        boolean bl2 = this.m_bUseElementCenters = this.m_elementNormal != null && this.m_bUseElementNormals || this.m_vector != null && this.m_bShowVectors;
        if (this.m_bUseElementCenters) {
            this.m_elemCenter = PdVector.realloc(this.m_elemCenter, this.m_numElements, this.m_dim);
            this.m_elemCenterTrans = PiVector.realloc(this.m_elemCenterTrans, this.m_numElements, this.m_dimTrans);
        } else {
            this.m_elemCenter = null;
            this.m_elemCenterTrans = null;
        }
        n2 = 0;
        if (this.m_usePolygons) {
            n2 = this.m_bShowSmoothEdgeColors && (this.m_bShowPolygonColors || this.m_bLocShowEdgeColorFromVertices) ? 1 : 0;
        } else if (this.m_useElements) {
            n2 = this.m_bShowSmoothEdgeColors && (this.m_bShowEdgeColors || this.m_bLocShowEdgeColorFromVertices) || this.m_bLocShowSmoothElementColors && (this.m_bShowElementColors || this.m_bLocShowElementColorFromVertices) ? 1 : 0;
        }
        this.setState(100, n2 != 0);
        if (!this.m_bShowElementColors) {
            this.m_bLocShowSmoothElementColors = false;
        }
        if (this.m_usePolygons && this.m_bShowSmoothEdgeColors && !this.m_bLocShowEdgeColorFromVertices) {
            this.makeInducedVertexColorsFromElementColors(this.m_numPolygons, this.m_polygon, this.m_polygonColor);
        } else if (this.m_useElements && this.m_bLocShowSmoothElementColors && !this.m_bLocShowElementColorFromVertices) {
            this.makeInducedVertexColorsFromElementColors(this.m_numElements, this.m_element, this.m_elementColor);
        } else {
            this.m_vertexColorFromElement = null;
        }
        this.m_bHasCreaseEdge = false;
        if ((this.m_bLocShowSmoothElementColors || this.m_bLocShowSmoothLighting) && this.m_creaseAngle <= Math.PI && this.m_numElements > 0 && this.m_elementNormal != null && this.m_bHasNeighbours) {
            int n3;
            if (this.m_bCreaseEdge == null || this.m_bCreaseEdge.length != this.m_numVertices) {
                this.m_bCreaseEdge = new boolean[this.m_numVertices];
            }
            for (int i = 0; i < this.m_numVertices; ++i) {
                this.m_bCreaseEdge[i] = false;
            }
            double d = Math.cos(this.m_creaseAngle);
            for (n3 = 0; n3 < this.m_numElements; ++n3) {
                int n4 = this.m_element[n3].getSize();
                for (int i = 0; i < n4; ++i) {
                    boolean bl3;
                    int n5 = this.m_neighbour[n3].m_data[i];
                    if (n5 < n3) continue;
                    double d2 = PdVector.dot(this.m_elementNormal[n3], this.m_elementNormal[n5]);
                    boolean bl4 = bl3 = d2 <= d;
                    if (!bl3) continue;
                    this.m_bCreaseEdge[this.m_element[n3].m_data[(i + 1) % n4]] = true;
                    this.m_bCreaseEdge[this.m_element[n3].m_data[(i + 2) % n4]] = true;
                }
            }
            for (n3 = 0; n3 < this.m_numVertices; ++n3) {
                if (!this.m_bCreaseEdge[n3]) continue;
                this.m_bHasCreaseEdge = true;
                break;
            }
        } else {
            this.m_bCreaseEdge = null;
        }
        this.m_globalVertexSize *= (double)PsConfig.getMonitorScale();
        this.m_globalVertexNormalSize *= (double)PsConfig.getMonitorScale();
        this.m_globalVertexNormalLength *= (double)PsConfig.getMonitorScale();
        this.m_globalEdgeSize *= (double)PsConfig.getMonitorScale();
        this.m_globalEdgeNormalSize *= (double)PsConfig.getMonitorScale();
        this.m_globalEdgeNormalLength *= (double)PsConfig.getMonitorScale();
        this.m_globalPolygonSize *= (double)PsConfig.getMonitorScale();
        this.m_globalPolygonNormalSize *= (double)PsConfig.getMonitorScale();
        this.m_globalPolygonNormalLength *= (double)PsConfig.getMonitorScale();
        this.m_globalElementNormalSize *= (double)PsConfig.getMonitorScale();
        this.m_globalElementNormalLength *= (double)PsConfig.getMonitorScale();
        this.m_globalBndSize *= (double)PsConfig.getMonitorScale();
        if (this.m_globalVectorLength != null) {
            int n6 = 0;
            while (n6 < this.m_globalVectorLength.length) {
                int n7 = n6++;
                this.m_globalVectorLength[n7] = this.m_globalVectorLength[n7] * (double)PsConfig.getMonitorScale();
            }
        }
        if (this.m_globalVectorSize != null) {
            int n8 = 0;
            while (n8 < this.m_globalVectorSize.length) {
                int n9 = n8++;
                this.m_globalVectorSize[n9] = this.m_globalVectorSize[n9] * (double)PsConfig.getMonitorScale();
            }
        }
        if (this.m_bndSize != null) {
            int n10 = 0;
            while (n10 < this.m_bndSize.length) {
                int n11 = n10++;
                this.m_bndSize[n11] = this.m_bndSize[n11] * (double)PsConfig.getMonitorScale();
            }
        }
        return true;
    }

    public void setSpecularColor(Color color) {
        super.setSpecularColor(color);
        int n = this.m_specularColor.getRGB();
        this.m_specular[0] = n >> 16 & 0xFF;
        this.m_specular[1] = n >> 8 & 0xFF;
        this.m_specular[2] = n & 0xFF;
    }

    private boolean makeInducedVertexColorsFromElementColors(int n, PiVector[] piVectorArray, Color[] colorArray) {
        int n2;
        if (piVectorArray == null || colorArray == null) {
            PsDebug.warning("missing element colors");
            this.m_vertexColorFromElement = null;
            this.m_bLocShowSmoothElementColors = false;
            return false;
        }
        if (this.m_numVertices == 0 || n == 0) {
            this.m_vertexColorFromElement = null;
            return true;
        }
        int[][] nArray = new int[this.m_numVertices][3];
        int[] nArray2 = new int[this.m_numVertices];
        for (n2 = 0; n2 < n; ++n2) {
            int n3 = piVectorArray[n2].getSize();
            int n4 = colorArray[n2].getRGB();
            for (int i = 0; i < n3; ++i) {
                int n5 = piVectorArray[n2].m_data[i];
                int[] nArray3 = nArray[n5];
                nArray3[0] = nArray3[0] + (n4 >> 16 & 0xFF);
                int[] nArray4 = nArray[n5];
                nArray4[1] = nArray4[1] + (n4 >> 8 & 0xFF);
                int[] nArray5 = nArray[n5];
                nArray5[2] = nArray5[2] + (n4 & 0xFF);
                int n6 = n5;
                nArray2[n6] = nArray2[n6] + 1;
            }
        }
        this.m_vertexColorFromElement = PdColor.realloc(this.m_vertexColorFromElement, this.m_numVertices);
        for (n2 = 0; n2 < this.m_numVertices; ++n2) {
            this.m_vertexColorFromElement[n2] = nArray2[n2] > 0 ? new Color((int)((float)nArray[n2][0] / (float)nArray2[n2]), (int)((float)nArray[n2][1] / (float)nArray2[n2]), (int)((float)nArray[n2][2] / (float)nArray2[n2])) : Color.black;
        }
        return true;
    }

    protected void drawTitle(Graphics graphics) {
        String string;
        if (!this.m_bShowName && !this.m_bShowTitle) {
            return;
        }
        if (this.m_bShowTitle && this.m_geometry.getTitle() != null) {
            string = this.m_geometry.getTitle();
            this.drawString(graphics, string, this.m_bndBoxTrans[0].m_data[0], this.m_bndBoxTrans[1].m_data[1], 0, 0, 6);
        }
        if (this.m_bShowName && this.m_geometry.getName() != null) {
            string = this.m_geometry.getName();
            this.drawString(graphics, string, this.m_bndBoxTrans[1].m_data[0], this.m_bndBoxTrans[1].m_data[1], 0, 0, 5);
        }
    }

    protected void drawItem(Graphics graphics, int n, double d, double d2) {
        this.m_heightFac = 0.2f + 0.8f * (float)d;
        this.m_itemHeight = (float)d2;
        int n2 = 0;
        if (this.m_useVertices) {
            if (n < this.m_numVertices) {
                this.m_bShowCurrElement = true;
                if (PsJavaView.m_bLargeModel) {
                    if (this.m_numVertices > 2000000 && n % 16 != 0) {
                        return;
                    }
                    if (this.m_numVertices > 1000000 && n % 8 != 0) {
                        return;
                    }
                    if (this.m_numVertices > 500000 && n % 4 != 0) {
                        return;
                    }
                    if (this.m_numVertices > 200000 && n % 2 != 0) {
                        return;
                    }
                    if (this.m_numVertices > 150000 && n % 3 == 0) {
                        return;
                    }
                }
                this.drawVertex(graphics, n);
                return;
            }
            n2 = this.m_numVertices;
        } else if (this.m_useUnusedVertices) {
            if (n < this.m_numUnusedVertices) {
                this.m_bShowCurrElement = true;
                this.drawVertex(graphics, this.m_unusedVertex.getEntry(n));
                return;
            }
            n2 = this.m_numUnusedVertices;
        }
        if (this.m_useElements) {
            if (n - n2 < this.m_numElements) {
                if (this.m_geomType != 34) {
                    this.drawElement(graphics, n - n2);
                } else {
                    this.drawTetra(graphics, n - n2);
                }
                return;
            }
            n2 += this.m_numElements;
        }
        if (this.m_usePolygons) {
            if (n - n2 < this.m_numPolygonEdges) {
                this.m_bShowCurrEdge = false;
                this.m_bShowCurrElement = true;
                this.m_bDrawingEdge = true;
                this.drawPolygon(graphics, n - n2);
                return;
            }
            PsDebug.error("itemInd out of range, index = " + n, this);
        }
    }

    private float getAdaptiveScale(float f) {
        float f2;
        float f3 = f2 = (float)this.m_camera.getDist();
        float f4 = Math.min(((PvDisplay)this.m_display).m_nWidth, ((PvDisplay)this.m_display).m_nHeight);
        float f5 = f4 / f3;
        float f6 = (float)this.m_camera.getFieldOfView();
        float f7 = f2;
        float f8 = (float)((double)f2 / PvCamera.SIZE * (double)f / (double)PvCamera.Z_STRETCH);
        float f9 = 1.0f;
        if ((double)(f7 - f8 * f6) < 1.0E-10) {
            return -1.0f;
        }
        float f10 = f9 * f7 / (f7 - f8 * f6);
        float f11 = f10 * f5;
        return (float)Math.log(f11 / 60.0f + 1.0f) * 3.0f;
    }

    private void drawVertex(Graphics graphics, int n) {
        Color color;
        int n2;
        boolean bl;
        PdVector pdVector = this.m_vertex[n];
        if (pdVector.hasTag(2)) {
            return;
        }
        if (n < 0 || this.m_numVertices <= n) {
            return;
        }
        this.m_bIsBackface = this.isBackVertexCulled(n);
        if (!this.m_bShowBackface && this.m_bIsBackface) {
            return;
        }
        boolean bl2 = this.m_bShowTaggedVertices && this.m_bHasTaggedVertices && pdVector.hasTag(12);
        boolean bl3 = this.m_bShowTaggedVertices && this.m_bHasTaggedVertices && pdVector.hasTag(11);
        boolean bl4 = this.m_bShowTaggedVertices && this.m_bHasTaggedVertices && pdVector.hasTag(1);
        boolean bl5 = bl = pdVector.getURL() != null;
        if (!(this.m_bShowVertices || this.m_bShowVertexNormals || this.m_bShowVectors || bl2 || bl3 || bl4 || bl)) {
            return;
        }
        int n3 = this.m_vertexTrans[n].m_data[0];
        int n4 = this.m_vertexTrans[n].m_data[1];
        int n5 = this.m_vertexTrans[n].m_data[2];
        double d = this.getVertexSize(n, bl2, bl3, bl4, bl);
        if (this.m_bAdaptiveSize) {
            float f = this.getAdaptiveScale(n5);
            if ((double)f < 0.0) {
                return;
            }
            d *= (double)f;
        }
        int n6 = (int)(d + 0.5);
        int n7 = (int)(2.0 * d + 0.5);
        if (this.m_bFastClipping) {
            if (n4 <= -n6 || n4 >= this.m_dispSizePS_ZOOM.height + n6 || n3 <= -n6 || n3 >= this.m_dispSizePS_ZOOM.width + n6) {
                return;
            }
            if (n6 > 0 && this.m_bEnableZBuffer && !this.m_bShowLocTransparency && 0 <= n3 - n6 && n3 < this.m_dispSizePS_ZOOM.width - n6 && 0 <= n4 - n6 && n4 < this.m_dispSizePS_ZOOM.height - n6 && n5 - this.m_zTolVertex + n6 < this.m_zBuffer[n4 - n6][n3 - n6] && n5 - this.m_zTolVertex + n6 < this.m_zBuffer[n4 + n6][n3 - n6] && n5 - this.m_zTolVertex + n6 < this.m_zBuffer[n4 + n6][n3 + n6] && n5 - this.m_zTolVertex + n6 < this.m_zBuffer[n4 - n6][n3 + n6] && n5 - this.m_zTolVertex + n6 < this.m_zBuffer[n4][n3]) {
                return;
            }
        }
        if (this.m_bAutoClip && n5 > this.m_autoClip) {
            return;
        }
        if (this.m_bIsClippable) {
            if (this.m_bEnableClipCamera && ((double)n5 < this.m_clipFar || (double)n5 > this.m_clipNear)) {
                return;
            }
            if (this.m_bEnableClipBounds && this.m_clipBounds != null) {
                this.project(this.m_vtMod, pdVector, this.m_modelMatrix, this.m_ambientMatrix);
                for (n2 = 0; n2 < 3; ++n2) {
                    if (this.m_vtMod.m_data[n2] < this.m_clipBounds[0].m_data[n2] - 1.0E-10) {
                        return;
                    }
                    if (!(this.m_vtMod.m_data[n2] > this.m_clipBounds[1].m_data[n2] + 1.0E-10)) continue;
                    return;
                }
            }
        }
        if (this.m_bEnable3DLook) {
            this.m_currVertex = pdVector;
        }
        int n8 = n2 = !(!this.m_bShowLighting || this.m_vertexNormal == null || bl2 || bl3 || bl4 || this.m_bEnableZBuffer && this.m_light != null && this.m_bEnable3DLook && d > 2.0 && this.m_camUp3D != null) ? 1 : 0;
        if (n2 != 0) {
            this.renderLight(pdVector, this.m_vertexNormal[n], this.m_light);
        }
        if (this.m_bShowVertexNormals) {
            color = this.m_bShowDepthcue ? PdColor.getDimmedColor(this.m_globalVertexNormalColor, (int)(255.0f * this.m_heightFac)) : this.m_globalVertexNormalColor;
            this.drawVectorAny(graphics, this.m_globalVertexNormalSize * (double)this.m_offFac, n3, n4, n5, this.m_vertexNormalTrans[n].m_data[0], this.m_vertexNormalTrans[n].m_data[1], this.m_vertexNormalTrans[n].m_data[2], this.m_bShowVertexNormalArrow, color, true);
        }
        if (this.m_bShowVectors) {
            for (int i = 0; i < this.m_numVectorFields; ++i) {
                if (!this.m_bShowVectorField[i] || this.m_vectorIsElementBased[i]) continue;
                if (this.m_vector[i][n].hasTag(1)) {
                    color = this.m_globalVertexTagColor;
                } else {
                    color = this.m_globalVectorColor[i];
                    if (this.m_bShowVectorColors[i]) {
                        color = this.m_vectorColor[i][n];
                    }
                }
                this.drawVectorAny(graphics, this.m_globalVectorSize[i] * (double)this.m_offFac, n3, n4, n5, this.m_vectorTrans[i][n].m_data[0], this.m_vectorTrans[i][n].m_data[1], this.m_vectorTrans[i][n].m_data[2], this.m_bShowVectorArrow[i], color, false);
            }
        }
        if (!(this.m_bShowVertices || bl2 || bl3 || bl4 || bl)) {
            return;
        }
        if (n6 > 0) {
            color = this.getVertexColor(n, bl2, bl3, bl4, bl);
            if (n2 != 0) {
                color = this.attenuateColor(color, this.m_lightAttMat, this.m_lightAttSpec);
            }
            if (this.m_bEnableZBuffer) {
                this.m_outCol = bl ? Color.cyan.getRGB() : -16777216;
                this.writeCircle(n3, n4, n6, color.getRGB(), n5);
            } else {
                graphics.setColor(color);
                if (n7 > 2) {
                    graphics.fillOval(n3 - n6, n4 - n6, n7, n7);
                } else {
                    graphics.fillRect(n3 - n6, n4 - n6, n7, n7);
                }
                if (this.m_bShowVertexOutline) {
                    if (bl) {
                        graphics.setColor(Color.cyan);
                    } else {
                        graphics.setColor(Color.black);
                    }
                    graphics.drawOval(n3 - n6, n4 - n6, n7, n7);
                }
            }
        }
        if (bl2 || bl || this.m_bShowIndices || this.m_bShowVertexLabels) {
            String string = pdVector.getName();
            if (string == null && (bl2 || this.m_bEnabledIndexLabels)) {
                string = String.valueOf(n);
            }
            if (string != null) {
                if (bl2 || bl3) {
                    n5 = 0x3FFFFFFF;
                }
                this.drawString(graphics, string, n3, n4, n5, (int)((double)n6 * 0.8) + 1, 0);
            }
        }
    }

    private double getVertexSize(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        double d = this.m_globalVertexSize;
        if (this.m_bShowVertexSizes) {
            d *= this.m_vertexSize.getEntry(n);
        }
        if (!this.m_bAdaptiveSize) {
            if (bl || bl2) {
                d = d < 1.0 ? 3.0 : (d += 4.0);
            } else if (bl4 && bl3) {
                d = d < 1.0 ? 2.0 : (d += 3.0);
            } else if (bl3 || bl4) {
                d = d < 1.0 ? 1.0 : (d += 2.0);
            }
        } else if (bl || bl2) {
            d *= 1.4;
        } else if (bl4 && bl3) {
            d *= 1.3;
        } else if (bl3 || bl4) {
            d *= 1.2;
        }
        return d * (double)this.m_offFac;
    }

    private Color getVertexColor(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Color color = this.m_globalVertexColor;
        if (bl4 && (bl || bl2)) {
            color = Color.cyan;
        } else if (bl || bl2) {
            color = this.m_globalVertexTagColor;
        } else if (bl3) {
            color = this.m_globalVertexTagColor;
        } else if (this.m_bShowVertices) {
            if (this.m_bShowVertexColors && this.m_vertexColor != null) {
                color = this.m_vertexColor[n];
            }
            if (this.m_bShowDepthcue) {
                color = PdColor.getDimmedColor(color, (int)(255.0f * this.m_heightFac));
            }
        } else {
            color = this.m_globalVertexColor;
        }
        return color;
    }

    private void writePixel(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n < 0 || n >= this.m_imgWidth || n2 < 0 || n2 >= this.m_zBuffer.length - 1) {
            return;
        }
        if (this.m_bEnable3DLook && this.m_cSize > 2 && this.m_camUp3D != null) {
            n6 = n - this.m_cx;
            int n7 = -(n2 - this.m_cy);
            int n8 = 1 + n3;
            if (this.m_bShowLighting && this.m_light != null && this.m_currVertex != null && this.m_dim == 3) {
                for (int i = 0; i < this.m_dim; ++i) {
                    this.m_sphNormal.m_data[i] = ((double)n6 * this.m_camHor3D.m_data[i] + (double)n7 * this.m_camUp3D.m_data[i] - (double)n8 * this.m_camView3D.m_data[i]) / (double)this.m_cSize;
                }
                this.renderLight(this.m_currVertex, this.m_sphNormal, this.m_light);
                n5 = PvGeometry.attenuateColor(n5, this.m_lightAttMat, this.m_lightAttSpec);
            } else {
                n5 = PdColor.getDimmedColor(n5, n8 * 255 / this.m_cSize);
            }
            n4 += n8 * this.m_z3DLookFac;
        }
        n6 = n2 * this.m_imgWidth + n;
        if (this.m_zBuffer[n2][n] >= n4 - this.m_zTolVertex) {
            if (this.m_bShowLocTransparency) {
                this.m_pixData[n6] = this.drawPixel(this.m_pixData[n6], n5, this.m_iTransparency, this.m_alpha, false, n, n2);
            }
            return;
        }
        if (this.m_bShowLocTransparency) {
            n5 = this.drawPixel(this.m_pixData[n6], n5, this.m_iTransparency, this.m_alpha, true, n, n2);
        }
        this.m_pixData[n6] = n5;
        this.m_zBuffer[n2][n] = n4 - this.m_zTolVertex;
    }

    private void write8Pixel(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.writePixel(n + n4, n2 + n5, n3, n6, n7);
        this.writePixel(n + n4, n2 - n5, n3, n6, n7);
        this.writePixel(n - n4, n2 - n5, n3, n6, n7);
        this.writePixel(n - n4, n2 + n5, n3, n6, n7);
        if (n4 != n5) {
            this.writePixel(n + n5, n2 + n4, n3, n6, n7);
            this.writePixel(n + n5, n2 - n4, n3, n6, n7);
            this.writePixel(n - n5, n2 - n4, n3, n6, n7);
            this.writePixel(n - n5, n2 + n4, n3, n6, n7);
        }
    }

    private short[][] createHeightArr(int n) {
        int n2;
        int n3;
        int n4;
        short[][] sArray = new short[n][n];
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 0; n3 < n; ++n3) {
                sArray[n4][n3] = -1;
            }
        }
        n4 = n;
        n3 = (n4 - 1) * (n4 - 1);
        int n5 = n4 - 1;
        int n6 = 0;
        int n7 = 1 - n5;
        if (this.m_bShowVertexOutline) {
            sArray[0][n - 1] = 0;
            sArray[n - 1][0] = 0;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            sArray[n2][0] = (short)(Math.sqrt(n3 - n2 * n2) + 0.5);
        }
        while (n5 > n6 + 1) {
            if (n7 < 0) {
                n7 += 2 * n6 + 3;
                ++n6;
                for (n2 = 0; n2 < n5; ++n2) {
                    sArray[n2][n6] = (short)(Math.sqrt(n3 - n6 * n6 - n2 * n2) + 0.5);
                }
            } else {
                n7 += 2 * (n6 - n5) + 5;
                ++n6;
                --n5;
                for (n2 = 0; n2 < n5; ++n2) {
                    sArray[n2][n6] = (short)(Math.sqrt(n3 - n6 * n6 - n2 * n2) + 0.5);
                }
                if (n6 < n5) {
                    for (n2 = 0; n2 < n6; ++n2) {
                        sArray[n2][n5] = (short)(Math.sqrt(n3 - n5 * n5 - n2 * n2) + 0.5);
                    }
                }
            }
            if (!this.m_bShowVertexOutline) continue;
            sArray[n6][n5] = 0;
            sArray[n5][n6] = 0;
        }
        return sArray;
    }

    private void writeCircle(int n, int n2, int n3, int n4, int n5) {
        if (this.m_imgWidth == 0) {
            return;
        }
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                if (this.m_bShowVertexOutline) {
                    this.writePixel(n - 1, n2, 0, n5, this.m_outCol);
                    this.writePixel(n + 1, n2, 0, n5, this.m_outCol);
                    this.writePixel(n, n2 - 1, 0, n5, this.m_outCol);
                    this.writePixel(n, n2 + 1, 0, n5, this.m_outCol);
                }
                this.writePixel(n, n2, 1, n5, n4);
                break;
            }
            case 2: {
                int n6 = n3 - 1;
                for (int i = -n6; i <= n6; ++i) {
                    int n7 = n2 + i;
                    if (this.m_bShowVertexOutline) {
                        this.writePixel(n - n3, n7, 0, n5, this.m_outCol);
                        this.writePixel(n + n3, n7, 0, n5, this.m_outCol);
                        this.writePixel(n + i, n2 - n6 - 1, 0, n5, this.m_outCol);
                        this.writePixel(n + i, n2 + n6 + 1, 0, n5, this.m_outCol);
                    }
                    for (int j = -n6; j <= n6; ++j) {
                        int n8 = n + j;
                        this.writePixel(n8, n7, 1, n5, n4);
                    }
                }
                break;
            }
            default: {
                if (n < -n3 || n >= this.m_imgWidth + n3 || n2 < -n3 || n2 >= this.m_zBuffer.length - 1 + n3) {
                    return;
                }
                if (this.m_heightArr == null) {
                    this.m_heightArr = this.createHeightArr(this.m_cacheRadius);
                }
                this.m_cx = n;
                this.m_cy = n2;
                this.m_cSize = n3;
                int n9 = n3;
                int n10 = 0;
                int n11 = 1 - n9;
                if (this.m_bShowVertexOutline) {
                    this.write8Pixel(n, n2, 0, n10, n9, n5, this.m_outCol);
                }
                this.writeLine(n3 - 1, 0, n5, n4, n3);
                while (n9 > n10 + 1) {
                    if (n11 < 0) {
                        n11 += (n10 << 1) + 3;
                        this.writeLine(n9 - 1, ++n10, n5, n4, n3);
                    } else {
                        n11 += (n10 - n9 << 1) + 5;
                        this.writeLine(--n9 - 1, ++n10, n5, n4, n3);
                        if (n10 < n9) {
                            this.writeLine(n10 - 1, n9, n5, n4, n3);
                        }
                    }
                    if (!this.m_bShowVertexOutline) continue;
                    this.write8Pixel(n, n2, 0, n10, n9, n5, this.m_outCol);
                }
                break block0;
            }
        }
    }

    private void writeLine(int n, int n2, int n3, int n4, int n5) {
        if (this.m_cy + n2 < 0 || this.m_cy - n2 >= this.m_zBuffer.length - 1) {
            return;
        }
        int n6 = this.m_cacheRadius / n5 >> 1;
        int n7 = this.m_cacheRadius / n5;
        int n8 = this.m_cacheRadius * (1 + 2 * n2) / n5 >> 1;
        for (int i = 0; i <= n; ++i) {
            int n9 = 0;
            if (this.m_heightArr[n6][n8] > 0) {
                n9 = this.m_heightArr[n6][n8] * n5 / this.m_cacheRadius;
            }
            this.writePixel(this.m_cx + i, this.m_cy + n2, n9, n3, n4);
            if (i != 0) {
                this.writePixel(this.m_cx - i, this.m_cy + n2, n9, n3, n4);
            }
            if (n2 != 0) {
                this.writePixel(this.m_cx + i, this.m_cy - n2, n9, n3, n4);
                if (i != 0) {
                    this.writePixel(this.m_cx - i, this.m_cy - n2, n9, n3, n4);
                }
            }
            n6 += n7;
        }
    }

    private void drawString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        FontMetrics fontMetrics;
        if (string == null || string.equals("")) {
            return;
        }
        int[] nArray = this.m_labelAttribute[n5].m_data;
        Font font = PsConfig.getFont(nArray[4]);
        int n6 = this.m_offFac / PS_ZOOM;
        String string2 = this.m_labelFont[n5];
        int n7 = (int)(this.m_labelSize.getEntry(n5) * (double)n6);
        int n8 = this.m_labelStyle.getEntry(n5);
        boolean bl = false;
        if (string2 != null && string2 != font.getName()) {
            bl = true;
        }
        if (n7 != font.getSize()) {
            bl = true;
        }
        if (n8 != font.getStyle()) {
            bl = true;
        }
        if (bl) {
            font = new Font(string2, n8, n7);
        }
        int n9 = 0;
        int n10 = 0;
        try {
            fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        catch (Exception exception) {
            return;
        }
        if (nArray[2] == 0) {
            n9 = n4;
        } else if (nArray[2] == 1) {
            n9 = -fontMetrics.stringWidth(string) * PS_ZOOM / 2;
        } else if (nArray[2] == 2) {
            n9 = -fontMetrics.stringWidth(string) * PS_ZOOM - n4;
        }
        if (nArray[3] == 2) {
            n10 = 2 * fontMetrics.getHeight() * PS_ZOOM / 3 + n4;
        } else if (nArray[3] == 1) {
            n10 = fontMetrics.getHeight() * PS_ZOOM / 3;
        } else if (nArray[3] == 0) {
            n10 = -n4;
        }
        if (this.m_bEnableZBuffer) {
            int n11 = (int)(1.1f * (float)fontMetrics.stringWidth(string));
            int n12 = (int)(1.5f * (float)fontMetrics.getHeight());
            boolean bl2 = false;
            if (n11 > this.m_widthString) {
                bl2 = true;
                this.m_widthString = n11;
            } else if (n12 > this.m_heightString) {
                bl2 = true;
                this.m_heightString = n12;
            }
            if (PsConfig.getOSId() != 0 && this.m_widthString * this.m_heightString <= 2730) {
                this.m_widthString = (int)(Math.ceil(2731.0f / (float)this.m_heightString) + 1.0);
                bl2 = true;
            }
            if (bl2 || this.m_imageString == null) {
                this.createImageString();
            }
            this.clearImageString(Color.black);
            Color color = this.m_labelColor[n5];
            if (n5 == 5 || n5 == 6) {
                color = PdColor.getXORColor(this.m_backColor, this.m_labelColor[n5], Color.white, 60);
            }
            int n13 = color.getRGB();
            if (this.m_gImageString.getFont() != font) {
                this.m_gImageString.setFont(font);
            }
            this.m_gImageString.drawString(string, 0, this.m_heightString >> 1);
            try {
                this.m_pgString = new PixelGrabber(this.m_imageString, 0, 0, this.m_widthString, this.m_heightString, this.m_pixString, 0, this.m_widthString);
                try {
                    this.m_pgString.grabPixels(0L);
                }
                catch (NullPointerException nullPointerException) {}
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            int n14 = 0;
            int n15 = this.m_pixData.length - 2 * this.m_widthString;
            int n16 = n + nArray[0] * this.m_offFac + n9;
            int n17 = n2 + nArray[1] * this.m_offFac + n10 + (this.m_heightString >> 1);
            int n18 = this.m_zTol;
            if (n5 == 0) {
                n18 = 2 * this.m_zTolVertex;
            } else if (n5 == 1 || n5 == 2) {
                n18 = this.m_zTolLine;
            } else if (n5 == 3) {
                n18 = this.m_zTolFace;
            } else if (n5 == 6) {
                n18 = 0x3FFFFFFF;
            }
            for (int i = 0; i < this.m_heightString; ++i) {
                int n19 = n17 - (this.m_heightString - i);
                int n20 = n16;
                int n21 = n19 * this.m_dispSize.width + n20;
                if (n21 < 0 || n21 > n15) continue;
                for (int j = 0; j < this.m_widthString; ++j) {
                    if (n20 >= 0 && n20 < this.m_dispSize.width && this.m_pixString[n14] != m_colorWhite) {
                        int n22 = this.m_pixString[n14] >> 16 & 0xFF;
                        boolean bl3 = n3 - n18 > this.m_zBuffer[n19][n20];
                        boolean bl4 = n3 - n18 > this.m_zBuffer[n19][n20];
                        int n23 = n13;
                        if (this.m_bShowLocTransparency) {
                            this.m_pixData[n21] = n23 = this.drawPixel(this.m_pixData[n21], n13, n22, this.m_alpha, bl3, n20, n19);
                            this.m_zBuffer[n19][n20] = n3 - n18;
                        } else if (bl4) {
                            int n24 = this.m_pixData[n21];
                            int n25 = n22;
                            int n26 = (n24 >> 16 & 0xFF) * n25;
                            int n27 = (n24 >> 8 & 0xFF) * n25;
                            int n28 = (n24 & 0xFF) * n25;
                            if (bl3) {
                                n26 += (n23 >> 16 & 0xFF) * (255 - n25);
                                n27 += (n23 >> 8 & 0xFF) * (255 - n25);
                                n28 += (n23 & 0xFF) * (255 - n25);
                            }
                            n26 = n26 << 8 & 0xFF0000;
                            n28 = n28 >> 8 & 0xFF;
                            this.m_pixData[n21] = n23 = this.m_alpha | n26 | (n27 &= 0xFF00) | n28;
                            this.m_zBuffer[n19][n20] = n3 - n18;
                        }
                    }
                    ++n20;
                    ++n21;
                    ++n14;
                }
            }
            if (bl2) {
                this.setOffFac(this.m_offFac);
            }
        } else {
            graphics.setFont(font);
            if (n5 == 5 || n5 == 6) {
                graphics.setColor(PdColor.getXORColor(this.m_backColor, this.m_labelColor[n5], Color.white, 60));
            } else {
                graphics.setColor(this.m_labelColor[n5]);
            }
            graphics.drawString(string, n + nArray[0] * this.m_offFac + n9, n2 + nArray[1] * this.m_offFac + n10);
        }
    }

    protected void setOffFac(int n) {
        if (this.m_offFac == n * PS_ZOOM) {
            return;
        }
        this.m_offFac = n * PS_ZOOM;
        if (this.m_imageString != null) {
            this.m_widthString = n * this.m_defWidthString;
            this.m_heightString = n * this.m_defHeightString;
            this.createImageString();
        }
    }

    private void createImageString() {
        if (this.m_imageString != null && this.m_imageString.getWidth(null) == this.m_widthString && this.m_imageString.getHeight(null) == this.m_heightString) {
            return;
        }
        this.m_imageString = this.m_display.getCanvas().createImage(this.m_widthString, this.m_heightString);
        this.m_pixString = new int[this.m_widthString * this.m_heightString];
        this.m_gImageString = this.m_imageString.getGraphics();
    }

    protected void clearImageString(Color color) {
        if (this.m_gImageString == null) {
            return;
        }
        this.m_gImageString.setColor(Color.white);
        this.m_gImageString.fillRect(0, 0, this.m_widthString, this.m_heightString);
        this.m_gImageString.setColor(color);
    }

    private void drawPolygon(Graphics graphics, int n) {
        int n2;
        block50: {
            int n3;
            Color color;
            double d;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            boolean bl;
            boolean bl2;
            int n10;
            block51: {
                int n11;
                n10 = this.m_edgePolygon.getEntry(n);
                n -= this.m_edgeOffset.getEntry(n);
                if (n10 == this.m_numPolygons) {
                    PsDebug.warning("edgeInd = " + n + " out of bounds.");
                    return;
                }
                bl2 = n == 0;
                bl = n == this.m_polygon[n10].getSize() - 2;
                n9 = 2;
                this.m_bElementDrawn = true;
                if (this.m_bFastClipping) {
                    n2 = 0;
                    n8 = 0;
                    n7 = 0;
                    n6 = 0;
                    n5 = 0;
                    for (n11 = 0; n11 < n9; ++n11) {
                        int n12 = this.m_polygon[n10].m_data[n + n11];
                        int n13 = this.m_vertexTrans[n12].m_data[0];
                        n4 = this.m_vertexTrans[n12].m_data[1];
                        int n14 = this.m_vertexTrans[n12].m_data[2];
                        if (n13 < 0) {
                            ++n2;
                            continue;
                        }
                        if (n4 < 0) {
                            ++n6;
                            continue;
                        }
                        if (n13 >= this.m_dispSizePS_ZOOM.width) {
                            ++n8;
                            continue;
                        }
                        if (n4 >= this.m_dispSizePS_ZOOM.height) {
                            ++n7;
                            continue;
                        }
                        if (!this.m_bDirtyClipping || !this.m_bEnableZBuffer || this.m_bShowLocTransparency || n14 - this.m_zTolVertex >= this.m_zBuffer[n4][n13]) continue;
                        ++n5;
                    }
                    if (n2 == n9 || n6 == n9 || n8 == n9 || n7 == n9 || n5 == n9) {
                        this.m_bElementDrawn = false;
                        return;
                    }
                }
                this.m_bElemIsClipped = false;
                if (this.m_bIsClippable && this.m_bEnableClipBounds && this.m_clipBounds != null) {
                    for (n2 = 0; n2 < n9; ++n2) {
                        this.project(this.m_vd[n2], this.m_vertex[this.m_polygon[n10].m_data[n + n2]], this.m_modelMatrix, this.m_ambientMatrix);
                    }
                    n2 = 0;
                    n8 = 0;
                    n7 = 0;
                    for (n6 = 0; n6 < 3; ++n6) {
                        for (n5 = 0; n5 < n9; ++n5) {
                            if (this.m_vd[n5].m_data[n6] < this.m_clipBounds[0].m_data[n6] - 1.0E-10) {
                                ++n8;
                            }
                            if (!(this.m_vd[n5].m_data[n6] > this.m_clipBounds[1].m_data[n6] + 1.0E-10)) continue;
                            ++n7;
                        }
                        if (n8 == n9 || n7 == n9) {
                            return;
                        }
                        n2 = n8 + n7;
                    }
                    this.m_bElemIsClipped = false;
                    if (n2 != 0) {
                        this.m_tPos[0] = 0.0;
                        this.m_tPos[1] = 1.0;
                        for (n6 = 0; n6 < 3; ++n6) {
                            if (this.m_clipBounds[0].m_data[n6] > this.m_clipBounds[1].m_data[n6]) continue;
                            this.clipPolygon3D(this.m_vd, this.m_tPos, n6, this.m_clipBounds[0].m_data[n6], this.m_clipBounds[1].m_data[n6]);
                            if (!(this.m_tPos[0] > 1.0) && !(this.m_tPos[1] < 0.0)) continue;
                            return;
                        }
                        this.m_bElemIsClipped = true;
                        for (n6 = 0; n6 < n9; ++n6) {
                            if (this.m_tPos[n6] != (double)n6) {
                                this.m_vtMod.blend(1.0 - this.m_tPos[n6], this.m_vd[0], this.m_tPos[n6], this.m_vd[1]);
                                this.project(this.m_centerTrans, this.m_vtMod, this.m_projviewMat);
                                this.m_xv[n6] = this.m_centerTrans.m_data[0];
                                this.m_yv[n6] = this.m_centerTrans.m_data[1];
                                this.m_zv[n6] = this.m_centerTrans.m_data[2];
                            } else {
                                n5 = this.m_polygon[n10].m_data[n + n6];
                                this.m_xv[n6] = this.m_vertexTrans[n5].m_data[0];
                                this.m_yv[n6] = this.m_vertexTrans[n5].m_data[1];
                                this.m_zv[n6] = this.m_vertexTrans[n5].m_data[2];
                            }
                            this.m_origInd[n6] = this.m_polygon[n10].m_data[n + n6];
                        }
                    }
                }
                if (!this.m_bElemIsClipped) {
                    if (this.m_bIsClippable && this.m_bEnableClipCamera) {
                        this.m_bElemIsClipped = false;
                        n9 = this.clipPolygon(n10, n, this.m_xv, this.m_yv, this.m_zv, this.m_origInd);
                        if (n9 == 0) {
                            return;
                        }
                    } else {
                        for (n2 = 0; n2 < n9; ++n2) {
                            n8 = this.m_polygon[n10].m_data[n + n2];
                            this.m_xv[n2] = this.m_vertexTrans[n8].m_data[0];
                            this.m_yv[n2] = this.m_vertexTrans[n8].m_data[1];
                            this.m_zv[n2] = this.m_vertexTrans[n8].m_data[2];
                            if (this.m_bAutoClip && this.m_zv[n2] > this.m_autoClip) {
                                return;
                            }
                            this.m_origInd[n2] = n8;
                        }
                    }
                }
                n2 = !this.m_useVertices && (this.m_bShowVertices || this.m_bShowTaggedVertices && this.m_bHasTaggedVertices || this.m_bShowVertexNormals || this.m_bShowVectors) ? 1 : 0;
                n8 = this.m_bShowTaggedPolygons && this.m_bHasTaggedPolygons && this.m_polygon[n10].hasTag(12) ? 1 : 0;
                n7 = this.m_bShowTaggedPolygons && this.m_bHasTaggedPolygons && this.m_polygon[n10].hasTag(11) ? 1 : 0;
                n6 = this.m_bShowTaggedPolygons && this.m_bHasTaggedPolygons && this.m_polygon[n10].hasTag(1) ? 1 : 0;
                n5 = this.m_polygon[n10].getURL() != null ? 1 : 0;
                int n15 = n11 = this.m_bShowPolygons || n8 != 0 || n7 != 0 || n6 != 0 || n5 != 0 ? 1 : 0;
                if (n11 == 0) break block50;
                d = this.getPolygonSize(n10, n8 != 0, n7 != 0, n6 != 0, n5 != 0);
                if (!this.m_bAdaptiveSize) break block51;
                n4 = this.m_polygon[n10].m_data[n];
                float f = this.getAdaptiveScale(this.m_vertexTrans[n4].m_data[2]);
                if ((double)f < 0.0) break block50;
                d *= (double)f;
            }
            n4 = (int)(d + 0.5);
            int n16 = (int)(2.0 * d + 0.5);
            if (n4 == 0 && d > 0.0) {
                n4 = 1;
            }
            if (n16 == 0 && d > 0.0) {
                n16 = 1;
            }
            Color color2 = color = this.getPolygonColor(n10, n, n8 != 0, n7 != 0, n6 != 0, n5 != 0);
            if (this.m_bShowLighting && !this.m_bLocShowSmoothLighting && this.m_vertexNormal != null) {
                n3 = this.m_polygon[n10].m_data[n];
                this.renderLight(this.m_vertex[n3], this.m_vertexNormal[n3], this.m_light);
                color = this.attenuateColor(color, this.m_lightAttMat, this.m_lightAttSpec);
            }
            if (n4 > 0) {
                int n17;
                double d2;
                int n18;
                if (this.m_bShowSmoothEdgeColors) {
                    for (n3 = 0; n3 < n9; ++n3) {
                        Color color3 = this.getPolygonColor(n10, n + n3, n8 != 0, n7 != 0, n6 != 0, n5 != 0);
                        n18 = color3.getRGB();
                        if (n3 == 1) {
                            color2 = color3;
                        }
                        PvGeometry.setScaledColor(this.m_cv[n3], n18, 16);
                        this.m_cv[3 - n3][0] = this.m_cv[n3][0];
                        this.m_cv[3 - n3][1] = this.m_cv[n3][1];
                        this.m_cv[3 - n3][2] = this.m_cv[n3][2];
                    }
                }
                if (this.m_bShowEdgeAura) {
                    this.m_bDepthcueEdge = false;
                    n3 = this.m_bShowSmoothEdgeColors ? 1 : 0;
                    boolean bl3 = this.m_bEnable3DLook;
                    n18 = this.m_bShowLighting;
                    this.m_bShowSmoothShading = false;
                    this.m_bEnable3DLook = false;
                    this.m_bShowLighting = false;
                    this.drawLineAny(graphics, Math.max(4 * this.m_offFac, n16), this.m_xv[0], this.m_yv[0], this.m_zv[0] - 30, this.m_xv[1], this.m_yv[1], this.m_zv[1] - 30, this.m_backColor, this.m_backColor, false);
                    this.m_bShowLighting = n18;
                    this.m_bEnable3DLook = bl3;
                    this.m_bShowSmoothEdgeColors = n3;
                }
                this.m_bDepthcueEdge = true;
                if ((this.m_bShowPolygonStartArrow || this.m_bShowPolygonEndArrow) && (d2 = Math.sqrt((n3 = this.m_xv[1] - this.m_xv[0]) * n3 + (n17 = this.m_yv[1] - this.m_yv[0]) * n17)) > 1.0E-10) {
                    for (int i = 0; i < 2; ++i) {
                        if (!(bl2 && i == 0 && this.m_bShowPolygonStartArrow || bl && i == 1 && this.m_bShowPolygonEndArrow)) continue;
                        int n19 = this.m_polygon[n10].m_data[n + i];
                        boolean bl4 = this.m_bShowTaggedVertices && this.m_bHasTaggedVertices && this.m_vertex[n19].hasTag(12);
                        boolean bl5 = this.m_bShowTaggedVertices && this.m_bHasTaggedVertices && this.m_vertex[n19].hasTag(11);
                        boolean bl6 = this.m_bShowTaggedVertices && this.m_bHasTaggedVertices && this.m_vertex[n19].hasTag(1);
                        double d3 = this.getVertexSize(n19, bl4, bl5, bl6, false);
                        if (this.m_bAdaptiveSize) {
                            float f = this.getAdaptiveScale(this.m_vertexTrans[n19].m_data[2]);
                            if ((double)f < 0.0) break block50;
                            d3 *= (double)f;
                        }
                        double d4 = d3 + (double)n4 / 2.0 - 1.0;
                        if (i == 1) {
                            d4 = -d4;
                        }
                        if (d4 == 0.0) continue;
                        int n20 = i;
                        this.m_xv[n20] = (int)((double)this.m_xv[n20] + (double)n3 * d4 / d2);
                        int n21 = i;
                        this.m_yv[n21] = (int)((double)this.m_yv[n21] + (double)n17 * d4 / d2);
                    }
                }
                n3 = n2 == 0 && n4 > 3 * this.m_offFac ? 1 : 0;
                this.drawLineAny(graphics, n4, this.m_xv[0], this.m_yv[0], this.m_zv[0], this.m_xv[1], this.m_yv[1], this.m_zv[1], color, color2, n3 != 0);
                if (this.m_bShowPolygonEndArrow && bl) {
                    this.drawVectorTipAny(graphics, n4, this.m_xv[0], this.m_yv[0], this.m_zv[0], this.m_xv[1], this.m_yv[1], this.m_zv[1], false, color2);
                }
                if (this.m_bShowPolygonStartArrow && bl2) {
                    this.drawVectorTipAny(graphics, n4, this.m_xv[1], this.m_yv[1], this.m_zv[1], this.m_xv[0], this.m_yv[0], this.m_zv[0], false, color);
                }
            }
            if (this.m_bShowIndices || this.m_bShowPolygonLabels || this.m_bShowEdgeLabels) {
                String string = this.m_polygon[n10].getName();
                if (string == null && this.m_bEnabledIndexLabels) {
                    string = this.m_bShowPolygonLabels ? String.valueOf(n10) : "";
                    if (this.m_bShowEdgeLabels) {
                        if (this.m_bShowPolygonLabels) {
                            string = string + ",";
                        }
                        string = string + String.valueOf(n);
                    }
                }
                if (string != null) {
                    this.drawString(graphics, string, (this.m_xv[0] + this.m_xv[1]) / 2, (this.m_yv[0] + this.m_yv[1]) / 2, (this.m_zv[0] + this.m_zv[1]) / 2, n4 >> 1, 2);
                }
            }
        }
        if (n2 != 0) {
            for (int i = 0; i < 2; ++i) {
                if (this.m_origInd[i] == -1) continue;
                this.drawVertex(graphics, this.m_origInd[i]);
            }
        }
    }

    private double getPolygonSize(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        double d = this.m_globalPolygonSize;
        if (this.m_bShowPolygonSizes) {
            d = this.m_globalPolygonSize * this.m_polygonSize.getEntry(n);
        }
        if (!this.m_bAdaptiveSize) {
            if (bl || bl2) {
                d = d < 1.0 ? 3.0 : (d += 4.0);
            } else if (bl4 && bl3) {
                d = d < 1.0 ? 2.0 : (d += 3.0);
            } else if (bl3 || bl4) {
                d = d < 1.0 ? 1.0 : (d += 2.0);
            }
        } else if (bl || bl2) {
            d *= 1.4;
        } else if (bl4 && bl3) {
            d *= 1.3;
        } else if (bl3 || bl4) {
            d *= 1.2;
        }
        return d * (double)this.m_offFac;
    }

    private void makeElementNormal(PdVector pdVector, int n, int n2) {
        if (this.m_dim != 2 && this.m_dim != 3 || n2 <= 2) {
            pdVector.set(0.0, 0.0, 1.0);
            return;
        }
        if (this.edgeB == null || this.edgeB.getSize() != this.m_dim) {
            this.edgeB = new PdVector(this.m_dim);
            this.edgeC = new PdVector(this.m_dim);
        }
        PdVector pdVector2 = this.m_vertex[this.m_element[n].m_data[0]];
        PdVector pdVector3 = this.m_vertex[this.m_element[n].m_data[1]];
        this.edgeB.sub(pdVector3, pdVector2);
        pdVector3 = this.m_vertex[this.m_element[n].m_data[2]];
        this.edgeC.sub(pdVector3, pdVector2);
        pdVector.cross(this.edgeB, this.edgeC);
        pdVector.normalize();
    }

    private void drawElement(Graphics graphics, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl;
        if (n < 0 || this.m_numElements <= n) {
            return;
        }
        int n7 = this.m_element[n].m_data.length;
        if (n7 == 0) {
            return;
        }
        if (2 * n7 > this.m_maxSizeOfElements) {
            this.setMaxSizeElements(2 * n7);
        }
        this.m_bElementDrawn = true;
        this.m_bIsBackface = this.isBackElementCulled(n);
        if (!this.m_bShowBackface && this.m_bIsBackface) {
            return;
        }
        this.m_bUseTexture = this.m_elementNormal == null ? this.m_bShowTexture : this.m_bShowTexture && (!this.m_bIsBackface && (this.m_textureSide & 1) != 0 || this.m_bIsBackface && (this.m_textureSide & 2) != 0);
        boolean bl2 = this.m_bShowTaggedElements && this.m_bHasTaggedElements && this.m_element[n].hasTag(12);
        boolean bl3 = this.m_bShowTaggedElements && this.m_bHasTaggedElements && this.m_element[n].hasTag(11);
        this.m_bIsTaggedElement = bl = this.m_bShowTaggedElements && this.m_bHasTaggedElements && this.m_element[n].hasTag(1);
        boolean bl4 = this.m_element[n].getURL() != null;
        this.m_bElemIsClipped = false;
        if (this.m_bIsClippable && this.m_bEnableClipBounds && this.m_clipBounds != null) {
            int n8;
            if (n7 > 2 * this.m_maxSizeOfElements / 3) {
                this.setMaxSizeElements(2 * this.m_maxSizeOfElements);
            }
            for (n6 = 0; n6 < n7; ++n6) {
                this.project(this.m_vd[n6], this.m_vertex[this.m_element[n].m_data[n6]], this.m_modelMatrix, this.m_ambientMatrix);
            }
            n6 = 0;
            for (n5 = 0; n5 < 3; ++n5) {
                n8 = 0;
                n4 = 0;
                for (n3 = 0; n3 < n7; ++n3) {
                    if (this.m_vd[n3].m_data[n5] < this.m_clipBounds[0].m_data[n5] - 1.0E-10) {
                        ++n8;
                    }
                    if (!(this.m_vd[n3].m_data[n5] > this.m_clipBounds[1].m_data[n5] + 1.0E-10)) continue;
                    ++n4;
                }
                if (n8 == n7 || n4 == n7) {
                    return;
                }
                n6 += n8 + n4;
            }
            if (n6 != 0) {
                this.m_bElemIsClipped = true;
                if (this.m_bShowLighting && this.m_bLocShowSmoothLighting) {
                    for (n5 = 0; n5 < n7; ++n5) {
                        n8 = this.m_element[n].m_data[n5];
                        if (!(this.m_vertexNormal == null || this.m_bHasCreaseEdge && this.m_bCreaseEdge[n8])) {
                            this.renderLight(this.m_vertex[n8], this.m_vertexNormal[n8], this.m_light);
                        } else if (this.m_elementNormal != null) {
                            this.renderLight(this.m_vertex[n8], this.m_elementNormal[n], this.m_light);
                        } else {
                            this.makeElementNormal(this.m_tmpNormal, n, n7);
                            this.renderLight(this.m_vertex[n8], this.m_tmpNormal, this.m_light);
                        }
                        for (n4 = 0; n4 < 3; ++n4) {
                            this.m_lv[n5][n4] = this.m_lightAttMat[n4];
                            this.m_lv[n5][n4 + 3] = this.m_lightAttSpec[n4];
                        }
                    }
                }
                if (this.m_bLocShowSmoothElementColors) {
                    for (n5 = 0; n5 < n7; ++n5) {
                        Color color = this.getElementColor(n, n5, bl2, bl3, bl, bl4);
                        PvGeometry.setScaledColor(this.m_cv[n5], color.getRGB(), 16);
                    }
                }
                if (this.m_bUseTexture) {
                    this.projectTextures(this.m_tv, n, n7);
                }
                for (n5 = 0; n5 < n7; ++n5) {
                    this.m_origInd[n5] = this.m_element[n].m_data[n5];
                }
                this.m_bElemIsClipped = false;
                for (n5 = 0; n5 < 3; ++n5) {
                    if (this.m_clipBounds[0].m_data[n5] > this.m_clipBounds[1].m_data[n5]) continue;
                    this.m_bElemIsClipped = true;
                    n7 = this.clipElement3D(n7, this.m_vd, this.m_origInd, this.m_tv, this.m_cv, this.m_lv, n5, (float)this.m_clipBounds[0].m_data[n5], (float)this.m_clipBounds[1].m_data[n5]);
                }
                for (n5 = 0; n5 < n7; ++n5) {
                    this.project(this.m_centerTrans, this.m_vd[n5], this.m_projviewMat);
                    this.m_xv[n5] = this.m_centerTrans.m_data[0];
                    this.m_yv[n5] = this.m_centerTrans.m_data[1];
                    this.m_zv[n5] = this.m_centerTrans.m_data[2];
                }
                if (n7 == 0) {
                    return;
                }
            }
        }
        if (!this.m_bElemIsClipped) {
            if (this.m_bIsClippable && this.m_bEnableClipCamera) {
                if (this.m_bShowLighting && this.m_bLocShowSmoothLighting) {
                    for (n6 = 0; n6 < n7; ++n6) {
                        n5 = this.m_element[n].m_data[n6];
                        if (!(this.m_vertexNormal == null || this.m_bHasCreaseEdge && this.m_bCreaseEdge[n5])) {
                            this.renderLight(this.m_vertex[n5], this.m_vertexNormal[n5], this.m_light);
                        } else if (this.m_elementNormal != null) {
                            this.renderLight(this.m_vertex[n5], this.m_elementNormal[n], this.m_light);
                        } else {
                            this.makeElementNormal(this.m_tmpNormal, n, n7);
                            this.renderLight(this.m_vertex[n5], this.m_tmpNormal, this.m_light);
                        }
                        for (n2 = 0; n2 < 3; ++n2) {
                            this.m_lvClip[n6][n2] = this.m_lightAttMat[n2];
                            this.m_lvClip[n6][n2 + 3] = this.m_lightAttSpec[n2];
                        }
                    }
                }
                if (this.m_bLocShowSmoothElementColors || this.m_bLocShowElementColorFromVertices) {
                    for (n6 = 0; n6 < n7; ++n6) {
                        Color color = this.getElementColor(n, n6, bl2, bl3, bl, bl4);
                        PvGeometry.setScaledColor(this.m_cvClip[n6], color.getRGB(), 16);
                    }
                }
                if (this.m_bUseTexture) {
                    this.projectTextures(this.m_tvClip, n, n7);
                }
                this.m_bElemIsClipped = false;
                if ((n7 = this.clipElement(n, n7, this.m_xv, this.m_yv, this.m_zv, this.m_origInd, this.m_tv, this.m_tvClip, this.m_cv, this.m_cvClip, this.m_lv, this.m_lvClip)) == 0) {
                    return;
                }
            } else {
                for (n6 = 0; n6 < n7; ++n6) {
                    n5 = this.m_element[n].m_data[n6];
                    this.m_xv[n6] = this.m_vertexTrans[n5].m_data[0];
                    this.m_yv[n6] = this.m_vertexTrans[n5].m_data[1];
                    this.m_zv[n6] = this.m_vertexTrans[n5].m_data[2];
                    if (this.m_bAutoClip && (this.m_zv[n6] > this.m_autoClip || this.m_zv[n6] < -this.m_autoClip)) {
                        return;
                    }
                    this.m_origInd[n6] = n5;
                }
                if (this.m_bShowLighting && this.m_bLocShowSmoothLighting) {
                    for (n6 = 0; n6 < n7; ++n6) {
                        n5 = this.m_element[n].m_data[n6];
                        if (!(this.m_vertexNormal == null || this.m_bHasCreaseEdge && this.m_bCreaseEdge[n5])) {
                            this.renderLight(this.m_vertex[n5], this.m_vertexNormal[n5], this.m_light);
                        } else if (this.m_elementNormal != null) {
                            this.renderLight(this.m_vertex[n5], this.m_elementNormal[n], this.m_light);
                        } else {
                            this.makeElementNormal(this.m_tmpNormal, n, n7);
                            this.renderLight(this.m_vertex[n5], this.m_tmpNormal, this.m_light);
                        }
                        for (n2 = 0; n2 < 3; ++n2) {
                            this.m_lv[n6][n2] = this.m_lightAttMat[n2];
                            this.m_lv[n6][n2 + 3] = this.m_lightAttSpec[n2];
                        }
                    }
                }
                if (this.m_bLocShowSmoothElementColors) {
                    for (n6 = 0; n6 < n7; ++n6) {
                        Color color = this.getElementColor(n, n6, bl2, bl3, bl, bl4);
                        n2 = color.getRGB();
                        PvGeometry.setScaledColor(this.m_cv[n6], n2, 16);
                    }
                }
                if (this.m_bUseTexture) {
                    this.projectTextures(this.m_tv, n, n7);
                }
            }
        }
        if (this.m_bUseTexture) {
            for (n6 = 0; n6 < n7; ++n6) {
                this.m_tv[n6].m_data[2] = (2 * this.m_sceneZFac + 8 * (this.m_zv[n6] - this.m_scene.m_zMin)) / 10;
            }
        }
        n6 = 6;
        this.m_bShowCurrElement = this.m_bShowElements || bl;
        this.m_bShowCurrEdge = (this.m_bShowEdges || this.m_bShowTaggedEdges && this.m_bHasTaggedEdges) && n7 < n6;
        this.m_bDrawingEdge = false;
        this.m_bDepthcueEdge = false;
        Color color = this.getElementColor(n, -1, bl2, bl3, bl, bl4);
        if (this.m_bShowLighting && !this.m_bLocShowSmoothLighting) {
            n2 = this.m_element[n].m_data[0];
            if (this.m_elementNormal != null) {
                this.renderLight(this.m_vertex[n2], this.m_elementNormal[n], this.m_light);
            } else {
                this.makeElementNormal(this.m_tmpNormal, n, n7);
                this.renderLight(this.m_vertex[n2], this.m_tmpNormal, this.m_light);
            }
            if (!this.m_bEnableZBuffer) {
                color = this.attenuateColor(color, this.m_lightAttMat, this.m_lightAttSpec);
            }
        }
        if (this.m_bShowElements || bl) {
            if (!this.m_bEnableZBuffer || !(this.m_globalEdgeSize < 2.0) || !this.m_bShowElements || this.m_bShowSilhouette) {
                this.m_bShowCurrEdge = false;
            }
            if (this.m_bEnableZBuffer) {
                if (this.m_bShowCurrEdge) {
                    this.m_currEdgeCol = this.m_alpha | this.getEdgeColor_(n, -1, -1, -1, -1).getRGB();
                }
                n2 = color.getRGB();
                if (n7 > n6) {
                    if (this.m_xvSub == null) {
                        this.m_xvSub = new int[3];
                        this.m_yvSub = new int[3];
                        this.m_zvSub = new int[3];
                        this.m_cvSub = new int[3][];
                    }
                    this.m_elemSub = this.triangulate(this.m_xv, this.m_yv, this.m_zv, n7);
                    if (this.m_elemSub == null) {
                        return;
                    }
                    for (n4 = 0; n4 < n7 - 2; ++n4) {
                        for (n3 = 0; n3 < 3; ++n3) {
                            this.m_xvSub[n3] = this.m_xv[this.m_elemSub[n4][n3]];
                            this.m_yvSub[n3] = this.m_yv[this.m_elemSub[n4][n3]];
                            this.m_zvSub[n3] = this.m_zv[this.m_elemSub[n4][n3]];
                            this.m_cvSub[n3] = this.m_cv[this.m_elemSub[n4][n3]];
                            if (this.m_bShowLighting) {
                                this.m_lvSub[n3] = this.m_lv[this.m_elemSub[n4][n3]];
                            }
                            if (!this.m_bUseTexture) continue;
                            this.m_tvSub[n3] = this.m_tv[this.m_elemSub[n4][n3]];
                        }
                        this.drawElementZBuffer(this.m_xvSub, this.m_yvSub, this.m_zvSub, 3, this.m_cvSub, n2, this.m_lvSub, this.m_tvSub);
                    }
                } else {
                    this.drawElementZBuffer(this.m_xv, this.m_yv, this.m_zv, n7, this.m_cv, n2, this.m_lv, this.m_tv);
                }
            } else {
                if (this.m_bShowDepthcue) {
                    color = PdColor.getDimmedColor(color, (int)(255.0f * this.m_heightFac));
                }
                graphics.setColor(color);
                graphics.fillPolygon(this.m_xv, this.m_yv, n7);
            }
        }
        this.m_bShowCurrElement = true;
        this.m_bShowCurrEdge = false;
        this.m_bDrawingEdge = true;
        n2 = this.m_bShowLighting ? 1 : 0;
        if (this.m_bEnable3DLook) {
            this.m_bShowLighting = false;
        }
        boolean bl5 = this.m_bDepthcueEdge = !this.m_bShowElements && this.m_bShowDepthcue;
        if (this.m_bShowEdges || this.m_bShowTaggedEdges && this.m_bHasTaggedEdges) {
            if (this.m_bAdaptiveSize || this.m_bEnable3DLook && this.m_globalEdgeSize > 1.0 || !this.m_bEnableZBuffer || !(this.m_globalEdgeSize < 2.0) || n7 >= n6 || !this.m_bShowElements || this.m_bShowSilhouette) {
                n4 = this.m_bShowSmoothShading ? 1 : 0;
                this.m_bShowSmoothShading = this.m_bShowSmoothEdgeColors && this.m_bShowEdgeColors;
                this.drawElementEdges(graphics, n, n7, this.m_xv, this.m_yv, this.m_zv, this.m_cv, this.m_lv);
                this.m_bShowSmoothShading = n4;
            }
        } else if (this.m_bShowSilhouette) {
            this.drawElementEdges(graphics, n, n7, this.m_xv, this.m_yv, this.m_zv, this.m_cv, this.m_lv);
        }
        if (!(!this.m_bShowBoundaries || this.m_bEnableClip && this.m_bElemIsClipped)) {
            this.drawElementBnd(graphics, n, n7, this.m_xv, this.m_yv, this.m_zv);
        }
        this.m_bShowLighting = n2;
        if (!this.m_useVertices && (this.m_bShowVertices || this.m_bShowTaggedVertices && this.m_bHasTaggedVertices || this.m_bShowVertexLabels || this.m_bShowVertexNormals || this.m_bShowVectors)) {
            this.drawElementVertices(graphics, n, n7, this.m_origInd);
        }
        if ((this.m_bShowIndices || this.m_bShowElementLabels) && (this.m_bShowElements || this.m_bShowTaggedElements && this.m_bHasTaggedElements)) {
            n4 = 0;
            n3 = 0;
            int n9 = Integer.MIN_VALUE;
            for (int i = n7 - 1; i >= 0; --i) {
                n4 += this.m_xv[i];
                n3 += this.m_yv[i];
                if (n9 >= this.m_zv[i]) continue;
                n9 = this.m_zv[i];
            }
            String string = this.m_element[n].getName();
            if (string == null && this.m_bEnabledIndexLabels) {
                string = String.valueOf(n);
            }
            if (string != null) {
                this.drawString(graphics, string, n4 / n7, n3 / n7, n9, 0, 3);
            }
        }
        if (this.m_bShowElementNormals) {
            this.drawElementNormal(graphics, n, n7, this.m_xv, this.m_yv, this.m_zv);
        }
        if (this.m_bShowVectors) {
            this.drawElementVectors(graphics, n, n7, this.m_xv, this.m_yv, this.m_zv, this.m_origInd);
        }
    }

    private void drawTetra(Graphics graphics, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        if (n < 0 || this.m_numElements <= n) {
            return;
        }
        int n14 = this.m_element[n].m_data.length;
        if (n14 == 0) {
            return;
        }
        if (2 * n14 > this.m_maxSizeOfElements) {
            this.setMaxSizeElements(2 * n14);
        }
        this.m_bElementDrawn = true;
        if (this.m_bFastClipping) {
            n13 = 0;
            n12 = 0;
            n11 = 0;
            n10 = 0;
            n9 = 0;
            for (n8 = 0; n8 < n14; ++n8) {
                n7 = this.m_element[n].m_data[n8];
                n6 = this.m_vertexTrans[n7].m_data[0];
                n5 = this.m_vertexTrans[n7].m_data[1];
                n4 = this.m_vertexTrans[n7].m_data[2];
                if (n6 < 0) {
                    ++n13;
                    continue;
                }
                if (n5 < 0) {
                    ++n10;
                    continue;
                }
                if (n6 >= this.m_dispSizePS_ZOOM.width) {
                    ++n12;
                    continue;
                }
                if (n5 >= this.m_dispSizePS_ZOOM.height) {
                    ++n11;
                    continue;
                }
                if (this.m_bDirtyClipping && this.m_bEnableZBuffer && !this.m_bShowLocTransparency && n4 - this.m_zTolVertex >= this.m_zBuffer[n5][n6]) continue;
            }
            if (n13 == n14 || n10 == n14 || n12 == n14 || n11 == n14 || n9 == n14) {
                this.m_bElementDrawn = false;
                return;
            }
        }
        this.m_bIsBackface = this.isBackElementCulled(n);
        if (!this.m_bShowBackface && this.m_bIsBackface) {
            return;
        }
        this.m_bUseTexture = this.m_elementNormal == null ? this.m_bShowTexture : this.m_bShowTexture && (!this.m_bIsBackface && (this.m_textureSide & 1) != 0 || this.m_bIsBackface && (this.m_textureSide & 2) != 0);
        n13 = this.m_bShowTaggedElements && this.m_bHasTaggedElements && this.m_element[n].hasTag(12) ? 1 : 0;
        n12 = this.m_bShowTaggedElements && this.m_bHasTaggedElements && this.m_element[n].hasTag(11) ? 1 : 0;
        n11 = this.m_bShowTaggedElements && this.m_bHasTaggedElements && this.m_element[n].hasTag(1) ? 1 : 0;
        this.m_bIsTaggedElement = n11;
        n10 = this.m_element[n].getURL() != null ? 1 : 0;
        this.m_bElemIsClipped = false;
        if (this.m_bIsClippable && this.m_bEnableClipBounds && this.m_clipBounds != null) {
            if (n14 > 2 * this.m_maxSizeOfElements / 3) {
                this.setMaxSizeElements(2 * this.m_maxSizeOfElements);
            }
            for (n9 = 0; n9 < n14; ++n9) {
                this.project(this.m_vd[n9], this.m_vertex[this.m_element[n].m_data[n9]], this.m_modelMatrix, this.m_ambientMatrix);
            }
            n9 = 0;
            for (n8 = 0; n8 < 3; ++n8) {
                n7 = 0;
                n6 = 0;
                for (n5 = 0; n5 < n14; ++n5) {
                    if (this.m_vd[n5].m_data[n8] < this.m_clipBounds[0].m_data[n8] - 1.0E-10) {
                        ++n7;
                    }
                    if (!(this.m_vd[n5].m_data[n8] > this.m_clipBounds[1].m_data[n8] + 1.0E-10)) continue;
                    ++n6;
                }
                if (n7 == n14 || n6 == n14) {
                    return;
                }
                n9 += n7 + n6;
            }
            if (n9 != 0) {
                this.m_bElemIsClipped = true;
                if (this.m_bShowLighting && this.m_bLocShowSmoothLighting) {
                    for (n8 = 0; n8 < n14; ++n8) {
                        n7 = this.m_element[n].m_data[n8];
                        if (!(this.m_vertexNormal == null || this.m_bHasCreaseEdge && this.m_bCreaseEdge[n7])) {
                            this.renderLight(this.m_vertex[n7], this.m_vertexNormal[n7], this.m_light);
                        } else if (this.m_elementNormal != null) {
                            this.renderLight(this.m_vertex[n7], this.m_elementNormal[n], this.m_light);
                        } else {
                            this.makeElementNormal(this.m_tmpNormal, n, n14);
                            this.renderLight(this.m_vertex[n7], this.m_tmpNormal, this.m_light);
                        }
                        for (n6 = 0; n6 < 3; ++n6) {
                            this.m_lv[n8][n6] = this.m_lightAttMat[n6];
                            this.m_lv[n8][n6 + 3] = this.m_lightAttSpec[n6];
                        }
                    }
                }
                if (this.m_bLocShowSmoothElementColors) {
                    for (n8 = 0; n8 < n14; ++n8) {
                        Color color = this.getElementColor(n, n8, n13 != 0, n12 != 0, n11 != 0, n10 != 0);
                        PvGeometry.setScaledColor(this.m_cv[n8], color.getRGB(), 16);
                    }
                }
                if (this.m_bUseTexture) {
                    this.projectTextures(this.m_tv, n, n14);
                }
                for (n8 = 0; n8 < n14; ++n8) {
                    this.m_origInd[n8] = this.m_element[n].m_data[n8];
                }
                this.m_bElemIsClipped = false;
                for (n8 = 0; n8 < 3; ++n8) {
                    if (this.m_clipBounds[0].m_data[n8] > this.m_clipBounds[1].m_data[n8]) continue;
                    this.m_bElemIsClipped = true;
                    n14 = this.clipElement3D(n14, this.m_vd, this.m_origInd, this.m_tv, this.m_cv, this.m_lv, n8, (float)this.m_clipBounds[0].m_data[n8], (float)this.m_clipBounds[1].m_data[n8]);
                }
                for (n8 = 0; n8 < n14; ++n8) {
                    this.project(this.m_centerTrans, this.m_vd[n8], this.m_projviewMat);
                    this.m_xv[n8] = this.m_centerTrans.m_data[0];
                    this.m_yv[n8] = this.m_centerTrans.m_data[1];
                    this.m_zv[n8] = this.m_centerTrans.m_data[2];
                }
                if (n14 == 0) {
                    return;
                }
            }
        }
        if (!this.m_bElemIsClipped) {
            if (this.m_bIsClippable && this.m_bEnableClipCamera) {
                if (this.m_bShowLighting && this.m_bLocShowSmoothLighting) {
                    for (n9 = 0; n9 < n14; ++n9) {
                        n8 = this.m_element[n].m_data[n9];
                        if (!(this.m_vertexNormal == null || this.m_bHasCreaseEdge && this.m_bCreaseEdge[n8])) {
                            this.renderLight(this.m_vertex[n8], this.m_vertexNormal[n8], this.m_light);
                        } else if (this.m_elementNormal != null) {
                            this.renderLight(this.m_vertex[n8], this.m_elementNormal[n], this.m_light);
                        } else {
                            this.makeElementNormal(this.m_tmpNormal, n, n14);
                            this.renderLight(this.m_vertex[n8], this.m_tmpNormal, this.m_light);
                        }
                        for (int i = 0; i < 3; ++i) {
                            this.m_lvClip[n9][i] = this.m_lightAttMat[i];
                            this.m_lvClip[n9][i + 3] = this.m_lightAttSpec[i];
                        }
                    }
                }
                if (this.m_bLocShowSmoothElementColors || this.m_bLocShowElementColorFromVertices) {
                    for (n9 = 0; n9 < n14; ++n9) {
                        Color color = this.getElementColor(n, n9, n13 != 0, n12 != 0, n11 != 0, n10 != 0);
                        PvGeometry.setScaledColor(this.m_cvClip[n9], color.getRGB(), 16);
                    }
                }
                if (this.m_bUseTexture) {
                    this.projectTextures(this.m_tvClip, n, n14);
                }
                this.m_bElemIsClipped = false;
                if ((n14 = this.clipElement(n, n14, this.m_xv, this.m_yv, this.m_zv, this.m_origInd, this.m_tv, this.m_tvClip, this.m_cv, this.m_cvClip, this.m_lv, this.m_lvClip)) == 0) {
                    return;
                }
            } else {
                for (n9 = 0; n9 < n14; ++n9) {
                    n8 = this.m_element[n].m_data[n9];
                    this.m_xv[n9] = this.m_vertexTrans[n8].m_data[0];
                    this.m_yv[n9] = this.m_vertexTrans[n8].m_data[1];
                    this.m_zv[n9] = this.m_vertexTrans[n8].m_data[2];
                    if (this.m_bAutoClip && (this.m_zv[n9] > this.m_autoClip || this.m_zv[n9] < -this.m_autoClip)) {
                        return;
                    }
                    this.m_origInd[n9] = n8;
                }
                if (this.m_bShowLighting && this.m_bLocShowSmoothLighting) {
                    for (n9 = 0; n9 < n14; ++n9) {
                        n8 = this.m_element[n].m_data[n9];
                        if (!(this.m_vertexNormal == null || this.m_bHasCreaseEdge && this.m_bCreaseEdge[n8])) {
                            this.renderLight(this.m_vertex[n8], this.m_vertexNormal[n8], this.m_light);
                        } else if (this.m_elementNormal != null) {
                            this.renderLight(this.m_vertex[n8], this.m_elementNormal[n], this.m_light);
                        } else {
                            this.makeElementNormal(this.m_tmpNormal, n, n14);
                            this.renderLight(this.m_vertex[n8], this.m_tmpNormal, this.m_light);
                        }
                        for (int i = 0; i < 3; ++i) {
                            this.m_lv[n9][i] = this.m_lightAttMat[i];
                            this.m_lv[n9][i + 3] = this.m_lightAttSpec[i];
                        }
                    }
                }
                if (this.m_bLocShowSmoothElementColors) {
                    for (n9 = 0; n9 < n14; ++n9) {
                        Color color = this.getElementColor(n, n9, n13 != 0, n12 != 0, n11 != 0, n10 != 0);
                        int n15 = color.getRGB();
                        PvGeometry.setScaledColor(this.m_cv[n9], n15, 16);
                    }
                }
                if (this.m_bUseTexture) {
                    this.projectTextures(this.m_tv, n, n14);
                }
            }
        }
        if (this.m_bUseTexture) {
            for (n9 = 0; n9 < n14; ++n9) {
                this.m_tv[n9].m_data[2] = (2 * this.m_sceneZFac + 8 * (this.m_zv[n9] - this.m_scene.m_zMin)) / 10;
            }
        }
        n9 = 6;
        this.m_bShowCurrElement = this.m_bShowElements || n11 != 0;
        this.m_bShowCurrEdge = (this.m_bShowEdges || this.m_bShowTaggedEdges && this.m_bHasTaggedEdges) && n14 < n9;
        this.m_bDrawingEdge = false;
        this.m_bDepthcueEdge = false;
        Color color = this.getElementColor(n, -1, n13 != 0, n12 != 0, n11 != 0, n10 != 0);
        if (this.m_bShowLighting && !this.m_bLocShowSmoothLighting) {
            int n16 = this.m_element[n].m_data[0];
            if (this.m_elementNormal != null) {
                this.renderLight(this.m_vertex[n16], this.m_elementNormal[n], this.m_light);
            } else {
                this.makeElementNormal(this.m_tmpNormal, n, n14);
                this.renderLight(this.m_vertex[n16], this.m_tmpNormal, this.m_light);
            }
            if (!this.m_bEnableZBuffer) {
                color = this.attenuateColor(color, this.m_lightAttMat, this.m_lightAttSpec);
            }
        }
        int n17 = 4;
        n6 = 3;
        if (this.m_xvSub == null) {
            this.m_xvSub = new int[n6];
            this.m_yvSub = new int[n6];
            this.m_zvSub = new int[n6];
            this.m_cvSub = new int[n6][];
        }
        if (this.m_bShowElements || n11 != 0) {
            if (!this.m_bEnableZBuffer || !(this.m_globalEdgeSize < 2.0) || !this.m_bShowElements || this.m_bShowSilhouette) {
                this.m_bShowCurrEdge = false;
            }
            if (this.getType() == 34) {
                this.m_elemSub[0][0] = 0;
                this.m_elemSub[0][1] = 2;
                this.m_elemSub[0][2] = 1;
                this.m_elemSub[1][0] = 1;
                this.m_elemSub[1][1] = 2;
                this.m_elemSub[1][2] = 3;
                this.m_elemSub[2][0] = 2;
                this.m_elemSub[2][1] = 0;
                this.m_elemSub[2][2] = 3;
                this.m_elemSub[3][0] = 0;
                this.m_elemSub[3][1] = 1;
                this.m_elemSub[3][2] = 3;
            }
            for (n5 = 0; n5 < n17; ++n5) {
                for (n4 = 0; n4 < n6; ++n4) {
                    this.m_xvSub[n4] = this.m_xv[this.m_elemSub[n5][n4]];
                    this.m_yvSub[n4] = this.m_yv[this.m_elemSub[n5][n4]];
                    if (!this.m_bEnableZBuffer) continue;
                    this.m_zvSub[n4] = this.m_zv[this.m_elemSub[n5][n4]];
                    this.m_cvSub[n4] = this.m_cv[this.m_elemSub[n5][n4]];
                    if (this.m_bShowLighting) {
                        this.m_lvSub[n4] = this.m_lv[this.m_elemSub[n5][n4]];
                    }
                    if (!this.m_bUseTexture) continue;
                    this.m_tvSub[n4] = this.m_tv[this.m_elemSub[n5][n4]];
                }
                if (this.m_bEnableZBuffer) {
                    if (this.m_bShowCurrEdge) {
                        this.m_currEdgeCol = this.m_alpha | this.getEdgeColor_(n, -1, -1, -1, -1).getRGB();
                    }
                    n4 = color.getRGB();
                    this.drawElementZBuffer(this.m_xvSub, this.m_yvSub, this.m_zvSub, n6, this.m_cvSub, n4, this.m_lvSub, this.m_tvSub);
                    continue;
                }
                if (this.m_bShowDepthcue) {
                    color = PdColor.getDimmedColor(color, (int)(255.0f * this.m_heightFac));
                }
                graphics.setColor(color);
                graphics.fillPolygon(this.m_xvSub, this.m_yvSub, n6);
            }
        }
        this.m_bShowCurrElement = true;
        this.m_bShowCurrEdge = false;
        this.m_bDrawingEdge = true;
        n5 = this.m_bShowLighting ? 1 : 0;
        if (this.m_bEnable3DLook) {
            this.m_bShowLighting = false;
        }
        boolean bl = this.m_bDepthcueEdge = !this.m_bShowElements && this.m_bShowDepthcue;
        if (this.m_bShowEdges || this.m_bShowTaggedEdges && this.m_bHasTaggedEdges) {
            if (this.m_bAdaptiveSize || this.m_bEnable3DLook && this.m_globalEdgeSize > 1.0 || !this.m_bEnableZBuffer || !(this.m_globalEdgeSize < 2.0) || n14 >= n9 || !this.m_bShowElements || this.m_bShowSilhouette) {
                n4 = this.m_bShowSmoothShading ? 1 : 0;
                this.m_bShowSmoothShading = this.m_bShowSmoothEdgeColors && this.m_bShowEdgeColors;
                for (n3 = 0; n3 < n17; ++n3) {
                    for (n2 = 0; n2 < n6; ++n2) {
                        this.m_xvSub[n2] = this.m_xv[this.m_elemSub[n3][n2]];
                        this.m_yvSub[n2] = this.m_yv[this.m_elemSub[n3][n2]];
                        if (!this.m_bEnableZBuffer) continue;
                        this.m_zvSub[n2] = this.m_zv[this.m_elemSub[n3][n2]];
                        this.m_cvSub[n2] = this.m_cv[this.m_elemSub[n3][n2]];
                        if (this.m_bShowLighting) {
                            this.m_lvSub[n2] = this.m_lv[this.m_elemSub[n3][n2]];
                        }
                        if (!this.m_bUseTexture) continue;
                        this.m_tvSub[n2] = this.m_tv[this.m_elemSub[n3][n2]];
                    }
                    this.drawElementEdges(graphics, n, n6, this.m_xvSub, this.m_yvSub, this.m_zvSub, this.m_cvSub, this.m_lvSub);
                }
                this.m_bShowSmoothShading = n4;
            }
        } else if (this.m_bShowSilhouette) {
            this.drawElementEdges(graphics, n, n14, this.m_xv, this.m_yv, this.m_zv, this.m_cv, this.m_lv);
        }
        if (!(!this.m_bShowBoundaries || this.m_bEnableClip && this.m_bElemIsClipped)) {
            this.drawElementBnd(graphics, n, n14, this.m_xv, this.m_yv, this.m_zv);
        }
        this.m_bShowLighting = n5;
        if (!this.m_useVertices && (this.m_bShowVertices || this.m_bShowTaggedVertices && this.m_bHasTaggedVertices || this.m_bShowVertexLabels || this.m_bShowVertexNormals || this.m_bShowVectors)) {
            this.drawElementVertices(graphics, n, n14, this.m_origInd);
        }
        if ((this.m_bShowIndices || this.m_bShowElementLabels) && (this.m_bShowElements || this.m_bShowTaggedElements && this.m_bHasTaggedElements)) {
            n4 = 0;
            n3 = 0;
            n2 = Integer.MIN_VALUE;
            for (int i = n14 - 1; i >= 0; --i) {
                n4 += this.m_xv[i];
                n3 += this.m_yv[i];
                if (n2 >= this.m_zv[i]) continue;
                n2 = this.m_zv[i];
            }
            String string = this.m_element[n].getName();
            if (string == null && this.m_bEnabledIndexLabels) {
                string = String.valueOf(n);
            }
            if (string != null) {
                this.drawString(graphics, string, n4 / n14, n3 / n14, n2, 0, 3);
            }
        }
        if (this.m_bShowElementNormals) {
            this.drawElementNormal(graphics, n, n14, this.m_xv, this.m_yv, this.m_zv);
        }
        if (this.m_bShowVectors) {
            this.drawElementVectors(graphics, n, n14, this.m_xv, this.m_yv, this.m_zv, this.m_origInd);
        }
    }

    protected void burnElement(int n, int[] nArray, int n2, int n3, PsScanline psScanline, boolean bl) {
        int n4;
        int n5;
        int n6;
        boolean bl2;
        boolean bl3;
        if (this.m_bary == null) {
            this.m_bary = new double[3];
            this.m_baryDelta = new double[3];
        }
        boolean bl4 = this.m_bShowDepthcue;
        this.m_bShowDepthcue = false;
        int n7 = this.m_element[n].m_data.length;
        if (n7 == 0) {
            return;
        }
        this.m_bIsBackface = this.isBackElementCulled(n);
        boolean bl5 = this.m_bShowTaggedElements && this.m_bHasTaggedElements && this.m_element[n].hasTag(12);
        boolean bl6 = this.m_bShowTaggedElements && this.m_bHasTaggedElements && this.m_element[n].hasTag(11);
        this.m_bIsTaggedElement = bl3 = this.m_bShowTaggedElements && this.m_bHasTaggedElements && this.m_element[n].hasTag(1);
        boolean bl7 = bl2 = this.m_element[n].getURL() != null;
        if (this.m_bShowSmoothShading) {
            for (n6 = 0; n6 < n7; ++n6) {
                Color color = this.getElementColor(n, n6, bl5, bl6, bl3, bl2);
                n5 = color.getRGB();
                this.m_cv[n6][0] = n5 >> 16 & 0xFF;
                this.m_cv[n6][1] = n5 >> 8 & 0xFF;
                this.m_cv[n6][2] = n5 & 0xFF;
            }
        } else {
            int n8;
            Color color = this.getElementColor(n, -1, bl5, bl6, bl3, bl2);
            if (this.m_bShowLighting) {
                n8 = this.m_element[n].m_data[0];
                if (this.m_elementNormal != null) {
                    this.renderLight(this.m_vertex[n8], this.m_elementNormal[n], this.m_light);
                } else {
                    this.makeElementNormal(this.m_tmpNormal, n, n7);
                    this.renderLight(this.m_vertex[n8], this.m_tmpNormal, this.m_light);
                }
                color = this.attenuateColor(color, this.m_lightAttMat, this.m_lightAttSpec);
            }
            n8 = color.getRGB();
            for (n5 = 0; n5 < n7; ++n5) {
                this.m_cv[n5][0] = n8 >> 16 & 0xFF;
                this.m_cv[n5][1] = n8 >> 8 & 0xFF;
                this.m_cv[n5][2] = n8 & 0xFF;
            }
        }
        if (this.m_bShowTexture) {
            this.projectTextures(this.m_tv, n, n7);
        }
        n6 = 5;
        int n9 = psScanline.m_ymin;
        for (n5 = 0; n5 < psScanline.m_length; ++n5) {
            int n10;
            int n11;
            n4 = n9 * n2 + psScanline.m_xa[n5];
            for (n11 = 0; n11 < 3; ++n11) {
                this.m_bary[n11] = psScanline.m_aAnteile[n11][n5];
                this.m_baryDelta[n11] = (double)psScanline.m_eAnteile[n11][n5] - this.m_bary[n11];
                if (psScanline.m_xe[n5] <= psScanline.m_xa[n5]) continue;
                int n12 = n11;
                this.m_baryDelta[n12] = this.m_baryDelta[n12] / (double)(psScanline.m_xe[n5] - psScanline.m_xa[n5]);
            }
            for (n10 = psScanline.m_xa[n5]; n10 <= psScanline.m_xe[n5]; ++n10) {
                int n13;
                int n14 = 0;
                int n15 = 0;
                n11 = 0;
                for (n13 = 0; n13 < 3; ++n13) {
                    n11 = (int)((double)n11 + this.m_bary[n13] * (double)this.m_cv[n13][0]);
                    n15 = (int)((double)n15 + this.m_bary[n13] * (double)this.m_cv[n13][1]);
                    n14 = (int)((double)n14 + this.m_bary[n13] * (double)this.m_cv[n13][2]);
                }
                n11 = Math.max(Math.min(n11, 255), 0);
                n15 = Math.max(Math.min(n15, 255), 0);
                n14 = Math.max(Math.min(n14, 255), 0);
                if (bl) {
                    int n16 = n4;
                    nArray[n16] = nArray[n16] + (nArray[n4] & 0xFF000000 | n11 << 16 | n15 << 8 | n14);
                } else {
                    nArray[n4] = 0xFF000000 | n11 << 16 | n15 << 8 | n14;
                }
                ++n4;
                for (n13 = 0; n13 < 3; ++n13) {
                    int n17 = n13;
                    this.m_bary[n17] = this.m_bary[n17] + this.m_baryDelta[n13];
                }
            }
            n4 = n9 * n2;
            for (n10 = 1; n10 <= n6; ++n10) {
                if (n4 + psScanline.m_xa[n5] - n10 >= 0) {
                    nArray[n4 + psScanline.m_xa[n5] - n10] = nArray[n4 + psScanline.m_xa[n5]];
                }
                if (n4 + psScanline.m_xe[n5] + n10 >= nArray.length) continue;
                nArray[n4 + psScanline.m_xe[n5] + n10] = nArray[n4 + psScanline.m_xe[n5]];
            }
            ++n9;
        }
        n9 = psScanline.m_ymin - 1;
        if (n9 > 0) {
            for (n5 = 0; n5 < n6 - 1; ++n5) {
                for (n4 = psScanline.m_xa[0] - n6; n4 <= psScanline.m_xe[0] + n6; ++n4) {
                    if ((n9 - n5) * n2 + n4 < 0 || (n9 + 1) * n2 + n4 >= nArray.length) continue;
                    nArray[(n9 - n5) * n2 + n4] = nArray[(n9 + 1) * n2 + n4];
                }
            }
        }
        if (psScanline.m_length > 0 && (n9 = psScanline.m_ymin + psScanline.m_length) < n3) {
            for (n5 = 0; n5 < n6 - 1; ++n5) {
                for (n4 = psScanline.m_xa[psScanline.m_length - 1] - n6; n4 <= psScanline.m_xe[psScanline.m_length - 1] + n6; ++n4) {
                    if ((n9 - 1) * n2 + n4 < 0 || (n9 + n5) * n2 + n4 >= nArray.length) continue;
                    nArray[(n9 + n5) * n2 + n4] = nArray[(n9 - 1) * n2 + n4];
                }
            }
        }
        this.m_bShowDepthcue = bl4;
    }

    private void projectTextures(PiVector[] piVectorArray, int n, int n2) {
        int n3 = this.getDimOfTextures();
        PdVector pdVector = null;
        for (int i = 0; i < n2; ++i) {
            if (this.m_bShowVertexTexture) {
                pdVector = this.m_vertexTexture[this.m_element[n].m_data[i]];
            } else {
                if (!this.m_bShowElementTexture) break;
                pdVector = this.m_elementTexture[n][i];
            }
            for (int j = 0; j < n3; ++j) {
                piVectorArray[i].m_data[j] = (int)(pdVector.m_data[j] * 1048576.0);
            }
        }
    }

    private int[][] triangulate(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2;
        int n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            this.m_indVec[n2] = (n2 + 1) % n3;
        }
        int n4 = -1;
        int n5 = n3 - 1;
        int n6 = 0;
        int n7 = 0;
        if (this.m_currVertexArr == null || this.m_currVertexArr.length < n3) {
            this.m_currVertexArr = PdVector.realloc(this.m_currVertexArr, 2 * n3, 3);
        }
        while (n7 < n3 - 3) {
            int n8 = n3 - n7;
            int n9 = n6;
            for (n2 = 0; n2 < n8; ++n2) {
                this.m_currVertexArr[n2].set(nArray[n9], (double)nArray2[n9], 0.0);
                n9 = this.m_indVec[n9];
            }
            PdVector.angleWithOrientation(this.m_angleArr, this.m_currVertexArr, n8);
            double d = 0.0;
            int n10 = -1;
            n9 = n6;
            for (n2 = 0; n2 < n8; ++n2) {
                if ((this.m_angleArr[(n2 - 1 + n8) % n8] < 0.01 || this.m_angleArr[(n2 + 1) % n8] < 0.01) && this.m_angleArr[n2] > d) {
                    d = this.m_angleArr[n2];
                    n10 = n9;
                    n4 = n5;
                }
                n5 = n9;
                n9 = this.m_indVec[n9];
            }
            d = -1000.0;
            if (n10 == -1) {
                for (n2 = 0; n2 < n8; ++n2) {
                    if (this.m_angleArr[n2] > d) {
                        d = this.m_angleArr[n2];
                        n10 = n9;
                        n4 = n5;
                    }
                    n5 = n9;
                    n9 = this.m_indVec[n9];
                }
            }
            if (n10 == -1) {
                PsDebug.error("missing max angle");
                return null;
            }
            this.m_elemSub[n7][0] = n4;
            this.m_elemSub[n7][1] = n10;
            this.m_elemSub[n7][2] = this.m_indVec[n10];
            this.m_indVec[n4] = this.m_indVec[n10];
            n5 = n4;
            n6 = this.m_indVec[n10];
            ++n7;
        }
        this.m_elemSub[n7][0] = n6;
        this.m_elemSub[n7][1] = this.m_indVec[n6];
        this.m_elemSub[n7][2] = this.m_indVec[this.m_indVec[n6]];
        return this.m_elemSub;
    }

    private boolean isBackVertexCulled(int n) {
        if (this.m_vertexNormalTrans == null) {
            return false;
        }
        return this.m_vertexNormalTrans[n].hasTag(15);
    }

    private boolean isBackElementCulled(int n) {
        if (this.m_elementNormalTrans == null) {
            return false;
        }
        return this.m_elementNormalTrans[n].hasTag(15);
    }

    public void drawSpline(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = 3;
        int n11 = (n + n4) / 2;
        int n12 = (n2 + n5) / 2;
        int n13 = (n3 + n6) / 2;
        int n14 = (n4 + n7) / 2;
        int n15 = (n5 + n8) / 2;
        int n16 = (n6 + n9) / 2;
        int n17 = (n11 + n14) / 2;
        int n18 = (n12 + n15) / 2;
        int n19 = (n13 + n16) / 2;
        int n20 = (n + n17) / 2;
        int n21 = (n2 + n18) / 2;
        if (Math.abs(n11 - n20) + Math.abs(n12 - n21) > n10) {
            this.drawSpline(graphics, n, n2, n3, n11, n12, n13, n17, n18, n19);
        } else {
            this.drawLineAny(graphics, 2, n, n2, n3, n17, n18, n19, Color.red, Color.red, false);
        }
        n20 = (n7 + n17) / 2;
        n21 = (n8 + n18) / 2;
        if (Math.abs(n14 - n20) + Math.abs(n15 - n21) > n10) {
            this.drawSpline(graphics, n17, n18, n19, n14, n15, n16, n7, n8, n9);
        } else {
            this.drawLineAny(graphics, 2, n17, n18, n19, n7, n8, n9, Color.red, Color.red, false);
        }
    }

    private void drawLineAny(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, Color color, Color color2, boolean bl) {
        if (n == 0) {
            return;
        }
        if (color == null || color2 == null) {
            return;
        }
        if (this.m_bEnableZBuffer) {
            int n8 = color.getRGB();
            int n9 = color2.getRGB();
            int n10 = n8;
            int n11 = n9;
            if (n < 2) {
                this.drawLineZBresen(n2, n3, n4, n5, n6, n7, n10, n11);
            } else {
                int n12;
                if (!this.m_bEnable3DLook) {
                    this.drawLineZThick(n, n2, n3, n4, n5, n6, n7, n10, n11);
                } else {
                    n12 = this.m_iTransparency;
                    this.m_iTransparency = 0;
                    this.drawLineZThick3D(n, n2, n3, n4, n5, n6, n7, n10, n11);
                    this.m_iTransparency = n12;
                }
                if (bl && !this.m_bShowDepthcue) {
                    n12 = this.m_bShowVertexOutline ? 1 : 0;
                    this.m_bShowVertexOutline = false;
                    if (this.m_bShowLighting && !this.m_bEnable3DLook && this.m_lv != null) {
                        if (this.m_bLocShowSmoothLighting) {
                            n10 = PvGeometry.attenuateColor(n8, this.m_lv[0]);
                            n11 = PvGeometry.attenuateColor(n9, this.m_lv[1]);
                        } else {
                            n10 = PvGeometry.attenuateColor(n8, this.m_lightAttMat, this.m_lightAttSpec);
                            n11 = PvGeometry.attenuateColor(n9, this.m_lightAttMat, this.m_lightAttSpec);
                        }
                    }
                    int n13 = this.m_zTolVertex;
                    this.m_zTolVertex = this.m_zTolLine;
                    this.writeCircle(n2, n3, 1 + n >> 1, n10, n4);
                    this.writeCircle(n5, n6, 1 + n >> 1, n11, n7);
                    this.m_zTolVertex = n13;
                    this.m_bShowVertexOutline = n12;
                }
            }
        } else {
            graphics.setColor(color);
            if (n < 2 || n == PS_ZOOM) {
                graphics.drawLine(n2, n3, n5, n6);
            } else {
                this.drawLineThick(graphics, n, n2, n3, n5, n6, bl);
            }
        }
    }

    private void drawVectorAny(Graphics graphics, double d, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, Color color, boolean bl2) {
        int n7;
        boolean bl3;
        boolean bl4 = this.m_bShowSmoothShading;
        boolean bl5 = this.m_bShowDepthcue;
        this.m_bShowSmoothShading = false;
        this.m_bShowDepthcue = false;
        if (this.m_bAdaptiveSize) {
            float f = this.getAdaptiveScale(n3);
            if ((double)f < 0.0) {
                return;
            }
            d *= (double)f;
        }
        boolean bl6 = bl3 = (n7 = (int)(d + 0.5)) > 3 * this.m_offFac;
        if (this.m_bEnable3DLook && bl) {
            bl3 = false;
        }
        int n8 = this.m_zTolLine;
        this.m_zTolLine = bl2 ? -3 * this.m_zTolLine : 3 * this.m_zTolLine;
        this.drawLineAny(graphics, n7, n, n2, n3, n4, n5, n6, color, color, bl3);
        if (bl) {
            this.drawVectorTipAny(graphics, n7, n, n2, n3, n4, n5, n6, true, color);
        }
        this.m_zTolLine = n8;
        this.m_bShowDepthcue = bl5;
        this.m_bShowSmoothShading = bl4;
    }

    private void drawVectorTipAny(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, Color color) {
        double d = n5 - n2;
        double d2 = n6 - n3;
        double d3 = n7 - n4;
        double d4 = d * d + d2 * d2;
        if (d4 < 1.0) {
            return;
        }
        double d5 = (double)n + 4.0 * (double)this.m_offFac;
        if (n > 3 && this.m_offFac > 1) {
            d5 = (double)n + 4.0 * (double)this.m_offFac * 0.8;
        }
        double d6 = this.m_offFac;
        d6 *= d6;
        double d7 = bl ? 2.0 * d5 / Math.PI / Math.sqrt(d4) * Math.atan(d4 / 50.0 / d6) : 2.0 * d5 / Math.PI / Math.sqrt(d4) * Math.atan(8.0);
        d = (int)(d * d7);
        d2 = (int)(d2 * d7);
        d3 = (int)(d3 * d7);
        int n8 = n5 + (int)(-d + d2);
        int n9 = n6 + (int)(-d - d2);
        int n10 = n7 - (int)d3;
        boolean bl2 = this.m_bShowSmoothShading;
        boolean bl3 = this.m_bShowDepthcue;
        this.m_bShowSmoothShading = false;
        this.m_bShowDepthcue = false;
        this.drawLineAny(graphics, n, n5, n6, n7, n8, n9, n10, color, color, n > 3 * this.m_offFac);
        n8 = n5 + (int)(-d - d2);
        n9 = n6 + (int)(d - d2);
        this.drawLineAny(graphics, n, n5, n6, n7, n8, n9, n10, color, color, n > 3 * this.m_offFac);
        this.m_bShowDepthcue = bl3;
        this.m_bShowSmoothShading = bl2;
    }

    private void drawElementVectors(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        for (int i = 0; i < this.m_numVectorFields; ++i) {
            Color color;
            if (!this.m_bShowVectorField[i] || !this.m_vectorIsElementBased[i]) continue;
            if (this.m_vector[i][n].hasTag(1)) {
                color = this.m_globalElementTagColor;
            } else {
                color = this.m_globalVectorColor[i];
                if (this.m_bShowVectorColors[i]) {
                    color = this.m_vectorColor[i][n];
                }
            }
            this.drawVectorAny(graphics, this.m_globalVectorSize[i] * (double)this.m_offFac, this.m_elemCenterTrans[n].m_data[0], this.m_elemCenterTrans[n].m_data[1], this.m_elemCenterTrans[n].m_data[2], this.m_vectorTrans[i][n].m_data[0], this.m_vectorTrans[i][n].m_data[1], this.m_vectorTrans[i][n].m_data[2], this.m_bShowVectorArrow[i], color, false);
        }
    }

    private static void getElementCenter(PdVector pdVector, int[] nArray, PdVector[] pdVectorArray, int n) {
        int n2 = nArray.length;
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (int j = 0; j < n2; ++j) {
                d += pdVectorArray[nArray[j]].m_data[i];
            }
            pdVector.setEntry(i, d / (double)n2);
        }
    }

    private Color getElementCenterColor(int[] nArray) {
        int n = nArray.length;
        if (n == 0) {
            return Color.black;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            int n5 = this.m_vertexColor[nArray[i]].getRGB();
            n2 += n5 >> 16 & 0xFF;
            n3 += n5 >> 8 & 0xFF;
            n4 += n5 & 0xFF;
        }
        return new Color(n2 /= n, n3 /= n, n4 /= n);
    }

    private void drawElementNormal(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) {
        Color color = this.m_bShowDepthcue ? PdColor.getDimmedColor(this.m_globalElementNormalColor, (int)(255.0f * this.m_heightFac)) : this.m_globalElementNormalColor;
        this.drawVectorAny(graphics, this.m_globalElementNormalSize * (double)this.m_offFac, this.m_elemCenterTrans[n].m_data[0], this.m_elemCenterTrans[n].m_data[1], this.m_elemCenterTrans[n].m_data[2], this.m_elementNormalTrans[n].m_data[0], this.m_elementNormalTrans[n].m_data[1], this.m_elementNormalTrans[n].m_data[2], this.m_bShowElementNormalArrow, color, true);
    }

    private Color getPolygonColor(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Color color = null;
        if (bl4) {
            color = Color.cyan;
        } else if (bl || bl2) {
            color = this.m_globalPolygonTagColor;
        } else if (bl3) {
            color = this.m_globalPolygonTagColor;
        }
        if (color != null) {
            return color;
        }
        int n3 = this.m_polygon[n].m_data[n2];
        if (this.m_bShowPolygonColors && this.m_bLocShowEdgeColorFromVertices) {
            if (n3 != -1 && this.m_bShowSmoothShading) {
                color = this.m_vertexColor[n3];
            } else {
                int n4 = this.m_polygon[n].m_data[n2 + 1];
                color = PdColor.blend(0.5, this.m_vertexColor[n3], 0.5, this.m_vertexColor[n4]);
            }
        } else {
            color = this.m_vertexColorFromElement != null && n3 != -1 ? this.m_vertexColorFromElement[n3] : (this.m_bShowPolygonColors ? this.m_polygonColor[n] : this.m_globalPolygonColor);
        }
        if (this.m_bShowDepthcue && !this.m_bEnableZBuffer) {
            color = this.m_bEnable3DLook ? PdColor.getDimmedColor(color, (double)this.m_heightFac, (double)this.m_heightFac) : PdColor.getDimmedColor(color, (double)this.m_heightFac, (double)this.m_grey * (1.0 - (double)this.m_heightFac));
        }
        return color;
    }

    private Color getElementColor(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Color color = null;
        if (!bl4 && !bl) {
            if (bl2) {
                color = this.m_globalElementTagColor;
            } else if (bl3) {
                color = this.m_globalElementTagColor;
            }
        }
        if (color != null) {
            return color;
        }
        int n3 = n2 != -1 ? this.m_element[n].m_data[n2] : -1;
        color = this.m_bIsBackface && (this.m_bShowElementBackColor || this.m_bShowElementBackColors) ? (this.m_bShowElementBackColors ? this.m_elementBackColor[n] : this.m_globalElementBackColor) : (this.m_bShowElementColors && this.m_bLocShowElementColorFromVertices ? (n3 != -1 ? this.m_vertexColor[n3] : this.getElementCenterColor(this.m_element[n].m_data)) : (this.m_vertexColorFromElement != null && n3 != -1 && (!this.m_bHasCreaseEdge || !this.m_bCreaseEdge[n3]) ? this.m_vertexColorFromElement[n3] : (this.m_bShowElementColors ? this.m_elementColor[n] : this.m_globalElementColor)));
        return color;
    }

    private void renderLight(PdVector pdVector, PdVector pdVector2, PvLight[] pvLightArray) {
        int n;
        for (n = 0; n < 3; ++n) {
            this.m_lightAttMat[n] = 0;
            this.m_lightAttSpec[n] = 0;
        }
        if (this.m_bModAmb) {
            this.project(this.m_vtMod, pdVector, this.m_modelMatrix, this.m_ambientMatrix);
        } else {
            this.m_vtMod.copyArray_fastTmp(pdVector);
        }
        if (this.m_bHasHighlight || !this.m_bLightsSymmetric) {
            this.m_vertexEye.sub(this.m_cameraPos, this.m_vtMod);
            if (this.m_bHasHighlight) {
                this.m_vertexEye.normalize();
            }
        }
        if (this.m_bModAmb) {
            this.m_vtSrc.blendBase(pdVector, this.m_globalVertexNormalLength, pdVector2);
            this.project(this.m_vtTipMod, this.m_vtSrc, this.m_modelMatrix, this.m_ambientMatrix);
            this.m_vtTipMod.sub(this.m_vtMod);
            this.m_vtTipMod.normalize();
            this.m_vnMod.copyArray(this.m_vtTipMod);
        } else {
            this.m_vnMod.copyArray_fastTmp(pdVector2);
        }
        if (this.m_dim < 3) {
            this.m_vnMod.m_data[2] = 1.0;
        }
        for (n = 0; n < pvLightArray.length; ++n) {
            float f;
            float f2;
            float f3;
            float f4;
            PvLight pvLight = pvLightArray[n];
            if (!pvLight.m_bSwitchedOn) continue;
            float f5 = 1.0f;
            if (pvLight.m_lightType == 3) {
                float f6;
                this.m_vlMod.sub(this.m_vtMod, pvLight.m_positionView);
                float f7 = (float)this.m_vlMod.length();
                if ((double)f7 > pvLight.getFalloff() || (f6 = (float)PdVector.angle(pvLight.m_directionView, this.m_vlMod)) > (f4 = (float)pvLight.getAngle()) + (f3 = (float)pvLight.getCorona())) continue;
                if (f6 > f4 && f3 > 1.0E-10f) {
                    f5 = 1.0f - (f6 - f4) / f3;
                }
            }
            int[] nArray = pvLight.m_matCol;
            int n2 = (int)(pvLight.m_intensity.getValue() * 65536.0);
            if (pvLight.m_lightType == 0) {
                for (int i = 0; i < 3; ++i) {
                    int n3 = i;
                    this.m_lightAttMat[n3] = this.m_lightAttMat[n3] + n2 * nArray[i] / 255;
                }
                continue;
            }
            f4 = -((float)PdVector.dot(this.m_vnMod, pvLight.m_directionView));
            if (f4 < -1.0f) {
                f4 = -1.0f;
            } else if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            if (pvLight.m_shading != 0 && (f3 = (float)PdVector.dot(this.m_vnMod, this.m_vertexEye)) < 0.0f) {
                f4 = -f4;
            }
            switch (pvLight.m_shading) {
                case 0: {
                    if (!(f4 < 0.0f)) break;
                    f4 = -f4;
                    break;
                }
                case 1: 
                case 11: {
                    if (!(f4 < 0.0f)) break;
                    f4 = 0.0f;
                    break;
                }
                case 2: 
                case 12: {
                    f4 = 0.5f * (f4 + 1.0f);
                    break;
                }
                case 13: {
                    f3 = (float)Math.sqrt(1.0f - f4 * f4);
                    float f8 = (float)Math.acos(f4) * 180.0f / (float)Math.PI;
                    f4 = 0.21428572f + f3 * 0.18189137f + (11.0f - 0.044444446f * f8) * 0.071428575f * f4;
                    break;
                }
                case 14: {
                    f2 = 0.5f * (f4 + 1.0f);
                    f3 = (float)Math.sqrt(1.0f - f4 * f4);
                    float f8 = (float)Math.acos(f4) * 57.29578f;
                    float f9 = 0.21428572f + f3 * 0.18189137f + (11.0f - 0.044444446f * f8) * 0.071428575f * f4;
                    f = (float)pvLight.getBlend();
                    f4 = f * f2 + (1.0f - f) * f9;
                    break;
                }
                default: {
                    PsDebug.warning("unknown shading type or light model.");
                    return;
                }
            }
            if (pvLight.m_lightType == 3) {
                n2 = (int)((float)n2 * f5);
            }
            f2 = (float)n2 * f4 / 255.0f;
            for (int i = 0; i < 3; ++i) {
                int n4 = i;
                this.m_lightAttMat[n4] = (int)((float)this.m_lightAttMat[n4] + f2 * (float)nArray[i]);
            }
            if (!pvLight.m_bHighlight) continue;
            this.m_halfVector.sub(this.m_vertexEye, pvLight.m_directionView);
            float f10 = (float)this.m_halfVector.length();
            if ((double)f10 < 1.0E-10) continue;
            f = (float)Math.abs(PdVector.dot(this.m_vnMod, this.m_halfVector) / (double)f10);
            f = (float)n2 * (float)Math.pow(f, pvLight.getExponent());
            for (int i = 0; i < 3; ++i) {
                int n5 = i;
                this.m_lightAttSpec[n5] = (int)((float)this.m_lightAttSpec[n5] + f * (float)this.m_specular[i]);
            }
        }
    }

    private Color attenuateColor(Color color, int[] nArray, int[] nArray2) {
        int n = color.getRGB();
        this.m_matCol[0] = n >> 16 & 0xFF;
        this.m_matCol[1] = n >> 8 & 0xFF;
        this.m_matCol[2] = n & 0xFF;
        for (int i = 0; i < 3; ++i) {
            this.m_color[i] = nArray[i] * this.m_matCol[i] + nArray2[i] >> 16;
            if (this.m_color[i] > 255) {
                this.m_color[i] = 255;
                continue;
            }
            if (this.m_color[i] >= 0) continue;
            this.m_color[i] = 0;
        }
        return new Color(this.m_color[0], this.m_color[1], this.m_color[2]);
    }

    private static int attenuateColor(int n, int[] nArray, int[] nArray2) {
        int n2 = n >> 24 & 0xFF;
        int n3 = (n >> 16 & 0xFF) * nArray[0] + nArray2[0] >> 16;
        int n4 = (n >> 8 & 0xFF) * nArray[1] + nArray2[1] >> 16;
        int n5 = (n & 0xFF) * nArray[2] + nArray2[2] >> 16;
        if (n3 > 255) {
            n3 = 255;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        if (n5 > 255) {
            n5 = 255;
        }
        n = n2 << 24 | n3 << 16 | n4 << 8 | n5;
        return n;
    }

    private static int attenuateColor(int n, int[] nArray) {
        int n2 = n >> 24 & 0xFF;
        n2 = 255;
        int n3 = (n >> 16 & 0xFF) * nArray[0] + nArray[3] >> 16;
        int n4 = (n >> 8 & 0xFF) * nArray[1] + nArray[4] >> 16;
        int n5 = (n & 0xFF) * nArray[2] + nArray[5] >> 16;
        if (n3 > 255) {
            n3 = 255;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        if (n5 > 255) {
            n5 = 255;
        }
        n = n2 << 24 | n3 << 16 | n4 << 8 | n5;
        return n;
    }

    private boolean drawLineZBuffer(int[] nArray, int[] nArray2, int[] nArray3, int n, int[][] nArray4, int n2, int[][] nArray5, PiVector[] piVectorArray) {
        this.m_currElementCol = this.m_alpha | n2 & 0xFFFFFF;
        boolean bl = this.m_bShowSmoothShading;
        this.m_bShowSmoothShading = nArray4 == null ? false : this.m_bShowSmoothEdgeColors;
        boolean bl2 = this.m_bLocShowSmoothLighting;
        if (nArray5 == null) {
            this.m_bLocShowSmoothLighting = false;
        }
        this.drawElementTexture_(nArray, nArray2, nArray3, n, nArray4, nArray5, piVectorArray);
        this.m_bLocShowSmoothLighting = bl2;
        this.m_bShowSmoothShading = bl;
        return true;
    }

    private boolean drawElementZBuffer(int[] nArray, int[] nArray2, int[] nArray3, int n, int[][] nArray4, int n2, int[][] nArray5, PiVector[] piVectorArray) {
        this.m_currElementCol = this.m_alpha | n2 & 0xFFFFFF;
        boolean bl = this.m_bShowSmoothShading;
        this.m_bShowSmoothShading = nArray4 == null ? false : this.m_bLocShowSmoothElementColors;
        boolean bl2 = this.m_bLocShowSmoothLighting;
        if (nArray5 == null) {
            this.m_bLocShowSmoothLighting = false;
        }
        this.drawElementTexture_(nArray, nArray2, nArray3, n, nArray4, nArray5, piVectorArray);
        this.m_bLocShowSmoothLighting = bl2;
        this.m_bShowSmoothShading = bl;
        return true;
    }

    protected void setPixZB(int n, int n2, int[] nArray) {
        this.m_imgWidth = n;
        this.m_imgHeight = n2;
        this.m_pixData = nArray;
    }

    protected void removePixZB() {
        this.m_imgWidth = 0;
        this.m_imgHeight = 0;
        this.m_pixData = null;
    }

    private Color getEdgeColor_(int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        Color color = null;
        boolean bl2 = this.m_bShowTaggedElements && this.m_bHasTaggedElements && this.m_element[n].hasTag(12);
        boolean bl3 = bl = n != -1 && this.m_element[n].getURL() != null;
        if (bl && bl2) {
            color = Color.yellow;
        }
        if (color != null) {
            return color;
        }
        if (this.m_bShowTaggedEdges && this.m_bHasTaggedEdges && n != -1 && this.m_element[n].hasTag(1)) {
            color = this.m_globalEdgeTagColor;
            return color;
        }
        color = this.m_bShowEdgeColors && this.m_bShowEdgeColorFromElements ? (n2 != -1 ? PdColor.blend(0.5, this.m_elementColor[n], 0.5, this.m_elementColor[n2]) : this.m_elementColor[n]) : (this.m_bShowEdgeColors && this.m_bLocShowEdgeColorFromVertices && n3 != -1 ? (n4 != -1 ? PdColor.blend(0.5, this.m_vertexColor[n3], 0.5, this.m_vertexColor[n4]) : this.m_vertexColor[n3]) : (this.m_bShowEdgeColors && this.m_bHasEdgeColors && n5 != -1 ? this.m_edgeColor[n5] : this.m_globalEdgeColor));
        if (this.m_bShowDepthcue && this.m_bShowEdgeColors && !this.m_bEnableZBuffer) {
            color = this.m_bEnable3DLook || this.m_bShowElements ? PdColor.getDimmedColor(color, (double)this.m_heightFac, (double)this.m_heightFac) : PdColor.getDimmedColor(color, (double)this.m_heightFac, (double)this.m_grey * (1.0 - (double)this.m_heightFac));
        }
        return color;
    }

    private double getEdgeSize(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        double d = this.m_globalEdgeSize;
        if (this.m_bShowEdgeSizes) {
            d = this.m_globalEdgeSize * this.m_edgeSize.getEntry(n);
        }
        if (!this.m_bAdaptiveSize) {
            if (bl || bl2) {
                d = d < 1.0 ? 3.0 : (d += 4.0);
            } else if (bl4 && bl3) {
                d = d < 1.0 ? 2.0 : (d += 3.0);
            } else if (bl3 || bl4) {
                d = d < 1.0 ? 1.0 : (d += 2.0);
            }
        } else if (bl || bl2) {
            d *= (double)1.4f;
        } else if (bl4 && bl3) {
            d *= (double)1.3f;
        } else if (bl3 || bl4) {
            d *= (double)1.2f;
        }
        return d * (double)this.m_offFac;
    }

    private void drawElementEdges(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[][] nArray4, int[][] nArray5) {
        int n3;
        int n4;
        int n5;
        boolean bl;
        if (n2 < 2) {
            return;
        }
        double d = this.m_globalEdgeSize * (double)this.m_offFac;
        int n6 = (int)(d + 0.5);
        if (this.m_bShowEdgeAura && !this.m_bShowElements) {
            int n7;
            graphics.setColor(this.m_backColor);
            int n8 = this.m_backColor.getRGB();
            bl = this.m_bShowSmoothShading;
            n5 = this.m_bEnable3DLook;
            n4 = this.m_bShowLighting;
            this.m_bShowSmoothShading = false;
            this.m_bEnable3DLook = false;
            this.m_bShowLighting = false;
            if (this.m_bEnableZBuffer) {
                n3 = this.m_bShowDepthcue ? 1 : 0;
                this.m_bShowDepthcue = false;
                if (this.m_bAdaptiveSize && n2 >= 3) {
                    float f = this.getAdaptiveScale((float)(nArray3[0] + nArray3[1] + nArray3[2]) / 3.0f);
                    if (f >= 0.0f) {
                        n6 = (int)(d * (double)f + 0.5);
                    }
                } else {
                    n6 = (int)(d + 0.5);
                }
                n7 = Math.max(2 * this.m_offFac, n6);
                this.drawPolygonOneSide(graphics, n7, nArray, nArray2, nArray3, n2, !this.isBackElementCulled(n), n8);
                this.m_bShowDepthcue = n3;
            } else {
                if (this.m_bAdaptiveSize && n2 >= 3) {
                    float f = this.getAdaptiveScale((float)(nArray3[0] + nArray3[1] + nArray3[2]) / 3.0f);
                    if (f >= 0.0f) {
                        n6 = (int)(d * (double)f + 0.5);
                    }
                } else {
                    n6 = (int)(d + 0.5);
                }
                n7 = Math.max(2 * this.m_offFac, n6);
                this.drawPolygonOneSide(graphics, n7, nArray, nArray2, nArray3, n2, !this.isBackElementCulled(n), n8);
            }
            this.m_bShowLighting = n4;
            this.m_bEnable3DLook = n5;
            this.m_bShowSmoothShading = bl;
        }
        Color color = this.getEdgeColor_(n, -1, -1, -1, -1);
        if (this.m_bShowLighting && !this.m_bLocShowSmoothLighting) {
            color = this.attenuateColor(color, this.m_lightAttMat, this.m_lightAttSpec);
        }
        boolean bl2 = bl = this.m_bShowSilhouette && this.m_bHasNeighbours && this.m_elementNormal != null && (!this.m_bEnableClip || !this.m_bElemIsClipped);
        if (this.m_bShowSmoothEdgeColors) {
            for (n5 = 0; n5 < n2; ++n5) {
                this.m_cvTmp[n5] = nArray4[n5];
            }
        }
        if (this.m_bShowLighting && this.m_bLocShowSmoothLighting) {
            for (n5 = 0; n5 < n2; ++n5) {
                this.m_lvTmp[n5] = nArray5[n5];
            }
        }
        n5 = Integer.MIN_VALUE;
        if (this.m_bShowEdgeLabels) {
            for (n4 = 0; n4 < n2; ++n4) {
                if (nArray3[n4] <= n5) continue;
                n5 = nArray3[n4];
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            n3 = -1;
            if (!this.m_bElemIsClipped && this.m_bHasNeighbours) {
                n3 = this.m_neighbour[n].m_data[n4];
                if (this.m_bShowEdgeOnce && n3 > n && (this.m_bShowEdgeSizes || this.m_bEnableZBuffer && this.m_bEnable3DLook)) continue;
            }
            int n9 = -1;
            if (this.m_elementEdge != null) {
                n9 = this.m_elementEdge[n].m_data[n4];
            }
            int n10 = (n4 + 1) % n2;
            int n11 = (n4 + 2) % n2;
            if (this.m_bShowLighting && this.m_bLocShowSmoothLighting) {
                this.m_lv[0] = this.m_lvTmp[n10];
                this.m_lv[1] = this.m_lvTmp[n11];
                this.m_lv[2] = this.m_lvTmp[n11];
                this.m_lv[3] = this.m_lvTmp[n10];
            }
            if (bl && n3 != -1 && this.isBackElementCulled(n) != this.isBackElementCulled(n3)) {
                int n12;
                if (n3 >= this.m_numElements) continue;
                Color color2 = this.m_globalBndColor;
                if (this.m_bDepthcueEdge) {
                    color2 = this.m_bEnable3DLook || this.m_bShowElements ? PdColor.getDimmedColor(color2, (double)this.m_heightFac, (double)this.m_heightFac) : PdColor.getDimmedColor(color2, (double)this.m_heightFac, (double)this.m_grey * (1.0 - (double)this.m_heightFac));
                }
                if (this.m_bShowSmoothEdgeColors) {
                    int n13 = color2.getRGB();
                    PvGeometry.setScaledColor(this.m_cvTmpOne, n13, 16);
                    this.m_cv[0] = this.m_cvTmpOne;
                    this.m_cv[1] = this.m_cvTmpOne;
                    this.m_cv[2] = this.m_cvTmpOne;
                    this.m_cv[3] = this.m_cvTmpOne;
                }
                double d2 = this.m_globalBndSize * (double)this.m_offFac;
                if (this.m_bAdaptiveSize) {
                    float f = this.getAdaptiveScale((float)(nArray3[n10] + nArray3[n11]) / 2.0f);
                    if ((double)f < 0.0) continue;
                    d2 *= (double)f;
                }
                if ((n12 = (int)(d2 + 0.5)) == 0 && d2 > 0.0) {
                    n12 = 1;
                }
                this.drawLineAny(graphics, n12, nArray[n10], nArray2[n10], nArray3[n10], nArray[n11], nArray2[n11], nArray3[n11], color2, color2, n12 > 3 * this.m_offFac);
            } else {
                int n14;
                if (!this.m_bShowEdges) continue;
                int n15 = -1;
                if (!this.m_bElemIsClipped && this.m_neighbour != null) {
                    n15 = this.m_neighbour[n].m_data[n4];
                }
                int n16 = n14 = this.m_element[n].m_data[0];
                if (!this.m_bElemIsClipped) {
                    n14 = this.m_element[n].m_data[n10];
                    n16 = this.m_element[n].m_data[n11];
                }
                Color color3 = null;
                Color color4 = null;
                if (this.m_bShowSmoothEdgeColors) {
                    if (this.m_bLocShowEdgeColorFromVertices) {
                        color3 = color = this.getEdgeColor_(-1, -1, n14, -1, -1);
                        PvGeometry.setScaledColor(this.m_cvTmpOne, color.getRGB(), 16);
                        this.m_cv[0] = this.m_cvTmpOne;
                        this.m_cv[3] = this.m_cvTmpOne;
                        color4 = color = this.getEdgeColor_(-1, -1, n16, -1, n9);
                        PvGeometry.setScaledColor(this.m_cvTmpTwo, color.getRGB(), 16);
                        this.m_cv[1] = this.m_cvTmpTwo;
                        this.m_cv[2] = this.m_cvTmpTwo;
                    } else {
                        if (!this.m_bShowEdgeColorFromElements) continue;
                        color3 = color = this.getEdgeColor_(n, n15, n14, -1, n9);
                        color4 = color;
                        PvGeometry.setScaledColor(this.m_cvTmpOne, color.getRGB(), 16);
                        this.m_cv[0] = this.m_cvTmpOne;
                        this.m_cv[1] = this.m_cvTmpOne;
                        this.m_cv[2] = this.m_cvTmpOne;
                        this.m_cv[3] = this.m_cvTmpOne;
                    }
                } else {
                    color3 = color = this.getEdgeColor_(n, n15, n14, n16, n9);
                    color4 = color;
                }
                if (this.m_bDepthcueEdge && !this.m_bEnableZBuffer) {
                    if (this.m_bEnable3DLook || this.m_bShowElements) {
                        color3 = PdColor.getDimmedColor(color3, (double)this.m_heightFac, (double)this.m_heightFac);
                        color4 = PdColor.getDimmedColor(color4, (double)this.m_heightFac, (double)this.m_heightFac);
                    } else {
                        color3 = PdColor.getDimmedColor(color3, (double)this.m_heightFac, (double)this.m_grey * (1.0 - (double)this.m_heightFac));
                        color4 = PdColor.getDimmedColor(color4, (double)this.m_heightFac, (double)this.m_grey * (1.0 - (double)this.m_heightFac));
                    }
                }
                d = this.getEdgeSize(n9, false, false, false, false);
                if (this.m_bAdaptiveSize) {
                    float f = this.getAdaptiveScale((float)(nArray3[n10] + nArray3[n11]) / 2.0f);
                    if ((double)f < 0.0) continue;
                    n6 = (int)(d * (double)f + 0.5);
                } else {
                    n6 = (int)(d + 0.5);
                }
                if (n6 == 0 && d > 0.0) {
                    n6 = 1;
                }
                this.drawLineAny(graphics, n6, nArray[n10], nArray2[n10], nArray3[n10], nArray[n11], nArray2[n11], nArray3[n11], color3, color4, n6 > 3 * this.m_offFac);
            }
            if (!this.m_bShowEdgeLabels) continue;
            String string = null;
            if (this.m_edge != null) {
                string = this.m_edge[n9].getName();
            }
            if (string == null && this.m_bEnabledIndexLabels) {
                string = String.valueOf(n9);
            }
            if (string == null) continue;
            this.drawString(graphics, string, (this.m_xv[n10] + this.m_xv[n11]) / 2, (this.m_yv[n10] + this.m_yv[n11]) / 2, n5, n6 >> 1, 1);
        }
        if (this.m_bShowLighting && this.m_bLocShowSmoothLighting) {
            for (n4 = 0; n4 < n2; ++n4) {
                this.m_lv[n4] = this.m_lvTmp[n4];
            }
        }
        if (this.m_bShowSmoothEdgeColors) {
            for (n4 = 0; n4 < n2; ++n4) {
                this.m_cv[n4] = this.m_cvTmp[n4];
            }
        }
    }

    private void drawElementBnd(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) {
        int n3;
        if (!this.m_bHasNeighbours || this.m_neighbour[n].m_data.length < n2 || this.m_bEnableClip && this.m_bElemIsClipped) {
            return;
        }
        if (this.m_bShowSmoothEdgeColors) {
            for (n3 = 0; n3 < n2; ++n3) {
                this.m_cvTmp[n3] = this.m_cv[n3];
            }
        }
        if (this.m_bShowLighting && this.m_bLocShowSmoothLighting) {
            for (n3 = 0; n3 < n2; ++n3) {
                this.m_lvTmp[n3] = this.m_lv[n3];
            }
        }
        for (n3 = 0; n3 < n2; ++n3) {
            int n4;
            if (this.m_neighbour[n].m_data[n3] > -1) continue;
            int n5 = -1;
            for (int i = 0; i < this.m_numBndPolygons; ++i) {
                n4 = this.m_bndElementInd[i].getIndexOf(n);
                if (n4 == -1 || n3 != this.m_bndNeighbourLocInd[i].getEntry(n4) || this.m_bShowBnd[n5 = i]) continue;
                return;
            }
            Color color = this.m_globalBndColor;
            if (n5 != -1 && this.m_bShowBndMaterials[n5]) {
                color = this.m_bndColor[n5];
            }
            if (this.m_bDepthcueEdge && !this.m_bEnableZBuffer) {
                color = this.m_bEnable3DLook ? PdColor.getDimmedColor(color, (double)this.m_heightFac, (double)this.m_heightFac) : PdColor.getDimmedColor(color, (double)this.m_heightFac, (double)this.m_grey * (1.0 - (double)this.m_heightFac));
            }
            if (this.m_bShowSmoothEdgeColors) {
                n4 = color.getRGB();
                PvGeometry.setScaledColor(this.m_cvTmpOne, n4, 16);
                this.m_cv[0] = this.m_cvTmpOne;
                this.m_cv[1] = this.m_cvTmpOne;
                this.m_cv[2] = this.m_cvTmpOne;
                this.m_cv[3] = this.m_cvTmpOne;
            }
            n4 = (n3 + 1) % n2;
            int n6 = (n3 + 2) % n2;
            if (this.m_bShowLighting && this.m_bLocShowSmoothLighting) {
                this.m_lv[0] = this.m_lvTmp[n4];
                this.m_lv[1] = this.m_lvTmp[n6];
                this.m_lv[2] = this.m_lvTmp[n6];
                this.m_lv[3] = this.m_lvTmp[n4];
            }
            double d = this.m_globalBndSize;
            if (n5 != -1 && this.m_bShowBndMaterials[n5]) {
                d = this.m_bndSize[n5];
            }
            d *= (double)this.m_offFac;
            if (this.m_bAdaptiveSize) {
                float f = this.getAdaptiveScale((float)(nArray3[n4] + nArray3[n6]) / 2.0f);
                if ((double)f < 0.0) continue;
                d *= (double)f;
            }
            int n7 = (int)(d + 0.5);
            int n8 = this.m_zTolLine;
            if (n7 > 0 && this.m_bEnableZBuffer) {
                this.m_zTolLine = this.m_zTolVertex;
            }
            this.drawLineAny(graphics, n7, nArray[n4], nArray2[n4], nArray3[n4], nArray[n6], nArray2[n6], nArray3[n6], color, color, n7 > 3 * this.m_offFac);
            this.m_zTolLine = n8;
        }
        if (this.m_bShowLighting && this.m_bLocShowSmoothLighting) {
            for (n3 = 0; n3 < n2; ++n3) {
                this.m_lv[n3] = this.m_lvTmp[n3];
            }
        }
        if (this.m_bShowSmoothEdgeColors) {
            for (n3 = 0; n3 < n2; ++n3) {
                this.m_cv[n3] = this.m_cvTmp[n3];
            }
        }
    }

    private void drawElementVertices(Graphics graphics, int n, int n2, int[] nArray) {
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] == -1) continue;
            if (this.m_bShowBackface && this.m_bShowEdgeOnce && this.m_bHasNeighbours && !this.m_bElemIsClipped && this.m_numUnusedVertices == 0) {
                int n3 = this.m_neighbour[n].m_data[(i - 2 + n2) % n2];
                int n4 = this.m_neighbour[n].m_data[(i - 1 + n2) % n2];
                if (n3 >= this.m_numElements || n4 >= this.m_numElements) {
                    PsDebug.warning("void neighbour information, invoke: makeNeighbour()!");
                    return;
                }
                if (n3 != -1 && (double)this.m_itemHeight < this.m_scene.getHeightOfElementInCurrentGeometry(n3) || n4 != -1 && (double)this.m_itemHeight < this.m_scene.getHeightOfElementInCurrentGeometry(n4)) continue;
            }
            this.drawVertex(graphics, nArray[i]);
        }
    }

    private boolean clipPolygon3D(PdVector[] pdVectorArray, double[] dArray, int n, double d, double d2) {
        double d3 = pdVectorArray[0].m_data[n] - pdVectorArray[1].m_data[n];
        if (Math.abs(d3) < 1.0E-10) {
            return false;
        }
        double d4 = (pdVectorArray[0].m_data[n] - d) / d3;
        double d5 = (pdVectorArray[0].m_data[n] - d2) / d3;
        if (d4 > d5) {
            double d6 = d4;
            d4 = d5;
            d5 = d6;
        }
        if (d4 > dArray[0]) {
            this.m_bElemIsClipped = true;
            dArray[0] = d4;
        }
        if (d5 < dArray[1]) {
            this.m_bElemIsClipped = true;
            dArray[1] = d5;
        }
        return this.m_bElemIsClipped;
    }

    private int clipPolygon(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n3 = 0;
        int n4 = 0;
        double d7 = 0.0;
        for (int i = 0; i < 2; ++i) {
            int n5 = this.m_polygon[n].m_data[n2 + i];
            if ((double)this.m_vertexTrans[n5].m_data[2] < this.m_clipFar || (double)this.m_vertexTrans[n5].m_data[2] > this.m_clipNear) {
                this.m_bElemIsClipped = true;
                d4 = this.m_vertexTrans[n5].m_data[0];
                d5 = this.m_vertexTrans[n5].m_data[1];
                d6 = this.m_vertexTrans[n5].m_data[2];
                if (n4 == 1) {
                    d7 = d6 < this.m_clipFar ? (d3 - this.m_clipFar) / (d3 - d6) : (d3 - this.m_clipNear) / (d3 - d6);
                    nArray[n3] = (int)((1.0 - d7) * d + d7 * d4);
                    nArray2[n3] = (int)((1.0 - d7) * d2 + d7 * d5);
                    nArray3[n3] = (int)((1.0 - d7) * d3 + d7 * d6);
                    nArray4[n3] = -1;
                    ++n3;
                }
                n4 = -1;
                continue;
            }
            d = this.m_vertexTrans[n5].m_data[0];
            d2 = this.m_vertexTrans[n5].m_data[1];
            d3 = this.m_vertexTrans[n5].m_data[2];
            if (n4 == -1) {
                d7 = d6 < this.m_clipFar ? (d3 - this.m_clipFar) / (d3 - d6) : (d3 - this.m_clipNear) / (d3 - d6);
                nArray[n3] = (int)((1.0 - d7) * d + d7 * d4);
                nArray2[n3] = (int)((1.0 - d7) * d2 + d7 * d5);
                nArray3[n3] = (int)((1.0 - d7) * d3 + d7 * d6);
                nArray4[n3] = -1;
                ++n3;
            }
            nArray[n3] = this.m_vertexTrans[n5].m_data[0];
            nArray2[n3] = this.m_vertexTrans[n5].m_data[1];
            nArray3[n3] = this.m_vertexTrans[n5].m_data[2];
            nArray4[n3] = n5;
            ++n3;
            n4 = 1;
        }
        return n3;
    }

    private int clipElement3D(int n, PdVector[] pdVectorArray, int[] nArray, PiVector[] piVectorArray, int[][] nArray2, int[][] nArray3, int n2, float f, float f2) {
        int n3;
        int n4;
        PdVector[] pdVectorArray2 = this.m_vdClip;
        int[] nArray4 = this.m_origIndClip;
        PiVector[] piVectorArray2 = this.m_tvClip;
        int[][] nArray5 = this.m_cvClip;
        int[][] nArray6 = this.m_lvClip;
        int n5 = -2;
        int n6 = -1;
        int n7 = 1;
        float[] fArray = null;
        int n8 = 0;
        for (n4 = 0; n4 < n; ++n4) {
            n3 = n4;
            int n9 = (n4 + 1) % n;
            int n10 = nArray[n3];
            float f3 = (float)pdVectorArray[n3].m_data[n2];
            float f4 = (float)pdVectorArray[n9].m_data[n2];
            int n11 = n7;
            int n12 = n7;
            if (f3 < f) {
                n11 = n5;
            }
            if (f3 > f2) {
                n11 = n6;
            }
            if (f4 < f) {
                n12 = n5;
            }
            if (f4 > f2) {
                n12 = n6;
            }
            if (n11 != n7 || n12 != n7) {
                this.m_bElemIsClipped = true;
            }
            if (n11 == n5 && n12 == n5 || n11 == n6 && n12 == n6) continue;
            if (n11 == n7) {
                if (n4 < n) {
                    int n13;
                    pdVectorArray2[n8].copyArray(pdVectorArray[n3]);
                    if (piVectorArray != null) {
                        for (n13 = 0; n13 < this.m_dimOfTextures; ++n13) {
                            piVectorArray2[n8].copyArray(piVectorArray[n4]);
                        }
                    }
                    if (nArray2 != null && nArray5 != null) {
                        for (n13 = 0; n13 < 3; ++n13) {
                            nArray5[n8][n13] = nArray2[n4][n13];
                        }
                    }
                    if (nArray3 != null && nArray6 != null) {
                        for (n13 = 0; n13 < 6; ++n13) {
                            nArray6[n8][n13] = nArray3[n4][n13];
                        }
                    }
                    nArray4[n8] = n10;
                    ++n8;
                }
                if (n12 == n7) continue;
            }
            if (fArray == null) {
                fArray = new float[2];
            }
            PiVector piVector = null;
            PiVector piVector2 = null;
            if (piVectorArray != null) {
                piVector = piVectorArray[n3];
                piVector2 = piVectorArray[n9];
            }
            int[] nArray7 = null;
            int[] nArray8 = null;
            if (nArray2 != null) {
                nArray7 = nArray2[n3];
                nArray8 = nArray2[n9];
            }
            int[] nArray9 = null;
            int[] nArray10 = null;
            if (nArray3 != null) {
                nArray9 = nArray3[n3];
                nArray10 = nArray3[n9];
            }
            int n14 = 1;
            if (n11 == n7 && n12 == n5 || n11 == n5 && n12 == n7) {
                fArray[0] = (f3 - f) / (f3 - f4);
            } else if (n11 == n7 && n12 == n6 || n11 == n6 && n12 == n7) {
                fArray[0] = (f3 - f2) / (f3 - f4);
            } else if (n11 == n5 && n12 == n6) {
                fArray[0] = (f3 - f) / (f3 - f4);
                fArray[1] = (f3 - f2) / (f3 - f4);
                n14 = 2;
            } else if (n11 == n6 && n12 == n5) {
                fArray[0] = (f3 - f2) / (f3 - f4);
                fArray[1] = (f3 - f) / (f3 - f4);
                n14 = 2;
            }
            for (int i = 0; i < n14; ++i) {
                int n15;
                pdVectorArray2[n8].blend(1.0f - fArray[i], pdVectorArray[n3], fArray[i], pdVectorArray[n9]);
                if (piVectorArray != null) {
                    piVectorArray2[n8].blend(1.0f - fArray[i], piVector, fArray[i], piVector2);
                }
                if (nArray2 != null && nArray5 != null) {
                    for (n15 = 0; n15 < 3; ++n15) {
                        nArray5[n8][n15] = (int)((1.0f - fArray[i]) * (float)nArray7[n15] + fArray[i] * (float)nArray8[n15] + 0.5f);
                    }
                }
                if (nArray3 != null && nArray6 != null) {
                    for (n15 = 0; n15 < 6; ++n15) {
                        nArray6[n8][n15] = (int)((1.0f - fArray[i]) * (float)nArray9[n15] + fArray[i] * (float)nArray10[n15] + 0.5f);
                    }
                }
                nArray4[n8] = -1;
                ++n8;
            }
        }
        n = n8;
        for (n4 = 0; n4 < n; ++n4) {
            pdVectorArray[n4].copyArray(pdVectorArray2[n4]);
            nArray[n4] = nArray4[n4];
            if (piVectorArray != null) {
                piVectorArray[n4].copyArray(piVectorArray2[n4]);
            }
            if (nArray2 != null && nArray5 != null) {
                for (n3 = 0; n3 < 3; ++n3) {
                    nArray2[n4][n3] = nArray5[n4][n3];
                }
            }
            if (nArray3 == null || nArray6 == null) continue;
            for (n3 = 0; n3 < 6; ++n3) {
                nArray3[n4][n3] = nArray6[n4][n3];
            }
        }
        return n;
    }

    private int clipElement(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, PiVector[] piVectorArray, PiVector[] piVectorArray2, int[][] nArray5, int[][] nArray6, int[][] nArray7, int[][] nArray8) {
        int n3 = -2;
        int n4 = -1;
        int n5 = 1;
        float[] fArray = null;
        int n6 = 0;
        for (int i = 0; i < n2; ++i) {
            int n7 = i;
            int n8 = (i + 1) % n2;
            int n9 = this.m_element[n].m_data[n7];
            int n10 = this.m_element[n].m_data[n8];
            int[] nArray9 = this.m_vertexTrans[n9].m_data;
            int[] nArray10 = this.m_vertexTrans[n10].m_data;
            int n11 = n5;
            int n12 = n5;
            if ((double)nArray9[2] < this.m_clipFar) {
                n11 = n3;
            }
            if ((double)nArray9[2] > this.m_clipNear) {
                n11 = n4;
            }
            if ((double)nArray10[2] < this.m_clipFar) {
                n12 = n3;
            }
            if ((double)nArray10[2] > this.m_clipNear) {
                n12 = n4;
            }
            if (n11 != n5 || n12 != n5) {
                this.m_bElemIsClipped = true;
            }
            if (n11 == n3 && n12 == n3 || n11 == n4 && n12 == n4) continue;
            if (n11 == n5) {
                if (i < n2) {
                    int n13;
                    nArray[n6] = nArray9[0];
                    nArray2[n6] = nArray9[1];
                    nArray3[n6] = nArray9[2];
                    if (this.m_bUseTexture) {
                        piVectorArray[n6].copyArray(piVectorArray2[i]);
                    }
                    if (nArray6 != null && nArray5 != null) {
                        for (n13 = 0; n13 < 3; ++n13) {
                            nArray5[n6][n13] = nArray6[i][n13];
                        }
                    }
                    if (nArray8 != null && nArray7 != null) {
                        for (n13 = 0; n13 < 6; ++n13) {
                            nArray7[n6][n13] = nArray8[i][n13];
                        }
                    }
                    nArray4[n6] = n9;
                    ++n6;
                }
                if (n12 == n5) continue;
            }
            if (fArray == null) {
                fArray = new float[2];
            }
            float f = nArray9[0];
            float f2 = nArray9[1];
            float f3 = nArray9[2];
            float f4 = nArray10[0];
            float f5 = nArray10[1];
            float f6 = nArray10[2];
            PiVector piVector = null;
            PiVector piVector2 = null;
            if (this.m_bUseTexture) {
                piVector = piVectorArray2[n7];
                piVector2 = piVectorArray2[n8];
            }
            int[] nArray11 = null;
            int[] nArray12 = null;
            if (nArray6 != null) {
                nArray11 = nArray6[n7];
                nArray12 = nArray6[n8];
            }
            int[] nArray13 = null;
            int[] nArray14 = null;
            if (nArray8 != null) {
                nArray13 = nArray8[n7];
                nArray14 = nArray8[n8];
            }
            int n14 = 1;
            if (n11 == n5 && n12 == n3 || n11 == n3 && n12 == n5) {
                fArray[0] = (float)(((double)f3 - this.m_clipFar) / (double)(f3 - f6));
            } else if (n11 == n5 && n12 == n4 || n11 == n4 && n12 == n5) {
                fArray[0] = (float)(((double)f3 - this.m_clipNear) / (double)(f3 - f6));
            } else if (n11 == n3 && n12 == n4) {
                fArray[0] = (float)(((double)f3 - this.m_clipFar) / (double)(f3 - f6));
                fArray[1] = (float)(((double)f3 - this.m_clipNear) / (double)(f3 - f6));
                n14 = 2;
            } else if (n11 == n4 && n12 == n3) {
                fArray[0] = (float)(((double)f3 - this.m_clipNear) / (double)(f3 - f6));
                fArray[1] = (float)(((double)f3 - this.m_clipFar) / (double)(f3 - f6));
                n14 = 2;
            }
            for (int j = 0; j < n14; ++j) {
                int n15;
                nArray[n6] = (int)((1.0f - fArray[j]) * f + fArray[j] * f4);
                nArray2[n6] = (int)((1.0f - fArray[j]) * f2 + fArray[j] * f5);
                nArray3[n6] = (int)((1.0f - fArray[j]) * f3 + fArray[j] * f6);
                if (this.m_bUseTexture) {
                    piVectorArray[n6].blend(1.0f - fArray[j], piVector, fArray[j], piVector2);
                }
                if (nArray6 != null && nArray5 != null) {
                    for (n15 = 0; n15 < 3; ++n15) {
                        nArray5[n6][n15] = (int)((1.0f - fArray[j]) * (float)nArray11[n15] + fArray[j] * (float)nArray12[n15] + 0.5f);
                    }
                }
                if (nArray8 != null && nArray7 != null) {
                    for (n15 = 0; n15 < 6; ++n15) {
                        nArray7[n6][n15] = (int)((1.0f - fArray[j]) * (float)nArray13[n15] + fArray[j] * (float)nArray14[n15] + 0.5f);
                    }
                }
                nArray4[n6] = -1;
                ++n6;
            }
        }
        n2 = n6;
        return n2;
    }

    private void drawElementTexture_(int[] nArray, int[] nArray2, int[] nArray3, int n, int[][] nArray4, int[][] nArray5, PiVector[] piVectorArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.m_bUseTexture) {
            for (n8 = 0; n8 < n; ++n8) {
            }
        }
        if (PvScene.m_bTiming) {
            PvScene.m_timePaintPrep += PsDebug.getTimeIncr();
        }
        int n9 = 0;
        int n10 = nArray2[0];
        for (n8 = 1; n8 < n; ++n8) {
            if (nArray2[n8] >= n10 && (nArray2[n8] != n10 || nArray2[(n8 + 1) % n] <= nArray2[n8])) continue;
            n10 = nArray2[n8];
            n9 = n8;
        }
        int n11 = nArray[n9];
        int n12 = nArray2[n9];
        int n13 = nArray[(n9 + 1) % n];
        int n14 = nArray2[(n9 + 1) % n];
        int n15 = nArray[(n9 - 1 + n) % n];
        int n16 = nArray2[(n9 - 1 + n) % n];
        int[] nArray6 = null;
        int[] nArray7 = null;
        int[] nArray8 = null;
        int[] nArray9 = null;
        boolean bl = n13 * (n16 - n12) + n15 * (n12 - n14) - (n16 - n14) * n11 < 0;
        int n17 = 0;
        this.m_bndIdentifier.setEntry(0, 0);
        int n18 = n9;
        for (n7 = 0; n7 < n; ++n7) {
            n8 = n18;
            n18 = (n8 + 1) % n;
            n6 = nArray[n18] - nArray[n8];
            n5 = nArray2[n18] - nArray2[n8];
            int n19 = bl ? (n6 < 0 ? 1 : 0) : (n4 = n6 > 0 ? 1 : 0);
            int n20 = bl ? (n6 > 0 ? 1 : 0) : (n3 = n6 < 0 ? 1 : 0);
            n2 = Math.abs(n6) < Math.abs(n5) ? (n4 != 0 ? (bl && n5 < 0 || !bl && n5 > 0 ? 7 : 2) : (bl && n5 > 0 || !bl && n5 < 0 ? 3 : 6)) : (n4 != 0 ? (bl && n5 < 0 || !bl && n5 > 0 ? 8 : 1) : (bl && n5 > 0 || !bl && n5 < 0 ? 4 : 5));
            if (this.m_bShowSmoothShading) {
                nArray6 = nArray4[n8];
                nArray7 = nArray4[n18];
            }
            if (this.m_bLocShowSmoothLighting) {
                nArray8 = nArray5[n8];
                nArray9 = nArray5[n18];
            }
            PiVector piVector = null;
            PiVector piVector2 = null;
            if (this.m_bUseTexture) {
                piVector = piVectorArray[n8];
                piVector2 = piVectorArray[n18];
            }
            if ((n17 = this.discretizeBndEdge(nArray[n8], nArray2[n8], nArray3[n8], nArray[n18], nArray2[n18], nArray3[n18], nArray6, nArray7, this.m_colDestBnd, nArray8, nArray9, this.m_lightDestBnd, piVector, piVector2, this.m_faceTextureBnd, this.m_faceDestBnd, n17, this.m_bShowCurrEdge, n4 != 0, n3 != 0, bl, n2)) != -1) continue;
            return;
        }
        if (n17 == 0) {
            return;
        }
        int n21 = n17 / 2 + 1;
        n6 = -1;
        if (this.m_faceDestBnd[n17 - 1].m_data[1] == this.m_faceDestBnd[0].m_data[1] && this.m_faceDestBnd[n17 - 1].m_data[1] == this.m_faceDestBnd[n17 - 2].m_data[1] && Math.abs(this.m_faceDestBnd[n17 - 1].m_data[0] - this.m_faceDestBnd[0].m_data[0]) <= Math.abs(this.m_faceDestBnd[n17 - 2].m_data[0] - this.m_faceDestBnd[0].m_data[0])) {
            --n17;
        }
        int n22 = 0;
        int n23 = n17 - 1;
        while (this.m_faceDestBnd[n22].m_data[1] < this.m_faceDestBnd[n23].m_data[1]) {
            ++n22;
        }
        if (this.m_faceDestBnd[n22].m_data[1] == this.m_faceDestBnd[n22 + 1].m_data[1]) {
            if (this.m_faceDestBnd[n23].m_data[1] == this.m_faceDestBnd[n22].m_data[1]) {
                if (Math.abs(this.m_faceDestBnd[n23].m_data[0] - this.m_faceDestBnd[n22].m_data[0]) <= Math.abs(this.m_faceDestBnd[n23].m_data[0] - this.m_faceDestBnd[n22 + 1].m_data[0])) {
                    ++n22;
                }
            } else {
                ++n22;
            }
        }
        if (PvScene.m_bTiming) {
            PvScene.m_timeTexBnd += PsDebug.getTimeIncr();
        }
        for (n8 = 0; n8 < n21; ++n8) {
            int n24 = 0;
            int n25 = 0;
            n7 = this.m_faceDestBnd[n22].m_data[0];
            if (!this.m_bShowCurrEdge) {
                n25 = this.m_faceDestBnd[n22].m_data[3];
            }
            if (this.m_faceDestBnd[n22].m_data[1] <= n6 || this.m_faceDestBnd[n22].m_data[1] < 0) {
                ++n22;
                continue;
            }
            n6 = this.m_faceDestBnd[n22].m_data[1];
            if (n6 < 0 || n6 >= this.m_imgHeight) break;
            n5 = this.m_faceDestBnd[n22].m_data[2];
            while (this.m_faceDestBnd[n23].m_data[1] < n6 && n23 > n22) {
                --n23;
            }
            if (n23 < n22) break;
            n4 = this.m_faceDestBnd[n23].m_data[0];
            if (!this.m_bShowCurrEdge) {
                n24 = this.m_faceDestBnd[n23].m_data[3];
            }
            n3 = n6;
            n3 = this.m_faceDestBnd[n23].m_data[1];
            n2 = this.m_faceDestBnd[n23].m_data[2];
            if (n3 < 0 || n3 >= this.m_imgHeight) {
                n3 = n6;
            }
            if (n3 < 0 || n3 >= this.m_dispSize.height) {
                n3 = n6;
            }
            if (this.m_bUseTexture) {
                this.drawScanline(n7, n6, n5, n4, n3, n2, this.m_colDestBnd[n22], this.m_colDestBnd[n23], this.m_lightDestBnd[n22], this.m_lightDestBnd[n23], this.m_faceTextureBnd[n22].m_data, this.m_faceTextureBnd[n23].m_data, n25, n24);
            } else {
                this.drawScanline(n7, n6, n5, n4, n3, n2, this.m_colDestBnd[n22], this.m_colDestBnd[n23], this.m_lightDestBnd[n22], this.m_lightDestBnd[n23], null, null, n25, n24);
            }
            if (--n23 < ++n22) break;
        }
        if (PvScene.m_bTiming) {
            PvScene.m_timeTexScan += PsDebug.getTimeIncr();
        }
        int n26 = this.m_bndIdentifier.getEntry(0);
        for (n8 = 1; n8 < n26; ++n8) {
            int n27 = this.m_bndIdentifier.m_data[n8];
            if ((this.m_pixData[n27] & 0xFF000000) != -33554432) continue;
            this.m_pixData[n27] = this.m_alpha | this.m_pixData[n27] & 0xFFFFFF;
        }
    }

    private void drawScanline(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int n7, int n8) {
        int n9;
        int n10;
        int n11;
        if (n2 < 0 || n2 >= this.m_imgHeight) {
            return;
        }
        if (n < 0 && n4 < 0 || n >= this.m_imgWidth && n4 >= this.m_imgWidth) {
            return;
        }
        int n12 = 0;
        boolean bl = this.m_bShowDepthcue && (!this.m_bDrawingEdge || this.m_bDepthcueEdge);
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        if (bl) {
            if (this.m_bUseTexture) {
                n22 = nArray5[2];
                n23 = nArray6[2];
            } else {
                n22 = (2 * this.m_sceneZFac + 8 * (n3 - this.m_scene.m_zMin)) / 10;
                n23 = (2 * this.m_sceneZFac + 8 * (n6 - this.m_scene.m_zMin)) / 10;
            }
        }
        int n24 = n4 - n;
        int n25 = 0;
        int n26 = n2;
        int n27 = n2 * this.m_imgWidth;
        if (n24 >= 0) {
            n27 += n;
            if (this.m_bUseTexture) {
                n14 = nArray5[0];
                n17 = nArray5[1];
            }
            if (bl) {
                n20 = n22;
            }
            n11 = n3;
            n25 = n;
            if (this.m_bShowSmoothShading) {
                for (n10 = 0; n10 < 3; ++n10) {
                    this.m_cd[n10] = nArray[n10];
                }
            }
            if (this.m_bLocShowSmoothLighting) {
                for (n10 = 0; n10 < 6; ++n10) {
                    this.m_ld[n10] = nArray3[n10];
                }
            }
        } else {
            n27 += n4;
            if (this.m_bUseTexture) {
                n14 = nArray6[0];
                n17 = nArray6[1];
            }
            if (bl) {
                n20 = n23;
            }
            n11 = n6;
            n25 = n4;
            n10 = n7;
            n7 = n8;
            n8 = n10;
            if (this.m_bShowSmoothShading) {
                for (n9 = 0; n9 < 3; ++n9) {
                    this.m_cd[n9] = nArray2[n9];
                }
            }
            if (this.m_bLocShowSmoothLighting) {
                for (n9 = 0; n9 < 6; ++n9) {
                    this.m_ld[n9] = nArray4[n9];
                }
            }
        }
        if (n24 != 0) {
            if (this.m_bUseTexture) {
                n15 = (nArray6[0] - nArray5[0]) / n24;
                n18 = (nArray6[1] - nArray5[1]) / n24;
            }
            if (bl) {
                n21 = (n23 - n22) / n24;
            }
            n13 = (n6 - n3) / n24;
            if (this.m_bShowSmoothShading) {
                for (n10 = 0; n10 < 3; ++n10) {
                    this.m_cdInc[n10] = (nArray2[n10] - nArray[n10]) / n24;
                }
            }
            if (this.m_bLocShowSmoothLighting) {
                for (n10 = 0; n10 < 6; ++n10) {
                    this.m_ldInc[n10] = (nArray4[n10] - nArray3[n10]) / n24;
                }
            }
            if (n24 < 0) {
                n24 = -n24;
            }
        } else {
            if (this.m_bShowSmoothShading) {
                for (n10 = 0; n10 < 3; ++n10) {
                    this.m_cdInc[n10] = 0;
                }
            }
            if (this.m_bLocShowSmoothLighting) {
                for (n10 = 0; n10 < 6; ++n10) {
                    this.m_ldInc[n10] = 0;
                }
            }
        }
        if (this.m_bUseTexture && this.m_filterType != 0) {
            n16 = n15 >> 1;
            n19 = n18 >> 1;
        }
        n24 += n8;
        if (n7 > 0) {
            for (n10 = 0; n10 < n7; ++n10) {
                ++n27;
                ++n25;
                if (this.m_bUseTexture) {
                    n14 += n15;
                    n17 += n18;
                }
                if (bl) {
                    n20 += n21;
                }
                n11 += n13;
                if (this.m_bShowSmoothShading) {
                    for (n9 = 0; n9 < 3; ++n9) {
                        int n28 = n9;
                        this.m_cd[n28] = this.m_cd[n28] + this.m_cdInc[n9];
                    }
                }
                if (this.m_bLocShowSmoothLighting) {
                    for (n9 = 0; n9 < 6; ++n9) {
                        int n29 = n9;
                        this.m_ld[n29] = this.m_ld[n29] + this.m_ldInc[n9];
                    }
                }
                --n24;
            }
        }
        int n30 = 0;
        int[] nArray7 = this.m_zBuffer[n26];
        while (n24 >= 0) {
            int n31;
            int n32 = n11;
            boolean bl2 = true;
            if (this.m_bShowLocTransparency && n25 >= 0 && n25 < this.m_imgWidth) {
                boolean bl3 = bl2 = nArray7[n25] < n32 - this.m_zTol;
            }
            if (n25 >= 0 && n25 < this.m_imgWidth) {
                if (!this.m_bShowLocTransparency && nArray7[n25] >= n32 - this.m_zTol) {
                    if ((this.m_pixData[n27] & 0xFF000000) == -33554432) {
                        this.m_pixData[n27] = this.m_bShowCurrEdge && this.m_bShowLocTransparency && nArray7[n25] < n32 + this.m_zTol ? this.drawPixel(this.m_pixData[n27], this.m_currEdgeCol, this.m_iTransparency, this.m_alpha, false, n25, n26) : this.m_alpha | this.m_pixData[n27] & 0xFFFFFF;
                    }
                } else if (this.m_bShowLocTransparency && !this.m_bShowCurrEdge && nArray7[n25] > n32 - this.m_zTol && nArray7[n25] < n32 + this.m_zTol && (this.m_pixData[n27] & 0xFF000000) == -33554432) {
                    this.m_pixData[n27] = this.m_alpha | this.m_pixData[n27] & 0xFFFFFF;
                } else {
                    if (nArray7[n25] < n32 - this.m_zTol) {
                        nArray7[n25] = n32;
                    }
                    n31 = this.m_iTransparency;
                    if (this.m_bShowCurrEdge && (this.m_pixData[n27] & 0xFF000000) == -33554432) {
                        this.m_pixData[n27] = this.m_bShowLocTransparency ? this.drawPixel(this.m_pixData[n27], this.m_currEdgeCol, this.m_iTransparency, this.m_alpha, bl2, n25, n26) : this.m_currEdgeCol;
                    } else if (this.m_bShowCurrElement && this.m_bFastScanline && n30 > 0 && n24 > 0) {
                        --n30;
                        this.m_pixData[n27] = this.m_pixData[n27 - 1];
                    } else if (this.m_bShowCurrElement) {
                        int n33;
                        int n34;
                        int n35;
                        int n36;
                        if (this.m_bFastScanline) {
                            n30 = n24 - 2;
                        }
                        if (this.m_bIsTaggedElement) {
                            n12 = this.m_currElementCol;
                        } else if (this.m_bUseTexture && !this.m_bDrawingEdge) {
                            long l = (long)n14 * (long)this.m_textureTilingWidth;
                            n36 = (int)(l >> 20);
                            l = (long)n17 * (long)this.m_textureTilingHeight;
                            n35 = (int)(l >> 20);
                            if ((this.m_texturePeriodic & 1) == 1) {
                                if (n36 < 0) {
                                    n36 = this.m_textureWidth + n36 % this.m_textureWidth;
                                }
                                if (n36 >= this.m_textureWidth) {
                                    n36 %= this.m_textureWidth;
                                }
                            } else if (n36 >= this.m_textureWidth && n36 < this.m_textureTilingWidth) {
                                n36 %= this.m_textureWidth;
                            }
                            if ((this.m_texturePeriodic & 2) == 2) {
                                if (n35 < 0) {
                                    n35 = this.m_textureHeight + n35 % this.m_textureHeight;
                                }
                                if (n35 >= this.m_textureHeight) {
                                    n35 %= this.m_textureHeight;
                                }
                            } else if (n35 >= this.m_textureHeight && n35 < this.m_textureTilingHeight) {
                                n35 %= this.m_textureHeight;
                            }
                            boolean bl4 = n36 >= 0 && n36 < this.m_textureWidth && n35 >= 0 && n35 < this.m_textureHeight;
                            int n37 = (this.m_textureHeight - n35 - 1) * this.m_textureWidth + n36;
                            if (bl4 && n37 >= 0 && n37 < this.m_texturePix.length) {
                                int n38;
                                n12 = this.m_filterType == 0 ? this.m_texturePix[n37] : this.getTexStencil(this.m_texturePix, n37, n36, n35, n16 >> 20, n19 >> 20);
                                if (this.m_blendingMode == 0) {
                                    n10 = n12 >> 24 & 0xFF;
                                    if (n10 != 255) {
                                        n31 = this.m_bShowLocTransparency ? 255 - n10 + n31 * n10 / 255 : 255 - n10;
                                    }
                                } else if (this.m_blendingMode == 1) {
                                    n10 = n12 >> 24 & 0xFF;
                                    if (n10 != 255) {
                                        n38 = this.m_bShowSmoothShading ? PvGeometry.getScaledColor(m_alphaTransp, this.m_cd, 16) : this.m_currElementCol;
                                        n12 = this.drawPixel(n38, n12, 255 - n10, this.m_alpha, bl2, n25, n26);
                                    }
                                } else if (this.m_blendingMode == 2) {
                                    n38 = this.m_bShowSmoothShading ? PvGeometry.getScaledColor(m_alphaTransp, this.m_cd, 16) : this.m_currElementCol;
                                    n10 = n12 & 0xFF;
                                    if (n10 != 255) {
                                        if (this.m_bShowLocTransparency) {
                                            n10 = n10 <= n31 ? 0 : 255 * (n10 - n31) / (255 - n31);
                                        }
                                        n31 = 255 - n10;
                                    }
                                    n12 = n10 << 24 | n38 & 0xFFFFFF;
                                }
                            } else {
                                n12 = this.m_currElementCol;
                            }
                        } else {
                            n12 = this.m_bShowSmoothShading ? PvGeometry.getScaledColor(m_alphaOpaque, this.m_cd, 16) : this.m_currElementCol;
                        }
                        n10 = n12 & 0xFF000000;
                        if (this.m_bLocShowSmoothLighting) {
                            n9 = (n12 >> 16 & 0xFF) * this.m_ld[0] + this.m_ld[3] >> 16;
                            n34 = (n12 >> 8 & 0xFF) * this.m_ld[1] + this.m_ld[4] >> 16;
                            n33 = (n12 & 0xFF) * this.m_ld[2] + this.m_ld[5] >> 16;
                            if (n9 > 255) {
                                n9 = 255;
                            }
                            if (n34 > 255) {
                                n34 = 255;
                            }
                            if (n33 > 255) {
                                n33 = 255;
                            }
                            n12 = n10 | n9 << 16 | n34 << 8 | n33;
                        } else if (this.m_bShowLighting) {
                            n9 = (n12 >> 16 & 0xFF) * this.m_lightAttMat[0] + this.m_lightAttSpec[0] >> 16;
                            n34 = (n12 >> 8 & 0xFF) * this.m_lightAttMat[1] + this.m_lightAttSpec[1] >> 16;
                            n33 = (n12 & 0xFF) * this.m_lightAttMat[2] + this.m_lightAttSpec[2] >> 16;
                            if (n9 > 255) {
                                n9 = 255;
                            }
                            if (n34 > 255) {
                                n34 = 255;
                            }
                            if (n33 > 255) {
                                n33 = 255;
                            }
                            n12 = n10 | n9 << 16 | n34 << 8 | n33;
                        }
                        if (bl) {
                            n36 = 255 * n20 / this.m_sceneZFac;
                            if (n36 < 0) {
                                n36 = 0;
                            } else if (n36 > 255) {
                                n36 = 255;
                            }
                            n9 = (n12 >> 16 & 0xFF) * n36;
                            n34 = (n12 >> 8 & 0xFF) * n36;
                            n33 = (n12 & 0xFF) * n36;
                            if (this.m_bDrawingEdge && this.m_bDepthcueEdge) {
                                n35 = this.m_grey * (255 - n36);
                                n9 += n35;
                                n34 += n35;
                                n33 += n35;
                            }
                            n9 = n9 << 8 & 0xFF0000;
                            n33 = n33 >> 8 & 0xFF;
                            n12 = n10 | n9 | (n34 &= 0xFF00) | n33;
                        }
                        if (this.m_bShowLocTransparency) {
                            n12 = this.drawPixel(this.m_pixData[n27], n12, n31, this.m_alpha, bl2, n25, n26);
                        } else if (n10 != -16777216) {
                            n12 = this.drawPixel(this.m_pixData[n27], n12, n31, this.m_alpha, bl2, n25, n26);
                        }
                        this.m_pixData[n27] = n12;
                    } else if ((this.m_pixData[n27] & 0xFF000000) == -33554432) {
                        this.m_pixData[n27] = this.m_alpha | this.m_pixData[n27] & 0xFFFFFF;
                    }
                }
            }
            ++n27;
            ++n25;
            if (this.m_bUseTexture) {
                n14 += n15;
                n17 += n18;
            }
            if (bl) {
                n20 += n21;
            }
            n11 += n13;
            if (this.m_bShowSmoothShading) {
                for (n31 = 0; n31 < 3; ++n31) {
                    int n39 = n31;
                    this.m_cd[n39] = this.m_cd[n39] + this.m_cdInc[n31];
                }
            }
            if (this.m_bLocShowSmoothLighting) {
                for (n31 = 0; n31 < 6; ++n31) {
                    int n40 = n31;
                    this.m_ld[n40] = this.m_ld[n40] + this.m_ldInc[n31];
                }
            }
            --n24;
        }
    }

    private int getTexStencil(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = this.m_texturePix[n];
        int n7 = n6 >> 24 & 0xFF;
        this.m_rgb[0] = n6 >> 16 & 0xFF;
        this.m_rgb[1] = n6 >> 8 & 0xFF;
        this.m_rgb[2] = n6 & 0xFF;
        n4 = 1;
        n5 = 1;
        if (this.m_filterType == 1) {
            int n8;
            this.m_poss[0] = n;
            this.m_poss[1] = (this.m_textureHeight - n3 - 1) * this.m_textureWidth + (n2 + n4);
            this.m_poss[2] = (this.m_textureHeight - (n3 + n5) - 1) * this.m_textureWidth + n2;
            this.m_poss[3] = (this.m_textureHeight - (n3 + n5) - 1) * this.m_textureWidth + (n2 + n4);
            for (n8 = 1; n8 < 4; ++n8) {
                n6 = this.m_poss[n8] < 0 || this.m_poss[n8] >= this.m_texturePix.length ? this.m_texturePix[n] : this.m_texturePix[this.m_poss[n8]];
                n7 += n6 >> 24 & 0xFF;
                this.m_rgb[0] = this.m_rgb[0] + (n6 >> 16 & 0xFF);
                this.m_rgb[1] = this.m_rgb[1] + (n6 >> 8 & 0xFF);
                this.m_rgb[2] = this.m_rgb[2] + (n6 & 0xFF);
            }
            n7 >>= 2;
            for (n8 = 0; n8 < 3; ++n8) {
                this.m_rgb[n8] = this.m_rgb[n8] >> 2;
            }
        } else {
            int n9;
            n7 <<= 1;
            for (n9 = 0; n9 < 3; ++n9) {
                this.m_rgb[n9] = this.m_rgb[n9] << 1;
            }
            this.m_poss[0] = (this.m_textureHeight - (n3 - n5) - 1) * this.m_textureWidth + (n2 - n4);
            this.m_poss[1] = (this.m_textureHeight - (n3 - n5) - 1) * this.m_textureWidth + (n2 + n4);
            this.m_poss[2] = (this.m_textureHeight - (n3 + n5) - 1) * this.m_textureWidth + (n2 - n4);
            this.m_poss[3] = (this.m_textureHeight - (n3 + n5) - 1) * this.m_textureWidth + (n2 + n4);
            this.m_poss[4] = (this.m_textureHeight - (n3 - n5) - 1) * this.m_textureWidth + n2;
            this.m_poss[5] = (this.m_textureHeight - n3 - 1) * this.m_textureWidth + (n2 + n4);
            this.m_poss[6] = (this.m_textureHeight - n3 - 1) * this.m_textureWidth + (n2 - n4);
            this.m_poss[7] = (this.m_textureHeight - (n3 + n5) - 1) * this.m_textureWidth + n2;
            for (n9 = 4; n9 < 8; ++n9) {
                n6 = this.m_poss[n9] < 0 || this.m_poss[n9] >= this.m_texturePix.length ? this.m_texturePix[n] : this.m_texturePix[this.m_poss[n9]];
                n7 += n6 >> 24 & 0xFF;
                this.m_rgb[0] = this.m_rgb[0] + (n6 >> 16 & 0xFF);
                this.m_rgb[1] = this.m_rgb[1] + (n6 >> 8 & 0xFF);
                this.m_rgb[2] = this.m_rgb[2] + (n6 & 0xFF);
            }
            n7 <<= 1;
            for (n9 = 0; n9 < 3; ++n9) {
                this.m_rgb[n9] = this.m_rgb[n9] << 1;
            }
            for (n9 = 0; n9 < 4; ++n9) {
                n6 = this.m_poss[n9] < 0 || this.m_poss[n9] >= this.m_texturePix.length ? this.m_texturePix[n] : this.m_texturePix[this.m_poss[n9]];
                n7 += n6 >> 24 & 0xFF;
                this.m_rgb[0] = this.m_rgb[0] + (n6 >> 16 & 0xFF);
                this.m_rgb[1] = this.m_rgb[1] + (n6 >> 8 & 0xFF);
                this.m_rgb[2] = this.m_rgb[2] + (n6 & 0xFF);
            }
            n7 >>= 4;
            for (n9 = 0; n9 < 3; ++n9) {
                this.m_rgb[n9] = this.m_rgb[n9] >> 4;
            }
        }
        n6 = n7 << 24 | this.m_rgb[0] << 16 | this.m_rgb[1] << 8 | this.m_rgb[2];
        return n6;
    }

    private static int getScaledColor(int n, int[] nArray, int n2) {
        if (n2 == 0) {
            int n3 = nArray[0] & 0xFF;
            int n4 = nArray[1] & 0xFF;
            int n5 = nArray[2] & 0xFF;
            return n | n3 << 16 | n4 << 8 | n5;
        }
        if (n2 == 16) {
            int n6 = nArray[0] & 0xFF0000;
            int n7 = nArray[1] >> 8 & 0xFF00;
            int n8 = nArray[2] >> 16 & 0xFF;
            return n | n6 | n7 | n8;
        }
        int n9 = nArray[0] >> n2 & 0xFF;
        int n10 = nArray[1] >> n2 & 0xFF;
        int n11 = nArray[2] >> n2 & 0xFF;
        return n | n9 << 16 | n10 << 8 | n11;
    }

    private static void setScaledColor(int[] nArray, int n, int n2) {
        nArray[0] = (n >> 16 & 0xFF) << n2;
        nArray[1] = (n >> 8 & 0xFF) << n2;
        nArray[2] = (n & 0xFF) << n2;
    }

    private int drawPixel(int n, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        int n7 = (n >> 16 & 0xFF) * n3;
        int n8 = (n >> 8 & 0xFF) * n3;
        int n9 = (n & 0xFF) * n3;
        if (bl) {
            n7 += (n2 >> 16 & 0xFF) * (255 - n3);
            n8 += (n2 >> 8 & 0xFF) * (255 - n3);
            n9 += (n2 & 0xFF) * (255 - n3);
            if (this.m_tpBuffer != null) {
                this.m_tpBuffer[n6][n5] = n3;
                this.m_colBuffer[n6][n5] = n2;
            }
        } else {
            int n10 = (255 - n3) * this.m_tpBuffer[n6][n5] >> 8;
            int n11 = (255 - n3) * (255 - this.m_tpBuffer[n6][n5]) >> 8;
            n7 += (n2 >> 16 & 0xFF) * n10;
            n8 += (n2 >> 8 & 0xFF) * n10;
            n9 += (n2 & 0xFF) * n10;
            n7 += (this.m_colBuffer[n6][n5] >> 16 & 0xFF) * n11;
            n8 += (this.m_colBuffer[n6][n5] >> 8 & 0xFF) * n11;
            n9 += (this.m_colBuffer[n6][n5] & 0xFF) * n11;
        }
        n7 = n7 << 8 & 0xFF0000;
        n9 = n9 >> 8 & 0xFF;
        return n4 | n7 | (n8 &= 0xFF00) | n9;
    }

    private int discretizeBndEdge(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, int[][] nArray3, int[] nArray4, int[] nArray5, int[][] nArray6, PiVector piVector, PiVector piVector2, PiVector[] piVectorArray, PiVector[] piVectorArray2, int n7, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n8) {
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17 = n7;
        if (n7 >= piVectorArray2.length) {
            return -1;
        }
        if (this.m_bUseTexture) {
            for (n16 = 0; n16 < 3; ++n16) {
                this.m_td[n16] = piVector.m_data[n16];
                this.m_tdInc[n16] = piVector2.m_data[n16] - piVector.m_data[n16];
            }
        }
        if (this.m_bShowSmoothShading) {
            for (n16 = 0; n16 < 3; ++n16) {
                this.m_cd[n16] = nArray[n16];
                this.m_cdInc[n16] = nArray2[n16] - nArray[n16];
            }
        }
        if (this.m_bLocShowSmoothLighting) {
            for (n16 = 0; n16 < 6; ++n16) {
                this.m_ld[n16] = nArray4[n16];
                this.m_ldInc[n16] = nArray5[n16] - nArray4[n16];
            }
        }
        int n18 = n4 - n;
        int n19 = n5 - n2;
        int n20 = n6 - n3;
        int n21 = n;
        int n22 = n2;
        int n23 = n3;
        n16 = 1;
        int n24 = 1;
        if (n18 < 0) {
            n18 = -n18;
            n16 = -1;
        }
        if (n19 < 0) {
            n19 = -n19;
            n24 = -1;
        }
        int n25 = n18 << 1;
        int n26 = n19 << 1;
        int n27 = this.m_pixData.length;
        int n28 = this.m_bndIdentifier.m_data[0];
        boolean bl5 = n18 <= n19;
        int n29 = n15 = bl5 ? n19 : n18;
        if (this.m_bUseTexture && n7 + n15 >= piVectorArray.length) {
            return -1;
        }
        if (n15 == 0) {
            return n7;
        }
        if (this.m_bUseTexture) {
            n14 = 0;
            while (n14 < 3) {
                int n30 = n14++;
                this.m_tdInc[n30] = this.m_tdInc[n30] / n15;
            }
        }
        if (this.m_bShowSmoothShading) {
            n14 = 0;
            while (n14 < 3) {
                int n31 = n14++;
                this.m_cdInc[n31] = this.m_cdInc[n31] / n15;
            }
        }
        if (this.m_bLocShowSmoothLighting) {
            n14 = 0;
            while (n14 < 6) {
                int n32 = n14++;
                this.m_ldInc[n32] = this.m_ldInc[n32] / n15;
            }
        }
        n14 = 0xFFFFFF;
        if (n18 <= n19) {
            n20 /= n19;
            n13 = n25 - n19;
            n12 = n25;
            n11 = n25 - n26;
            do {
                piVectorArray2[n7].m_data[0] = n21;
                piVectorArray2[n7].m_data[1] = n22;
                piVectorArray2[n7].m_data[2] = n23;
                if (this.m_bUseTexture) {
                    piVectorArray[n7].set(this.m_td, 3);
                }
                if (this.m_bShowSmoothShading) {
                    for (n10 = 0; n10 < 3; ++n10) {
                        nArray3[n7][n10] = this.m_cd[n10];
                    }
                }
                if (this.m_bLocShowSmoothLighting) {
                    for (n10 = 0; n10 < 6; ++n10) {
                        nArray6[n7][n10] = this.m_ld[n10];
                    }
                }
                if (n21 >= 0 && n21 < this.m_imgWidth && (n9 = n22 * this.m_imgWidth + n21) >= 0 && n9 < n27) {
                    this.m_pixData[n9] = 0xFE000000 | this.m_pixData[n9] & n14;
                    this.m_bndIdentifier.m_data[++n28] = n9;
                }
                if (++n7 >= piVectorArray2.length) {
                    return -1;
                }
                n22 += n24;
                n23 += n20;
                if (n13 <= 0) {
                    n13 += n12;
                } else {
                    n13 += n11;
                    n21 += n16;
                }
                if (this.m_bUseTexture) {
                    for (n10 = 0; n10 < 3; ++n10) {
                        int n33 = n10;
                        this.m_td[n33] = this.m_td[n33] + this.m_tdInc[n10];
                    }
                }
                if (this.m_bShowSmoothShading) {
                    for (n10 = 0; n10 < 3; ++n10) {
                        int n34 = n10;
                        this.m_cd[n34] = this.m_cd[n34] + this.m_cdInc[n10];
                    }
                }
                if (!this.m_bLocShowSmoothLighting) continue;
                for (n10 = 0; n10 < 6; ++n10) {
                    int n35 = n10;
                    this.m_ld[n35] = this.m_ld[n35] + this.m_ldInc[n10];
                }
            } while (n22 != n5);
        } else {
            n20 /= n18;
            n13 = n26 - n18;
            n12 = n26;
            n11 = n26 - n25;
            piVectorArray2[n7].m_data[0] = n21;
            piVectorArray2[n7].m_data[1] = n22;
            piVectorArray2[n7].m_data[2] = n23;
            if (this.m_bUseTexture) {
                piVectorArray[n7].set(this.m_td, 3);
            }
            if (this.m_bShowSmoothShading) {
                for (n10 = 0; n10 < 3; ++n10) {
                    nArray3[n7][n10] = this.m_cd[n10];
                }
            }
            if (this.m_bLocShowSmoothLighting) {
                for (n10 = 0; n10 < 6; ++n10) {
                    nArray6[n7][n10] = this.m_ld[n10];
                }
            }
            if (n21 >= 0 && n21 < this.m_imgWidth && (n9 = n22 * this.m_imgWidth + n21) >= 0 && n9 < n27) {
                this.m_pixData[n9] = 0xFE000000 | this.m_pixData[n9] & n14;
                this.m_bndIdentifier.m_data[++n28] = n9;
            }
            ++n7;
            int n36 = n10 = bl2 && n24 < 0 || bl3 && n24 > 0 ? 1 : 0;
            while (n21 != n4) {
                int n37;
                if (n7 >= piVectorArray2.length - 1) {
                    return -1;
                }
                if (n13 <= 0) {
                    n13 += n12;
                    n21 += n16;
                    n23 += n20;
                    if (this.m_bUseTexture) {
                        for (n37 = 0; n37 < 3; ++n37) {
                            int n38 = n37;
                            this.m_td[n38] = this.m_td[n38] + this.m_tdInc[n37];
                        }
                    }
                    if (this.m_bShowSmoothShading) {
                        for (n37 = 0; n37 < 3; ++n37) {
                            int n39 = n37;
                            this.m_cd[n39] = this.m_cd[n39] + this.m_cdInc[n37];
                        }
                    }
                    if (this.m_bLocShowSmoothLighting) {
                        for (n37 = 0; n37 < 6; ++n37) {
                            int n40 = n37;
                            this.m_ld[n40] = this.m_ld[n40] + this.m_ldInc[n37];
                        }
                    }
                } else if (n10 != 0) {
                    n13 += n11;
                    n21 += n16;
                    n22 += n24;
                    n23 += n20;
                    if (this.m_bUseTexture) {
                        for (n37 = 0; n37 < 3; ++n37) {
                            int n41 = n37;
                            this.m_td[n41] = this.m_td[n41] + this.m_tdInc[n37];
                        }
                    }
                    if (this.m_bShowSmoothShading) {
                        for (n37 = 0; n37 < 3; ++n37) {
                            int n42 = n37;
                            this.m_cd[n42] = this.m_cd[n42] + this.m_cdInc[n37];
                        }
                    }
                    if (this.m_bLocShowSmoothLighting) {
                        for (n37 = 0; n37 < 6; ++n37) {
                            int n43 = n37;
                            this.m_ld[n43] = this.m_ld[n43] + this.m_ldInc[n37];
                        }
                    }
                    if (n21 != n4) {
                        piVectorArray2[n7].m_data[0] = n21;
                        piVectorArray2[n7].m_data[1] = n22;
                        piVectorArray2[n7].m_data[2] = n23;
                        if (this.m_bUseTexture) {
                            piVectorArray[n7].set(this.m_td, 3);
                        }
                        if (this.m_bShowSmoothShading) {
                            for (n37 = 0; n37 < 3; ++n37) {
                                nArray3[n7][n37] = this.m_cd[n37];
                            }
                        }
                        if (this.m_bLocShowSmoothLighting) {
                            for (n37 = 0; n37 < 6; ++n37) {
                                nArray6[n7][n37] = this.m_ld[n37];
                            }
                        }
                        ++n7;
                    }
                } else {
                    piVectorArray2[n7].m_data[0] = n21;
                    piVectorArray2[n7].m_data[1] = n22;
                    piVectorArray2[n7].m_data[2] = n23;
                    if (this.m_bUseTexture) {
                        piVectorArray[n7].set(this.m_td, 3);
                    }
                    if (this.m_bShowSmoothShading) {
                        for (n37 = 0; n37 < 3; ++n37) {
                            nArray3[n7][n37] = this.m_cd[n37];
                        }
                    }
                    if (this.m_bLocShowSmoothLighting) {
                        for (n37 = 0; n37 < 6; ++n37) {
                            nArray6[n7][n37] = this.m_ld[n37];
                        }
                    }
                    ++n7;
                    n13 += n11;
                    n21 += n16;
                    n22 += n24;
                    n23 += n20;
                    if (this.m_bUseTexture) {
                        for (n37 = 0; n37 < 3; ++n37) {
                            int n44 = n37;
                            this.m_td[n44] = this.m_td[n44] + this.m_tdInc[n37];
                        }
                    }
                    if (this.m_bShowSmoothShading) {
                        for (n37 = 0; n37 < 3; ++n37) {
                            int n45 = n37;
                            this.m_cd[n45] = this.m_cd[n45] + this.m_cdInc[n37];
                        }
                    }
                    if (this.m_bLocShowSmoothLighting) {
                        for (n37 = 0; n37 < 6; ++n37) {
                            int n46 = n37;
                            this.m_ld[n46] = this.m_ld[n46] + this.m_ldInc[n37];
                        }
                    }
                }
                if (n21 < 0 || n21 >= this.m_imgWidth || (n9 = n22 * this.m_imgWidth + n21) < 0 || n9 >= n27) continue;
                this.m_pixData[n9] = 0xFE000000 | this.m_pixData[n9] & n14;
                this.m_bndIdentifier.m_data[++n28] = n9;
            }
        }
        this.m_bndIdentifier.m_data[0] = n28;
        if (!bl) {
            if (n8 == 1 || n8 == 2 || n8 == 3 || n8 == 8) {
                for (n10 = n17; n10 < n7; ++n10) {
                    piVectorArray2[n10].m_data[3] = 0;
                }
            } else if (n8 == 6 || n8 == 7) {
                for (n10 = n17; n10 < n7; ++n10) {
                    piVectorArray2[n10].m_data[3] = 0;
                }
            } else if (n8 == 5) {
                if (n24 < 0) {
                    piVectorArray2[n17].m_data[3] = 0;
                    for (n10 = n17 + 1; n10 < n7; ++n10) {
                        piVectorArray2[n10].m_data[3] = piVectorArray2[n10 - 1].m_data[0] - piVectorArray2[n10].m_data[0] + 1;
                    }
                } else {
                    for (n10 = n17; n10 < n7 - 1; ++n10) {
                        piVectorArray2[n10].m_data[3] = piVectorArray2[n10 + 1].m_data[0] - piVectorArray2[n10].m_data[0] + 1;
                    }
                    piVectorArray2[n7 - 1].m_data[3] = n7 - 2 >= n17 ? piVectorArray2[n7 - 2].m_data[3] : 0;
                }
            } else if (n8 == 4) {
                if (n24 < 0) {
                    piVectorArray2[n17].m_data[3] = 0;
                    for (n10 = n17 + 1; n10 < n7; ++n10) {
                        piVectorArray2[n10].m_data[3] = piVectorArray2[n10 - 1].m_data[0] - piVectorArray2[n10].m_data[0] - 1;
                    }
                } else {
                    for (n10 = n17; n10 < n7 - 1; ++n10) {
                        piVectorArray2[n10].m_data[3] = piVectorArray2[n10 + 1].m_data[0] - piVectorArray2[n10].m_data[0] - 1;
                    }
                    piVectorArray2[n7 - 1].m_data[3] = n7 - 2 >= n17 ? piVectorArray2[n7 - 2].m_data[3] : 0;
                }
            }
        }
        return n7;
    }

    private void writePixel(int n, int n2, int n3, float f) {
        int n4;
        boolean bl;
        if (n2 < 0 || n2 >= this.m_imgHeight || n < 0 || n >= this.m_imgWidth) {
            return;
        }
        boolean bl2 = bl = (int)f - this.m_zTol > this.m_zBuffer[n2][n];
        if (!bl && !this.m_bShowLocTransparency) {
            return;
        }
        int n5 = n3;
        if (this.m_bShowDepthcue && this.m_bDepthcueEdge) {
            int n6;
            if (this.m_bUse_m_heightFac) {
                n4 = (int)(255.0f * this.m_heightFac);
            } else {
                n4 = (int)(255.0f * (f - (float)this.m_scene.m_zMin));
                n6 = this.m_scene.m_zMax - this.m_scene.m_zMin;
                if (n6 != 0) {
                    n4 /= n6;
                }
                if (n4 < 0) {
                    n4 = 0;
                } else if (n4 > 255) {
                    n4 = 255;
                }
            }
            n6 = (n5 >> 16 & 0xFF) * n4;
            int n7 = (n5 >> 8 & 0xFF) * n4;
            int n8 = (n5 & 0xFF) * n4;
            int n9 = this.m_grey * (255 - n4) & 0xFF00;
            n6 += n9;
            n7 += n9;
            n8 += n9;
            n6 = n6 << 8 & 0xFF0000;
            n8 = n8 >> 8 & 0xFF;
            n5 = n6 | (n7 &= 0xFF00) | n8;
        }
        n5 = this.m_alpha | n5;
        if (this.m_bShowLocTransparency) {
            n5 = this.drawPixel(this.m_pixData[n2 * this.m_imgWidth + n], n5, this.m_iTransparency, this.m_alpha, bl, n, n2);
        }
        this.m_pixData[n2 * this.m_imgWidth + n] = n5;
        n4 = (int)f - this.m_zTol;
        if (this.m_zBuffer[n2][n] < n4) {
            this.m_zBuffer[n2][n] = n4;
        }
    }

    private void drawLineZBresen(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        if (n < 0 && n4 < 0 || n >= this.m_imgWidth && n4 >= this.m_imgWidth || n2 < 0 && n5 < 0 || n2 >= this.m_imgHeight && n5 >= this.m_imgHeight) {
            return;
        }
        int n10 = n7;
        int n11 = this.m_zTol;
        this.m_zTol = this.m_zTolLine;
        int n12 = n4 - n;
        int n13 = n5 - n2;
        int n14 = n6 - n3;
        int n15 = n;
        int n16 = n2;
        int n17 = n3;
        int n18 = 1;
        int n19 = 1;
        if (n12 < 0) {
            n12 = -n12;
            n18 = -1;
        }
        if (n13 < 0) {
            n13 = -n13;
            n19 = -1;
        }
        if (this.m_bShowSmoothEdgeColors) {
            n9 = n12 >= n13 ? n12 : n13;
            if (n9 == 0) {
                n9 = 1;
            }
            PvGeometry.setScaledColor(this.m_c1d, n7, 16);
            PvGeometry.setScaledColor(this.m_c2d, n8, 16);
            for (int i = 0; i < 3; ++i) {
                this.m_cdInc[i] = (this.m_c2d[i] - this.m_c1d[i]) / n9;
            }
        }
        if (n12 >= n13) {
            int n20 = n13 << 1;
            int n21 = n13 - n12 << 1;
            if (n12 == 0) {
                this.writePixel(n15, n16, n10, n17);
                this.m_zTol = n11;
                return;
            }
            n14 /= n12;
            int n22 = n20 - n12;
            while (n15 != n4) {
                if (this.m_bShowSmoothEdgeColors) {
                    n10 = PvGeometry.getScaledColor(m_alphaOpaque, this.m_c1d, 16);
                    for (n9 = 0; n9 < 3; ++n9) {
                        int n23 = n9;
                        this.m_c1d[n23] = this.m_c1d[n23] + this.m_cdInc[n9];
                    }
                }
                this.writePixel(n15, n16, n10, n17);
                n15 += n18;
                n17 += n14;
                if (n22 <= 0) {
                    n22 += n20;
                    continue;
                }
                n22 += n21;
                n16 += n19;
            }
        } else {
            int n24 = n12 << 1;
            int n25 = n12 - n13 << 1;
            n14 /= n13;
            int n26 = n24 - n13;
            while (n16 != n5) {
                if (this.m_bShowSmoothEdgeColors) {
                    n10 = PvGeometry.getScaledColor(m_alphaOpaque, this.m_c1d, 16);
                    for (n9 = 0; n9 < 3; ++n9) {
                        int n27 = n9;
                        this.m_c1d[n27] = this.m_c1d[n27] + this.m_cdInc[n9];
                    }
                }
                this.writePixel(n15, n16, n10, n17);
                n16 += n19;
                n17 += n14;
                if (n26 <= 0) {
                    n26 += n24;
                    continue;
                }
                n26 += n25;
                n15 += n18;
            }
        }
        this.m_zTol = n11;
    }

    private void drawLineZBresen(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        if (n < 0 && n4 < 0 || n >= this.m_imgWidth && n4 >= this.m_imgWidth || n2 < 0 && n5 < 0 || n2 >= this.m_imgHeight && n5 >= this.m_imgHeight) {
            return;
        }
        int n11 = n7;
        int n12 = this.m_zTol;
        this.m_zTol = this.m_zTolLine;
        int n13 = n4 - n;
        int n14 = n5 - n2;
        int n15 = n6 - n3;
        int n16 = n;
        int n17 = n2;
        int n18 = n3;
        int n19 = 1;
        int n20 = 1;
        if (n13 < 0) {
            n13 = -n13;
            n19 = -1;
        }
        if (n14 < 0) {
            n14 = -n14;
            n20 = -1;
        }
        if (this.m_bShowSmoothEdgeColors) {
            n10 = n13 >= n14 ? n13 : n14;
            PvGeometry.setScaledColor(this.m_c1d, n7, 16);
            PvGeometry.setScaledColor(this.m_c2d, n8, 16);
            for (int i = 0; i < 3; ++i) {
                this.m_cdInc[i] = (this.m_c2d[i] - this.m_c1d[i]) / n10;
            }
        }
        if (n13 >= n14) {
            int n21 = n14 << 1;
            int n22 = n14 - n13 << 1;
            if (n13 == 0) {
                this.writePixel(n16, n17, n11, n18);
                this.m_zTol = n12;
                return;
            }
            n15 /= n13;
            int n23 = n21 - n13;
            while (n16 != n4) {
                if (this.m_bShowSmoothEdgeColors) {
                    n11 = PvGeometry.getScaledColor(m_alphaOpaque, this.m_c1d, 16);
                    for (n10 = 0; n10 < 3; ++n10) {
                        int n24 = n10;
                        this.m_c1d[n24] = this.m_c1d[n24] + this.m_cdInc[n10];
                    }
                }
                this.writePixel(n16, n17, n11, n18);
                this.writePixel(n16, n17 + 1, n11, n18);
                this.writePixel(n16, n17 - 1, n11, n18);
                n16 += n19;
                n18 += n15;
                if (n23 <= 0) {
                    n23 += n21;
                    continue;
                }
                n23 += n22;
                n17 += n20;
            }
        } else {
            int n25 = n13 << 1;
            int n26 = n13 - n14 << 1;
            n15 /= n14;
            int n27 = n25 - n14;
            while (n17 != n5) {
                if (this.m_bShowSmoothEdgeColors) {
                    n11 = PvGeometry.getScaledColor(m_alphaOpaque, this.m_c1d, 16);
                    for (n10 = 0; n10 < 3; ++n10) {
                        int n28 = n10;
                        this.m_c1d[n28] = this.m_c1d[n28] + this.m_cdInc[n10];
                    }
                }
                this.writePixel(n16, n17, n11, n18);
                this.writePixel(n16 - 1, n17, n11, n18);
                this.writePixel(n16 + 1, n17, n11, n18);
                n17 += n20;
                n18 += n15;
                if (n27 <= 0) {
                    n27 += n25;
                    continue;
                }
                n27 += n26;
                n16 += n19;
            }
        }
        this.m_zTol = n12;
    }

    private void drawLineZThick(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (n < PS_ZOOM) {
            return;
        }
        if (n2 < -n && n5 < -n || n2 >= this.m_imgWidth + n && n5 >= this.m_imgWidth + n || n3 < -n && n6 < -n || n3 >= this.m_imgHeight + n && n6 >= this.m_imgHeight + n) {
            return;
        }
        float f = n5 - n2;
        float f2 = n3 - n6;
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        if ((double)f3 < 1.0E-10) {
            f3 = 1.0f;
        }
        float f4 = 0.5f * (float)n * f2 / f3;
        float f5 = 0.5f * (float)n * -f / f3;
        this.m_xCorner[0] = (int)((float)n2 + f4);
        this.m_xCorner[1] = (int)((float)n5 + f4);
        this.m_xCorner[2] = (int)((float)n5 - f4);
        this.m_xCorner[3] = (int)((float)n2 - f4);
        this.m_yCorner[0] = (int)((float)n3 - f5);
        this.m_yCorner[1] = (int)((float)n6 - f5);
        this.m_yCorner[2] = (int)((float)n6 + f5);
        this.m_yCorner[3] = (int)((float)n3 + f5);
        this.m_zCorner[0] = n4;
        this.m_zCorner[1] = n7;
        this.m_zCorner[2] = n7;
        this.m_zCorner[3] = n4;
        int n10 = 4;
        if (this.m_tv != null) {
            for (int i = 0; i < n10; ++i) {
                this.m_tv[i].m_data[0] = this.m_textureWidth - 1 << 20;
                this.m_tv[i].m_data[1] = this.m_textureHeight - 1 << 20;
                this.m_tv[i].m_data[2] = this.m_zCorner[i] - this.m_scene.m_zMin;
            }
        }
        int[][] nArray = null;
        if (this.m_bShowSmoothEdgeColors) {
            nArray = this.m_cv;
        }
        int[][] nArray2 = null;
        if (this.m_bLocShowSmoothLighting) {
            nArray2 = this.m_lv;
        }
        int n11 = this.m_zTol;
        this.m_zTol = this.m_zTolLine;
        this.drawLineZBuffer(this.m_xCorner, this.m_yCorner, this.m_zCorner, n10, nArray, n8, nArray2, this.m_tv);
        this.m_zTol = n11;
    }

    private void drawLineZThick3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (n < PS_ZOOM) {
            return;
        }
        if (n2 < -n && n5 < -n || n2 >= this.m_imgWidth + n && n5 >= this.m_imgWidth + n || n3 < -n && n6 < -n || n3 >= this.m_imgHeight + n && n6 >= this.m_imgHeight + n) {
            return;
        }
        float f = n5 - n2;
        float f2 = n6 - n3;
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        if ((double)f3 < 1.0E-10) {
            f3 = 1.0f;
        }
        float f4 = (float)n * f2 / f3;
        float f5 = (float)n * -f / f3;
        float f6 = (float)(this.m_z3DLookFac * n) / 2.0f;
        if (Math.abs(f4) >= Math.abs(f5)) {
            if (f4 < 0.0f) {
                f4 = -f4;
                f5 = -f5;
            }
        } else if (f5 < 0.0f) {
            f4 = -f4;
            f5 = -f5;
        }
        int n10 = (int)((float)n2 - f4 / 2.0f + 0.5f);
        int n11 = (int)((float)n3 - f5 / 2.0f + 0.5f);
        int n12 = n4;
        int n13 = (int)((float)n5 - f4 / 2.0f + 0.5f);
        int n14 = (int)((float)n6 - f5 / 2.0f + 0.5f);
        int n15 = n7;
        if (Math.abs(f4) >= Math.abs(f5)) {
            int n16 = (int)(f4 + 1.0f + 0.5f);
            float f7 = n11;
            float f8 = n14;
            float f9 = f5 / (float)(n16 - 1);
            for (int i = 0; i < n16; ++i) {
                float f10 = (float)((i << 1) - (n16 - 1)) / (float)n16;
                float f11 = 1.0f - f10 * f10;
                float f12 = (float)Math.sqrt(f11);
                int n17 = n8;
                int n18 = n9;
                if (this.m_bShowSmoothEdgeColors) {
                    n17 = PvGeometry.getScaledColor(m_alphaOpaque, this.m_cv[0], 16);
                    n18 = PvGeometry.getScaledColor(m_alphaOpaque, this.m_cv[1], 16);
                }
                if (n > 1) {
                    n17 = PdColor.getDimmedColor(n17, (int)(255.0f * f12));
                    n18 = PdColor.getDimmedColor(n18, (int)(255.0f * f12));
                }
                if (i == 0) {
                    this.drawLineZBresen(n10, n11, n12, n13, n14, n15, n17, n18);
                    if (n16 == 2 && (f9 >= 1.0f || f9 <= -1.0f)) {
                        this.drawLineZBresen(n10 + 1, n11, n12, n13 + 1, n14, n15, n17, n18);
                    }
                } else if (i == n16 - 1) {
                    this.drawLineZBresen(n10, n11, n12, n13, n14, n15, n17, n18);
                } else {
                    this.drawLineZBresen(n10, n11, n12, n13, n14, n15, n17, n18, 0);
                }
                ++n10;
                ++n13;
                n11 = Math.round(f7 += f9);
                n14 = Math.round(f8 += f9);
                float f13 = f12 * f6;
                n12 = Math.round((float)n4 + f13);
                n15 = Math.round((float)n7 + f13);
            }
        } else {
            int n19 = (int)(f5 + 1.0f + 0.5f);
            float f14 = n10;
            float f15 = n13;
            float f16 = f4 / (float)(n19 - 1);
            for (int i = 0; i < n19; ++i) {
                float f17 = (float)((i << 1) - (n19 - 1)) / (float)n19;
                float f18 = 1.0f - f17 * f17;
                float f19 = (float)Math.sqrt(f18);
                int n20 = n8;
                int n21 = n9;
                if (this.m_bShowSmoothEdgeColors) {
                    n20 = PvGeometry.getScaledColor(m_alphaOpaque, this.m_cv[0], 16);
                    n21 = PvGeometry.getScaledColor(m_alphaOpaque, this.m_cv[1], 16);
                }
                if (n > 2) {
                    n20 = PdColor.getDimmedColor(n20, (int)(255.0f * f19));
                    n21 = PdColor.getDimmedColor(n21, (int)(255.0f * f19));
                }
                if (i == 0) {
                    this.drawLineZBresen(n10, n11, n12, n13, n14, n15, n20, n21);
                    if (n19 == 2 && (f16 >= 1.0f || f16 <= -1.0f)) {
                        this.drawLineZBresen(n10, n11 + 1, n12, n13, n14 + 1, n15, n20, n21);
                    }
                } else if (i == n19 - 1) {
                    this.drawLineZBresen(n10, n11, n12, n13, n14, n15, n20, n21);
                } else {
                    this.drawLineZBresen(n10, n11, n12, n13, n14, n15, n20, n21, 1);
                }
                n10 = Math.round(f14 += f16);
                n13 = Math.round(f15 += f16);
                ++n11;
                ++n14;
                float f20 = f19 * f6;
                n12 = Math.round((float)n4 + f20);
                n15 = Math.round((float)n7 + f20);
            }
        }
    }

    public void setTexture(int[] nArray, int n, int n2, int n3, int n4) {
        this.setTexture(nArray, n, n2, 1, 1, 3, n3, n4, 3);
    }

    public void setTexture(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.m_texturePix = nArray;
        this.m_textureWidth = n;
        this.m_textureHeight = n2;
        this.m_textureTilingWidth = n3 * n;
        this.m_textureTilingHeight = n4 * n2;
        this.m_textureTiling.setSize(n3, n4);
        this.m_texturePeriodic = n5;
        if (nArray == null) {
            this.setState(71, false);
            this.setState(72, false);
            this.m_bUseTexture = this.m_bShowTexture = false;
        }
        this.m_blendingMode = n6;
        this.m_filterType = n7;
        this.m_textureSide = n8;
        this.m_texturePeriodic = n5;
    }

    public void setTransparency(double d) {
        this.m_alpha = Math.abs(1.0 - d) < 0.02 ? 0 : (Math.abs(d) < 0.02 ? m_alphaOpaque : (255 - (int)(255.0 * d) & 0xFF) << 24);
        this.m_locTransparencyOrig = this.m_iTransparency = (int)(255.0 * d);
        this.m_alpha = m_alphaOpaque;
    }

    protected int updateUnusedVertices() {
        int n;
        int n2;
        if (this.m_numVertices == 0) {
            return 0;
        }
        int n3 = -1;
        this.m_unusedVertex.setSize(this.m_numVertices);
        this.m_unusedVertex.setConstant(0);
        int[] nArray = this.m_unusedVertex.m_data;
        for (n2 = 0; n2 < this.m_numElements; ++n2) {
            for (n = this.m_element[n2].m_data.length - 1; n >= 0; --n) {
                nArray[this.m_element[n2].m_data[n]] = n3;
            }
        }
        for (n2 = 0; n2 < this.m_numPolygons; ++n2) {
            for (n = this.m_polygon[n2].m_data.length - 1; n >= 0; --n) {
                nArray[this.m_polygon[n2].m_data[n]] = n3;
            }
        }
        int n4 = 0;
        for (n2 = 0; n2 < this.m_numVertices; ++n2) {
            if (nArray[n2] == n3) continue;
            nArray[n4++] = n2;
        }
        this.m_numUnusedVertices = n4;
        return this.m_numUnusedVertices;
    }

    protected int[] getUnusedVertices() {
        return this.m_unusedVertex.m_data;
    }

    protected int getNumUnusedVertices() {
        return this.m_numUnusedVertices;
    }

    protected int getNumItems() {
        int n = 0;
        if (this.m_useVertices) {
            n += this.m_numVertices;
        } else if (this.m_useUnusedVertices) {
            n += this.m_numUnusedVertices;
        }
        if (this.m_useElements) {
            n += this.m_numElements;
        }
        if (this.m_usePolygons) {
            n += this.m_numPolygonEdges;
        }
        return n;
    }

    public void projectItems(PdMatrix pdMatrix, PdMatrix pdMatrix2, PdMatrix pdMatrix3, PdMatrix pdMatrix4) {
        if (this.m_dim != this.vtSrc.getSize()) {
            this.vtSrc.setSize(this.m_dim);
            this.vtSrc1.setSize(this.m_dim + 1);
        }
        this.m_projviewMat = pdMatrix;
        this.m_viewMat = pdMatrix3;
        this.m_bModAmb = pdMatrix4 != null || this.m_ambientMatrix != null || this.m_ambientProj != 0;
        this.projectVertices(pdMatrix, pdMatrix4);
        if (this.m_bShowName || this.m_bShowTitle) {
            int n = this.m_ambientProj;
            this.m_ambientProj = 0;
            for (int i = 0; i < 2; ++i) {
                this.m_vt.copyArray(this.m_bndBox[i]);
                this.project(this.m_bndBoxTrans[i], this.m_vt, pdMatrix);
            }
            this.m_ambientProj = n;
        }
        if (this.m_bShowVertexSizes && this.m_vertexSize == null) {
            this.m_bShowVertexSizes = false;
        }
        if (this.m_bUseVertexNormals) {
            this.projectVertexNormals(pdMatrix, pdMatrix4);
        }
        if (this.m_bUseElementCenters) {
            this.projectElementCenters(pdMatrix, pdMatrix4);
        }
        if (this.m_bUseElementNormals) {
            this.projectElementNormals(pdMatrix, pdMatrix4);
        }
        if (this.m_bShowVectors) {
            this.projectVectors(pdMatrix, pdMatrix4);
        }
    }

    protected void drawCenter(Graphics graphics) {
        graphics.setColor(Color.green);
        int n = 4;
        int n2 = this.m_centerTrans.m_data[0];
        int n3 = this.m_centerTrans.m_data[1];
        graphics.fillOval(n2 - n, n3 - n, 2 * n, 2 * n);
        graphics.setColor(Color.black);
        graphics.drawOval(n2 - n, n3 - n, 2 * n, 2 * n);
    }

    public void setModelMatrix(PdMatrix pdMatrix) {
        super.setModelMatrix(pdMatrix);
        if (this.m_geometry != null) {
            this.m_geometry.setModelMatrix(pdMatrix);
        }
    }

    public void setAmbientMatrix(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        super.setAmbientMatrix(pdMatrix, pdMatrix2);
        if (this.m_geometry != null) {
            this.m_geometry.setAmbientMatrix(pdMatrix, pdMatrix2);
        }
    }

    private boolean project(PiVector piVector, PdVector pdVector, PdMatrix pdMatrix) {
        boolean bl = true;
        if (this.m_position == null) {
            if (this.m_bPerspectivity) {
                int n;
                double d = pdMatrix.m_data[3][3];
                for (n = 0; n < 3; ++n) {
                    d += pdMatrix.m_data[3][n] * pdVector.m_data[n];
                }
                if (d < 0.0) {
                    bl = false;
                    d = -d;
                }
                n = d > 0.001 ? 1 : 0;
                bl = bl && n != 0;
                for (int i = 0; i < 3; ++i) {
                    double d2 = pdMatrix.m_data[i][3];
                    for (int j = 0; j < 3; ++j) {
                        d2 += pdMatrix.m_data[i][j] * pdVector.m_data[j];
                    }
                    if (n != 0) {
                        if (PS_ZOOM != 1 && i < 2) {
                            d2 *= (double)PS_ZOOM;
                        }
                        piVector.m_data[i] = (int)(d2 / d + 0.3);
                        continue;
                    }
                    piVector.m_data[i] = (int)(d2 + 0.3);
                }
                if (!bl) {
                    piVector.m_data[2] = Integer.MIN_VALUE;
                }
            } else {
                for (int i = 0; i < 3; ++i) {
                    double d = pdMatrix.m_data[i][3];
                    for (int j = 0; j < 3; ++j) {
                        d += pdMatrix.m_data[i][j] * pdVector.m_data[j];
                    }
                    if (PS_ZOOM != 1 && i < 2) {
                        d *= (double)PS_ZOOM;
                    }
                    piVector.m_data[i] = (int)(d + 0.3);
                }
            }
        } else {
            int n;
            int n2;
            int n3;
            double d = PdVector.length(3, this.m_viewMat.m_data[2]);
            if (this.m_dispSize != null) {
                n3 = this.m_dispSize.width / 10;
                n2 = this.m_dispSize.height - n3;
            } else {
                n3 = ((PvDisplay)this.m_display).m_widthOff;
                n2 = ((PvDisplay)this.m_display).m_heightOff;
            }
            double d3 = pdMatrix.m_data[0][3];
            double d4 = pdMatrix.m_data[1][3];
            double d5 = pdMatrix.m_data[0][3];
            for (n = 0; n < 3; ++n) {
                d5 += pdMatrix.m_data[0][n] * pdVector.m_data[n] / d;
            }
            piVector.m_data[0] = (int)((double)PS_ZOOM * (d5 + (double)n3 - d3 + 0.3));
            d5 = pdMatrix.m_data[1][3];
            for (n = 0; n < 3; ++n) {
                d5 += pdMatrix.m_data[1][n] * pdVector.m_data[n] / d;
            }
            piVector.m_data[1] = (int)((double)PS_ZOOM * (d5 + (double)n2 - d4 + 0.3));
            d5 = pdMatrix.m_data[2][3];
            for (n = 0; n < 3; ++n) {
                d5 += pdMatrix.m_data[2][n] * pdVector.m_data[n] / d;
            }
            piVector.m_data[2] = (int)(d5 + 0.3);
        }
        return bl;
    }

    protected static boolean project_tmp_beta(PiVector piVector, PdVector pdVector, PdMatrix pdMatrix, boolean bl) {
        boolean bl2 = true;
        if (bl) {
            int n;
            double d = pdMatrix.m_data[3][3];
            for (n = 0; n < 3; ++n) {
                d += pdMatrix.m_data[3][n] * pdVector.m_data[n];
            }
            if (d < 0.0) {
                bl2 = false;
                d = -d;
            }
            n = d > 0.001 ? 1 : 0;
            bl2 = bl2 && n != 0;
            for (int i = 0; i < 3; ++i) {
                double d2 = pdMatrix.m_data[i][3];
                for (int j = 0; j < 3; ++j) {
                    d2 += pdMatrix.m_data[i][j] * pdVector.m_data[j];
                }
                if (n != 0) {
                    if (PS_ZOOM != 1 && i < 2) {
                        d2 *= (double)PS_ZOOM;
                    }
                    piVector.m_data[i] = (int)(d2 / d + 0.3);
                    continue;
                }
                piVector.m_data[i] = (int)(d2 + 0.3);
            }
            if (!bl2) {
                piVector.m_data[2] = Integer.MIN_VALUE;
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                double d = pdMatrix.m_data[i][3];
                for (int j = 0; j < 3; ++j) {
                    d += pdMatrix.m_data[i][j] * pdVector.m_data[j];
                }
                if (PS_ZOOM != 1 && i < 2) {
                    d *= (double)PS_ZOOM;
                }
                piVector.m_data[i] = (int)(d + 0.3);
            }
        }
        return bl2;
    }

    private void project(PdVector pdVector, PdVector pdVector2, PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (pdMatrix2 != null) {
            this.vtSrc1.copyArray(pdVector2);
            if (this.m_position == null) {
                this.vtSrc1.m_data[this.m_dim] = 1.0;
                this.vtSrc1.leftMultMatrix(pdMatrix2);
            } else {
                if (this.vtSrc1.getSize() != pdMatrix2.getSize()) {
                    this.vtSrc1.setSize(pdMatrix2.getSize());
                }
                double d = PdVector.length(this.m_dim, pdMatrix2.m_data[0]);
                this.vtSrc1.m_data[this.m_dim] = 0.0;
                this.vtSrc1.leftMultMatrix(pdMatrix2);
                this.vtSrc1.multScalar(1.0 / d);
            }
            this.vtSrc1.m_data[this.m_dim] = 0.0;
        }
        if (this.m_position == null && this.m_ambientProj != 0) {
            if (pdMatrix2 != null) {
                this.vtSrc.copyArray(this.vtSrc1);
            } else {
                this.vtSrc.copyArray(pdVector2);
            }
            if (this.m_ambientSpace == 9 || this.m_ambientSpace == 6 || this.m_ambientSpace == 3 || this.m_ambientSpace == 1 || this.m_ambientSpace == 2 || this.m_ambientSpace == 4 || this.m_ambientSpace == 7 || this.m_ambientSpace == 10) {
                if (this.m_ambientProj == 1) {
                    PuProj.stereographic(this.vtSrc, this.vtSrc);
                } else {
                    PsDebug.warning("unknown projection type");
                }
            } else if (this.m_ambientSpace == 5 || this.m_ambientSpace == 8 || this.m_ambientSpace == 11) {
                if (this.m_ambientProj == 2) {
                    PuProj.lorentz2Klein(this.vtSrc, this.vtSrc);
                } else if (this.m_ambientProj == 1) {
                    PuProj.lorentz2Poincare(this.vtSrc, this.vtSrc);
                } else if (this.m_ambientProj == 3) {
                    PuProj.lorentz2Uhm(this.vtSrc, this.vtSrc);
                } else {
                    PsDebug.warning("unknown projection type");
                }
            } else {
                PsDebug.warning("unknown ambient space");
            }
            this.vtMod1.copyArray(this.vtSrc);
            for (int i = this.m_dim - 1; i < this.m_dimTrans; ++i) {
                this.vtMod1.m_data[i] = 0.0;
            }
        } else if (pdMatrix2 != null) {
            this.vtMod1.copyArray(this.vtSrc1);
        } else {
            this.vtMod1.copyArray(pdVector2);
        }
        if (pdMatrix != null) {
            this.vtMod1.m_data[this.m_dimTrans] = 1.0;
            if (this.m_position == null) {
                this.vtMod1.leftMultMatrix(pdMatrix);
            } else {
                double d = PdVector.length(this.m_dimTrans, pdMatrix.m_data[this.m_dimTrans - 1]);
                this.vtMod1.m_data[this.m_dimTrans] = 0.0;
                this.vtMod1.leftMultMatrix(pdMatrix);
                this.vtMod1.multScalar(1.0 / d);
            }
        }
        pdVector.copyArray(this.vtMod1);
    }

    protected void setPosition(int n, int n2) {
        if (this.m_position == null) {
            this.m_position = new int[2];
        }
        this.m_position[0] = n;
        this.m_position[1] = n2;
    }

    protected int getZMin() {
        return this.m_zMin;
    }

    protected int getZMax() {
        return this.m_zMax;
    }

    protected void projectVertices(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (this.m_numVertices == 0) {
            return;
        }
        this.m_zMin = Integer.MAX_VALUE;
        this.m_zMax = Integer.MIN_VALUE;
        bDebug = true;
        for (int i = 0; i < this.m_numVertices; ++i) {
            if (this.m_bModAmb) {
                this.project(this.m_vtMod, this.m_vertex[i], pdMatrix2, this.m_ambientMatrix);
            } else {
                this.m_vtMod.copyArray(this.m_vertex[i]);
            }
            boolean bl = this.project(this.m_vertexTrans[i], this.m_vtMod, pdMatrix);
            if (!bl) continue;
            if (this.m_vertexTrans[i].m_data[2] < this.m_zMin) {
                this.m_zMin = this.m_vertexTrans[i].m_data[2];
            }
            if (this.m_vertexTrans[i].m_data[2] <= this.m_zMax) continue;
            this.m_zMax = this.m_vertexTrans[i].m_data[2];
        }
        if (this.m_center != null) {
            if (this.m_bModAmb) {
                this.project(this.m_vtMod, this.m_center, pdMatrix2, this.m_ambientMatrix);
            } else {
                this.m_vtMod.copyArray(this.m_center);
            }
        } else {
            this.m_vtMod.setConstant(0.0);
        }
        this.project(this.m_centerTrans, this.m_vtMod, pdMatrix);
        bDebug = false;
    }

    protected void projectVertexNormals(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (this.m_numVertices == 0 || this.m_vertexNormal == null || this.m_vertexNormal.length < this.m_numVertices) {
            this.m_bShowVertexNormals = false;
            return;
        }
        boolean bl = this.m_bEnableClip;
        this.m_bEnableClip = false;
        PdVector[] pdVectorArray = this.m_clipBounds;
        this.m_clipBounds = null;
        for (int i = 0; i < this.m_numVertices; ++i) {
            this.m_vtSrc.blendBase(this.m_vertex[i], this.m_globalVertexNormalLength, this.m_vertexNormal[i]);
            if (this.m_bModAmb) {
                this.project(this.m_vtTipMod, this.m_vtSrc, pdMatrix2, this.m_ambientMatrix);
            } else {
                this.m_vtTipMod.copyArray(this.m_vtSrc);
            }
            this.project(this.m_vertexNormalTrans[i], this.m_vtTipMod, pdMatrix);
            if (this.m_bShowElements || this.m_bShowPolygons || this.m_bShowBackface) continue;
            boolean bl2 = false;
            if (!this.m_bPerspectivity) {
                bl2 = this.m_vertexNormalTrans[i].m_data[2] - this.m_vertexTrans[i].m_data[2] < 0;
            } else {
                this.project(this.m_vtMod, this.m_vertex[i], pdMatrix2, this.m_ambientMatrix);
                this.m_vtTipMod.sub(this.m_vtMod);
                this.m_vertexEye.sub(this.m_vtMod, this.m_cameraPos);
                boolean bl3 = bl2 = PdVector.dot(this.m_vtTipMod, this.m_vertexEye) > 0.0;
            }
            if (bl2) {
                this.m_vertexNormalTrans[i].setTag(15);
                continue;
            }
            this.m_vertexNormalTrans[i].clearTag(15);
        }
        this.m_bEnableClip = bl;
        this.m_clipBounds = pdVectorArray;
    }

    protected void projectVectors(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (this.m_numVertices == 0 || this.m_numVectorFields == 0) {
            this.m_bShowVectors = false;
            return;
        }
        boolean bl = this.m_bEnableClip;
        this.m_bEnableClip = false;
        PdVector[] pdVectorArray = this.m_clipBounds;
        this.m_clipBounds = null;
        for (int i = 0; i < this.m_numVectorFields; ++i) {
            int n;
            if (!this.m_bShowVectorField[i]) continue;
            int n2 = this.getDimOfVectors(i);
            this.m_vtSrc.setConstant(0.0);
            if (!this.m_vectorIsElementBased[i]) {
                for (n = 0; n < this.m_numVertices; ++n) {
                    if (n2 == 1 && this.m_vertexNormal != null) {
                        this.m_vtSrc.blendBase(this.m_vertex[n], this.m_globalVectorLength[i] * this.m_vector[i][n].m_data[0], this.m_vertexNormal[n]);
                    } else if (n2 == this.m_dim) {
                        this.m_vtSrc.blendBase(this.m_vertex[n], this.m_globalVectorLength[i], this.m_vector[i][n]);
                    } else {
                        this.m_vtSrc.copyArray(this.m_vector[i][n]);
                        this.m_vtSrc.blendBase(this.m_vertex[n], this.m_globalVectorLength[i], this.m_vtSrc);
                    }
                    if (this.m_bModAmb) {
                        this.project(this.m_vtMod, this.m_vtSrc, pdMatrix2, this.m_ambientMatrix);
                    } else {
                        this.m_vtMod.copyArray(this.m_vtSrc);
                    }
                    this.project(this.m_vectorTrans[i][n], this.m_vtMod, pdMatrix);
                }
                continue;
            }
            for (n = 0; n < this.m_numElements; ++n) {
                if (n2 == 1 && this.m_elementNormal != null) {
                    this.m_vtSrc.blendBase(this.m_elemCenter[n], this.m_globalVectorLength[i] * this.m_vector[i][n].m_data[0], this.m_elementNormal[n]);
                } else if (n2 == this.m_dim) {
                    this.m_vtSrc.blendBase(this.m_elemCenter[n], this.m_globalVectorLength[i], this.m_vector[i][n]);
                } else {
                    this.m_vtSrc.copyArray(this.m_vector[i][n]);
                    this.m_vtSrc.blendBase(this.m_elemCenter[n], this.m_globalVectorLength[i], this.m_vtSrc);
                }
                if (this.m_bModAmb) {
                    this.project(this.m_vtMod, this.m_vtSrc, pdMatrix2, this.m_ambientMatrix);
                } else {
                    this.m_vtMod.copyArray(this.m_vtSrc);
                }
                this.project(this.m_vectorTrans[i][n], this.m_vtMod, pdMatrix);
            }
        }
        this.m_bEnableClip = bl;
        this.m_clipBounds = pdVectorArray;
    }

    protected void projectElementNormals(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (this.m_numElements == 0 || this.m_elementNormal == null || this.m_elementNormal.length < this.m_numElements) {
            this.m_bShowElementNormals = false;
            return;
        }
        boolean bl = this.m_bEnableClip;
        this.m_bEnableClip = false;
        PdVector[] pdVectorArray = this.m_clipBounds;
        this.m_clipBounds = null;
        boolean bl2 = !this.m_bShowSilhouette && this.m_bShowBackface && !this.m_bShowElementBackColor && !this.m_bShowElementBackColors && !this.m_bShowEdgeAura && this.m_dim >= 3 && (!this.m_bShowTexture || this.m_textureSide == 3);
        for (int i = 0; i < this.m_numElements; ++i) {
            this.m_vtSrc.blendBase(this.m_elemCenter[i], this.m_globalElementNormalLength, this.m_elementNormal[i]);
            if (this.m_bModAmb) {
                this.project(this.m_vtTipMod, this.m_vtSrc, pdMatrix2, this.m_ambientMatrix);
            } else {
                this.m_vtTipMod.copyArray(this.m_vtSrc);
            }
            this.project(this.m_elementNormalTrans[i], this.m_vtTipMod, pdMatrix);
            if (bl2) continue;
            boolean bl3 = false;
            if (!this.m_bPerspectivity) {
                int n = this.m_element[i].m_data.length;
                double d = this.m_vertexTrans[this.m_element[i].m_data[0]].m_data[2];
                for (int j = 1; j < n; ++j) {
                    d += (double)this.m_vertexTrans[this.m_element[i].m_data[j]].m_data[2];
                }
                bl3 = this.m_elementNormalTrans[i].m_data[2] - (int)(d / (double)n) < 0;
            } else {
                this.project(this.m_vtMod, this.m_elemCenter[i], pdMatrix2, this.m_ambientMatrix);
                this.m_vtTipMod.sub(this.m_vtMod);
                this.m_vertexEye.sub(this.m_vtMod, this.m_cameraPos);
                boolean bl4 = bl3 = PdVector.dot(this.m_vtTipMod, this.m_vertexEye) > 0.0;
            }
            if (bl3) {
                this.m_elementNormalTrans[i].setTag(15);
                continue;
            }
            this.m_elementNormalTrans[i].clearTag(15);
        }
        this.m_bEnableClip = bl;
        this.m_clipBounds = pdVectorArray;
    }

    protected void projectElementCenters(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        for (int i = 0; i < this.m_numElements; ++i) {
            PvGeometry.getElementCenter(this.m_elemCenter[i], this.m_element[i].m_data, this.m_vertex, this.m_dim);
            if (this.m_bModAmb) {
                this.project(this.m_vtMod, this.m_elemCenter[i], pdMatrix2, this.m_ambientMatrix);
            } else {
                this.m_vtMod.copyArray(this.m_elemCenter[i]);
            }
            this.project(this.m_elemCenterTrans[i], this.m_vtMod, pdMatrix);
        }
    }

    public void setGlobalVertexNormalSize(double d) {
        this.m_globalVertexNormalSize = d;
        if (this.m_globalVertexNormalSize > 1.0) {
            this.m_globalVertexNormalSize = 2.0 * d - 1.0;
        }
    }

    public void setGlobalPolygonNormalSize(double d) {
        this.m_globalPolygonNormalSize = d;
        if (this.m_globalPolygonNormalSize > 1.0) {
            this.m_globalPolygonNormalSize = 2.0 * d - 1.0;
        }
    }

    public void setGlobalElementNormalSize(double d) {
        this.m_globalElementNormalSize = d;
        if (this.m_globalElementNormalSize > 1.0) {
            this.m_globalElementNormalSize = 2.0 * d - 1.0;
        }
    }

    public void setGlobalPolygonSize(double d) {
        this.m_globalPolygonSize = d;
    }

    public void setGlobalEdgeSize(double d) {
        this.m_globalEdgeSize = d;
        if (this.m_globalEdgeSize > 1.0) {
            this.m_globalEdgeSize = 2.0 * d - 1.0;
        }
    }

    public void setGlobalBndSize(double d) {
        this.m_globalBndSize = d;
        if (this.m_globalBndSize > 1.0) {
            this.m_globalBndSize = 2.0 * d - 1.0;
        }
    }

    protected void setMaxNumVertices(int n) {
        if (this.m_maxNumVertices == n) {
            return;
        }
        super.setMaxNumVertices(n);
        this.m_vertexTrans = PiVector.realloc(this.m_vertexTrans, n, this.m_dimTrans);
    }

    public void setPolygons(PiVector[] piVectorArray) {
        super.setPolygons(piVectorArray);
        this.computeNumPolygonEdges();
    }

    public int addPolygon(PiVector piVector) {
        this.setNumPolygons(this.m_numPolygons + 1);
        this.setPolygon(this.m_numPolygons - 1, piVector);
        this.computeNumPolygonEdges();
        return this.m_numPolygons - 1;
    }

    public void setVertexNormals(PdVector[] pdVectorArray) {
        super.setVertexNormals(pdVectorArray);
        if (pdVectorArray == null) {
            this.m_vertexNormalTrans = null;
        } else {
            this.assureVertexNormals();
        }
    }

    public void assureVertexNormals() {
        super.assureVertexNormals();
        if (this.m_vertexNormalTrans == null || this.m_vertexNormalTrans.length != this.m_maxNumVertices) {
            this.m_vertexNormalTrans = PiVector.realloc(this.m_vertexNormalTrans, this.m_maxNumVertices, this.m_dimTrans);
        }
    }

    public void setElementNormals(PdVector[] pdVectorArray) {
        super.setElementNormals(pdVectorArray);
        if (pdVectorArray == null) {
            this.m_elementNormalTrans = null;
        } else {
            this.assureElementNormals();
        }
    }

    public void assureElementNormals() {
        super.assureElementNormals();
        if (this.m_elementNormalTrans == null || this.m_elementNormalTrans.length != this.m_maxNumElements) {
            this.m_elementNormalTrans = PiVector.realloc(this.m_elementNormalTrans, this.m_maxNumElements, this.m_dimTrans);
        }
    }

    protected int computeNumPolygonEdges() {
        int n;
        this.m_numPolygonEdges = 0;
        for (n = 0; n < this.m_numPolygons; ++n) {
            if (this.m_polygon[n] == null) continue;
            this.m_numPolygonEdges += Math.max(this.m_polygon[n].getSize() - 1, 0);
        }
        this.m_edgeOffset.setSize(this.m_numPolygonEdges);
        this.m_edgePolygon.setSize(this.m_numPolygonEdges);
        n = 0;
        int n2 = 0;
        for (int i = 0; i < this.m_numPolygons; ++i) {
            if (this.m_polygon[i] == null) continue;
            int n3 = Math.max(this.m_polygon[i].getSize() - 1, 0);
            for (int j = 0; j < n3; ++j) {
                this.m_edgePolygon.m_data[n] = i;
                this.m_edgeOffset.m_data[n] = n2;
                ++n;
            }
            n2 += n3;
        }
        return this.m_numPolygonEdges;
    }

    public void setNumVectorFields(int n) {
        if (n == this.m_numVectorFields) {
            return;
        }
        PiVector[][] piVectorArrayArray = new PiVector[n][];
        for (int i = 0; i < Math.min(n, this.m_numVectorFields); ++i) {
            piVectorArrayArray[i] = this.m_vectorTrans[i];
        }
        this.m_vectorTrans = piVectorArrayArray;
        super.setNumVectorFields(n);
    }

    public void setNumVectors(int n, int n2, int n3) {
        super.setNumVectors(n, n2, n3);
        this.m_vectorTrans[n] = PiVector.realloc(this.m_vectorTrans[n], n2, this.m_dimTrans);
    }

    protected int addGeometryVertex(PdVector pdVector) {
        if (!this.m_bInstanceSharing) {
            this.setNumVertices(this.m_numVertices + 1);
            this.setVertex(this.m_numVertices - 1, pdVector);
        }
        return this.m_geometry.addVertex(pdVector);
    }

    protected boolean setGeometryVertex(int n, PdVector pdVector) {
        this.setVertex(n, pdVector);
        PdVector pdVector2 = this.m_geometry.getVertex(n);
        pdVector2.copyArray(pdVector);
        return this.m_geometry.setVertex(n, pdVector2);
    }

    protected int addGeometryElement(PiVector piVector) {
        int n = piVector.getSize();
        int n2 = -1;
        switch (this.getType()) {
            case 33: {
                if (n < 3) break;
                if (!this.m_bInstanceSharing) {
                    this.setNumElements(this.m_numElements + 1);
                    this.setElement(this.m_numElements - 1, piVector);
                }
                n2 = this.m_geometry.addElement(piVector);
                break;
            }
            case 32: {
                if (n < 2) break;
                if (!this.m_bInstanceSharing) {
                    this.addPolygon(piVector);
                }
                n2 = this.m_geometry.addPolygon(piVector);
            }
        }
        this.m_geometry.update(this.m_geometry);
        return n2;
    }

    protected boolean setGeometryElement(int n, PiVector piVector) {
        int n2 = piVector.getSize();
        switch (this.getType()) {
            case 33: {
                if (n2 < 3) {
                    return false;
                }
                this.setElement(n, piVector);
                PiVector piVector2 = this.m_geometry.getElement(n);
                piVector2.copyArray(piVector);
                return this.m_geometry.setElement(n, piVector2);
            }
            case 32: {
                if (n2 < 2) {
                    return false;
                }
                this.setPolygon(n, piVector);
                PiVector piVector3 = this.m_geometry.getPolygon(n);
                piVector3.copyArray(piVector);
                return this.m_geometry.setPolygon(n, piVector3);
            }
        }
        return false;
    }

    protected void drawPolygonOneSide(Graphics graphics, int n, int[] nArray, int[] nArray2, int[] nArray3, int n2, boolean bl, int n3) {
        if (n == PS_ZOOM) {
            graphics.drawPolygon(nArray, nArray2, n2);
        } else {
            int[] nArray4 = new int[n2];
            int[] nArray5 = new int[n2];
            boolean bl2 = PvGeometry.getParallelCurve(nArray4, nArray5, nArray, nArray2, n2, n, true, bl);
            if (!bl2) {
                return;
            }
            --n2;
            for (int i = 0; i < n2; ++i) {
                this.m_xCorner[0] = nArray[i];
                this.m_xCorner[1] = nArray4[i];
                this.m_xCorner[2] = nArray4[i + 1];
                this.m_xCorner[3] = nArray[i + 1];
                this.m_yCorner[0] = nArray2[i];
                this.m_yCorner[1] = nArray5[i];
                this.m_yCorner[2] = nArray5[i + 1];
                this.m_yCorner[3] = nArray2[i + 1];
                if (!this.m_bEnableZBuffer) {
                    graphics.fillPolygon(this.m_xCorner, this.m_yCorner, 4);
                    continue;
                }
                this.m_zCorner[0] = nArray3[i];
                this.m_zCorner[1] = nArray3[i];
                this.m_zCorner[2] = nArray3[i + 1];
                this.m_zCorner[3] = nArray3[i + 1];
                this.m_bUseTexture = false;
                this.drawLineZBuffer(this.m_xCorner, this.m_yCorner, this.m_zCorner, 4, null, n3, null, null);
                this.m_bUseTexture = this.m_bShowTexture;
            }
            if (n2 > 0) {
                this.m_xCorner[0] = nArray[n2];
                this.m_xCorner[1] = nArray4[n2];
                this.m_xCorner[2] = nArray4[0];
                this.m_xCorner[3] = nArray[0];
                this.m_yCorner[0] = nArray2[n2];
                this.m_yCorner[1] = nArray5[n2];
                this.m_yCorner[2] = nArray5[0];
                this.m_yCorner[3] = nArray2[0];
                if (!this.m_bEnableZBuffer) {
                    graphics.fillPolygon(this.m_xCorner, this.m_yCorner, 4);
                } else {
                    this.m_zCorner[0] = nArray3[n2];
                    this.m_zCorner[1] = nArray3[n2];
                    this.m_zCorner[2] = nArray3[0];
                    this.m_zCorner[3] = nArray3[0];
                    this.m_bUseTexture = false;
                    this.drawLineZBuffer(this.m_xCorner, this.m_yCorner, this.m_zCorner, 4, null, n3, null, null);
                    this.m_bUseTexture = this.m_bShowTexture;
                }
            }
        }
    }

    protected void drawLineThick(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        PvGeometry.drawLineThick(graphics, n, this.m_xCorner, this.m_yCorner, n2, n3, n4, n5, bl);
    }

    protected static void drawLineThick(Graphics graphics, int n, int[] nArray, int[] nArray2, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = n4 - n2;
        int n7 = n3 - n5;
        float f = (float)Math.sqrt(n6 * n6 + n7 * n7);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        float f2 = (float)n / 2.0f * (float)n7 / f;
        float f3 = (float)n / 2.0f * (float)(-n6) / f;
        nArray[0] = (int)((float)n2 + f2);
        nArray[1] = (int)((float)n4 + f2);
        nArray[2] = (int)((float)n4 - f2);
        nArray[3] = (int)((float)n2 - f2);
        nArray2[0] = (int)((float)n3 - f3);
        nArray2[1] = (int)((float)n5 - f3);
        nArray2[2] = (int)((float)n5 + f3);
        nArray2[3] = (int)((float)n3 + f3);
        graphics.fillPolygon(nArray, nArray2, 4);
        if (bl) {
            int n8 = n / 2;
            graphics.fillOval(n2 - n8, n3 - n8, n - PS_ZOOM, n - PS_ZOOM);
            graphics.fillOval(n4 - n8, n5 - n8, n - PS_ZOOM, n - PS_ZOOM);
        }
    }

    protected static boolean getParallelCurve(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n, double d, boolean bl, boolean bl2) {
        double d2;
        double d3;
        int n2;
        int n3 = n - 1;
        if (bl) {
            ++n3;
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n];
        for (n2 = 0; n2 < n3; ++n2) {
            double d4;
            d3 = nArray3[(n2 + 1) % n] - nArray3[n2];
            d2 = nArray4[n2] - nArray4[(n2 + 1) % n];
            if (Math.abs(d3) + Math.abs(d2) < Math.abs(d)) {
                return false;
            }
            if (nArray3[(n2 + 1) % n] == nArray3[n2]) {
                d4 = d2 > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
            } else {
                d4 = Math.atan(d2 / d3);
                if (nArray3[(n2 + 1) % n] < nArray3[n2]) {
                    d4 = d2 > 0.0 ? (d4 += Math.PI) : (d4 -= Math.PI);
                }
            }
            dArray[n2] = d4 >= 0.0 ? d4 : Math.PI * 2 + d4;
        }
        d3 = 0.2;
        if (bl && n > 2) {
            for (n2 = 0; n2 < n; ++n2) {
                dArray2[n2] = (dArray[(n2 - 1 + n) % n] + dArray[n2] - Math.PI) / 2.0;
                d2 = Math.abs(dArray[(n2 - 1 + n) % n] - dArray[n2]);
                if (d2 < d3 || Math.abs(d2 - Math.PI) < d3 || Math.abs(d2 - Math.PI * 2) < d3 || Math.abs(d2 - Math.PI * 3) < d3) {
                    return false;
                }
                if (!(Math.abs(d2) >= Math.PI)) continue;
                int n4 = n2;
                dArray2[n4] = dArray2[n4] + Math.PI;
            }
        } else {
            for (n2 = 1; n2 < n - 1; ++n2) {
                dArray2[n2] = (dArray[n2 - 1] + dArray[n2] - Math.PI) / 2.0;
                d2 = Math.abs(dArray[n2 - 1] - dArray[n2]);
                if (d2 < d3 || Math.abs(d2 - Math.PI) < d3 || Math.abs(d2 - Math.PI * 2) < d3 || Math.abs(d2 - Math.PI * 3) < d3) {
                    return false;
                }
                if (!(d2 >= Math.PI)) continue;
                int n5 = n2;
                dArray2[n5] = dArray2[n5] + Math.PI;
            }
            dArray2[0] = dArray[0] - 1.5707963267948966;
            dArray2[n - 1] = dArray[n - 1] - 1.5707963267948966;
        }
        for (n2 = 0; n2 < n; ++n2) {
            d2 = Math.sin(dArray2[n2]);
            double d5 = Math.cos(dArray2[n2]);
            double d6 = d;
            double d7 = (dArray[(n2 - 1 + n) % n] - dArray[n2]) / 2.0;
            double d8 = Math.sin(d7 = Math.min(1.5707963267948966 - d7, 1.5707963267948966 + d7));
            if (Math.abs(d8) > 0.2) {
                d6 /= Math.abs(d8);
            }
            if (bl2) {
                nArray[n2] = (int)((double)nArray3[n2] - d6 * d5);
                nArray2[n2] = (int)((double)nArray4[n2] + d6 * d2);
                continue;
            }
            nArray[n2] = (int)((double)nArray3[n2] + d6 * d5);
            nArray2[n2] = (int)((double)nArray4[n2] - d6 * d2);
        }
        return true;
    }
}

