/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.object.PsDebug;
import jv.vecmath.PiVector;

public class PuMath {
    public static final double EPS = 1.0E-10;
    public static final double GOLD = 1.618033988749895;

    public static int sign(double d) {
        if (d < 0.0) {
            return -1;
        }
        if (d > 0.0) {
            return 1;
        }
        return 0;
    }

    public static double sign(double d, double d2) {
        if (d2 > 0.0) {
            return Math.abs(d);
        }
        return -Math.abs(d);
    }

    public static double log(double d, double d2) {
        if (d < 1.0000000001) {
            return 0.0;
        }
        return Math.log(d2) / Math.log(d);
    }

    public static double exp(double d, double d2) {
        if (d < 1.0E-10) {
            return 0.0;
        }
        return Math.exp(d2 * Math.log(d));
    }

    public static double sqr(double d) {
        return d * d;
    }

    public static double sinh(double d) {
        return (Math.exp(d) - Math.exp(-d)) / 2.0;
    }

    public static double cosh(double d) {
        return (Math.exp(d) + Math.exp(-d)) / 2.0;
    }

    public static double tanh(double d) {
        double d2 = Math.exp(d);
        double d3 = Math.exp(-d);
        return (d2 - d3) / (d2 + d3);
    }

    public static double coth(double d) {
        double d2 = Math.exp(d);
        double d3 = Math.exp(-d);
        return (d2 + d3) / (d2 - d3);
    }

    public static double asinh(double d) {
        return Math.log(d + Math.sqrt(d * d + 1.0));
    }

    public static double acosh(double d) {
        return d > 1.0 ? Math.log(d + Math.sqrt(d * d - 1.0)) : 0.0;
    }

    public static double atanh(double d) {
        return Math.log((1.0 + d) / (1.0 - d)) / 2.0;
    }

    public static double acoth(double d) {
        return Math.log((1.0 + d) / (d - 1.0)) / 2.0;
    }

    public static double area(double d, double d2, double d3) {
        double d4 = (d + d2 + d3) / 2.0;
        double d5 = d4 * (d4 - d) * (d4 - d2) * (d4 - d3);
        if (d5 < 0.0) {
            return 0.0;
        }
        return Math.sqrt(d5);
    }

    public static double angle(double d, double d2, double d3) {
        double d4 = 2.0 * d2 * d3;
        if (d4 <= 0.0) {
            return 0.0;
        }
        return Math.acos((d2 * d2 + d3 * d3 - d * d) / d4);
    }

    public static boolean angle(double[] dArray, double d, double d2, double d3) {
        if (dArray == null || dArray.length < 3) {
            return false;
        }
        dArray[0] = PuMath.angle(d, d2, d3);
        dArray[1] = PuMath.angle(d2, d3, d);
        dArray[2] = PuMath.angle(d3, d2, d);
        return true;
    }

    public static double ctg(double d, double d2, double d3) {
        double d4 = (d + d2 + d3) / 2.0;
        double d5 = d4 * (d4 - d);
        double d6 = (d4 - d2) * (d4 - d3);
        double d7 = 2.0 * Math.sqrt(d5 * d6);
        d7 = d7 < 1.0E-10 ? 0.0 : (d5 - d6) / d7;
        return d7;
    }

    public static void ctg(double[] dArray, double d, double d2, double d3) {
        double d4 = (d + d2 + d3) / 2.0;
        double d5 = 2.0 * Math.sqrt(d4 * (d4 - d) * (d4 - d2) * (d4 - d3));
        if (d5 < 1.0E-10) {
            dArray[2] = 0.0;
            dArray[1] = 0.0;
            dArray[0] = 0.0;
            return;
        }
        dArray[0] = (d4 * (d4 - d) - (d4 - d2) * (d4 - d3)) / d5;
        dArray[1] = (d4 * (d4 - d2) - (d4 - d) * (d4 - d3)) / d5;
        dArray[2] = (d4 * (d4 - d3) - (d4 - d2) * (d4 - d)) / d5;
    }

    public static void projectOnto(double[] dArray, double[] dArray2) {
        double d = PuMath.dot(dArray, dArray2);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d * dArray2[i];
        }
    }

    public static double dot(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static double sqrDist(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i] - dArray2[i];
            d += d2 * d2;
        }
        return d;
    }

    public static double dist(double[] dArray, double[] dArray2) {
        return Math.sqrt(PuMath.sqrDist(dArray, dArray2));
    }

    public static int factorial(int n) {
        int n2 = 33;
        if (n <= 1) {
            return 1;
        }
        if (n >= n2) {
            PsDebug.warning("factorial: argument too big");
            return Integer.MAX_VALUE;
        }
        int n3 = 1;
        for (int i = 2; i < n; ++i) {
            n3 *= i;
        }
        return n3;
    }

    public static double binom(int n, int n2) {
        double d = 1.0;
        int n3 = n2;
        for (int i = n; i > n - n2; --i) {
            d *= (double)i;
            if (n3 <= 1) continue;
            d /= (double)n3;
            --n3;
        }
        return d;
    }

    public static double toRadians(double d) {
        return d / 180.0 * Math.PI;
    }

    public static double toDegrees(double d) {
        return d * 180.0 / Math.PI;
    }

    public static int gcd(int n, int n2) {
        int n3;
        if (n > n2) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        while (n > 0) {
            n3 = n2 % n;
            n2 = n;
            n = n3;
        }
        return n2;
    }

    public static int gcd(PiVector piVector) {
        if (piVector == null || piVector.getSize() == 0) {
            return 1;
        }
        int n = piVector.getSize();
        int n2 = Math.abs(piVector.m_data[0]);
        for (int i = 1; i < n; ++i) {
            if (piVector.m_data[i] % n2 == 0) continue;
            n2 = PuMath.gcd(n2, Math.abs(piVector.m_data[i]));
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        int n;
        double[] dArray = new double[]{2.0, -1.0, 7.0, 6.0, 5.0, 4.0, 10.0, 11.0, 12.0, 13.0, -4.0};
        int n2 = dArray.length;
        int[] nArray = new int[n2];
        System.out.print("orig: ");
        for (n = 0; n < n2 - 1; ++n) {
            System.out.print(dArray[n] + ", ");
        }
        System.out.println(dArray[n2 - 1] + "##");
        PuMath.heapsort(n2, dArray, nArray);
        System.out.print("indx: ");
        for (n = 0; n < n2 - 1; ++n) {
            System.out.print(dArray[nArray[n]] + ", ");
        }
        System.out.println(dArray[nArray[n2 - 1]] + "##");
        System.out.flush();
    }

    public static final void heapsort(int n, double[] dArray, int[] nArray) {
        int n2;
        if (n <= 0) {
            return;
        }
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = n2;
        }
        int n3 = n / 2 + 1;
        int n4 = n - 1;
        while (true) {
            double d;
            int n5;
            if (n3 > 1) {
                n5 = nArray[--n3 - 1];
                d = dArray[n5];
            } else {
                n5 = nArray[n4];
                d = dArray[n5];
                nArray[n4] = nArray[0];
                if (--n4 <= 0) {
                    nArray[0] = n5;
                    return;
                }
            }
            int n6 = n3 - 1;
            n2 = n3 << 1;
            while (n2 <= n4 + 1) {
                if (n2 < n4 + 1 && dArray[nArray[n2 - 1]] < dArray[nArray[n2]]) {
                    ++n2;
                }
                if (d < dArray[nArray[n2 - 1]]) {
                    nArray[n6] = nArray[n2 - 1];
                    n6 = n2 - 1;
                    n2 += n2;
                    continue;
                }
                n2 = n4 + 2;
            }
            nArray[n6] = n5;
        }
    }

    public static final void heapsort(int n, int[] nArray, int[] nArray2) {
        int n2;
        if (n <= 0) {
            return;
        }
        for (n2 = 0; n2 < n; ++n2) {
            nArray2[n2] = n2;
        }
        int n3 = n / 2 + 1;
        int n4 = n - 1;
        while (true) {
            int n5;
            int n6;
            if (n3 > 1) {
                n6 = nArray2[--n3 - 1];
                n5 = nArray[n6];
            } else {
                n6 = nArray2[n4];
                n5 = nArray[n6];
                nArray2[n4] = nArray2[0];
                if (--n4 <= 0) {
                    nArray2[0] = n6;
                    return;
                }
            }
            int n7 = n3 - 1;
            n2 = n3 << 1;
            while (n2 <= n4 + 1) {
                if (n2 < n4 + 1 && nArray[nArray2[n2 - 1]] < nArray[nArray2[n2]]) {
                    ++n2;
                }
                if (n5 < nArray[nArray2[n2 - 1]]) {
                    nArray2[n7] = nArray2[n2 - 1];
                    n7 = n2 - 1;
                    n2 += n2;
                    continue;
                }
                n2 = n4 + 2;
            }
            nArray2[n7] = n6;
        }
    }

    public static double precision(double d, double d2) {
        d /= d2;
        d = Math.round(d);
        return d *= d2;
    }

    public static int modulo(int n, int n2) {
        if (n >= 0) {
            return n % n2;
        }
        return (n2 - -n % n2) % n2;
    }

    public static int lcm(int n, int n2) {
        return Math.abs(n * n2) / PuMath.gcd(n, n2);
    }
}

