/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.object.PsDebug;
import jv.vecmath.P_Vector;
import jv.vecmath.PuData;

public class PbVector
extends P_Vector
implements Cloneable {
    public boolean[] m_data;

    public Object clone() {
        PbVector pbVector = null;
        pbVector = (PbVector)super.clone();
        if (pbVector == null) {
            return null;
        }
        if (this.m_data != null) {
            pbVector.m_data = (boolean[])this.m_data.clone();
        }
        return pbVector;
    }

    public static boolean[][] getEntries(PbVector[] pbVectorArray) {
        if (pbVectorArray == null) {
            return null;
        }
        int n = pbVectorArray.length;
        boolean[][] blArrayArray = new boolean[n][];
        for (int i = 0; i < n; ++i) {
            blArrayArray[i] = pbVectorArray[i].getEntries();
        }
        return blArrayArray;
    }

    public static PbVector[][] alloc(int n, int n2, int n3) {
        PbVector[][] pbVectorArray = new PbVector[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                pbVectorArray[i][j] = new PbVector(n3);
            }
        }
        return pbVectorArray;
    }

    public static PbVector[] realloc(PbVector[] pbVectorArray, int n, int n2) {
        int n3;
        int n4;
        if (pbVectorArray != null && pbVectorArray.length == n) {
            for (int i = 0; i < pbVectorArray.length; ++i) {
                if (pbVectorArray[i] == null) {
                    pbVectorArray[i] = new PbVector(n2);
                    continue;
                }
                if (pbVectorArray[i].m_data != null && pbVectorArray[i].m_data.length == n2) continue;
                pbVectorArray[i].setSize(n2);
            }
            return pbVectorArray;
        }
        PbVector[] pbVectorArray2 = new PbVector[n];
        if (pbVectorArray == null) {
            n4 = 0;
        } else {
            n4 = Math.min(pbVectorArray.length, n);
            System.arraycopy(pbVectorArray, 0, pbVectorArray2, 0, n4);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (pbVectorArray2[n3] == null) {
                pbVectorArray2[n3] = new PbVector(n2);
                continue;
            }
            if (pbVectorArray2[n3].m_data != null && pbVectorArray2[n3].m_data.length == n2) continue;
            pbVectorArray2[n3].setSize(n2);
        }
        for (n3 = n4; n3 < n; ++n3) {
            pbVectorArray2[n3] = new PbVector(n2);
        }
        return pbVectorArray2;
    }

    public static PbVector[] realloc(PbVector[] pbVectorArray, int n) {
        int n2;
        int n3;
        if (pbVectorArray != null && pbVectorArray.length == n) {
            for (int i = 0; i < pbVectorArray.length; ++i) {
                if (pbVectorArray[i] != null) continue;
                pbVectorArray[i] = new PbVector();
            }
            return pbVectorArray;
        }
        PbVector[] pbVectorArray2 = new PbVector[n];
        if (pbVectorArray == null) {
            n3 = 0;
        } else {
            n3 = Math.min(pbVectorArray.length, n);
            System.arraycopy(pbVectorArray, 0, pbVectorArray2, 0, n3);
            for (n2 = 0; n2 < n3; ++n2) {
                if (pbVectorArray2[n2] != null) continue;
                pbVectorArray2[n2] = new PbVector();
            }
        }
        for (n2 = n3; n2 < n; ++n2) {
            pbVectorArray2[n2] = new PbVector();
        }
        return pbVectorArray2;
    }

    public static PbVector[] copyNew(boolean[][] blArray) {
        if (blArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        int n = blArray.length;
        PbVector[] pbVectorArray = new PbVector[n];
        for (int i = 0; i < n; ++i) {
            pbVectorArray[i] = new PbVector(blArray[i]);
        }
        return pbVectorArray;
    }

    public static PbVector[] copyNew(PbVector[] pbVectorArray) {
        if (pbVectorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        return PbVector.copyNew(pbVectorArray, pbVectorArray.length);
    }

    public static PbVector[] copyNew(PbVector[] pbVectorArray, int n) {
        if (pbVectorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PbVector[] pbVectorArray2 = new PbVector[n];
        for (int i = 0; i < n; ++i) {
            pbVectorArray2[i] = PbVector.copyNew(pbVectorArray[i]);
        }
        return pbVectorArray2;
    }

    public static boolean copy(PbVector[] pbVectorArray, int n, PbVector[] pbVectorArray2, int n2, int n3) {
        if (n3 == 0) {
            return true;
        }
        if (pbVectorArray == null || pbVectorArray.length < n + n3) {
            PsDebug.warning("missing space in dataDest", pbVectorArray);
            return false;
        }
        if (pbVectorArray2 == null || pbVectorArray2.length < n2 + n3) {
            PsDebug.warning("missing space in dataSrc", pbVectorArray2);
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            pbVectorArray[n + i].copy(pbVectorArray2[n2 + i]);
        }
        return true;
    }

    public static int getSameSize(PbVector[] pbVectorArray, int n) {
        if (pbVectorArray == null || pbVectorArray.length == 0) {
            return -1;
        }
        if (pbVectorArray[0] == null) {
            return -1;
        }
        if (pbVectorArray.length < n) {
            PsDebug.warning("used vectors larger than array size.");
            n = pbVectorArray.length;
        }
        int n2 = pbVectorArray[0].getSize();
        for (int i = 1; i < n; ++i) {
            if (n2 == pbVectorArray[i].getSize()) continue;
            n2 = -1;
            break;
        }
        return n2;
    }

    public static void setConstant(PbVector[] pbVectorArray, boolean bl) {
        if (pbVectorArray == null || pbVectorArray.length == 0 || pbVectorArray[0] == null) {
            return;
        }
        for (int i = 0; i < pbVectorArray.length; ++i) {
            pbVectorArray[i].setConstant(bl);
        }
    }

    public static void setConstant(PbVector[] pbVectorArray, boolean[] blArray) {
        if (pbVectorArray == null || pbVectorArray.length == 0 || pbVectorArray[0] == null) {
            return;
        }
        int n = pbVectorArray[0].m_data.length;
        if (n != blArray.length) {
            PsDebug.warning("arrays have different length");
            return;
        }
        for (int i = 0; i < pbVectorArray.length; ++i) {
            System.arraycopy(blArray, 0, pbVectorArray[i].m_data, 0, n);
        }
    }

    public static void setConstant(PbVector[] pbVectorArray, PbVector pbVector) {
        if (pbVector == null || pbVector.m_data == null) {
            return;
        }
        PbVector.setConstant(pbVectorArray, pbVector.m_data);
    }

    public static void setConstant(PbVector pbVector, boolean bl) {
        if (pbVector == null || pbVector.m_data == null) {
            return;
        }
        for (int i = pbVector.getSize() - 1; i >= 0; --i) {
            pbVector.m_data[i] = bl;
        }
    }

    public static void setConstant(boolean[] blArray, boolean bl) {
        if (blArray == null) {
            return;
        }
        for (int i = blArray.length - 1; i >= 0; --i) {
            blArray[i] = bl;
        }
    }

    public void setConstant(boolean bl) {
        if (this.m_data == null || this.m_data.length == 0) {
            return;
        }
        for (int i = this.m_data.length - 1; i >= 0; --i) {
            this.m_data[i] = bl;
        }
    }

    public PbVector() {
        this(0);
    }

    public PbVector(int n) {
        this.m_data = new boolean[n];
    }

    public PbVector(boolean bl) {
        this(1);
        this.m_data[0] = bl;
    }

    public PbVector(boolean bl, boolean bl2) {
        this(2);
        this.m_data[0] = bl;
        this.m_data[1] = bl2;
    }

    public PbVector(boolean bl, boolean bl2, boolean bl3) {
        this(3);
        this.m_data[0] = bl;
        this.m_data[1] = bl2;
        this.m_data[2] = bl3;
    }

    public PbVector(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(4);
        this.m_data[0] = bl;
        this.m_data[1] = bl2;
        this.m_data[2] = bl3;
        this.m_data[3] = bl4;
    }

    public PbVector(boolean[] blArray) {
        this();
        this.set(blArray);
    }

    public int getSize() {
        if (this.m_data == null) {
            return 0;
        }
        return this.m_data.length;
    }

    public int setSize(int n) {
        if (this.m_data == null) {
            this.m_data = new boolean[n];
        } else if (this.m_data.length != n) {
            this.m_data = PuData.realloc(this.m_data, n);
        }
        return n;
    }

    public boolean[] getEntries() {
        return (boolean[])this.m_data.clone();
    }

    public boolean getEntry(int n) {
        if (n < 0 || this.m_data.length <= n) {
            PsDebug.warning("index out of range, index=" + n);
            return false;
        }
        return this.m_data[n];
    }

    public void setEntry(int n, boolean bl) {
        if (n < 0) {
            PsDebug.warning("index out of range, index=" + n);
            return;
        }
        if (this.m_data.length <= n) {
            this.setSize(n + 1);
        }
        this.m_data[n] = bl;
    }

    public boolean getFirstEntry() {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return false;
        }
        return this.m_data[0];
    }

    public void setFirstEntry(boolean bl) {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return;
        }
        this.m_data[0] = bl;
    }

    public boolean getLastEntry() {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return false;
        }
        return this.m_data[this.m_data.length - 1];
    }

    public void setLastEntry(boolean bl) {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return;
        }
        this.m_data[this.m_data.length - 1] = bl;
    }

    public int addEntry(boolean bl) {
        int n = this.setSize(this.getSize() + 1);
        this.m_data[n - 1] = bl;
        return n;
    }

    public void set(PbVector pbVector, int n, int n2) {
        if (pbVector == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (pbVector.getSize() < n + n2) {
            PsDebug.warning("argument array too small.");
            return;
        }
        if (this.m_data == null || this.m_data.length != n2) {
            this.setSize(n2);
        }
        System.arraycopy(pbVector.m_data, n, this.m_data, 0, n2);
    }

    public void set(boolean[] blArray, int n, int n2) {
        if (blArray == null || blArray.length < n + n2) {
            PsDebug.warning("argument array too small.");
            return;
        }
        if (this.m_data == null || this.m_data.length != n2) {
            this.setSize(n2);
        }
        System.arraycopy(blArray, n, this.m_data, 0, n2);
    }

    public void set(boolean[] blArray, int n) {
        this.set(blArray, 0, n);
    }

    public void set(boolean[] blArray) {
        if (blArray == null) {
            PsDebug.warning("missing argument array.");
            return;
        }
        this.set(blArray, 0, blArray.length);
    }

    public void set(boolean bl) {
        if (this.m_data == null || this.m_data.length < 1) {
            this.setSize(1);
        }
        this.m_data[0] = bl;
    }

    public void set(boolean bl, boolean bl2) {
        if (this.m_data == null || this.m_data.length < 2) {
            this.setSize(2);
        }
        this.m_data[0] = bl;
        this.m_data[1] = bl2;
    }

    public void set(boolean bl, boolean bl2, boolean bl3) {
        if (this.m_data == null || this.m_data.length < 3) {
            this.setSize(3);
        }
        this.m_data[0] = bl;
        this.m_data[1] = bl2;
        this.m_data[2] = bl3;
    }

    public void set(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (this.m_data == null || this.m_data.length < 4) {
            this.setSize(4);
        }
        this.m_data[0] = bl;
        this.m_data[1] = bl2;
        this.m_data[2] = bl3;
        this.m_data[3] = bl4;
    }

    public void invert(int n) {
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            boolean bl = this.m_data[i];
            this.m_data[i] = this.m_data[n - 1 - i];
            this.m_data[n - 1 - i] = bl;
        }
    }

    public void invert() {
        int n = this.m_data.length / 2;
        for (int i = 0; i < n; ++i) {
            boolean bl = this.m_data[i];
            this.m_data[i] = this.m_data[this.m_data.length - 1 - i];
            this.m_data[this.m_data.length - 1 - i] = bl;
        }
    }

    public void invertEntries() {
        for (int i = 0; i < this.m_data.length; ++i) {
            this.m_data[i] = !this.m_data[i];
        }
    }

    public void and(PbVector pbVector) {
        if (this.m_data == null) {
            this.setSize(pbVector.m_data.length);
        }
        if (this.m_data.length != pbVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            int n = i;
            this.m_data[n] = this.m_data[n] & pbVector.m_data[i];
        }
    }

    public void or(PbVector pbVector) {
        if (this.m_data == null) {
            this.setSize(pbVector.m_data.length);
        }
        if (this.m_data.length != pbVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            int n = i;
            this.m_data[n] = this.m_data[n] | pbVector.m_data[i];
        }
    }

    public void xor(PbVector pbVector) {
        if (this.m_data == null) {
            this.setSize(pbVector.m_data.length);
        }
        if (this.m_data.length != pbVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            int n = i;
            this.m_data[n] = this.m_data[n] ^ pbVector.m_data[i];
        }
    }

    public int countValue(boolean bl) {
        if (this.m_data == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.m_data.length; ++i) {
            if (this.m_data[i] != bl) continue;
            ++n;
        }
        return n;
    }

    public static PbVector copyNew(PbVector pbVector) {
        if (pbVector == null) {
            return null;
        }
        if (pbVector.m_data == null) {
            PsDebug.warning("missing data of argument vector.");
            return null;
        }
        PbVector pbVector2 = new PbVector(pbVector.m_data.length);
        pbVector2.copy(pbVector);
        return pbVector2;
    }

    public boolean copy(int n, PbVector pbVector, int n2, int n3) {
        if (this.m_data.length < n + n3) {
            PsDebug.warning("missing space in this");
            return false;
        }
        if (this.m_data == null || this.m_data.length < n + n3) {
            this.setSize(n + n3);
        }
        System.arraycopy(pbVector.m_data, n2, this.m_data, n, n3);
        return true;
    }

    public void copy(PbVector pbVector) {
        if (pbVector == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (pbVector.m_data == null) {
            PsDebug.warning("missing data of argument vector");
            return;
        }
        this.copyArray(pbVector);
        super.copy(pbVector);
    }

    public void copyArray(PbVector pbVector) {
        if (pbVector == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (pbVector.m_data == null) {
            PsDebug.warning("missing data of argument vector");
            return;
        }
        int n = pbVector.m_data.length;
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(n);
        }
        if (this.m_data.length > n) {
            for (int i = n; i < this.m_data.length; ++i) {
                this.m_data[i] = false;
            }
        } else {
            n = this.m_data.length;
        }
        switch (n) {
            case 3: {
                if (this.m_data[2] != pbVector.m_data[2]) {
                    this.m_data[2] = pbVector.m_data[2];
                }
            }
            case 2: {
                if (this.m_data[1] != pbVector.m_data[1]) {
                    this.m_data[1] = pbVector.m_data[1];
                }
            }
            case 1: {
                if (this.m_data[0] == pbVector.m_data[0]) break;
                this.m_data[0] = pbVector.m_data[0];
                break;
            }
            default: {
                System.arraycopy(pbVector.m_data, 0, this.m_data, 0, n);
            }
        }
    }

    public void copy(boolean[] blArray, int n) {
        if (blArray == null) {
            PsDebug.warning("null vector 'anArray' passed");
            return;
        }
        int n2 = n;
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(n2);
        }
        if (this.m_data.length > n2) {
            for (int i = n2; i < this.m_data.length; ++i) {
                this.m_data[i] = false;
            }
        } else {
            n2 = this.m_data.length;
        }
        switch (n2) {
            case 3: {
                this.m_data[2] = blArray[2];
            }
            case 2: {
                this.m_data[1] = blArray[1];
            }
            case 1: {
                this.m_data[0] = blArray[0];
                break;
            }
            default: {
                System.arraycopy(blArray, 0, this.m_data, 0, n2);
            }
        }
    }

    public void copy(boolean[] blArray, int n, int n2) {
        if (blArray == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (blArray.length < n + n2) {
            PsDebug.warning("ind+size is bigger than array");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(n2);
        }
        int n3 = Math.min(this.m_data.length, n2);
        System.arraycopy(blArray, n, this.m_data, 0, n3);
        for (int i = n3; i < this.m_data.length; ++i) {
            this.m_data[i] = false;
        }
    }

    public int countTrueEntries() {
        int n = 0;
        for (int i = 0; i < this.m_data.length; ++i) {
            if (!this.m_data[i]) continue;
            ++n;
        }
        return n;
    }

    public static PbVector blendNew(double d, PbVector pbVector, double d2, PbVector pbVector2) {
        if (pbVector == null || pbVector2 == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PbVector pbVector3 = new PbVector(pbVector.getSize());
        pbVector3.blend(d, pbVector, d2, pbVector2);
        return pbVector3;
    }

    public void blend(double d, PbVector pbVector, double d2, PbVector pbVector2) {
        if (pbVector == null || pbVector2 == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this.m_data.length != pbVector.m_data.length || this.m_data.length != pbVector2.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        if (this.m_data == null) {
            this.setSize(pbVector.m_data.length);
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            this.m_data[i] = d >= d2 ? pbVector.m_data[i] : pbVector2.m_data[i];
        }
    }

    public int indexOf(boolean bl) {
        for (int i = 0; i < this.m_data.length; ++i) {
            if (this.m_data[i] != bl) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(boolean[] blArray) {
        int n = this.getSize();
        if (blArray == null) {
            return n == 0;
        }
        if (n != blArray.length) {
            return false;
        }
        --n;
        while (n >= 0) {
            if (this.m_data[n] != blArray[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof PbVector) {
            return this.equals((PbVector)object);
        }
        if (object instanceof boolean[]) {
            return this.equals((boolean[])object);
        }
        return super.equals(object);
    }

    public boolean equals(PbVector pbVector) {
        if (pbVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        return this.equals(pbVector.m_data);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PbVector ***********\n");
        int n = this.getSize();
        stringBuffer.append("\t size\t = " + n + "\n");
        if (n > 0) {
            stringBuffer.append("\t m_data = (" + String.valueOf(this.m_data[0]));
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(", " + String.valueOf(this.m_data[i]));
            }
            stringBuffer.append(")\n");
        } else if (this.m_data != null) {
            stringBuffer.append("\t m_data = {}\n");
        } else {
            stringBuffer.append("\t m_data = null\n");
        }
        return stringBuffer.toString();
    }

    public String toShortString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = this.getSize();
        if (n > 0) {
            stringBuffer.append("\t {" + String.valueOf(this.m_data[0]));
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(", " + String.valueOf(this.m_data[i]));
            }
            stringBuffer.append("},");
        } else if (this.m_data != null) {
            stringBuffer.append("\t m_data = {},");
        } else {
            stringBuffer.append("\t m_data = null,");
        }
        stringBuffer.append("\t Attr = (" + this.getBits() + ")\n");
        return stringBuffer.toString();
    }
}

