/*
 * Decompiled with CFR 0.152.
 */
package jv.project;

import java.awt.Point;
import java.io.Serializable;
import jv.project.PvCameraIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;

public final class PvCameraEvent
implements Serializable {
    protected PvDisplayIf m_display;
    protected PvCameraIf m_camera;
    protected Point m_location;
    protected int m_dim;
    protected PdVector m_vertex;

    public PvCameraEvent(PvDisplayIf pvDisplayIf, int n) {
        this.m_display = pvDisplayIf;
        this.m_dim = n;
        this.m_location = new Point();
        this.m_vertex = new PdVector(n);
    }

    public PvDisplayIf getSource() {
        return this.m_display;
    }

    public int getDimOfVertex() {
        return this.m_dim;
    }

    public Point getLocation() {
        return this.m_location;
    }

    public void setLocation(Point point) {
        this.m_location.setLocation(point);
    }

    public PdVector getVertex() {
        return this.m_vertex;
    }

    public void setVertex(PdVector pdVector) {
        this.m_vertex.copy(pdVector);
    }

    public void setCamera(PvCameraIf pvCameraIf) {
        this.m_camera = pvCameraIf;
    }

    public int getProjectionMode() {
        return this.m_camera.getProjectionMode();
    }

    public double getScale() {
        return this.m_camera.getScale();
    }

    public double getRoll() {
        return this.m_camera.getRoll();
    }

    public PdVector getInterest() {
        return this.m_camera.getInterest();
    }

    public PdVector getPosition() {
        return this.m_camera.getPosition();
    }

    public PdVector getViewDir() {
        return this.m_camera.getViewDir();
    }

    public PdVector getUpVector() {
        return this.m_camera.getUpVector();
    }
}

