/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;

public final class PsUtil {
    static /* synthetic */ Class class$java$lang$Object;

    public static Object newInstance(Class clazz, String string) {
        if (clazz == null || string == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        Class clazz2 = clazz;
        String string2 = null;
        Object object = null;
        try {
            do {
                if ((object = PsUtil.newInstance(string2 = clazz2.getName() + string)) == null) continue;
                return object;
            } while ((clazz2 = clazz2.getSuperclass()) != null && clazz2 != (class$java$lang$Object == null ? PsUtil.class$("java.lang.Object") : class$java$lang$Object));
            return null;
        }
        catch (SecurityException securityException) {
            PsDebug.warning("failed with security exception, className = " + string2 + "\n\t SecurityExceptionEx = " + securityException.toString() + ", Message = " + securityException.getMessage());
            return null;
        }
    }

    public static Object newInstance(String string) {
        if (string == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            PsDebug.notify("Class not found: " + string + "\n\tException = " + classNotFoundException.toString() + ", Message = " + classNotFoundException.getMessage());
            return null;
        }
        catch (SecurityException securityException) {
            PsDebug.warning("failed with security exception, className = " + string + "\n\tSecurityException = " + securityException.toString() + ", Message = " + securityException.getMessage());
            return null;
        }
        catch (Exception exception) {
            PsDebug.warning("failed with exception, className = " + string + "\n\tException = " + exception.toString() + ", Message = " + exception.getMessage());
            return null;
        }
        try {
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            PsDebug.error("failed to create instance, className = " + string + "\n\tNoSuchMethodError = " + noSuchMethodError.toString() + ", Message = " + noSuchMethodError.getMessage());
            return null;
        }
        catch (InstantiationException instantiationException) {
            PsDebug.warning("failed to create instance, className = " + string + "\n\tInstantiationException = " + instantiationException.toString() + ", Message = " + instantiationException.getMessage());
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            PsDebug.warning("failed with access exception, className = " + string + "\n\tIllegalAccessException = " + illegalAccessException.toString() + ", Message = " + illegalAccessException.getMessage());
            return null;
        }
        catch (SecurityException securityException) {
            PsDebug.warning("failed with security exception, className = " + string + "\n\tSecurityException = " + securityException.toString() + ", Message = " + securityException.getMessage());
            return null;
        }
        catch (Exception exception) {
            PsDebug.warning("failed with exception, className = " + string + "\n\tException = " + exception.toString() + ", Message = " + exception.getMessage());
            return null;
        }
    }

    public static BufferedReader open(String string) {
        if (string == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        PsDebug.notify("file " + string);
        BufferedReader bufferedReader = string.startsWith("http:") || string.startsWith("https:") || string.startsWith("ftp:") || string.startsWith("file:") ? PsUtil.openURL(string) : PsUtil.openFile(string);
        if (bufferedReader == null) {
            if (!PsConfig.isApplication()) {
                PsDebug.warning("relative url encountered, try with codebase.");
                bufferedReader = PsUtil.openURL(PsConfig.getCodeBase() + string);
            } else {
                String string2 = PsConfig.getInstBase();
                if (PuString.isEmpty(string2)) {
                    string2 = PsConfig.getCodeBase();
                }
                bufferedReader = PsUtil.openFile(string2 + string);
            }
        }
        if (bufferedReader == null) {
            PsDebug.warning("failed to open file = " + string);
            return null;
        }
        PsDebug.showStatus("file found = " + string);
        try {
            for (int i = 0; i < 100 && !bufferedReader.ready(); ++i) {
                Thread.sleep(100L);
            }
            if (!bufferedReader.ready()) {
                PsDebug.warning("input reader not ready after 100 tries");
                return null;
            }
        }
        catch (Exception exception) {
            PsDebug.warning("exception = " + exception.toString());
            PsDebug.message("failed reading from reader.", false);
            return null;
        }
        return bufferedReader;
    }

    public static BufferedReader openFile(String string) {
        if (string == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        PsDebug.notify("opening file = " + string + " .......");
        try {
            Closeable closeable;
            File file = new File(string);
            Closeable closeable2 = new FileInputStream(file);
            if (string.endsWith(".gz")) {
                closeable2 = new GZIPInputStream((InputStream)closeable2);
            } else if (string.endsWith(".zip")) {
                closeable = new ZipInputStream((InputStream)closeable2);
                closeable.getNextEntry();
                closeable2 = closeable;
            }
            closeable = new BufferedReader(new InputStreamReader((InputStream)closeable2));
            PsDebug.notify("... succeeded");
            return closeable;
        }
        catch (FileNotFoundException fileNotFoundException) {
            PsDebug.warning("file " + string + " not found, FileNotFoundException\n\texception.getMessage() = " + fileNotFoundException.getMessage() + "\n\texception.toString()   = " + fileNotFoundException.toString());
            PsDebug.error("... failed, file = ", string);
            return null;
        }
        catch (IOException iOException) {
            PsDebug.warning("file " + string + " not found, FileNotFoundException\n\texception.getMessage() = " + iOException.getMessage() + "\n\texception.toString()   = " + iOException.toString());
            PsDebug.error("... failed, file = ", string);
            return null;
        }
        catch (SecurityException securityException) {
            PsDebug.warning("file " + string + " not found, SecurityExceptionexception.getMessage() = " + securityException.getMessage() + "\n\texception.toString()   = " + securityException.toString());
            PsDebug.error("... failed, file = ", string);
            return null;
        }
    }

    public static BufferedReader openURL(String string) {
        if (string == null) {
            PsDebug.warning("missing url");
            return null;
        }
        PsDebug.notify("opening file = " + string + " .......");
        try {
            Closeable closeable;
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            if (string.endsWith(".gz")) {
                inputStream = new GZIPInputStream(inputStream);
            } else if (string.endsWith(".zip")) {
                closeable = new ZipInputStream(inputStream);
                closeable.getNextEntry();
                inputStream = closeable;
            }
            closeable = new BufferedReader(new InputStreamReader(inputStream));
            return closeable;
        }
        catch (MalformedURLException malformedURLException) {
            PsDebug.warning("file " + string + " not found, MalformedURLFoundException\n\texception.getMessage() = " + malformedURLException.getMessage() + "\n\texception.toString()   = " + malformedURLException.toString());
            PsDebug.error("... failed, URL = ", string);
            return null;
        }
        catch (IOException iOException) {
            PsDebug.warning("file " + string + " not found, IOException\n\texception.getMessage() = " + iOException.getMessage() + "\n\texception.toString()   = " + iOException.toString());
            PsDebug.error("... failed, URL = ", string);
            return null;
        }
        catch (SecurityException securityException) {
            PsDebug.warning("file " + string + " not found, SecurityException\n\texception.getMessage() = " + securityException.getMessage() + "\n\texception.toString()   = " + securityException.toString());
            PsDebug.error("... failed, URL = ", string);
            return null;
        }
    }

    public static DataInputStream open_as_DataInputStream(String string) {
        if (string == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        PsDebug.notify("file " + string);
        DataInputStream dataInputStream = string.startsWith("http:") || string.startsWith("https:") || string.startsWith("ftp:") || string.startsWith("file:") ? PsUtil.openURL_as_DataInputStream(string) : PsUtil.openFile_as_DataInputStream(string);
        if (dataInputStream == null && !PsConfig.isApplication()) {
            PsDebug.warning("relative url encountered, try with codebase.");
            dataInputStream = PsUtil.openURL_as_DataInputStream(PsConfig.getCodeBase() + string);
        }
        if (dataInputStream == null) {
            PsDebug.warning("failed to open file = " + string);
            return null;
        }
        return dataInputStream;
    }

    public static DataInputStream openFile_as_DataInputStream(String string) {
        if (string == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        PsDebug.notify("opening file = " + string + " .......");
        try {
            FilterInputStream filterInputStream;
            File file = new File(string);
            InputStream inputStream = new FileInputStream(file);
            if (string.endsWith(".gz")) {
                inputStream = new GZIPInputStream(inputStream);
            } else if (string.endsWith(".zip")) {
                filterInputStream = new ZipInputStream(inputStream);
                ((ZipInputStream)filterInputStream).getNextEntry();
                inputStream = filterInputStream;
            }
            filterInputStream = new DataInputStream(inputStream);
            PsDebug.notify("... succeeded");
            return filterInputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            PsDebug.warning("file " + string + " not found, FileNotFoundException\n\texception.getMessage() = " + fileNotFoundException.getMessage() + "\n\texception.toString()   = " + fileNotFoundException.toString());
            PsDebug.error("... failed, file = ", string);
            return null;
        }
        catch (IOException iOException) {
            PsDebug.warning("file " + string + " not found, FileNotFoundException\n\texception.getMessage() = " + iOException.getMessage() + "\n\texception.toString()   = " + iOException.toString());
            PsDebug.error("... failed, file = ", string);
            return null;
        }
        catch (SecurityException securityException) {
            PsDebug.warning("file " + string + " not found, SecurityExceptionexception.getMessage() = " + securityException.getMessage() + "\n\texception.toString()   = " + securityException.toString());
            PsDebug.error("... failed, file = ", string);
            return null;
        }
    }

    public static DataInputStream openURL_as_DataInputStream(String string) {
        if (string == null) {
            PsDebug.warning("missing url");
            return null;
        }
        PsDebug.notify("opening file = " + string + " .......");
        try {
            FilterInputStream filterInputStream;
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            if (string.endsWith(".gz")) {
                inputStream = new GZIPInputStream(inputStream);
            } else if (string.endsWith(".zip")) {
                filterInputStream = new ZipInputStream(inputStream);
                ((ZipInputStream)filterInputStream).getNextEntry();
                inputStream = filterInputStream;
            }
            filterInputStream = new DataInputStream(inputStream);
            return filterInputStream;
        }
        catch (MalformedURLException malformedURLException) {
            PsDebug.warning("file " + string + " not found, MalformedURLFoundException\n\texception.getMessage() = " + malformedURLException.getMessage() + "\n\texception.toString()   = " + malformedURLException.toString());
            PsDebug.error("... failed, URL = ", string);
            return null;
        }
        catch (IOException iOException) {
            PsDebug.warning("file " + string + " not found, IOException\n\texception.getMessage() = " + iOException.getMessage() + "\n\texception.toString()   = " + iOException.toString());
            PsDebug.error("... failed, URL = ", string);
            return null;
        }
        catch (SecurityException securityException) {
            PsDebug.warning("file " + string + " not found, SecurityException\n\texception.getMessage() = " + securityException.getMessage() + "\n\texception.toString()   = " + securityException.toString());
            PsDebug.error("... failed, URL = ", string);
            return null;
        }
    }

    public static PrintWriter writeFile(String string) {
        if (string == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        PsDebug.notify("opening file = " + string + " .......");
        try {
            Closeable closeable;
            Closeable closeable2;
            OutputStreamWriter outputStreamWriter = null;
            if (string.endsWith(".gz")) {
                closeable2 = new FileOutputStream(string);
                closeable = new GZIPOutputStream((OutputStream)closeable2);
                outputStreamWriter = new OutputStreamWriter((OutputStream)closeable);
            } else if (string.endsWith(".zip")) {
                closeable2 = new FileOutputStream(string);
                closeable = new ZipOutputStream((OutputStream)closeable2);
                ((ZipOutputStream)closeable).setMethod(8);
                String string2 = PsUtil.getFileName(string);
                string2 = string2.substring(0, string2.lastIndexOf("."));
                ZipEntry zipEntry = new ZipEntry(string2);
                ((ZipOutputStream)closeable).putNextEntry(zipEntry);
                outputStreamWriter = new OutputStreamWriter((OutputStream)closeable);
            } else {
                outputStreamWriter = new FileWriter(string);
            }
            closeable2 = new BufferedWriter(outputStreamWriter);
            closeable = new PrintWriter((Writer)closeable2);
            PsDebug.notify("... succeeded");
            return closeable;
        }
        catch (IOException iOException) {
            PsDebug.warning("file " + string + " not found, IOException\n\texception.getMessage() = " + iOException.getMessage() + "\n\texception.toString()   = " + iOException.toString());
            PsDebug.error("... failed, file = ", string);
            return null;
        }
        catch (SecurityException securityException) {
            PsDebug.warning("exception.getMessage() = " + securityException.getMessage() + "\n\texception.toString()   = " + securityException.toString());
            PsDebug.error("... failed, file = ", string);
            return null;
        }
    }

    public static String getFileName(String string) {
        if (string == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        if (string.indexOf(92) > -1) {
            string = string.substring(string.lastIndexOf(92) + 1, string.length());
        }
        if (string.indexOf(47) > -1) {
            string = string.substring(string.lastIndexOf(47) + 1, string.length());
        }
        return string;
    }

    public static String getFileBaseName(String string) {
        String string2;
        if (string == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        String string3 = PsUtil.getFileName(string);
        if (string3 == null) {
            return null;
        }
        int n = string3.lastIndexOf(46);
        if (n < 0) {
            return string3;
        }
        if (n >= 0 && (string3.endsWith(".zip") || string3.endsWith(".gz"))) {
            string3 = string3.substring(0, n);
            n = string3.lastIndexOf(46);
        }
        if (n >= 0 && ((string2 = string3.substring(n + 1, string3.length())).indexOf("0") > 0 || string2.indexOf("1") > 0 || string2.indexOf("2") > 0 || string2.indexOf("3") > 0 || string2.indexOf("4") > 0 || string2.indexOf("5") > 0 || string2.indexOf("6") > 0 || string2.indexOf("7") > 0 || string2.indexOf("8") > 0 || string2.indexOf("9") > 0)) {
            try {
                Integer.parseInt(string2);
                return string3;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n >= 0) {
            string3 = string3.substring(0, n);
        }
        return string3;
    }

    public static String getFileExtension(String string) {
        if (string == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        String string2 = PsUtil.getFileName(string);
        int n = string2.lastIndexOf(46);
        String string3 = "";
        if (n < 0) {
            return "";
        }
        if (n >= 0) {
            if (string2.endsWith(".zip")) {
                string2 = string2.substring(0, n);
                n = string2.lastIndexOf(46);
                string3 = ".zip";
            } else if (string2.endsWith(".gz")) {
                string2 = string2.substring(0, n);
                n = string2.lastIndexOf(46);
                string3 = ".gz";
            }
        }
        String string4 = "";
        if (n >= 0 && ((string4 = string2.substring(n + 1, string2.length())).indexOf("0") > 0 || string4.indexOf("1") > 0 || string4.indexOf("2") > 0 || string4.indexOf("3") > 0 || string4.indexOf("4") > 0 || string4.indexOf("5") > 0 || string4.indexOf("6") > 0 || string4.indexOf("7") > 0 || string4.indexOf("8") > 0 || string4.indexOf("9") > 0)) {
            try {
                Integer.parseInt(string4);
                return string3;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return string4 + string3;
    }

    public static String getFilePath(String string) {
        if (string == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        String string2 = "";
        int n = Math.max(string.lastIndexOf(92), string.lastIndexOf(47));
        if (n > -1) {
            string2 = string.substring(0, n + 1);
        }
        return string2;
    }

    public static String getFilePathAndBaseName(String string) {
        if (string == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        String string2 = PsUtil.getFilePath(string);
        String string3 = PsUtil.getFileBaseName(string);
        if (string2 == null || string2.length() == 0) {
            return string3;
        }
        if (string3 == null || string3.length() == 0) {
            return string;
        }
        String string4 = String.valueOf(PsConfig.getFileSeparator());
        String string5 = string2 + string4 + string3;
        return string5;
    }

    public static String assureFileSeparator(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        char c = PsConfig.getFileSeparator();
        if (c == '/' && string.indexOf(92) > -1) {
            string = string.replace('\\', c);
        } else if (c == '\\' && string.indexOf(47) > -1) {
            string = string.replace('/', c);
        }
        if (bl && string.length() > 0 && c != string.charAt(string.length() - 1)) {
            string = string + String.valueOf(c);
        }
        return string;
    }

    public static boolean isAbsolutePath(String string) {
        if (string == null) {
            return false;
        }
        return !PsConfig.isApplication() ? (string = string.toLowerCase()).startsWith("http:") || string.startsWith("https:") || string.startsWith("ftp:") || string.startsWith("file:") : string.charAt(0) == PsConfig.getFileSeparator() || string.indexOf(58) > -1;
    }

    public static String getSimpleClassName(Object object) {
        String string = object.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return string;
    }

    public String getClassName(Object object) {
        String string = object.getClass().getName();
        return string;
    }

    public static boolean hasAllBits(int n, int n2) {
        return (n & n2) == n2;
    }

    public static boolean hasSomeBits(int n, int n2) {
        return (n & n2) > 0;
    }

    public static boolean hasBits(int n, int n2) {
        return (n & n2) == n2;
    }

    public static int setBits(int n, int n2) {
        return n |= n2;
    }

    public static int clearBits(int n, int n2) {
        return n &= ~n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

