/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsGeometryInfo;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;

public final class PgHtmlLoader {
    public static boolean write(Writer writer, String string, String string2, int n, int n2) throws IOException {
        if (string == null) {
            PsDebug.warning("missing geometry file name");
            return false;
        }
        PsXmlSrc psXmlSrc = PgHtmlLoader.write(string, string2, n, n2);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to generate HTML tree");
            return false;
        }
        return PsXmlSrc.write(writer, psXmlSrc);
    }

    public static PsXmlSrc write(String string, String string2, int n, int n2) {
        if (string == null) {
            PsDebug.warning("missing geometry file name");
            return null;
        }
        PsXmlSrc psXmlSrc = new PsXmlSrc();
        PsXmlNode psXmlNode = new PsXmlNode("html");
        psXmlSrc.setRootNode(psXmlNode);
        PsXmlNode psXmlNode2 = psXmlNode.addChild("head");
        PsXmlNode[] psXmlNodeArray = new PsXmlNode[2];
        psXmlNodeArray[0] = psXmlNode2.addChild("meta");
        psXmlNodeArray[0].addAttribute("generator", PsConfig.getProgramAndVersion());
        psXmlNodeArray[1] = psXmlNode2.addChild("meta");
        psXmlNodeArray[1].addAttribute("date", new Date().toString());
        psXmlNode2.addChild("title", string);
        PsXmlNode psXmlNode3 = psXmlNode.addChild("body");
        psXmlNode3.addChild("h2", "Applet shows " + string);
        PsXmlNode psXmlNode4 = psXmlNode3.addChild("applet");
        psXmlNode4.addAttribute("code", "javaview.class");
        psXmlNode4.addAttribute("width", String.valueOf(n));
        psXmlNode4.addAttribute("height", String.valueOf(n2));
        psXmlNode4.addAttribute("archive", "jars/javaview.jar");
        psXmlNode4.setContent("<param name=model value=\"" + string + "\">\n<param name=displayFile value=\"" + string2 + "\">\n<param name=panel value=\"material\">");
        return psXmlSrc;
    }

    public static boolean writeValidate(Writer writer, String string, PsAuthorInfo psAuthorInfo, PsGeometryInfo psGeometryInfo, String string2, String string3, String string4, String string5, int n, int n2, String string6) throws IOException {
        PsXmlSrc psXmlSrc = PgHtmlLoader.writeValidate(string, psAuthorInfo, psGeometryInfo, string2, string3, string4, string5, n, n2, string6);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to generate HTML tree");
            return false;
        }
        return PsXmlSrc.write(writer, psXmlSrc);
    }

    public static PsXmlSrc writeValidate(String string, PsAuthorInfo psAuthorInfo, PsGeometryInfo psGeometryInfo, String string2, String string3, String string4, String string5, int n, int n2, String string6) {
        PsXmlNode psXmlNode;
        if (string2 == null) {
            string2 = "./";
        }
        if (psGeometryInfo == null) {
            PsDebug.error("missing geometry info");
            psGeometryInfo = new PsGeometryInfo();
        }
        PsXmlSrc psXmlSrc = new PsXmlSrc();
        PsXmlNode psXmlNode2 = new PsXmlNode("html");
        psXmlSrc.setRootNode(psXmlNode2);
        PsXmlNode psXmlNode3 = psXmlNode2.addChild("head");
        psXmlNode3.addChild("title", string);
        PsXmlNode psXmlNode4 = psXmlNode3.addChild("link");
        psXmlNode4.addAttribute("rel", "stylesheet");
        psXmlNode4.addAttribute("type", "text/css");
        psXmlNode4.addAttribute("href", string2 + "css/jvValidateFormat.css");
        PsXmlNode psXmlNode5 = psXmlNode3.addChild("meta");
        psXmlNode5.addAttribute("generator", PsConfig.getProgramAndVersion());
        psXmlNode5 = psXmlNode3.addChild("meta");
        psXmlNode5.addAttribute("date", new Date().toString());
        PsXmlNode psXmlNode6 = psXmlNode2.addChild("body");
        PsXmlNode psXmlNode7 = psXmlNode6.addChild("div");
        psXmlNode7.addAttribute("class", "jv-header");
        psXmlNode7.addChild("h2", string);
        Object object = psGeometryInfo.getAbstract();
        if (object != null) {
            psXmlNode7.addChild("p", (String)object);
        }
        psXmlNode7 = psXmlNode6.addChild("div");
        psXmlNode7.addAttribute("class", "jv-outline");
        PsXmlNode psXmlNode8 = psXmlNode7.addChild("table");
        psXmlNode8.addAttribute("class", "jv-table-applet");
        PsXmlNode psXmlNode9 = psXmlNode8.addChild("tr");
        PsXmlNode psXmlNode10 = psXmlNode9.addChild("td");
        psXmlNode10.addAttribute("width", "50%");
        psXmlNode10.addAttribute("align", "center");
        if (string6 != null) {
            psXmlNode = psXmlNode10.addChild("applet");
            psXmlNode.addAttribute("code", "javaview.class");
            psXmlNode.addAttribute("codebase", string2);
            psXmlNode.addAttribute("width", String.valueOf(n));
            psXmlNode.addAttribute("height", String.valueOf(n2));
            psXmlNode.addAttribute("archive", "jars/javaview.jar,jars/jvx.jar,jars/jvxGeom.jar");
            psXmlNode.setContent("<param name=model value=\"" + string6 + "\">\n<param name=displayFile value=\"" + string4 + "\">\n<param name=panel value=\"material\">");
        }
        psXmlNode10 = psXmlNode9.addChild("td");
        psXmlNode10.addAttribute("width", "50%");
        psXmlNode10.addAttribute("align", "center");
        PsXmlNode psXmlNode11 = psXmlNode10.addChild("img");
        psXmlNode11.addAttribute("border", "0");
        psXmlNode11.addAttribute("src", string2 + string5);
        psXmlNode11.addAttribute("width", String.valueOf(n));
        psXmlNode11.addAttribute("height", String.valueOf(n2));
        psXmlNode9 = psXmlNode8.addChild("tr");
        PsXmlNode psXmlNode12 = psXmlNode9.addChild("th");
        psXmlNode12.addAttribute("scope", "column");
        psXmlNode12.addAttribute("width", "50%");
        psXmlNode12.addAttribute("align", "center");
        if (string6 != null) {
            psXmlNode12.setContent("JVZ Compression");
        }
        psXmlNode12 = psXmlNode9.addChild("th");
        psXmlNode12.addAttribute("scope", "column");
        psXmlNode12.addAttribute("width", "50%");
        psXmlNode12.addAttribute("align", "center");
        psXmlNode12.setContent("Image");
        psXmlNode9 = psXmlNode8.addChild("tr");
        psXmlNode10 = psXmlNode9.addChild("td");
        psXmlNode10.addAttribute("width", "50%");
        psXmlNode10.addAttribute("align", "center");
        psXmlNode = psXmlNode10.addChild("applet");
        psXmlNode.addAttribute("code", "javaview.class");
        psXmlNode.addAttribute("codebase", string2);
        psXmlNode.addAttribute("width", String.valueOf(n));
        psXmlNode.addAttribute("height", String.valueOf(n2));
        psXmlNode.addAttribute("archive", "jars/javaview.jar,jars/jvx.jar");
        psXmlNode.setContent("<param name=model value=\"" + string3 + "\">\n<param name=displayFile value=\"" + string4 + "\">\n<param name=panel value=\"material\">");
        psXmlNode10 = psXmlNode9.addChild("td");
        psXmlNode10.addAttribute("width", "50%");
        psXmlNode10.addAttribute("align", "center");
        psXmlNode = psXmlNode10.addChild("applet");
        psXmlNode.addAttribute("code", "jvLite.class");
        psXmlNode.addAttribute("codebase", string2);
        psXmlNode.addAttribute("width", String.valueOf(n));
        psXmlNode.addAttribute("height", String.valueOf(n2));
        psXmlNode.addAttribute("archive", "jars/jvLite.jar");
        psXmlNode.setContent("<param name=model value=\"" + string3 + "\">\n<param name=displayFile value=\"" + string4 + "\">");
        psXmlNode9 = psXmlNode8.addChild("tr");
        psXmlNode12 = psXmlNode9.addChild("th");
        psXmlNode12.addAttribute("scope", "column");
        psXmlNode12.addAttribute("width", "50%");
        psXmlNode12.addAttribute("align", "center");
        psXmlNode12.setContent("JavaView Applet");
        psXmlNode12 = psXmlNode9.addChild("th");
        psXmlNode12.addAttribute("scope", "column");
        psXmlNode12.addAttribute("width", "50%");
        psXmlNode12.addAttribute("align", "center");
        psXmlNode12.setContent("Jv-Lite Applet");
        psXmlNode7 = psXmlNode6.addChild("div");
        psXmlNode7.addAttribute("class", "jv-description");
        psXmlNode7.addChild("h4", "Description");
        object = psGeometryInfo.getDetail();
        if (object != null) {
            psXmlNode7.addChild("p", (String)object);
        }
        psXmlNode7 = psXmlNode6.addChild("div");
        psXmlNode7.addAttribute("class", "jv-created");
        psXmlNode7.addChild("h4", "Created");
        psXmlNode8 = psXmlNode7.addChild("table");
        psXmlNode8.addAttribute("class", "jv-table-created");
        psXmlNode9 = psXmlNode8.addChild("tr");
        psXmlNode10 = psXmlNode9.addChild("td", "Software:");
        psXmlNode10.addAttribute("width", "50%");
        object = psGeometryInfo.getSoftware();
        if (PuString.isEmpty((String)object)) {
            object = PsConfig.getProgramAndVersion();
        }
        psXmlNode10 = psXmlNode9.addChild("td", (String)object);
        psXmlNode10.addAttribute("width", "50%");
        psXmlNode9 = psXmlNode8.addChild("tr");
        psXmlNode10 = psXmlNode9.addChild("td", "Date:");
        psXmlNode10.addAttribute("width", "50%");
        object = Calendar.getInstance();
        String string7 = String.valueOf(((Calendar)object).get(1)) + "-" + String.valueOf(((Calendar)object).get(2) + 1) + "-" + String.valueOf(((Calendar)object).get(5));
        psXmlNode10 = psXmlNode9.addChild("td", string7);
        psXmlNode10.addAttribute("width", "50%");
        psXmlNode9 = psXmlNode8.addChild("tr");
        psXmlNode10 = psXmlNode9.addChild("td", "Author:");
        psXmlNode10.addAttribute("width", "50%");
        psXmlNode10 = psXmlNode9.addChild("td");
        psXmlNode10.addAttribute("width", "50%");
        int n3 = psAuthorInfo.getNumAuthors();
        if (n3 > 0) {
            string7 = psAuthorInfo.getInfo(0, 0) + " " + psAuthorInfo.getInfo(0, 1);
            for (int i = 1; i < n3; ++i) {
                string7 = string7 + ", " + psAuthorInfo.getInfo(i, 0) + " " + psAuthorInfo.getInfo(i, 1);
            }
            psXmlNode10.setContent(string7);
        }
        return psXmlSrc;
    }

    public static PsXmlSrc writeValidateDescr(String string, PsAuthorInfo psAuthorInfo, PsGeometryInfo psGeometryInfo, String string2, String string3, String string4, int n, int n2, String string5, boolean bl) {
        PsXmlNode psXmlNode;
        Object object;
        if (psAuthorInfo == null) {
            PsDebug.error("missing author info");
            psAuthorInfo = new PsAuthorInfo();
        }
        if (psGeometryInfo == null) {
            PsDebug.error("missing geometry info");
            psGeometryInfo = new PsGeometryInfo();
        }
        PsXmlSrc psXmlSrc = new PsXmlSrc();
        PsXmlNode psXmlNode2 = new PsXmlNode("jv-val");
        psXmlSrc.setRootNode(psXmlNode2);
        psXmlSrc.setDocName("jv-val");
        psXmlSrc.setDocType("http://www.javaview.de/rsrc/jv-val.dtd");
        PsXmlNode psXmlNode3 = psXmlNode2.addChild("meta");
        psXmlNode3.addAttribute("generator", PsConfig.getProgramAndVersion());
        psXmlNode3 = psXmlNode2.addChild("meta");
        int[] nArray = PsConfig.getVersion(15);
        String string6 = String.valueOf(nArray[0]) + ".";
        if (nArray[1] < 10) {
            string6 = string6 + "0";
        }
        string6 = string6 + String.valueOf(nArray[1]);
        if (nArray[2] != 0) {
            string6 = string6 + ".";
            if (nArray[2] < 10) {
                string6 = string6 + "00";
            } else if (nArray[2] < 100) {
                string6 = string6 + "0";
            }
            string6 = string6 + String.valueOf(nArray[2]);
        }
        psXmlNode3.addAttribute("dtd", string6);
        psXmlNode3 = psXmlNode2.addChild("meta");
        psXmlNode3.addAttribute("date", new Date().toString());
        PsXmlNode psXmlNode4 = psXmlNode2.addChild("version", "1.00.000");
        psXmlNode4.addAttribute("type", "beta");
        if (string != null) {
            psXmlNode2.addChild("title", string);
        } else {
            psXmlNode2.addChild("title", "Validation File");
        }
        if (psAuthorInfo.getNumAuthors() > 0 && (object = psAuthorInfo.getXmlNode()) != null) {
            psXmlNode2.addChild((PsXmlNode)object);
        }
        object = psGeometryInfo.getSoftware();
        PsXmlNode psXmlNode5 = psGeometryInfo.getXmlNode();
        if (psXmlNode5 != null) {
            if (psXmlNode5.hasChild("msc2000")) {
                psXmlNode5.removeChild("msc2000");
            }
            if (psXmlNode5.hasChild("zentralblatt")) {
                psXmlNode5.removeChild("zentralblatt");
            }
            psXmlNode2.addChild(psXmlNode5);
        }
        if ((psXmlNode = psXmlNode2.addChild("files")) != null) {
            PsXmlNode psXmlNode6;
            if (string2 != null) {
                psXmlNode6 = psXmlNode.addChild("file_master");
                psXmlNode6.addAttribute("format", PsUtil.getFileExtension(string2));
                psXmlNode6.addChild("filename", string2);
            }
            if (string3 != null) {
                psXmlNode6 = psXmlNode.addChild("file_display");
                psXmlNode6.addAttribute("format", PsUtil.getFileExtension(string3));
                psXmlNode6.addChild("filename", string3);
            }
            if (bl && string4 != null) {
                psXmlNode6 = psXmlNode.addChild("file_image");
                psXmlNode6.addAttribute("format", PsUtil.getFileExtension(string4));
                psXmlNode6.addChild("filename", string4);
                psXmlNode6.addChild("imagewidth", String.valueOf(n));
                psXmlNode6.addChild("imageheight", String.valueOf(n2));
                if (object != null) {
                    psXmlNode6.addChild("software", (String)object);
                }
            }
            if (string5 != null) {
                psXmlNode6 = psXmlNode.addChild("file_other");
                psXmlNode6.addAttribute("format", PsUtil.getFileExtension(string5));
                psXmlNode6.addChild("filename", string5);
            }
        }
        return psXmlSrc;
    }
}

