/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Color;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgUtil;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.vecmath.P_Vector;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;
import jv.vecmath.PuVectorGeom;

public class PgPolygonSet
extends PgPointSet {
    protected boolean m_bShowEdgeLabels;
    protected boolean m_bShowPolygonLabels;
    protected int m_dimOfPolygons;
    protected int m_numPolygons;
    protected int m_maxNumPolygons;
    protected PiVector[] m_polygon;
    protected Color[] m_polygonColor;
    protected PdVector[] m_polygonNormal;
    protected PdVector m_polygonSize;
    protected boolean m_bShowPolygonSizes;
    protected boolean m_bShowPolygons;
    protected boolean m_bShowTaggedPolygons;
    protected boolean m_bShowPolygonStartArrow;
    protected boolean m_bShowPolygonEndArrow;
    protected boolean m_bShowPolygonNormals;
    protected boolean m_bShowPolygonNormalArrow;
    protected PuDouble m_globalPolygonNormalLength;
    protected PuDouble m_globalPolygonNormalSize;
    protected PdColor m_globalPolygonNormalColor;
    protected boolean m_bShowPolygonColors;
    protected PdColor m_globalPolygonColor;
    protected PdColor m_globalPolygonTagColor;
    protected PuDouble m_globalPolygonSize;
    protected boolean m_bShowSmoothLighting;
    protected boolean m_bShowSmoothEdgeColors;
    protected boolean m_bShowEdgeColorFromVertices;
    public static final int NORMAL = 100;
    public static final int BINORMAL = 101;
    public static final int OFFSET_NORMAL = 102;
    public static final int CURVATURE_NORMAL = 103;
    static /* synthetic */ Class class$jv$geom$PgPolygonSet;

    public PgPolygonSet() {
        this(3);
    }

    public PgPolygonSet(int n) {
        super(n);
        this.setType(32);
        this.addGeometryItem("Polygon");
        this.setDimOfSimplex(1);
        this.m_polygon = new PiVector[0];
        this.m_globalPolygonColor = new PdColor(PsConfig.getMessage(24075), this);
        this.m_globalPolygonTagColor = new PdColor(PsConfig.getMessage(24076), this);
        this.m_globalPolygonSize = new PuDouble(PsConfig.getMessage(24077), this);
        this.m_globalPolygonNormalLength = new PuDouble(PsConfig.getMessage(24078), this);
        this.m_globalPolygonNormalSize = new PuDouble(PsConfig.getMessage(24079), this);
        this.m_globalPolygonNormalColor = new PdColor(PsConfig.getMessage(24080), this);
        if (this.getClass() == (class$jv$geom$PgPolygonSet == null ? (class$jv$geom$PgPolygonSet = PgPolygonSet.class$("jv.geom.PgPolygonSet")) : class$jv$geom$PgPolygonSet)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_bShowEdgeLabels = false;
        this.m_bShowPolygonLabels = false;
        this.m_bShowVertices = true;
        this.setGlobalVertexColor(Color.red);
        this.setGlobalVertexSize(2.0);
        this.m_dimOfPolygons = -1;
        this.setMaxNumPolygons(0);
        this.m_bShowPolygons = true;
        this.m_bShowTaggedPolygons = true;
        this.m_bShowPolygonStartArrow = false;
        this.m_bShowPolygonEndArrow = false;
        this.m_polygonNormal = null;
        this.m_bShowPolygonNormals = false;
        this.m_bShowPolygonNormalArrow = false;
        this.m_globalPolygonNormalSize.setDefBounds(0.0, 10.0, 1.0, 2.0);
        this.m_globalPolygonNormalSize.setDefValue(1.0);
        this.m_globalPolygonNormalSize.init();
        this.m_globalPolygonNormalLength.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_globalPolygonNormalLength.setDefValue(0.5);
        this.m_globalPolygonNormalLength.init();
        this.m_globalPolygonNormalColor.setColor(Color.yellow);
        this.m_polygonColor = null;
        this.m_bShowPolygonColors = false;
        this.m_globalPolygonColor.setColor(Color.black);
        this.m_globalPolygonTagColor.setColor(Color.magenta);
        this.m_globalPolygonSize.setDefBounds(0.0, 10.0, 1.0, 2.0);
        this.m_globalPolygonSize.setDefValue(2.0);
        this.m_globalPolygonSize.init();
        this.m_polygonSize = null;
        this.m_bShowPolygonSizes = false;
        this.m_bShowSmoothLighting = false;
        this.m_bShowSmoothEdgeColors = false;
        this.m_bShowEdgeColorFromVertices = false;
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc pgJvxSrc = super.getJvx();
        pgJvxSrc.setType(32);
        pgJvxSrc.showEdgeLabels(this.isShowingEdgeLabels());
        pgJvxSrc.showPolygonLabels(this.isShowingPolygonLabels());
        pgJvxSrc.showTaggedPolygons(this.isShowingTaggedPolygons());
        pgJvxSrc.showPolygons(this.isShowingPolygons());
        pgJvxSrc.showPolygonStartArrow(this.isShowingPolygonStartArrow());
        pgJvxSrc.showPolygonEndArrow(this.isShowingPolygonEndArrow());
        pgJvxSrc.setDimOfPolygons(this.m_dimOfPolygons);
        pgJvxSrc.setNumPolygons(this.getNumPolygons());
        pgJvxSrc.setPolygons(this.getPolygons());
        pgJvxSrc.showSmoothLighting(this.isShowingSmoothLighting());
        pgJvxSrc.showSmoothElementColors(this.isShowingSmoothEdgeColors());
        pgJvxSrc.showEdgeColorFromVertices(this.isShowingEdgeColorFromVertices());
        pgJvxSrc.setPolygonColors(this.getPolygonColors());
        pgJvxSrc.showPolygonColors(this.isShowingPolygonColors());
        pgJvxSrc.setGlobalPolygonColor(this.getGlobalPolygonColor());
        pgJvxSrc.setGlobalPolygonTagColor(this.getGlobalPolygonTagColor());
        if (this.hasPolygonNormals()) {
            pgJvxSrc.showPolygonNormals(this.isShowingPolygonNormals());
            pgJvxSrc.setPolygonNormals(this.getPolygonNormals());
        } else {
            pgJvxSrc.showPolygonNormals(false);
        }
        pgJvxSrc.showPolygonNormalArrow(this.isShowingPolygonNormalArrow());
        pgJvxSrc.setGlobalPolygonNormalColor(this.getGlobalPolygonNormalColor());
        pgJvxSrc.setGlobalPolygonNormalLength(this.getGlobalPolygonNormalLength());
        pgJvxSrc.setGlobalPolygonNormalSize(this.getGlobalPolygonNormalSize());
        if (this.hasPolygonSizes()) {
            pgJvxSrc.showPolygonSizes(this.isShowingPolygonSizes());
            pgJvxSrc.setPolygonSizes(this.getPolygonSizes());
        } else {
            pgJvxSrc.showPolygonSizes(false);
        }
        pgJvxSrc.setPolygonSizes(this.getPolygonSizes());
        pgJvxSrc.setGlobalPolygonSize(this.getGlobalPolygonSize());
        return pgJvxSrc;
    }

    public void setJvx(PgJvxSrc pgJvxSrc) {
        super.setJvx(pgJvxSrc);
        this.showEdgeLabels(pgJvxSrc.isShowingEdgeLabels());
        this.showPolygonLabels(pgJvxSrc.isShowingPolygonLabels());
        this.showTaggedPolygons(pgJvxSrc.isShowingTaggedPolygons());
        this.showPolygons(pgJvxSrc.isShowingPolygons());
        this.showPolygonStartArrow(pgJvxSrc.isShowingPolygonStartArrow());
        this.showPolygonEndArrow(pgJvxSrc.isShowingPolygonEndArrow());
        int n = PiVector.getSameSize(pgJvxSrc.getPolygons(), pgJvxSrc.getNumPolygons());
        this.setDimOfPolygons(n);
        this.setNumPolygons(pgJvxSrc.getNumPolygons());
        this.setPolygons(pgJvxSrc.getPolygons());
        this.showSmoothLighting(pgJvxSrc.isShowingSmoothLighting());
        this.showSmoothEdgeColors(pgJvxSrc.isShowingSmoothEdgeColors());
        this.showEdgeColorFromVertices(pgJvxSrc.isShowingEdgeColorFromVertices());
        this.setPolygonColors(pgJvxSrc.getPolygonColors());
        this.showPolygonColors(pgJvxSrc.isShowingPolygonColors());
        if (pgJvxSrc.getGlobalPolygonColor() != null) {
            this.setGlobalPolygonColor(pgJvxSrc.getGlobalPolygonColor());
        }
        if (pgJvxSrc.getGlobalPolygonTagColor() != null) {
            this.setGlobalPolygonTagColor(pgJvxSrc.getGlobalPolygonTagColor());
        }
        this.showPolygonNormals(pgJvxSrc.isShowingPolygonNormals());
        this.showPolygonNormalArrow(pgJvxSrc.isShowingPolygonNormalArrow());
        if (pgJvxSrc.getPolygonNormals() != null) {
            this.setPolygonNormals(pgJvxSrc.getPolygonNormals());
        }
        if (pgJvxSrc.getGlobalPolygonNormalColor() != null) {
            this.setGlobalPolygonNormalColor(pgJvxSrc.getGlobalPolygonNormalColor());
        }
        if (pgJvxSrc.getGlobalPolygonNormalLength() != 0.0) {
            this.setGlobalPolygonNormalLength(pgJvxSrc.getGlobalPolygonNormalLength());
        }
        if (pgJvxSrc.getGlobalPolygonNormalSize() != 0.0) {
            this.setGlobalPolygonNormalSize(pgJvxSrc.getGlobalPolygonNormalSize());
        }
        this.showPolygonSizes(pgJvxSrc.isShowingPolygonSizes());
        this.setPolygonSizes(pgJvxSrc.getPolygonSizes());
        this.setGlobalPolygonSize(pgJvxSrc.getGlobalPolygonSize());
    }

    public Object clone() {
        PgPolygonSet pgPolygonSet = (PgPolygonSet)super.clone();
        if (pgPolygonSet == null) {
            return null;
        }
        if (this.m_polygon != null) {
            pgPolygonSet.m_polygon = (PiVector[])P_Vector.clone(this.m_polygon);
        }
        if (this.m_polygonColor != null) {
            pgPolygonSet.m_polygonColor = (Color[])this.m_polygonColor.clone();
        }
        pgPolygonSet.m_globalPolygonColor = (PdColor)this.m_globalPolygonColor.clone();
        pgPolygonSet.m_globalPolygonColor.setParent(pgPolygonSet);
        pgPolygonSet.m_globalPolygonTagColor = (PdColor)this.m_globalPolygonTagColor.clone();
        pgPolygonSet.m_globalPolygonTagColor.setParent(pgPolygonSet);
        pgPolygonSet.m_globalPolygonSize = (PuDouble)this.m_globalPolygonSize.clone();
        pgPolygonSet.m_globalPolygonSize.setParent(pgPolygonSet);
        if (this.m_polygonNormal != null) {
            pgPolygonSet.m_polygonNormal = (PdVector[])P_Vector.clone(this.m_polygonNormal);
        }
        pgPolygonSet.m_globalPolygonNormalLength = (PuDouble)this.m_globalPolygonNormalLength.clone();
        pgPolygonSet.m_globalPolygonNormalLength.setParent(pgPolygonSet);
        pgPolygonSet.m_globalPolygonNormalSize = (PuDouble)this.m_globalPolygonNormalSize.clone();
        pgPolygonSet.m_globalPolygonNormalSize.setParent(pgPolygonSet);
        pgPolygonSet.m_globalPolygonNormalColor = (PdColor)this.m_globalPolygonNormalColor.clone();
        pgPolygonSet.m_globalPolygonNormalColor.setParent(pgPolygonSet);
        if (this.m_polygonSize != null) {
            pgPolygonSet.m_polygonSize = (PdVector)this.m_polygonSize.clone();
        }
        return pgPolygonSet;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgPolygonSet)) {
            return;
        }
        PgPolygonSet pgPolygonSet = (PgPolygonSet)psObject;
        this.m_bShowPolygons = pgPolygonSet.m_bShowPolygons;
        this.m_bShowTaggedPolygons = pgPolygonSet.m_bShowTaggedPolygons;
        this.m_bShowPolygonColors = pgPolygonSet.m_bShowPolygonColors;
        this.m_bShowPolygonStartArrow = pgPolygonSet.m_bShowPolygonStartArrow;
        this.m_bShowPolygonEndArrow = pgPolygonSet.m_bShowPolygonEndArrow;
        this.m_bShowPolygonLabels = pgPolygonSet.m_bShowPolygonLabels;
        this.m_bShowPolygonNormals = pgPolygonSet.m_bShowPolygonNormals;
        this.m_bShowPolygonNormalArrow = pgPolygonSet.m_bShowPolygonNormalArrow;
        this.m_globalPolygonColor.copy(pgPolygonSet.m_globalPolygonColor);
        this.m_globalPolygonTagColor.copy(pgPolygonSet.m_globalPolygonTagColor);
        this.m_globalPolygonSize.copy(pgPolygonSet.m_globalPolygonSize);
        this.m_globalPolygonNormalColor.copy(pgPolygonSet.m_globalPolygonNormalColor);
        this.m_globalPolygonNormalLength.copy(pgPolygonSet.m_globalPolygonNormalLength);
        this.m_globalPolygonNormalSize.copy(pgPolygonSet.m_globalPolygonNormalSize);
        this.copyPolygonSet(pgPolygonSet);
    }

    public void copyPolygonSet(PgPolygonSet pgPolygonSet) {
        this.setDimOfPolygons(pgPolygonSet.getDimOfPolygons());
        this.setNumPolygons(pgPolygonSet.getNumPolygons());
        if (this.m_dimOfPolygons == -1) {
            PiVector.adjustSizes(this.m_polygon, 0, pgPolygonSet.getPolygons(), 0, this.m_numPolygons);
        }
        PiVector.copy(this.m_polygon, 0, pgPolygonSet.getPolygons(), 0, this.m_numPolygons);
        if (pgPolygonSet.m_polygonColor != null) {
            this.assurePolygonColors();
            PdColor.copy(this.m_polygonColor, 0, pgPolygonSet.getPolygonColors(), 0, this.m_numPolygons);
        } else {
            this.m_polygonColor = null;
        }
        if (pgPolygonSet.m_polygonNormal != null) {
            this.assurePolygonNormals();
            PdVector.copy(this.m_polygonNormal, 0, pgPolygonSet.getPolygonNormals(), 0, this.m_numPolygons);
        } else {
            this.m_polygonNormal = null;
        }
        if (pgPolygonSet.m_polygonSize != null) {
            this.assurePolygonSizes();
            this.m_polygonSize.copy(0, pgPolygonSet.getPolygonSizes(), 0, this.m_numPolygons);
        } else {
            this.m_polygonSize = null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgPolygonSet *********\n");
        stringBuffer.append("\t m_numPolygons    = " + this.m_numPolygons + "\n");
        stringBuffer.append("\t ******* m_polygon *******\n");
        if (this.m_polygon != null) {
            for (int i = 0; i < this.m_numPolygons; ++i) {
                stringBuffer.append("\t [" + i + "] = " + this.m_polygon[i].toShortString());
            }
        } else {
            stringBuffer.append("\t m_polygon = null\n");
        }
        return stringBuffer.toString();
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_globalPolygonColor) {
            PsDebug.notify("called with event=m_globalPolygonColor");
            return super.update(null);
        }
        if (object == this.m_globalPolygonTagColor) {
            PsDebug.notify("called with event=m_globalPolygonColor");
            return super.update(null);
        }
        if (object == this.m_globalPolygonSize) {
            PsDebug.notify("called with event=m_globalPolygonSize");
            return super.update(null);
        }
        if (object == this.m_globalPolygonNormalColor) {
            PsDebug.notify("called with event=m_globalPolygonNormalColor");
            return super.update(null);
        }
        if (object == this.m_globalPolygonNormalLength) {
            PsDebug.notify("called with event=m_globalPolygonNormalLength");
            return super.update(null);
        }
        if (object == this.m_globalPolygonNormalSize) {
            PsDebug.notify("called with event=m_globalPolygonNormalSize");
            return super.update(null);
        }
        return super.update(object);
    }

    public boolean applyModelingMatrix() {
        if (!this.hasModelMatrix()) {
            return false;
        }
        if (this.hasPolygonNormals()) {
            PdVector pdVector = new PdVector(3);
            PdVector pdVector2 = new PdVector(3);
            for (int i = 0; i < this.m_numPolygons; ++i) {
                pdVector.copyArray(this.m_polygonNormal[i]);
                pdVector2.leftMultAffin(this.m_modelMatrix, pdVector, false);
                this.m_polygonNormal[i].copyArray(pdVector2);
            }
        }
        return super.applyModelingMatrix();
    }

    public Color getGlobalPolygonColor() {
        return this.m_globalPolygonColor.getColor();
    }

    public Color getGlobalPolygonTagColor() {
        return this.m_globalPolygonTagColor.getColor();
    }

    public double getGlobalPolygonSize() {
        return this.m_globalPolygonSize.getValue();
    }

    public Color getGlobalPolygonNormalColor() {
        return this.m_globalPolygonNormalColor.getColor();
    }

    public double getGlobalPolygonNormalLength() {
        return this.m_globalPolygonNormalLength.getValue();
    }

    public double getGlobalPolygonNormalSize() {
        return this.m_globalPolygonNormalSize.getValue();
    }

    public void setGlobalPolygonColor(Color color) {
        this.m_globalPolygonColor.setColor(color);
    }

    public void setGlobalPolygonTagColor(Color color) {
        this.m_globalPolygonTagColor.setColor(color);
    }

    public void setGlobalPolygonSize(double d) {
        this.m_globalPolygonSize.setValue(d);
    }

    public void setGlobalPolygonNormalColor(Color color) {
        this.m_globalPolygonNormalColor.setColor(color);
    }

    public void setGlobalPolygonNormalLength(double d) {
        this.m_globalPolygonNormalLength.setValue(d);
    }

    public void setGlobalPolygonNormalSize(double d) {
        this.m_globalPolygonNormalSize.setValue(d);
    }

    public int addPolygon(PiVector piVector) {
        if (piVector == null || piVector.getSize() < 1) {
            PsDebug.warning("missing polygon, or too small.");
            return -1;
        }
        int n = this.m_numPolygons;
        if (n == this.m_maxNumPolygons) {
            this.setMaxNumPolygons((int)((double)(n + 1) * 1.2));
        }
        this.setNumPolygons(n + 1);
        this.setPolygon(n, piVector);
        return n;
    }

    public PiVector[] getPolygons() {
        return this.m_polygon;
    }

    public Color[] getPolygonColors() {
        return this.m_polygonColor;
    }

    public PdVector[] getPolygonNormals() {
        return this.m_polygonNormal;
    }

    public PdVector getPolygonSizes() {
        return this.m_polygonSize;
    }

    public boolean isShowingEdgeLabels() {
        return this.m_bShowEdgeLabels;
    }

    public boolean isShowingPolygonLabels() {
        return this.m_bShowPolygonLabels;
    }

    public boolean isShowingPolygons() {
        return this.m_bShowPolygons;
    }

    public boolean isShowingPolygonColors() {
        return this.m_bShowPolygonColors;
    }

    public boolean isShowingPolygonNormals() {
        return this.m_bShowPolygonNormals;
    }

    public boolean isShowingPolygonSizes() {
        return this.m_bShowPolygonSizes;
    }

    public boolean isShowingPolygonNormalArrow() {
        return this.m_bShowPolygonNormalArrow;
    }

    public boolean isShowingPolygonStartArrow() {
        return this.m_bShowPolygonStartArrow;
    }

    public boolean isShowingPolygonEndArrow() {
        return this.m_bShowPolygonEndArrow;
    }

    public boolean isShowingTaggedPolygons() {
        return this.m_bShowTaggedPolygons;
    }

    public void showTaggedPolygons(boolean bl) {
        this.m_bShowTaggedPolygons = bl;
    }

    public void showEdgeLabels(boolean bl) {
        this.m_bShowEdgeLabels = bl;
    }

    public void showPolygonLabels(boolean bl) {
        this.m_bShowPolygonLabels = bl;
    }

    public void showPolygons(boolean bl) {
        this.m_bShowPolygons = bl;
    }

    public void showPolygonColors(boolean bl) {
        this.m_bShowPolygonColors = bl;
    }

    public void showPolygonNormals(boolean bl) {
        this.m_bShowPolygonNormals = bl;
    }

    public void showPolygonSizes(boolean bl) {
        this.m_bShowPolygonSizes = bl;
    }

    public void showPolygonNormalArrow(boolean bl) {
        this.m_bShowPolygonNormalArrow = bl;
    }

    public void showPolygonStartArrow(boolean bl) {
        this.m_bShowPolygonStartArrow = bl;
    }

    public void showPolygonEndArrow(boolean bl) {
        this.m_bShowPolygonEndArrow = bl;
    }

    public void useGlobalPolygonColor(boolean bl) {
        this.showPolygonColors(!bl);
    }

    public int getMaxNumPolygons() {
        return this.m_maxNumPolygons;
    }

    public void setMaxNumPolygons(int n) {
        if (this.m_maxNumPolygons == n) {
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_maxNumPolygons = n;
            return;
        }
        this.m_polygon = this.m_dimOfPolygons > -1 ? PiVector.realloc(this.m_polygon, n, this.m_dimOfPolygons) : PiVector.realloc(this.m_polygon, n);
        this.m_maxNumPolygons = n;
        if (this.m_polygonColor != null) {
            this.assurePolygonColors();
        }
        if (this.m_polygonNormal != null) {
            this.assurePolygonNormals();
        }
        if (this.m_polygonSize != null) {
            this.assurePolygonSizes();
        }
        if (this.m_maxNumPolygons < this.m_numPolygons) {
            this.m_numPolygons = this.m_maxNumPolygons;
        }
    }

    public int getNumPolygons() {
        return this.m_numPolygons;
    }

    public void setNumPolygons(int n) {
        if (n == this.m_numPolygons) {
            return;
        }
        if (n > this.m_maxNumPolygons || n < this.m_maxNumPolygons / 2 && n < this.m_maxNumPolygons - 100) {
            this.setMaxNumPolygons(n);
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_numPolygons = n;
            return;
        }
        if (n < this.m_numPolygons && this.m_dimOfPolygons == -1) {
            for (int i = n; i < this.m_numPolygons; ++i) {
                this.m_polygon[i].setSize(0);
            }
        }
        this.m_numPolygons = n;
    }

    public void setSizeOfPolygon(int n, int n2) {
        if (this.m_dimOfPolygons == n2) {
            return;
        }
        if (n < 0 || this.m_numPolygons <= n) {
            PsDebug.warning("index out of bounds, index = " + n);
            return;
        }
        if (n2 < 0) {
            PsDebug.warning("argument aSize=" + n2 + " out of range.");
            return;
        }
        if (this.m_numPolygons == 1) {
            this.setDimOfPolygons(n2);
        } else if (this.m_dimOfPolygons != -1) {
            this.setDimOfPolygons(-1);
        }
        this.m_polygon[n].setSize(n2);
    }

    public void setDimOfVertices(int n) {
        if (this.m_polygonNormal != null) {
            for (int i = 0; i < this.m_maxNumPolygons; ++i) {
                this.m_polygonNormal[i].setSize(n);
            }
        }
        super.setDimOfVertices(n);
    }

    public void setDimOfPolygons(int n) {
        if (n == this.m_dimOfPolygons) {
            return;
        }
        if (n != -1 && n <= 0) {
            PsDebug.warning("argument aSize=" + n + " out of range.");
            return;
        }
        this.m_dimOfPolygons = n;
        if (n == -1) {
            for (int i = this.m_numPolygons; i < this.m_maxNumPolygons; ++i) {
                this.m_polygon[i].setSize(0);
            }
        } else {
            for (int i = 0; i < this.m_maxNumPolygons; ++i) {
                this.m_polygon[i].setSize(n);
            }
        }
    }

    public int getMaxDimOfPolygons() {
        if (this.m_dimOfPolygons != -1) {
            return this.m_dimOfPolygons;
        }
        int n = 0;
        for (int i = 0; i < this.m_numPolygons; ++i) {
            int n2 = this.m_polygon[i].getSize();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public int getDimOfPolygons() {
        return this.m_dimOfPolygons;
    }

    public boolean assureDimOfPolygons() {
        int n = PiVector.getSameSize(this.m_polygon, this.m_numPolygons);
        if (n != this.m_dimOfPolygons) {
            this.m_dimOfPolygons = n;
            return false;
        }
        return true;
    }

    public void setDimOfColors(int n) {
        if (n < 0 || this.m_dimOfColors == n) {
            return;
        }
        super.setDimOfColors(n);
    }

    public void setDimOfVectors(int n) {
        if (n < 0 || n == this.m_dim) {
            return;
        }
        super.setDimOfVectors(n);
        if (this.m_polygonNormal != null) {
            for (int i = 0; i < this.m_maxNumPolygons; ++i) {
                this.m_polygonNormal[i].setSize(n);
            }
        }
    }

    public boolean hasPolygonColors() {
        return this.m_polygonColor != null && this.m_polygonColor.length == this.m_maxNumPolygons;
    }

    public boolean hasPolygonNormals() {
        if (this.m_polygonNormal == null || this.m_polygonNormal.length != this.m_maxNumPolygons) {
            return false;
        }
        return this.m_polygonNormal.length <= 0 || !(Math.abs(this.m_polygonNormal[0].sqrLength() - 1.0) > 1.0E-10);
    }

    public boolean hasPolygonSizes() {
        return this.m_polygonSize != null && this.m_polygonSize.getSize() == this.m_maxNumPolygons;
    }

    public void assurePolygonColors() {
        if (this.m_polygonColor == null || this.m_polygonColor.length != this.m_maxNumPolygons) {
            this.m_polygonColor = PdColor.realloc(this.m_polygonColor, this.m_maxNumPolygons);
        }
    }

    public void assurePolygonNormals() {
        if (this.m_polygonNormal == null || this.m_polygonNormal.length != this.m_maxNumPolygons) {
            this.m_polygonNormal = PdVector.realloc(this.m_polygonNormal, this.m_maxNumPolygons, this.m_dim);
        }
    }

    public void assurePolygonSizes() {
        if (this.m_polygonSize == null) {
            this.m_polygonSize = new PdVector(this.m_maxNumPolygons);
            this.m_polygonSize.setConstant(this.m_globalPolygonSize.getValue());
        } else if (this.m_polygonSize.getSize() != this.m_maxNumPolygons) {
            this.m_polygonSize.setSize(this.m_maxNumPolygons);
        }
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        super.paint(pvGeometryIf);
        pvGeometryIf.setState(83, this.isShowingEdgeLabels());
        pvGeometryIf.setState(82, this.isShowingPolygonLabels());
        pvGeometryIf.setState(54, this.m_bShowPolygons);
        pvGeometryIf.setState(55, this.m_bShowTaggedPolygons);
        pvGeometryIf.setState(89, this.m_bShowPolygonStartArrow);
        pvGeometryIf.setState(90, this.m_bShowPolygonEndArrow);
        if (this.m_globalPolygonSize != null) {
            pvGeometryIf.setGlobalPolygonSize(this.m_globalPolygonSize.getValue());
        }
        if (this.m_globalPolygonColor != null) {
            pvGeometryIf.setGlobalPolygonColor(this.m_globalPolygonColor.getColor());
        }
        if (this.m_globalPolygonTagColor != null) {
            pvGeometryIf.setGlobalPolygonTagColor(this.m_globalPolygonTagColor.getColor());
        }
        pvGeometryIf.setDimOfPolygons(this.m_dimOfPolygons);
        pvGeometryIf.setNumPolygons(this.m_numPolygons);
        pvGeometryIf.setPolygons(this.m_polygon);
        pvGeometryIf.setPolygonColors(this.m_polygonColor);
        pvGeometryIf.setState(93, this.m_bShowPolygonColors);
        pvGeometryIf.setState(103, this.isShowingSmoothLighting());
        pvGeometryIf.setState(104, this.isShowingSmoothEdgeColors());
        pvGeometryIf.setState(96, this.isShowingEdgeColorFromVertices());
        pvGeometryIf.setPolygonNormals(this.m_polygonNormal);
        pvGeometryIf.setState(64, this.m_bShowPolygonNormals);
        pvGeometryIf.setState(65, this.m_bShowPolygonNormalArrow);
        if (this.m_globalPolygonNormalSize != null) {
            pvGeometryIf.setGlobalPolygonNormalSize(this.m_globalPolygonNormalSize.getValue());
        }
        if (this.m_globalPolygonNormalLength != null) {
            pvGeometryIf.setGlobalPolygonNormalLength(this.m_globalPolygonNormalLength.getValue());
        }
        if (this.m_globalPolygonNormalColor != null) {
            pvGeometryIf.setGlobalPolygonNormalColor(this.m_globalPolygonNormalColor.getColor());
        }
        pvGeometryIf.setPolygonSizes(this.m_polygonSize);
        pvGeometryIf.setState(108, this.m_bShowPolygonSizes);
    }

    public int[] removeMarkedVertices() {
        int n = -1;
        int[] nArray = super.removeMarkedVertices();
        for (int i = 0; i < this.m_numPolygons; ++i) {
            int n2 = 0;
            int n3 = this.m_polygon[i].getSize();
            for (int j = 0; j < n3; ++j) {
                if (nArray[this.m_polygon[i].m_data[j]] == n) continue;
                this.m_polygon[i].m_data[n2] = nArray[this.m_polygon[i].m_data[j]];
                ++n2;
            }
            if (n2 <= 1) {
                this.m_polygon[i].setTag(2);
                continue;
            }
            this.m_polygon[i].setSize(n2);
        }
        this.removeMarkedPolygons();
        this.assureDimOfPolygons();
        return nArray;
    }

    public int[] removePolygon(int n) {
        this.m_polygon[n].setTag(2);
        return this.removeMarkedPolygons();
    }

    public int[] removeMarkedPolygons() {
        int n;
        int n2 = 1;
        int n3 = -1;
        PiVector piVector = new PiVector(this.m_numPolygons);
        piVector.setConstant(n3);
        int[] nArray = piVector.m_data;
        for (n = 0; n < this.m_numPolygons; ++n) {
            if (this.m_polygon[n].hasTag(2)) continue;
            nArray[n] = n2;
        }
        int n4 = 0;
        for (n = 0; n < this.m_numPolygons; ++n) {
            if (nArray[n] != n2) continue;
            nArray[n] = n4++;
        }
        for (n = 0; n < this.m_numPolygons; ++n) {
            if (nArray[n] == n3 || nArray[n] >= n) continue;
            this.m_polygon[nArray[n]].setSize(this.m_polygon[n].getSize());
            this.m_polygon[nArray[n]].copy(this.m_polygon[n]);
        }
        if (this.m_polygonNormal != null) {
            for (n = 0; n < this.m_numPolygons; ++n) {
                if (nArray[n] == n3 || nArray[n] >= n) continue;
                this.m_polygonNormal[nArray[n]].setSize(this.m_polygonNormal[n].getSize());
                this.m_polygonNormal[nArray[n]].copy(this.m_polygonNormal[n]);
            }
        }
        if (this.m_polygonColor != null) {
            for (n = 0; n < this.m_numPolygons; ++n) {
                if (nArray[n] == n3 || nArray[n] >= n) continue;
                this.m_polygonColor[nArray[n]] = this.m_polygonColor[n];
            }
        }
        if (this.m_polygonSize != null) {
            for (n = 0; n < this.m_numPolygons; ++n) {
                if (nArray[n] == n3 || nArray[n] >= n) continue;
                this.m_polygonSize.setEntry(nArray[n], this.m_polygonSize.getEntry(n));
            }
        }
        int n5 = this.getNumVectorFields();
        for (n = 0; n < n5; ++n) {
            PgVectorField pgVectorField = this.getVectorField(n);
            if (pgVectorField.getBasedOn() == 0) continue;
            for (int i = 0; i < this.m_numPolygons; ++i) {
                if (nArray[i] == n3 || nArray[i] >= i) continue;
                pgVectorField.setVector(nArray[i], pgVectorField.getVector(i));
            }
            pgVectorField.setNumVectors(n4);
        }
        PsDebug.notify("number of deleted polygons = " + (this.m_numPolygons - n4));
        this.setNumPolygons(n4);
        this.setMaxNumPolygons(n4);
        return nArray;
    }

    public boolean removeUnusedVertices() {
        int n;
        int n2;
        int n3 = 1;
        int n4 = -1;
        PiVector piVector = new PiVector(this.m_numVertices);
        piVector.setConstant(n4);
        int[] nArray = piVector.m_data;
        for (n2 = 0; n2 < this.m_numPolygons; ++n2) {
            for (n = 0; n < this.m_polygon[n2].m_data.length; ++n) {
                nArray[this.m_polygon[n2].m_data[n]] = n3;
            }
        }
        int n5 = 0;
        for (n2 = 0; n2 < this.m_numVertices; ++n2) {
            if (nArray[n2] != n3) continue;
            nArray[n2] = n5++;
        }
        if (n5 == this.m_numVertices) {
            return true;
        }
        for (n2 = 0; n2 < this.m_numVertices; ++n2) {
            if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
            this.m_vertex[nArray[n2]] = this.m_vertex[n2];
        }
        for (n2 = 0; n2 < this.m_numPolygons; ++n2) {
            for (n = 0; n < this.m_polygon[n2].m_data.length; ++n) {
                this.m_polygon[n2].m_data[n] = nArray[this.m_polygon[n2].m_data[n]];
            }
        }
        if (this.m_vertexNormal != null) {
            for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
                this.m_vertexNormal[nArray[n2]] = this.m_vertexNormal[n2];
            }
        }
        if (this.m_vertexColor != null) {
            for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
                this.m_vertexColor[nArray[n2]] = this.m_vertexColor[n2];
            }
        }
        int n6 = this.getNumVectorFields();
        for (n2 = 0; n2 < n6; ++n2) {
            PgVectorField pgVectorField = this.getVectorField(n2);
            if (pgVectorField.getBasedOn() == 1) continue;
            for (n = 0; n < this.m_numVertices; ++n) {
                if (nArray[n] == n4 || nArray[n] >= n) continue;
                pgVectorField.setVector(nArray[n], pgVectorField.getVector(n));
            }
            pgVectorField.setNumVectors(n5);
        }
        PsDebug.notify("number of deleted vertices = " + (this.m_numVertices - n5));
        this.setNumVertices(n5);
        this.setMaxNumVertices(n5);
        return true;
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        boolean bl;
        int n;
        int n2 = this.getNumVertices();
        if (!super.merge(pgGeometryIf)) {
            return false;
        }
        if (!(pgGeometryIf instanceof PgPolygonSet)) {
            return false;
        }
        PgPolygonSet pgPolygonSet = (PgPolygonSet)pgGeometryIf;
        if (this.m_numPolygons == 0) {
            this.setDimOfPolygons(pgPolygonSet.m_dimOfPolygons);
        } else if (pgPolygonSet.m_dimOfPolygons != this.m_dimOfPolygons) {
            this.setDimOfPolygons(-1);
        }
        int n3 = this.m_numPolygons;
        int n4 = this.m_numPolygons + pgPolygonSet.m_numPolygons;
        this.setNumPolygons(n4);
        PiVector.copy(this.m_polygon, n3, pgPolygonSet.m_polygon, 0, pgPolygonSet.m_numPolygons);
        for (n = 0; n < pgPolygonSet.m_numPolygons; ++n) {
            int n5 = pgPolygonSet.m_polygon[n].getSize();
            this.m_polygon[n3 + n].setSize(n5);
            int n6 = 0;
            while (n6 < n5) {
                int n7 = n6++;
                this.m_polygon[n3 + n].m_data[n7] = this.m_polygon[n3 + n].m_data[n7] + n2;
            }
        }
        if (pgPolygonSet.m_polygonNormal != null) {
            this.assurePolygonNormals();
            PdVector.copy(this.m_polygonNormal, n3, pgPolygonSet.m_polygonNormal, 0, pgPolygonSet.m_numPolygons);
        }
        Color color = this.getGlobalPolygonColor();
        Color color2 = pgPolygonSet.getGlobalPolygonColor();
        boolean bl2 = color.getRGB() != color2.getRGB() || this.hasPolygonColors() || pgPolygonSet.hasPolygonColors();
        boolean bl3 = color.getRGB() == color2.getRGB() && !this.isShowingPolygonColors() && !pgPolygonSet.isShowingPolygonColors();
        boolean bl4 = bl2 && !this.isShowingPolygonColors();
        boolean bl5 = bl = bl2 && !pgPolygonSet.isShowingPolygonColors();
        if (!bl3) {
            this.showPolygonColors(true);
        }
        if (bl2) {
            this.assurePolygonColors();
            if (bl4) {
                for (n = 0; n < n3; ++n) {
                    this.setPolygonColor(n, color);
                }
            }
            if (bl) {
                for (n = n3; n < n4; ++n) {
                    this.setPolygonColor(n, color2);
                }
            } else {
                PdColor.copy(this.m_polygonColor, n3, pgPolygonSet.m_polygonColor, 0, pgPolygonSet.m_numPolygons);
            }
        }
        if (pgPolygonSet.m_polygonSize != null) {
            this.assurePolygonSizes();
            this.m_polygonSize.copy(n3, pgPolygonSet.m_polygonSize, 0, pgPolygonSet.m_numPolygons);
        }
        return true;
    }

    public int getPolygonWithVertex(int n) {
        for (int i = 0; i < this.m_numPolygons; ++i) {
            if (!this.m_polygon[i].contains(n)) continue;
            return i;
        }
        return -1;
    }

    public void clearTagPolygon(int n, int n2) {
        if (this.m_polygon == null || n < 0 || n > this.m_numPolygons - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_polygon[n].clearTag(n2);
    }

    public boolean hasTagPolygon(int n, int n2) {
        if (this.m_polygon == null || n < 0 || n > this.m_numPolygons - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        return this.m_polygon[n].hasTag(n2);
    }

    public void setTagPolygon(int n, int n2) {
        if (this.m_polygon == null || n < 0 || n > this.m_numPolygons - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_polygon[n].setTag(n2);
    }

    public PdVector[] getPolygonVertices(int n) {
        if (this.m_polygon == null || n < 0 || this.m_numPolygons <= n) {
            PsDebug.warning("ind out of bounds, ind = " + n);
            return null;
        }
        if (this.m_polygon[n].getSize() == 0) {
            PsDebug.notify("empty polygon, ind = " + n);
            return null;
        }
        int n2 = this.m_polygon[n].getSize();
        PdVector[] pdVectorArray = new PdVector[n2];
        --n2;
        while (n2 >= 0) {
            pdVectorArray[n2] = this.m_vertex[this.m_polygon[n].m_data[n2]];
            --n2;
        }
        return pdVectorArray;
    }

    public PiVector getPolygon(int n) {
        if (this.m_polygon == null || n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("ind out of bounds, ind = " + n);
            return null;
        }
        return this.m_polygon[n];
    }

    public PgPolygon getPolygonAsPgPolygon(int n) {
        PiVector piVector = this.getPolygon(n);
        int n2 = piVector.getSize();
        PgPolygon pgPolygon = new PgPolygon(this.getDimOfVertices());
        pgPolygon.setNumVertices(n2);
        for (int i = 0; i < n2; ++i) {
            pgPolygon.setVertex(i, this.getVertex(piVector.m_data[i]));
        }
        pgPolygon.setName("Polygon " + n + " of " + this.getName());
        if (this.isShowingPolygonColors()) {
            pgPolygon.setGlobalEdgeColor(this.getPolygonColor(n));
        } else {
            pgPolygon.setGlobalEdgeColor(this.getGlobalPolygonColor());
        }
        if (this.isShowingPolygonSizes()) {
            pgPolygon.setGlobalEdgeSize(this.getPolygonSize(n));
        } else {
            pgPolygon.setGlobalEdgeSize(this.getGlobalPolygonSize());
        }
        pgPolygon.setGlobalVertexColor(this.getGlobalVertexColor());
        pgPolygon.setGlobalVertexSize(this.getGlobalVertexSize());
        return pgPolygon;
    }

    public boolean setPolygonVertices(int n, PdVector[] pdVectorArray) {
        int n2 = this.m_polygon[n].getSize();
        if (n2 != pdVectorArray.length) {
            PsDebug.warning("polygon and array have different length");
            return false;
        }
        --n2;
        while (n2 >= 0) {
            this.m_vertex[this.m_polygon[n].m_data[n2]].copy(pdVectorArray[n2]);
            --n2;
        }
        return true;
    }

    public void setPolygon(int n, int n2, int n3) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " > " + this.m_numPolygons + "=m_numPolygons, bad programming style");
            this.setNumPolygons(n + 1);
        }
        this.setSizeOfPolygon(n, 2);
        this.m_polygon[n].set(n2, n3);
    }

    public boolean setPolygon(int n, PiVector piVector) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return false;
        }
        if (piVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " > " + this.m_numPolygons + "=m_numPolygons, bad programming style");
            this.setNumPolygons(n + 1);
        }
        this.setSizeOfPolygon(n, piVector.getSize());
        this.m_polygon[n].copy(piVector);
        return true;
    }

    public Color getPolygonColor(int n) {
        if (this.m_polygonColor == null || n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("ind out of bounds, ind = " + n);
            return null;
        }
        return this.m_polygonColor[n];
    }

    public boolean setPolygonColor(int n, Color color) {
        if (n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " out of range", this);
            return false;
        }
        if (color == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (this.m_polygonColor == null || this.m_numPolygons > this.m_polygonColor.length) {
            this.assurePolygonColors();
        }
        this.m_polygonColor[n] = color;
        return true;
    }

    public PdVector getPolygonNormal(int n) {
        if (this.m_polygonNormal == null || n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("ind out of bounds, ind = " + n);
            return null;
        }
        return this.m_polygonNormal[n];
    }

    public boolean setPolygonNormal(int n, PdVector pdVector) {
        if (n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " out of range", this);
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (this.m_polygonNormal == null || this.m_numPolygons > this.m_polygonNormal.length) {
            this.assurePolygonNormals();
        }
        this.m_polygonNormal[n].copy(pdVector);
        return true;
    }

    public double getPolygonSize(int n) {
        if (this.m_polygonSize == null || n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("ind out of bounds, ind = " + n);
            return this.m_globalPolygonSize.getValue();
        }
        return this.m_polygonSize.getEntry(n);
    }

    public void removePolygonSizes() {
        this.setPolygonSizes(null);
    }

    public boolean setPolygonSize(int n, double d) {
        if (n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " out of range", this);
            return false;
        }
        if (this.m_polygonSize == null || this.m_numPolygons > this.m_polygonSize.getSize()) {
            this.assurePolygonSizes();
        }
        this.m_polygonSize.setEntry(n, d);
        return true;
    }

    public void setPolygonSizes(PdVector pdVector) {
        if (pdVector == null) {
            this.m_polygonSize = null;
            return;
        }
        if (pdVector.getSize() < this.m_numPolygons) {
            PsDebug.warning("void length of argument array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_polygonSize = pdVector;
            return;
        }
        this.assurePolygonSizes();
        this.m_polygonSize.copy(0, pdVector, 0, this.m_numPolygons);
    }

    public void setPolygons(PiVector[] piVectorArray) {
        if ((piVectorArray == null || piVectorArray.length == 0) && this.m_numPolygons == 0) {
            return;
        }
        if (piVectorArray == null || piVectorArray.length == 0 || piVectorArray.length < this.m_numPolygons) {
            PsDebug.warning("void length of polygon array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_polygon = piVectorArray;
            if (this.m_maxNumPolygons != piVectorArray.length) {
                this.setMaxNumPolygons(piVectorArray.length);
            }
            return;
        }
        int n = piVectorArray[0].getSize();
        for (int i = 0; i < this.m_numPolygons; ++i) {
            int n2 = piVectorArray[i].getSize();
            this.m_polygon[i].setSize(n2);
            if (n == -1 || n2 == n) continue;
            n = -1;
        }
        this.setDimOfPolygons(n);
        PiVector.copy(this.m_polygon, 0, piVectorArray, 0, this.m_numPolygons);
    }

    public void removePolygonColors() {
        this.setPolygonColors(null);
    }

    public void setPolygonColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_polygonColor = null;
            return;
        }
        if (colorArray.length < this.m_numPolygons) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_polygonColor = colorArray;
            return;
        }
        this.assurePolygonColors();
        PdColor.copy(this.m_polygonColor, 0, colorArray, 0, this.m_numPolygons);
    }

    public void removePolygonNormals() {
        this.setPolygonNormals(null);
    }

    public void setPolygonNormals(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_polygonNormal = null;
            return;
        }
        if (pdVectorArray.length < this.m_numPolygons) {
            PsDebug.warning("void length of normal array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_polygonNormal = pdVectorArray;
            return;
        }
        this.assurePolygonNormals();
        PdVector.copy(this.m_polygonNormal, 0, pdVectorArray, 0, this.m_numPolygons);
    }

    public boolean isClosed(int n) {
        if (n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " out of range", this);
            return false;
        }
        return this.m_polygon[n].getFirstEntry() == this.m_polygon[n].getLastEntry();
    }

    public boolean setClosed(int n, boolean bl) {
        if (n < 0 || n >= this.m_numPolygons) {
            PsDebug.warning("index=" + n + " out of range", this);
            return false;
        }
        if (bl) {
            if (!this.isClosed(n)) {
                this.m_polygon[n].addEntry(this.m_polygon[n].getFirstEntry());
            }
        } else if (this.isClosed(n)) {
            this.m_polygon[n].setSize(this.m_polygon[n].getSize() - 1);
        }
        this.assureDimOfPolygons();
        return true;
    }

    public double getLengthOfPolygon(int n) {
        PdVector[] pdVectorArray = this.getPolygonVertices(n);
        if (pdVectorArray == null || pdVectorArray.length < 2) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 1; i < pdVectorArray.length; ++i) {
            d += PdVector.dist(pdVectorArray[i - 1], pdVectorArray[i]);
        }
        return d;
    }

    public double getLength() {
        double d = 0.0;
        for (int i = 0; i < this.m_numPolygons; ++i) {
            d += this.getLengthOfPolygon(i);
        }
        return d;
    }

    public double getVertexAngle(int n, int n2) {
        int n3 = this.m_polygon[n].getSize();
        PdVector pdVector = this.m_vertex[this.m_polygon[n].m_data[n2]];
        PdVector pdVector2 = this.m_vertex[this.m_polygon[n].m_data[(n2 + 1) % n3]];
        PdVector pdVector3 = this.m_vertex[this.m_polygon[n].m_data[(n2 - 1 + n3) % n3]];
        return PdVector.angle(pdVector, pdVector2, pdVector3);
    }

    public int getNumEdges() {
        int n = 0;
        for (int i = 0; i < this.m_numPolygons; ++i) {
            n += this.m_polygon[i].getSize();
        }
        return n;
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        int n;
        double d3;
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgPolygonSet) || !(pgGeometry2 instanceof PgPolygonSet)) {
            return false;
        }
        PgPolygonSet pgPolygonSet = (PgPolygonSet)pgGeometry;
        PgPolygonSet pgPolygonSet2 = (PgPolygonSet)pgGeometry2;
        if (pgPolygonSet.m_numPolygons != pgPolygonSet2.m_numPolygons) {
            PsDebug.warning("unequal number of polygons", this);
            return false;
        }
        double d4 = Math.abs(d);
        PgPolygonSet pgPolygonSet3 = d4 > (d3 = Math.abs(d2)) ? pgPolygonSet : pgPolygonSet2;
        this.m_bShowPolygons = pgPolygonSet3.m_bShowPolygons;
        this.m_bShowTaggedPolygons = pgPolygonSet3.m_bShowTaggedPolygons;
        this.m_bShowPolygonColors = pgPolygonSet3.m_bShowPolygonColors;
        this.m_bShowPolygonStartArrow = pgPolygonSet3.m_bShowPolygonStartArrow;
        this.m_bShowPolygonEndArrow = pgPolygonSet3.m_bShowPolygonEndArrow;
        this.m_bShowPolygonLabels = pgPolygonSet3.m_bShowPolygonLabels;
        this.m_bShowPolygonNormals = pgPolygonSet3.m_bShowPolygonNormals;
        this.m_bShowPolygonNormalArrow = pgPolygonSet3.m_bShowPolygonNormalArrow;
        this.m_globalPolygonColor.blend(d4, pgPolygonSet.m_globalPolygonColor, d2, pgPolygonSet2.m_globalPolygonColor);
        this.m_globalPolygonTagColor.blend(d4, pgPolygonSet.m_globalPolygonTagColor, d2, pgPolygonSet2.m_globalPolygonTagColor);
        this.m_globalPolygonSize.blend(d4, pgPolygonSet.m_globalPolygonSize, d2, pgPolygonSet2.m_globalPolygonSize);
        this.m_globalPolygonNormalColor.blend(d4, pgPolygonSet.m_globalPolygonNormalColor, d3, pgPolygonSet2.m_globalPolygonNormalColor);
        this.m_globalPolygonNormalLength.blend(d4, pgPolygonSet.m_globalPolygonNormalLength, d3, pgPolygonSet2.m_globalPolygonNormalLength);
        this.m_globalPolygonNormalSize.blend(d4, pgPolygonSet.m_globalPolygonNormalSize, d3, pgPolygonSet2.m_globalPolygonNormalSize);
        this.setNumPolygons(pgPolygonSet3.getNumPolygons());
        for (n = 0; n < this.m_numPolygons; ++n) {
            this.m_polygon[n].copy(pgPolygonSet3.m_polygon[n]);
        }
        if (pgPolygonSet.m_polygonNormal != null && pgPolygonSet2.m_polygonNormal != null) {
            this.assurePolygonNormals();
            for (n = 0; n < this.m_numPolygons; ++n) {
                this.m_polygonNormal[n].blend(d4, pgPolygonSet.m_polygonNormal[n], d3, pgPolygonSet2.m_polygonNormal[n]);
                this.m_polygonNormal[n].normalize();
            }
        } else {
            this.m_polygonNormal = null;
        }
        if (pgPolygonSet.m_polygonColor != null && pgPolygonSet2.m_polygonColor != null) {
            this.assurePolygonColors();
            for (n = 0; n < this.m_numPolygons; ++n) {
                this.m_polygonColor[n] = PdColor.blend(d4, pgPolygonSet.m_polygonColor[n], d3, pgPolygonSet2.m_polygonColor[n]);
            }
        } else {
            this.m_polygonColor = null;
        }
        return true;
    }

    public PvPickEvent intersectionWithLine(PdVector pdVector, PdVector pdVector2) {
        if (this.m_dim != 2 && this.m_dim != 3) {
            return null;
        }
        if (pdVector == null || pdVector.getSize() != 3 || pdVector2 == null || pdVector2.getSize() != 3) {
            PsDebug.warning("missing or wrong dimension of ray");
            return null;
        }
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        PgGeometry.convertWorldToModel(this, pdVector, pdVector2, pdVector3, pdVector4);
        pdVector4.normalize();
        PdVector pdVector5 = new PdVector(this.m_dim);
        PdVector pdVector6 = new PdVector(this.m_dim);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = this.getDiameter();
        if (d3 < 1.0E-10) {
            d3 = 1.0;
        }
        double d4 = this.getGlobalPolygonSize() * d3 / 1000.0;
        d2 = d3 / 200.0 + d4;
        PdVector pdVector7 = new PdVector(3);
        PdVector pdVector8 = this.m_dim == 2 ? new PdVector(2) : pdVector7;
        PdVector pdVector9 = new PdVector(3);
        PdBary pdBary = new PdBary(2);
        PdBary pdBary2 = new PdBary(2);
        PdVector pdVector10 = null;
        PdVector pdVector11 = null;
        if (this.m_dim == 2) {
            pdVector10 = new PdVector(3);
            pdVector11 = new PdVector(3);
        }
        PdVector pdVector12 = null;
        if (this.m_dim == 2) {
            pdVector12 = new PdVector(3);
        }
        pdVector4.normalize();
        for (int i = 0; i < this.m_numPolygons; ++i) {
            PdVector[] pdVectorArray = this.getPolygonVertices(i);
            if (pdVectorArray == null || pdVectorArray.length < 2) continue;
            for (int j = 1; j < pdVectorArray.length; ++j) {
                pdVector5.sub(pdVectorArray[j], pdVectorArray[j - 1]);
                if (pdVector5.sqrLength() < 1.0E-10) continue;
                if (this.m_dim == 2) {
                    pdVector10.copyArray(pdVectorArray[j - 1]);
                    pdVector11.copyArray(pdVectorArray[j]);
                    pdVector12.copyArray(pdVector5);
                } else {
                    pdVector10 = pdVectorArray[j - 1];
                    pdVector11 = pdVectorArray[j];
                    pdVector12 = pdVector5;
                }
                pdVector12.normalize();
                double d5 = PuVectorGeom.distOfLineToLine(pdVector3, pdVector4, pdVector10, pdVector12);
                if (d5 >= d2) continue;
                double d6 = PuVectorGeom.intersectionOfLineAndLine(pdVector7, pdVector3, pdVector4, pdVector10, pdVector12);
                if (this.m_dim == 2) {
                    pdVector8.m_data[0] = pdVector7.m_data[0];
                    pdVector8.m_data[1] = pdVector7.m_data[1];
                }
                PdBary.getBary(pdBary, pdVector7, pdVector10, pdVector11);
                boolean bl = pdBary.isInside();
                if (!bl && !(Math.abs(1.0 - pdBary.getEntry(0)) < 0.1) && !(Math.abs(1.0 - pdBary.getEntry(1)) < 0.1)) continue;
                d2 = d5;
                d = d6;
                n2 = i;
                n3 = j;
                pdVector6.copyArray(pdVector5);
                n = -1;
                if (bl) {
                    pdBary2.copy(pdBary);
                    pdVector9.blend(pdBary.getEntry(0), pdVector10, pdBary.getEntry(1), pdVector11);
                } else if (Math.abs(1.0 - pdBary.getEntry(0)) < 0.1) {
                    pdBary2.setEntry(0, 1.0);
                    pdBary2.setEntry(1, 0.0);
                    pdVector9.copyArray(pdVector10);
                    n = this.m_polygon[i].getEntry(j - 1);
                } else if (Math.abs(1.0 - pdBary.getEntry(1)) < 0.1) {
                    pdBary2.setEntry(0, 0.0);
                    pdBary2.setEntry(1, 1.0);
                    pdVector9.copyArray(pdVector11);
                    n = this.m_polygon[i].getEntry(j);
                }
                pdBary2.setElementInd(n2);
            }
        }
        if (n2 == -1) {
            return null;
        }
        PvPickEvent pvPickEvent = new PvPickEvent(this.m_dim);
        pvPickEvent.setGeometry(this);
        pvPickEvent.setVertex(pdVector9);
        pvPickEvent.setDistance(d);
        pvPickEvent.setHorDistance(d2);
        pvPickEvent.setElementInd(n2);
        pvPickEvent.setElementSubInd(n3);
        pvPickEvent.setBary(pdBary2);
        pvPickEvent.setVertexInd(n);
        pvPickEvent.setViewBase(pdVector);
        pvPickEvent.setViewDir(pdVector2);
        pvPickEvent.setNormal(pdVector6);
        return pvPickEvent;
    }

    public boolean makeVertexNormals() {
        this.makeNormals(100, 1.0);
        return true;
    }

    public void makeNormals() {
        this.makeVertexNormals();
    }

    public void makeBiNormals() {
        this.makeNormals(101, 1.0);
    }

    public void makeOffsetNormals() {
        this.makeNormals(102, 1.0);
    }

    public void makeCurvatureNormals() {
        this.makeNormals(103, 1.0);
    }

    public void makeNormals(int n, double d) {
        PdVector pdVector;
        if (this.m_numVertices < 2) {
            return;
        }
        if (n == 101 && this.m_dim != 3) {
            PsDebug.warning("dim!=3, cannot compute binormal.");
            return;
        }
        PdVector pdVector2 = null;
        if (this.hasVertexNormals() && (pdVector = this.getVertexNormal(0)).length() > 1.0E-10) {
            pdVector2 = (PdVector)pdVector.clone();
        }
        this.assureVertexNormals();
        pdVector = new PdVector(this.m_dim);
        PdVector pdVector3 = new PdVector(this.m_dim);
        PdVector pdVector4 = new PdVector(this.m_dim);
        PdVector pdVector5 = new PdVector(this.m_dim);
        PdVector pdVector6 = new PdVector(3);
        PdVector pdVector7 = new PdVector(3);
        for (int i = 0; i < this.m_numPolygons; ++i) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6 = this.m_polygon[i].getSize();
            boolean bl = this.isClosed(i);
            if (bl) {
                --n6;
            }
            if (this.m_polygon[i] == null || n6 < 2) {
                PsDebug.warning("polygon[" + i + "] null or less than 2 vertices");
                continue;
            }
            int n7 = 0;
            int n8 = 1;
            int n9 = this.m_polygon[i].getEntry(n7);
            do {
                n5 = this.m_polygon[i].getEntry(n8);
                pdVector.sub(this.m_vertex[n5], this.m_vertex[n9]);
            } while (pdVector.sqrLength() < 1.0E-10 && ++n8 < n6);
            if (n8 >= n6) {
                PsDebug.warning("polygon[" + i + "] is degenerated to a point");
                if (pdVector2 != null) {
                    pdVector4.copyArray(pdVector2);
                } else {
                    pdVector4.setEntry(this.m_dim - 1, 1.0);
                }
                for (n4 = 0; n4 < n6; ++n4) {
                    n3 = this.m_polygon[i].getEntry(n4);
                    this.m_vertexNormal[n3].copyArray(pdVector4);
                }
                continue;
            }
            int n10 = n6 - 1;
            if (bl) {
                n10 = n8;
            }
            pdVector.normalize();
            if (this.m_dim == 2) {
                pdVector4.set(-pdVector.getEntry(1), pdVector.getEntry(0));
                if (pdVector2 != null) {
                    pdVector2.copy(pdVector4);
                } else {
                    pdVector2 = (PdVector)pdVector4.clone();
                }
            } else if (pdVector2 != null && PdVector.dot(pdVector2, pdVector) > 1.0E-10) {
                pdVector2.orthogonalPart(pdVector4, pdVector);
                pdVector4.normalize();
            } else {
                pdVector4.normalToVector(pdVector);
            }
            if (n8 >= n6 - 1) {
                for (n4 = 0; n4 < n6; ++n4) {
                    n3 = this.m_polygon[i].getEntry(n4);
                    this.m_vertexNormal[n3].copyArray(pdVector4);
                }
                continue;
            }
            pdVector5.copyArray(pdVector4);
            pdVector7.cross(pdVector, pdVector4);
            pdVector4.setLength(d);
            int n11 = -1;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                bl3 = true;
            }
            int n12 = n8;
            int n13 = n5;
            boolean bl4 = false;
            boolean bl5 = true;
            while (bl5 || n12 != n10) {
                double d2;
                bl5 = false;
                n8 = n12;
                n12 = (n12 + 1) % n6;
                n5 = n13;
                n13 = this.m_polygon[i].getEntry(n12);
                pdVector3.sub(this.m_vertex[n13], this.m_vertex[n5]);
                if (pdVector3.sqrLength() < 1.0E-10) {
                    bl2 = true;
                    if (n11 != -1) continue;
                    n11 = n8;
                    continue;
                }
                pdVector3.normalize();
                pdVector4.sub(pdVector3, pdVector);
                if (!pdVector4.normalize()) {
                    n11 = -1;
                    bl3 = true;
                    continue;
                }
                if (!bl4) {
                    if (pdVector2 != null && PdVector.dot(pdVector2, pdVector4) < 0.0) {
                        pdVector4.multScalar(-1.0);
                    }
                    bl4 = true;
                }
                pdVector6.cross(pdVector, pdVector4);
                if (n == 100) {
                    pdVector4.setLength(d);
                } else if (n == 101) {
                    pdVector4.copy(pdVector6);
                    pdVector4.setLength(d);
                } else if (n == 102) {
                    double d3 = PdVector.angleWithOrientation(pdVector, pdVector3, pdVector6);
                    d2 = d / Math.cos(d3 / 2.0);
                    pdVector4.setLength(d2);
                } else if (n == 103) {
                    double d4 = PdVector.angleWithOrientation(pdVector, pdVector3, pdVector6);
                    d2 = d * d4;
                    pdVector4.setLength(d2);
                }
                if (PdVector.dot(pdVector6, pdVector7) < 0.0) {
                    pdVector4.multScalar(-1.0);
                    pdVector6.multScalar(-1.0);
                }
                if (bl3) {
                    int n14 = (n7 + 1) % n6;
                    if (!bl && n7 == 0) {
                        n14 = 0;
                    }
                    bl3 = false;
                    if (n == 100) {
                        pdVector5.setSize(3);
                        pdVector5.cross(pdVector6, pdVector);
                        pdVector5.setSize(this.m_dim);
                        pdVector5.setLength(d);
                    } else if (n == 101) {
                        pdVector5.copy(pdVector6);
                        pdVector5.setLength(d);
                    } else if (n == 102) {
                        pdVector5.setSize(3);
                        pdVector5.cross(pdVector6, pdVector);
                        pdVector5.setSize(this.m_dim);
                        pdVector5.setLength(d);
                    } else if (n == 103) {
                        pdVector5.setConstant(0.0);
                    }
                    n4 = n14;
                    while (n4 != n8) {
                        this.m_vertexNormal[this.m_polygon[i].getEntry(n4)].copy(pdVector5);
                        n4 = (n4 + 1) % n6;
                    }
                }
                pdVector5.copy(pdVector4);
                if (n == 100) {
                    pdVector5.setLength(d);
                } else if (n == 101) {
                    pdVector5.copy(pdVector6);
                    pdVector5.setLength(d);
                } else if (n == 102) {
                    double d5 = PdVector.angleWithOrientation(pdVector, pdVector3, pdVector6);
                    d2 = d / Math.cos(d5 / 2.0);
                    pdVector5.setLength(d2);
                } else if (n == 103) {
                    double d6 = PdVector.angleWithOrientation(pdVector, pdVector3, pdVector6);
                    d2 = d * d6;
                    pdVector5.setLength(d2);
                }
                if (bl2) {
                    bl2 = false;
                    n4 = n11;
                    n11 = -1;
                    while (n4 != n8) {
                        this.m_vertexNormal[this.m_polygon[i].getEntry(n4)].copy(pdVector5);
                        n4 = (n4 + 1) % n6;
                    }
                }
                this.m_vertexNormal[this.m_polygon[i].getEntry(n8)].copy(pdVector5);
                pdVector.copyArray(pdVector3);
                pdVector5.copyArray(pdVector4);
                pdVector7.copyArray(pdVector6);
                n9 = n5;
                n7 = n8;
            }
            if (bl || (n2 = n7 + 1) >= n6) continue;
            if (n == 100) {
                pdVector5.setSize(3);
                pdVector5.cross(pdVector7, pdVector);
                pdVector5.setSize(this.m_dim);
                pdVector5.setLength(d);
            } else if (n == 101) {
                pdVector5.copy(pdVector6);
                pdVector5.setLength(d);
            } else if (n == 102) {
                pdVector5.setSize(3);
                pdVector5.cross(pdVector7, pdVector);
                pdVector5.setSize(this.m_dim);
                pdVector5.setLength(d);
            } else if (n == 103) {
                pdVector5.setConstant(0.0);
            }
            for (n4 = n2; n4 < n6; ++n4) {
                this.m_vertexNormal[this.m_polygon[i].getEntry(n4)].copy(pdVector5);
            }
        }
    }

    public boolean makePolygonColorsFromXYZ() {
        int n;
        if (this.m_numPolygons == 0) {
            return true;
        }
        if (this.m_dim == 0) {
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        this.assurePolygonColors();
        Color[] colorArray = this.getPolygonColors();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        for (n = 0; n < this.m_dim; ++n) {
            if (!(dArray[n] < 1.0E-10)) continue;
            dArray[n] = 1.0;
        }
        n = Math.min(3, this.m_dim);
        float[] fArray = new float[n];
        for (int i = 0; i < this.m_numPolygons; ++i) {
            pdVector.sub(PgGeometry.getCenterOfElement(pdVector2, this.m_vertex, this.m_polygon[i].m_data), pdVectorArray[0]);
            for (int j = 0; j < n; ++j) {
                fArray[j] = (float)(pdVector.m_data[j] / dArray[j]);
            }
            if (n == 1) {
                colorArray[i] = new Color(fArray[0], 0.0f, 1.0f - fArray[0]);
                continue;
            }
            if (n == 2) {
                colorArray[i] = new Color(fArray[0], fArray[1], 0.0f);
                continue;
            }
            if (n != 3) continue;
            colorArray[i] = new Color(fArray[0], fArray[1], fArray[2]);
        }
        return true;
    }

    public boolean makePolygonColorsFromZ() {
        if (this.m_numPolygons == 0) {
            return true;
        }
        if (this.m_dim == 0) {
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assurePolygonColors();
        Color[] colorArray = this.getPolygonColors();
        PdVector pdVector = new PdVector(this.m_dim);
        float f = (float)(pdVectorArray[1].m_data[n] - pdVectorArray[0].m_data[n]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        for (int i = 0; i < this.m_numPolygons; ++i) {
            pdVector = PgGeometry.getCenterOfElement(pdVector, this.m_vertex, this.m_polygon[i].m_data);
            float f2 = (float)(pdVector.m_data[n] - pdVectorArray[0].m_data[n]) / f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[i] = new Color(f2, 0.0f, 1.0f - f2);
        }
        return true;
    }

    public boolean makePolygonColorsFromZHue() {
        if (this.m_numPolygons == 0) {
            return true;
        }
        if (this.m_dim == 0) {
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assurePolygonColors();
        Color[] colorArray = this.getPolygonColors();
        PdVector pdVector = new PdVector(this.m_dim);
        float f = (float)(pdVectorArray[1].m_data[n] - pdVectorArray[0].m_data[n]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        for (int i = 0; i < this.m_numPolygons; ++i) {
            pdVector = PgGeometry.getCenterOfElement(pdVector, this.m_vertex, this.m_polygon[i].m_data);
            float f2 = (float)(pdVector.m_data[n] - pdVectorArray[0].m_data[n]) / f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[i] = new Color(Color.HSBtoRGB(0.83333f * (1.0f - f2), 1.0f, 1.0f));
        }
        return true;
    }

    public int[] getFVector() {
        int[] nArray = super.getFVector();
        int n = 0;
        for (int i = 0; i < this.m_numPolygons; ++i) {
            n += this.m_polygon[i].getSize() - 1;
        }
        int[] nArray2 = PuData.realloc(nArray, nArray.length + 1);
        nArray2[nArray.length] = n;
        return nArray2;
    }

    public PiVector[] triangulate() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        PiVector[][] piVectorArrayArray = new PiVector[this.m_numPolygons][];
        for (int i = 0; i < this.m_numPolygons; ++i) {
            n3 = this.m_polygon[i].getSize();
            if (n3 > 1 && this.m_polygon[i].m_data[n3 - 1] == this.m_polygon[i].m_data[0]) {
                --n3;
            }
            PdVector[] pdVectorArray = new PdVector[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                pdVectorArray[n2] = this.m_vertex[this.m_polygon[i].m_data[n2]];
            }
            piVectorArrayArray[i] = PgUtil.triangulate(pdVectorArray, n3);
            if (piVectorArrayArray[i] == null) continue;
            n2 = piVectorArrayArray[i].length;
            n4 += n2;
            for (n = 0; n < n2; ++n) {
                int n5 = piVectorArrayArray[i][n].getSize();
                for (int j = 0; j < n5; ++j) {
                    piVectorArrayArray[i][n].m_data[j] = this.m_polygon[i].m_data[piVectorArrayArray[i][n].m_data[j]];
                }
            }
        }
        PiVector[] piVectorArray = new PiVector[n4];
        n3 = 0;
        for (int i = 0; i < this.m_numPolygons; ++i) {
            if (piVectorArrayArray[i] == null) continue;
            n2 = piVectorArrayArray[i].length;
            for (n = 0; n < n2; ++n) {
                piVectorArray[n3] = piVectorArrayArray[i][n];
                ++n3;
            }
        }
        if (n4 == 0) {
            PsDebug.warning("triangulation failed");
            return null;
        }
        return piVectorArray;
    }

    public void flipOrientation() {
        super.flipOrientation();
        for (int i = 0; i < this.m_numPolygons; ++i) {
            if (this.m_polygon[i] == null) continue;
            int n = this.m_polygon[i].getSize();
            this.m_polygon[i].invert(n);
        }
    }

    public boolean isShowingSmoothLighting() {
        return this.m_bShowSmoothLighting;
    }

    public void showSmoothLighting(boolean bl) {
        this.m_bShowSmoothLighting = bl;
    }

    public boolean isShowingSmoothEdgeColors() {
        return this.m_bShowSmoothEdgeColors;
    }

    public void showSmoothEdgeColors(boolean bl) {
        this.m_bShowSmoothEdgeColors = bl;
    }

    public boolean isShowingEdgeColorFromVertices() {
        return this.m_bShowEdgeColorFromVertices;
    }

    public void showEdgeColorFromVertices(boolean bl) {
        this.m_bShowEdgeColorFromVertices = bl;
    }

    public boolean isShowingEdgeFromVertexColors() {
        return this.m_bShowEdgeColorFromVertices;
    }

    public void showEdgeFromVertexColors(boolean bl) {
        this.m_bShowEdgeColorFromVertices = bl;
    }

    public boolean makePolygonFromVertexColors() {
        if (!this.hasVertexColors()) {
            PsDebug.warning("missing vertex colors");
            return false;
        }
        if (this.m_numPolygons == 0) {
            return true;
        }
        this.assurePolygonColors();
        for (int i = 0; i < this.m_numPolygons; ++i) {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n = this.m_polygon[i].getSize();
            if (n == 0) continue;
            for (int j = 0; j < n; ++j) {
                f += (float)this.m_vertexColor[this.m_polygon[i].m_data[j]].getRed();
                f2 += (float)this.m_vertexColor[this.m_polygon[i].m_data[j]].getGreen();
                f3 += (float)this.m_vertexColor[this.m_polygon[i].m_data[j]].getBlue();
            }
            this.setPolygonColor(i, new Color((int)(f /= (float)n), (int)(f2 /= (float)n), (int)(f3 /= (float)n)));
        }
        return true;
    }

    public boolean makeVertexFromPolygonColors() {
        int n;
        if (!this.hasPolygonColors()) {
            PsDebug.warning("missing polygon colors");
            return false;
        }
        if (this.m_numVertices == 0) {
            return true;
        }
        int[][] nArray = new int[this.m_numVertices][3];
        int[] nArray2 = new int[this.m_numVertices];
        for (n = 0; n < this.m_numPolygons; ++n) {
            int n2 = this.m_polygon[n].getSize();
            for (int i = 0; i < n2; ++i) {
                int n3 = this.m_polygon[n].m_data[i];
                int[] nArray3 = nArray[n3];
                nArray3[0] = nArray3[0] + this.m_polygonColor[n].getRed();
                int[] nArray4 = nArray[n3];
                nArray4[1] = nArray4[1] + this.m_polygonColor[n].getGreen();
                int[] nArray5 = nArray[n3];
                nArray5[2] = nArray5[2] + this.m_polygonColor[n].getBlue();
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + 1;
            }
        }
        this.assureVertexColors();
        for (n = 0; n < this.m_numVertices; ++n) {
            if (nArray2[n] > 0) {
                this.setVertexColor(n, new Color((int)((float)nArray[n][0] / (float)nArray2[n]), (int)((float)nArray[n][1] / (float)nArray2[n]), (int)((float)nArray[n][2] / (float)nArray2[n])));
                continue;
            }
            this.setVertexColor(n, Color.black);
        }
        return true;
    }

    public boolean makePolygonColorsFromLength() {
        if (this.m_dim == 0) {
            return false;
        }
        if (this.m_numPolygons == 0) {
            return true;
        }
        this.assurePolygonColors();
        double d = this.getLength();
        double d2 = 0.0;
        float f = 0.0f;
        for (int i = 0; i < this.m_numPolygons; ++i) {
            if (d > 1.0E-10) {
                f = (float)(d2 / d);
            }
            this.setPolygonColor(i, new Color(Color.HSBtoRGB(1.0f - f, 1.0f, 1.0f)));
            d2 += this.getLengthOfPolygon(i);
        }
        return true;
    }

    public boolean makeVertexColorsFromLength() {
        if (this.m_dim == 0) {
            return false;
        }
        if (this.m_numPolygons == 0) {
            return true;
        }
        this.assureVertexColors();
        double d = this.getLength();
        double d2 = 0.0;
        float f = 0.0f;
        for (int i = 0; i < this.m_numPolygons; ++i) {
            int n = this.m_polygon[i].getSize();
            if (n == 0) continue;
            boolean bl = this.isClosed(i);
            if (bl) {
                --n;
            }
            for (int j = 0; j < n; ++j) {
                int n2 = this.m_polygon[i].m_data[j];
                if (d > 1.0E-10) {
                    f = (float)(d2 / d);
                }
                this.setVertexColor(n2, new Color(Color.HSBtoRGB(1.0f - f, 1.0f, 1.0f)));
                if (j + 1 < n) {
                    int n3 = this.m_polygon[i].m_data[j + 1];
                    d2 += this.m_vertex[n2].dist(this.m_vertex[n3]);
                    continue;
                }
                if (!bl) continue;
                d2 += this.m_vertex[n2].dist(this.m_vertex[this.m_polygon[i].m_data[j + 1]]);
            }
        }
        return true;
    }

    public static PgPolygonSet convert(PgPolygon pgPolygon) {
        if (pgPolygon == null) {
            return null;
        }
        PgPolygonSet pgPolygonSet = new PgPolygonSet(pgPolygon.getDimOfVertices());
        pgPolygonSet.merge(pgPolygon);
        pgPolygonSet.showPolygonLabels(pgPolygon.isShowingEdgeLabels());
        pgPolygonSet.showEdgeLabels(false);
        pgPolygonSet.showPolygons(pgPolygon.isShowingEdges());
        pgPolygonSet.showPolygonStartArrow(pgPolygonSet.isShowingPolygonStartArrow());
        pgPolygonSet.showPolygonEndArrow(pgPolygonSet.isShowingPolygonEndArrow());
        pgPolygonSet.setNumPolygons(1);
        int n = pgPolygon.getNumEdges();
        pgPolygonSet.setDimOfPolygons(n + 1);
        PiVector[] piVectorArray = pgPolygon.getEdges();
        PiVector piVector = pgPolygonSet.getPolygon(0);
        piVector.setEntry(0, piVectorArray[0].getEntry(0));
        for (int i = 0; i < n; ++i) {
            piVector.setEntry(i + 1, piVectorArray[i].getEntry(1));
        }
        pgPolygonSet.showSmoothLighting(pgPolygon.isShowingSmoothLighting());
        pgPolygonSet.showSmoothEdgeColors(pgPolygon.isShowingSmoothEdgeColors());
        pgPolygonSet.showEdgeColorFromVertices(pgPolygon.isShowingEdgeColorFromVertices());
        pgPolygonSet.setGlobalPolygonColor(pgPolygon.getGlobalEdgeColor());
        pgPolygonSet.setGlobalPolygonTagColor(pgPolygon.getGlobalEdgeTagColor());
        pgPolygonSet.showPolygonNormals(pgPolygon.isShowingEdgeNormals());
        pgPolygonSet.setPolygonNormals(pgPolygon.getEdgeNormals());
        pgPolygonSet.setGlobalPolygonNormalColor(pgPolygon.getGlobalEdgeNormalColor());
        pgPolygonSet.setGlobalPolygonNormalLength(pgPolygon.getGlobalEdgeNormalLength());
        pgPolygonSet.setGlobalPolygonNormalSize(pgPolygon.getGlobalEdgeNormalSize());
        pgPolygonSet.showPolygonSizes(false);
        pgPolygonSet.setGlobalPolygonSize(pgPolygon.getGlobalEdgeSize());
        return pgPolygonSet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

