/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.gui;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import jv.geom.PgElementSet;
import jv.object.PsConfig;
import jv.object.PsMainFrame;
import jv.object.PsStackLayout;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.viewer.PvViewer;
import jvx.gui.PuColorBar;

public class PaColorBar
extends Applet
implements PsUpdateIf {
    protected Frame m_frame;
    protected PgElementSet m_geom;
    protected PuColorBar m_colorBar;
    protected PdVector m_elementValues;
    protected Button m_bStart;

    public String getAppletInfo() {
        return "Name: " + this.getClass().getName() + "\r\nAuthor: Matthias Nieser\r\nVersion: 1.00\r\nApplet shows usage of color bar\r\n";
    }

    public void init() {
        this.removeAll();
        this.m_colorBar = new PuColorBar(true, true, true);
        Panel panel = new Panel((LayoutManager)new PsStackLayout(2));
        Label label = new Label("Demo of Color Bar");
        label.setFont(PsConfig.getFont((int)4));
        panel.add(label);
        panel.add((Component)this.m_colorBar.getInfoPanel());
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "North");
        this.m_colorBar.setParent((PsUpdateIf)this);
        PvViewer pvViewer = new PvViewer((Applet)this, this.m_frame);
        PvDisplayIf pvDisplayIf = pvViewer.getDisplay();
        if (this.m_geom == null) {
            this.initGeom();
            pvDisplayIf.addGeometry((PgGeometryIf)this.m_geom);
        }
        this.add((Component)pvDisplayIf, "Center");
    }

    private void initGeom() {
        this.m_geom = new PgElementSet(3);
        this.m_geom.computeSphere(20, 20, 1.0);
        this.m_geom.makeElementNormals();
        this.m_geom.showEdges(false);
        this.m_geom.showElementColors(true);
        int n = this.m_geom.getNumElements();
        this.m_elementValues = new PdVector(n);
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            PiVector piVector = this.m_geom.getElement(i);
            int n2 = piVector.getSize();
            this.m_elementValues.m_data[i] = 0.0;
            for (int j = 0; j < n2; ++j) {
                int n3 = i;
                this.m_elementValues.m_data[n3] = this.m_elementValues.m_data[n3] + this.m_geom.getVertex((int)piVector.m_data[j]).m_data[2];
            }
            int n4 = i;
            this.m_elementValues.m_data[n4] = this.m_elementValues.m_data[n4] / (double)n2;
            if (this.m_elementValues.m_data[i] > d2) {
                d2 = this.m_elementValues.m_data[i];
            }
            if (!(this.m_elementValues.m_data[i] < d)) continue;
            d = this.m_elementValues.m_data[i];
        }
        this.m_colorBar.setMinValue(d);
        this.m_colorBar.setMaxValue(d2);
        this.colorizeGeometry();
    }

    private void colorizeGeometry() {
        if (this.m_geom == null || this.m_elementValues == null) {
            return;
        }
        int n = this.m_geom.getNumElements();
        for (int i = 0; i < n; ++i) {
            this.m_geom.setElementColor(i, this.m_colorBar.getColor(this.m_elementValues.m_data[i]));
            if (this.m_colorBar.isMarked(this.m_elementValues.m_data[i])) {
                this.m_geom.setTagElement(i, 1);
                continue;
            }
            this.m_geom.clearTagElement(i, 1);
        }
    }

    public PsUpdateIf getFather() {
        return null;
    }

    public void setParent(PsUpdateIf psUpdateIf) {
    }

    public boolean update(Object object) {
        if (object == this.m_colorBar) {
            this.colorizeGeometry();
            this.m_geom.update((Object)this.m_geom);
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        PaColorBar paColorBar = new PaColorBar();
        PsMainFrame psMainFrame = new PsMainFrame((Component)paColorBar, stringArray);
        psMainFrame.setOuterBounds(420, 5, 300, 300);
        paColorBar.m_frame = psMainFrame;
        paColorBar.init();
        ((Component)paColorBar.m_frame).setVisible(true);
    }
}

