/*
 * Decompiled with CFR 0.152.
 */
package vgp.surface.common;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.object.PsUtil;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvPickEvent;
import jv.project.PvViewerIf;
import jv.vecmath.PdVector;
import vgp.surface.common.PgSurface;
import vgp.surface.common.PgSurfaceDescr;

public class PjSurface
extends PjProject {
    public static final String[][] m_parmSurface = new String[][]{{"ProjectPanel", "String", "Show", "Show models selection panel, i.e. project panel"}, {"SurfaceName", "String", "Kuen", "Name of surface, must exist corresponding descriptor: vgp.surface.common.PgSurface_NAME.java"}, {"Console", "String", "Hide", "Show/Hide VGP-console for debugging"}, {"Control", "String", "Hide", "Show/Hide control panel"}, {"Frame", "String", "Hide", "Show/Hide frame around applet"}, {"Panel", "String", "Project", "Name of initial panel if control panel is showing"}, {"Select", "String", "Import Model", "Name of default project"}, {"Project1", "String", "Import Model;\t\tjv.loader.PjImportModel", "Default project"}};
    public static final String BASE_SURFACE_NAME = "vgp.surface.common.PgSurface_";
    protected PgSurface m_geom;
    protected Vector m_sceneVec;
    protected String m_defaultName;
    protected String m_surfaceNames;
    protected String m_surfaceParams;
    protected String m_surfaceColors;
    static /* synthetic */ Class class$vgp$surface$common$PjSurface;

    public PjSurface() {
        super("Classic Surfaces");
        this.setParameterInfo(m_parmSurface);
        this.m_sceneVec = new Vector();
        this.m_geom = new PgSurface(3);
        this.m_geom.setParent((PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$surface$common$PjSurface == null ? (class$vgp$surface$common$PjSurface = PjSurface.class$("vgp.surface.common.PjSurface")) : class$vgp$surface$common$PjSurface)) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void start() {
        PsDebug.notify((String)"called");
        PvViewerIf pvViewerIf = this.getViewer();
        if (pvViewerIf != null) {
            String string = pvViewerIf.getParameter("SurfaceName");
            String string2 = pvViewerIf.getParameter("SurfaceParams");
            String string3 = pvViewerIf.getParameter("SurfaceColors");
            this.setSurfaceNames(string, string2, string3);
            this.m_defaultName = this.m_surfaceNames;
        }
        this.loadSurfaces();
        this.update((Object)this);
        this.m_geom.update((Object)this.m_geom);
        super.start();
    }

    public void setSurfaceNames(String string, String string2, String string3) {
        this.m_surfaceNames = string;
        this.m_surfaceParams = string2;
        this.m_surfaceColors = string3;
    }

    public boolean loadSurfaces(String string, String string2, String string3) {
        this.setSurfaceNames(string, string2, string3);
        return this.loadSurfaces();
    }

    private static PgSurfaceDescr createDescr(String string) {
        PgSurfaceDescr pgSurfaceDescr = (PgSurfaceDescr)((Object)PsUtil.newInstance((String)string));
        if (pgSurfaceDescr == null) {
            PsDebug.warning((String)("missing surface descriptor = " + string));
            return null;
        }
        return pgSurfaceDescr;
    }

    protected boolean loadSurfaces() {
        String string;
        PgSurfaceDescr pgSurfaceDescr;
        int n = this.m_surfaceNames.indexOf(59);
        if (n == -1) {
            n = this.m_surfaceNames.length();
        }
        if ((pgSurfaceDescr = PjSurface.createDescr(string = BASE_SURFACE_NAME + this.m_surfaceNames.substring(0, n))) == null) {
            PsDebug.warning((String)("missing surface descriptor = " + string));
            pgSurfaceDescr = PjSurface.createDescr(BASE_SURFACE_NAME + this.m_defaultName);
            if (pgSurfaceDescr == null) {
                return false;
            }
        }
        this.removeGeometries();
        this.m_sceneVec.removeAllElements();
        this.m_geom.init();
        this.m_geom.setDimOfVertices(pgSurfaceDescr.getDimOfSurface());
        this.m_geom.setDescr(pgSurfaceDescr);
        this.m_geom.computeSurface();
        this.m_sceneVec.addElement(this.m_geom);
        String string2 = this.m_surfaceParams;
        int n2 = -1;
        if (string2 != null) {
            n2 = string2.indexOf(59);
            if (n2 == -1) {
                n2 = string2.length();
            }
            this.parseParams(this.m_geom, string2.substring(0, n2));
            if (n2 == string2.length()) {
                string2 = "";
                n2 = 0;
            } else if ((n2 = (string2 = string2.substring(n2 + 1)).indexOf(59)) == -1) {
                n2 = string2.length();
            }
        }
        String string3 = this.m_surfaceColors;
        int n3 = -1;
        if (string3 != null) {
            n3 = string3.indexOf(59);
            if (n3 == -1) {
                n3 = string3.length();
            }
            this.parseColors(this.m_geom, string3.substring(0, n3));
            if (n3 == string3.length()) {
                string3 = "";
                n3 = 0;
            } else if ((n3 = (string3 = string3.substring(n3 + 1)).indexOf(59)) == -1) {
                n3 = string3.length();
            }
        }
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        n = this.m_surfaceNames.indexOf(59);
        while (n != -1) {
            int n4 = this.m_surfaceNames.indexOf(59, n + 1);
            if (n4 == -1) {
                n4 = this.m_surfaceNames.length();
            }
            if ((pgSurfaceDescr = PjSurface.createDescr(string = BASE_SURFACE_NAME + this.m_surfaceNames.substring(n + 1, n4))) == null) {
                PsDebug.warning((String)("missing surface descriptor = " + string));
                return false;
            }
            PgSurface pgSurface = new PgSurface(pgSurfaceDescr.getDimOfSurface());
            pgSurface.setDescr(pgSurfaceDescr);
            pgSurface.computeSurface();
            this.m_sceneVec.addElement(pgSurface);
            if (string2 != null) {
                this.parseParams(pgSurface, string2.substring(0, n2));
                if (n2 == string2.length()) {
                    string2 = "";
                    n2 = 0;
                } else if ((n2 = (string2 = string2.substring(n2 + 1)).indexOf(59)) == -1) {
                    n2 = string2.length();
                }
            }
            if (string3 != null) {
                this.parseColors(pgSurface, string3.substring(0, n3));
                if (n3 == string3.length()) {
                    string3 = "";
                    n3 = 0;
                } else if ((n3 = (string3 = string3.substring(n3 + 1)).indexOf(59)) == -1) {
                    n3 = string3.length();
                }
            }
            this.addGeometry((PgGeometryIf)pgSurface);
            n = this.m_surfaceNames.indexOf(59, n + 1);
        }
        PsPanel psPanel = this.getInfoPanel();
        if (psPanel != null) {
            psPanel.setParent((PsUpdateIf)this);
        }
        return true;
    }

    private void parseColors(PgSurface pgSurface, String string) {
        char c;
        int n = 0;
        if (n < string.length()) {
            c = string.charAt(n);
            if (c != ',') {
                pgSurface.setGlobalVertexColor(this.transColors(c));
                ++n;
            }
            ++n;
        }
        if (n < string.length()) {
            c = string.charAt(n);
            if (c != ',') {
                pgSurface.setGlobalEdgeColor(this.transColors(c));
                ++n;
            }
            ++n;
        }
        if (n < string.length()) {
            c = string.charAt(n);
            if (c != ',') {
                pgSurface.setGlobalElementColor(this.transColors(c));
                ++n;
            }
            ++n;
        }
        if (n < string.length()) {
            c = string.charAt(n);
            if (c != ',') {
                pgSurface.setGlobalBndColor(this.transColors(c));
                ++n;
            }
            ++n;
        }
    }

    private void parseParams(PgSurface pgSurface, String string) {
        if (string.indexOf(118) != -1) {
            pgSurface.showVertices(false);
        }
        if (string.indexOf(86) != -1) {
            pgSurface.showVertices(true);
        }
        if (string.indexOf(108) != -1) {
            pgSurface.showEdges(false);
        }
        if (string.indexOf(76) != -1) {
            pgSurface.showEdges(true);
        }
        if (string.indexOf(101) != -1) {
            pgSurface.showElements(false);
        }
        if (string.indexOf(69) != -1) {
            pgSurface.showElements(true);
        }
        if (string.indexOf(98) != -1) {
            pgSurface.showBoundaries(false);
        }
        if (string.indexOf(66) != -1) {
            pgSurface.showBoundaries(true);
        }
        if (string.indexOf(110) != -1) {
            pgSurface.showVertexNormals(false);
        }
        if (string.indexOf(78) != -1) {
            pgSurface.showVertexNormals(true);
        }
        if (string.indexOf(109) != -1) {
            pgSurface.showElementNormals(false);
        }
        if (string.indexOf(77) != -1) {
            pgSurface.showElementNormals(true);
        }
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        if (this.m_sceneVec.size() > 1) {
            PgSurfaceDescr pgSurfaceDescr = this.m_geom.getDescr();
            if (pgSurfaceDescr == null) {
                return;
            }
            for (int i = 1; i < this.m_sceneVec.size(); ++i) {
                Enumeration enumeration = pgSurfaceDescr.getParameters();
                if (enumeration == null) continue;
                PgSurface pgSurface = (PgSurface)((Object)this.m_sceneVec.elementAt(i));
                PgSurfaceDescr pgSurfaceDescr2 = pgSurface.getDescr();
                while (enumeration.hasMoreElements()) {
                    PuDouble puDouble = (PuDouble)enumeration.nextElement();
                    String string = puDouble.getName();
                    PuDouble puDouble2 = null;
                    if (string.length() >= 3) {
                        PdVector pdVector = pvPickEvent.getVertex();
                        if (string.substring(string.length() - 3).equalsIgnoreCase("(x)")) {
                            puDouble2 = (PuDouble)pgSurfaceDescr2.getParameter(string);
                            if (puDouble2 != null) {
                                puDouble2.setValue(pdVector.m_data[0]);
                            }
                        } else if (string.substring(string.length() - 3).equalsIgnoreCase("(y)") && (puDouble2 = (PuDouble)pgSurfaceDescr2.getParameter(string)) != null) {
                            puDouble2.setValue(pdVector.m_data[1]);
                        }
                        if (string.substring(string.length() - 3).equalsIgnoreCase("(z)") && (puDouble2 = (PuDouble)pgSurfaceDescr2.getParameter(string)) != null) {
                            puDouble2.setValue(pdVector.m_data[2]);
                        }
                    }
                    if (puDouble2 == null) continue;
                    puDouble2.update(puDouble2);
                }
            }
        }
    }

    private Color transColors(char c) {
        switch (c) {
            case 'k': {
                return Color.black;
            }
            case 'y': {
                return Color.yellow;
            }
            case 'm': {
                return Color.magenta;
            }
            case 'c': {
                return Color.cyan;
            }
            case 'b': {
                return Color.blue;
            }
            case 'g': {
                return Color.green;
            }
            case 'r': {
                return Color.red;
            }
            case 'w': {
                return Color.white;
            }
            case '1': {
                return new Color(255, 180, 130);
            }
            case '2': {
                return new Color(200, 0, 0);
            }
        }
        return Color.black;
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"called");
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_geom) {
            if (this.m_sceneVec.size() > 1) {
                PgSurfaceDescr pgSurfaceDescr = this.m_geom.getDescr();
                if (pgSurfaceDescr == null) {
                    return true;
                }
                for (int i = 1; i < this.m_sceneVec.size(); ++i) {
                    Enumeration enumeration = pgSurfaceDescr.getParameters();
                    if (enumeration == null) continue;
                    PgSurface pgSurface = (PgSurface)((Object)this.m_sceneVec.elementAt(i));
                    PgSurfaceDescr pgSurfaceDescr2 = pgSurface.getDescr();
                    while (enumeration.hasMoreElements()) {
                        PuDouble puDouble;
                        String string;
                        PuDouble puDouble2;
                        Object e = enumeration.nextElement();
                        if (e instanceof PuDouble) {
                            puDouble2 = (PuDouble)e;
                            string = puDouble2.getName();
                            puDouble = (PuDouble)pgSurfaceDescr2.getParameter(string);
                            if (puDouble == null) continue;
                            puDouble.setValue(puDouble2.getValue());
                            puDouble.update((Object)puDouble);
                            continue;
                        }
                        if (!(e instanceof PuInteger) || (puDouble = (PuInteger)pgSurfaceDescr2.getParameter(string = (puDouble2 = (PuInteger)e).getName())) == null) continue;
                        puDouble.setValue(puDouble2.getValue());
                        puDouble.update((Object)puDouble);
                    }
                }
            }
            return true;
        }
        return super.update(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

