/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_CatEnn
extends PgWeierstrassDescr {
    private final double m_defaultRadius = 2.0;
    private final double m_defaultRadius1 = 2.0;
    private final int m_defaultSymmetry = 2;
    private final double m_defaultEps = 0.1;
    protected PuDouble m_dRadius;
    protected PuDouble m_dRadius1;
    protected PuInteger m_iSymmetry;
    protected PuDouble m_dEps;
    private double m_radius = 2.0;
    private double m_radius1 = 2.0;
    private int m_symmetry = 2;
    private double m_eps = 0.1;
    static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_CatEnn;

    public PgWeierstrass_CatEnn() {
        super(1);
        this.setName("Catenoid - Enneper order 2");
        this.m_dRadius = new PuDouble("Radius", (PsUpdateIf)this);
        this.m_dRadius1 = new PuDouble("Radius 1", (PsUpdateIf)this);
        this.m_iSymmetry = new PuInteger("Symmetry", (PsUpdateIf)this);
        this.m_dEps = new PuDouble("Morphing", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_CatEnn == null ? (class$vgp$minimal$weier$PgWeierstrass_CatEnn = PgWeierstrass_CatEnn.class$("vgp.minimal.weier.PgWeierstrass_CatEnn")) : class$vgp$minimal$weier$PgWeierstrass_CatEnn)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addParameter((PsObject)this.m_conjugation);
        this.m_numLines[0].setDefBounds(3, 65, 1, 10);
        this.m_numLines[0].setDefValue(33);
        this.m_numLines[0].init();
        this.addParameter((PsObject)this.m_numLines[0]);
        this.m_numLines[1].setDefBounds(7, 300, 1, 10);
        this.m_numLines[1].setDefValue(17);
        this.m_numLines[1].init();
        this.addParameter((PsObject)this.m_numLines[1]);
        this.m_dRadius.setDefBounds(0.5, 5.0, 0.1, 1.0);
        this.m_dRadius.setDefValue(2.0);
        this.m_dRadius.init();
        this.addParameter((PsObject)this.m_dRadius);
        this.m_dRadius1.setDefBounds(0.5, 5.0, 0.1, 1.0);
        this.m_dRadius1.setDefValue(2.0);
        this.m_dRadius1.init();
        this.addParameter((PsObject)this.m_dRadius1);
        this.m_iSymmetry.setDefBounds(2, 20, 1, 5);
        this.m_iSymmetry.setDefValue(2);
        this.m_iSymmetry.init();
        this.addParameter((PsObject)this.m_iSymmetry);
        this.m_dEps.setDefBounds(0.0, 0.5, 0.1, 1.0);
        this.m_dEps.setDefValue(0.1);
        this.m_dEps.init();
        this.addParameter((PsObject)this.m_dEps);
        this.setDomain(0, -2.0, 2.0, 0.0, Math.PI / (double)this.m_symmetry);
    }

    public boolean update(Object object) {
        if (object == this.m_dRadius) {
            this.m_radius = this.m_dRadius.getValue();
            this.setUMin(0, -this.m_radius);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_dRadius1) {
            this.m_radius1 = this.m_dRadius1.getValue();
            this.setUMax(0, this.m_radius1);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_iSymmetry) {
            this.m_symmetry = this.m_iSymmetry.getValue();
            this.setVMax(0, Math.PI / (double)this.m_symmetry);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_dEps) {
            this.m_eps = this.m_dEps.getValue();
            return this.m_parent.update((Object)this);
        }
        return super.update(object);
    }

    public PuComplex transform(PuComplex puComplex) {
        return PuComplex.polarToRect((double)Math.exp(puComplex.re), (double)puComplex.im);
    }

    public PuComplex f(PuComplex puComplex) {
        return PuComplex.ONE;
    }

    public PuComplex g(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.blend((double)(1.0 - this.m_eps), (PuComplex)PuComplex.inv((PuComplex)puComplex), (double)this.m_eps, (PuComplex)PuComplex.pow((PuComplex)puComplex, (int)(this.m_symmetry - 1)));
        return puComplex2;
    }

    public PuComplex[] getFStart(int n) {
        PuComplex[] puComplexArray = new PuComplex[this.m_vertDim];
        puComplexArray[0] = new PuComplex(0.0, 0.0);
        puComplexArray[1] = new PuComplex(0.0, 0.0);
        puComplexArray[2] = new PuComplex(0.0, Math.PI * -2);
        return puComplexArray;
    }

    public void getReflections() {
        for (int i = 0; i < this.m_symmetry; ++i) {
            this.reflectPart(2 * i + 1, 2 * i, 0);
            this.reflectPart(2 * i + 2, 2 * i + 1, 2);
        }
    }

    public void getBndReflectType(PiVector piVector, int n, PiVector piVector2) {
        if (piVector == null && n == 0) {
            piVector2.m_data[0] = 0;
            piVector2.m_data[2] = 0;
        }
    }

    public int getNumParts() {
        return 2 * this.m_symmetry;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

