/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_Cameloid
extends PgWeierstrassDescr {
    private final double m_defaultRadius = 1.0;
    private final double m_defaultS = 0.3;
    protected PuDouble m_dRadius;
    protected PuDouble m_dS;
    private double m_radius = 1.0;
    private double m_s = 0.3;
    private double m_q = 0.0;
    static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_Cameloid;

    public PgWeierstrass_Cameloid() {
        super(8, 3);
        this.setName("Cameloid Surface");
        this.m_dRadius = new PuDouble("Radius", (PsUpdateIf)this);
        this.m_dS = new PuDouble("S", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_Cameloid == null ? (class$vgp$minimal$weier$PgWeierstrass_Cameloid = PgWeierstrass_Cameloid.class$("vgp.minimal.weier.PgWeierstrass_Cameloid")) : class$vgp$minimal$weier$PgWeierstrass_Cameloid)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addParameter((PsObject)this.m_conjugation);
        this.m_numLines[0].setDefBounds(3, 65, 1, 10);
        this.m_numLines[0].setDefValue(7);
        this.m_numLines[0].init();
        this.addParameter((PsObject)this.m_numLines[0]);
        this.m_numLines[1].setDefBounds(3, 65, 1, 10);
        this.m_numLines[1].setDefValue(7);
        this.m_numLines[1].init();
        this.addParameter((PsObject)this.m_numLines[1]);
        this.m_numLines[2].setDefBounds(3, 65, 1, 10);
        this.m_numLines[2].setDefValue(7);
        this.m_numLines[2].init();
        this.addParameter((PsObject)this.m_numLines[2]);
        this.m_dRadius.setDefBounds(0.2, 10.0, 0.1, 1.0);
        this.m_dRadius.setDefValue(1.0);
        this.m_dRadius.init();
        this.addParameter((PsObject)this.m_dRadius);
        this.m_dS.setDefBounds(0.001, 1.0, 0.05, 0.2);
        this.m_dS.setDefValue(0.3);
        this.m_dS.init();
        this.addParameter((PsObject)this.m_dS);
        double d = -2.0 * Math.log(this.m_s);
        this.setDomain(0, 0.0, 1.5707963267948966, -1.0 - d - this.m_s, -d);
        this.setDomain(1, 0.0, 1.5707963267948966, -d, 0.0);
        this.setDomain(2, 0.0, 1.5707963267948966, 0.0, d);
        this.setDomain(3, 0.0, 1.5707963267948966, d, 1.0 + d + this.m_s);
        this.setDomain(4, -1.0 - d - this.m_s, -d, 0.0, 1.5707963267948966);
        this.setDomain(5, -d, 0.0, 0.0, 1.5707963267948966);
        this.setDomain(6, 0.0, d, 0.0, 1.5707963267948966);
        this.setDomain(7, d, 1.0 + d + this.m_s, 0.0, 1.5707963267948966);
        this.calculateQ();
    }

    public boolean update(Object object) {
        if (object == this.m_dRadius) {
            this.m_radius = this.m_dRadius.getValue();
            double d = -2.0 * Math.log(this.m_s);
            this.setVMin(0, -this.m_radius - d);
            this.setVMax(3, this.m_radius + d);
            this.setUMin(4, -this.m_radius - d);
            this.setUMax(7, this.m_radius + d);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_dS) {
            this.m_s = this.m_dS.getValue();
            this.calculateQ();
            double d = -2.0 * Math.log(this.m_s);
            this.setVMin(0, -this.m_radius - d - this.m_s);
            this.setVMax(0, -d);
            this.setVMin(1, -d);
            this.setVMax(2, d);
            this.setVMin(3, d);
            this.setVMax(3, this.m_radius + d + this.m_s);
            this.setUMin(4, -this.m_radius - d - this.m_s);
            this.setUMax(4, -d);
            this.setUMin(5, -d);
            this.setUMax(6, d);
            this.setUMin(7, d);
            this.setUMax(7, this.m_radius + d + this.m_s);
            return this.m_parent.update((Object)this);
        }
        return super.update(object);
    }

    public int getNumULines(int n) {
        if (n < 4) {
            return this.m_numLines[0].getValue();
        }
        if (n == 4 || n == 7) {
            return this.m_numLines[2].getValue();
        }
        return this.m_numLines[1].getValue();
    }

    public int getNumVLines(int n) {
        if (n > 3) {
            return this.m_numLines[0].getValue();
        }
        if (n == 0 || n == 3) {
            return this.m_numLines[2].getValue();
        }
        return this.m_numLines[1].getValue();
    }

    public PuComplex transform(int n, PuComplex puComplex) {
        PuComplex puComplex2 = n < 4 ? PuComplex.polarToRect((double)Math.exp(puComplex.im), (double)puComplex.re) : PuComplex.polarToRect((double)Math.exp(puComplex.re), (double)(1.5707963267948966 - puComplex.im));
        double d = 1.0 / (this.m_s * this.m_s);
        puComplex2 = PuComplex.moebius((double)d, (double)-1.0, (double)1.0, (double)d, (PuComplex)puComplex2);
        if (puComplex2.im < 0.0) {
            puComplex2.im = 0.0;
        }
        puComplex2.sqrt();
        puComplex2 = PuComplex.moebius((double)1.0, (double)-1.0, (double)1.0, (double)1.0, (PuComplex)puComplex2);
        if (n > 3) {
            puComplex2 = PuComplex.moebius((PuComplex)PuComplex.NEG_ONE, (PuComplex)PuComplex.I, (PuComplex)PuComplex.NEG_I, (PuComplex)PuComplex.ONE, (PuComplex)puComplex2);
        }
        if (puComplex2.im < 0.0) {
            puComplex2.im = 0.0;
        }
        if (puComplex2.abs() > 1.0) {
            puComplex2.mult(1.0 / puComplex2.abs());
        }
        return puComplex2;
    }

    private void calculateQ() {
        if (Math.abs(this.m_s - 1.0) < 1.0E-10) {
            this.m_q = 0.0;
        } else {
            double d = this.m_s * this.m_s;
            double d2 = d * d;
            this.m_q = 1.0 + (6.0 * d2 - 2.0) / (1.0 + 3.0 * d - 3.0 * d2 - d * d2) + (1.0 + d2) * Math.sqrt(1.0 + 4.0 * d - 6.0 * d2 + 4.0 * d * d2 + d2 * d2) / (this.m_s * (1.0 + 4.0 * d + d2) * (d - 1.0));
        }
    }

    public PuComplex f(PuComplex puComplex) {
        double d = this.m_s * this.m_s;
        PuComplex puComplex2 = PuComplex.add((PuComplex)puComplex, (double)1.0);
        puComplex2.sqr();
        PuComplex puComplex3 = PuComplex.sub((PuComplex)puComplex, (double)1.0);
        puComplex3.sqr();
        PuComplex puComplex4 = PuComplex.mult((PuComplex)puComplex3, (double)this.m_q);
        puComplex4.add(puComplex2);
        PuComplex puComplex5 = PuComplex.mult((PuComplex)PuComplex.sub((PuComplex)puComplex3, (PuComplex)PuComplex.mult((PuComplex)puComplex2, (double)d)), (PuComplex)PuComplex.add((PuComplex)PuComplex.mult((PuComplex)puComplex3, (double)d), (PuComplex)puComplex2));
        puComplex4.div(puComplex5);
        puComplex4.sqr();
        puComplex4.mult(puComplex2);
        puComplex4.mult(d * this.m_s * (1.0 + this.m_s) * (1.0 + this.m_s));
        puComplex4.mult(2.0);
        return puComplex4;
    }

    public PuComplex g(PuComplex puComplex) {
        if (puComplex.re == -1.0 && puComplex.im == 0.0) {
            return PuComplex.ONE;
        }
        PuComplex puComplex2 = PuComplex.add((PuComplex)puComplex, (double)1.0);
        PuComplex puComplex3 = PuComplex.sub((PuComplex)puComplex, (double)1.0);
        PuComplex puComplex4 = PuComplex.div((PuComplex)puComplex3, (PuComplex)puComplex2);
        puComplex2.sqr();
        puComplex3.sqr();
        puComplex4.mult(PuComplex.sub((PuComplex)puComplex3, (PuComplex)PuComplex.mult((PuComplex)puComplex2, (double)this.m_q)));
        puComplex4.div(PuComplex.add((PuComplex)PuComplex.mult((PuComplex)puComplex3, (double)this.m_q), (PuComplex)puComplex2));
        return puComplex4;
    }

    public void getConnections(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            this.connectPart(1, 0, 0, 2);
            this.connectPart(2, 0, 1, 2);
            this.connectPart(3, 0, 2, 2);
            this.connectPart(4, 0, 3, 1);
            this.connectPart(5, 0, 2, 1);
            this.connectPart(6, 0, 1, 1);
            this.connectPart(7, 0, 0, 1);
            this.connectPart(5, 3, 4, 1);
            this.connectPart(6, 3, 5, 1);
            this.connectPart(7, 3, 6, 1);
        }
        if (piVector == null) {
            this.connectPart(0, 2, 2, 2);
            this.connectPart(0, 3, 2, 3);
            this.connectPart(1, 2, 3, 2);
            this.connectPart(1, 3, 3, 3);
            this.connectPart(1, 5, 3, 5);
        }
    }

    public int getNumParts(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            return 8;
        }
        return 4;
    }

    public void getReflections(PiVector piVector) {
        if (piVector == null) {
            this.reflectPart(1, 0, 1);
            this.reflectPart(2, 0, 5);
            this.reflectPart(3, 2, 1);
        }
    }

    public void getBndReflectType(PiVector piVector, int n, PiVector piVector2) {
        if (this.equals(piVector, 0)) {
            if (n == 0) {
                piVector2.m_data[3] = 0;
            } else if (n == 1) {
                piVector2.m_data[3] = 0;
            } else if (n == 2) {
                piVector2.m_data[3] = 0;
            } else if (n == 3) {
                piVector2.m_data[3] = 0;
            } else if (n == 4) {
                piVector2.m_data[2] = 0;
            } else if (n == 5) {
                piVector2.m_data[2] = 0;
            } else if (n == 6) {
                piVector2.m_data[2] = 0;
            } else if (n == 7) {
                piVector2.m_data[2] = 0;
            }
        }
    }

    public boolean connectReflection(PiVector piVector, int n) {
        return true;
    }

    public boolean partIsSubdivided(PiVector piVector, int n) {
        return piVector == null && n == 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

