/*
 * Decompiled with CFR 0.152.
 */
package vgp.imageSource;

import jv.function.PuFunction;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.imageDisplay.PiImageSource;

public class PiFunctionGraph
extends PiImageSource {
    protected static final int COLOR_BLACK = 1;
    protected static final int COLOR_REDBLACK = 2;
    protected static final int COLOR_HUE = 3;
    protected static final int COLOR_HUEOFFSET = 4;
    protected static final int NUM_COLORS = 256;
    private PdVector m_pixIter;
    protected PuDouble m_maxValue;
    private PiVector m_colMap;
    protected PuInteger m_hueOffset;
    protected PuFunction m_function;
    static /* synthetic */ Class class$vgp$imageSource$PiFunctionGraph;

    public PiFunctionGraph() {
        this.setName("Function Graph");
        this.m_pixIter = new PdVector();
        this.m_maxValue = new PuDouble("Max Value", (PsUpdateIf)this);
        this.m_colMap = new PiVector();
        this.m_hueOffset = new PuInteger("Hue Offset", (PsUpdateIf)this);
        this.m_function = new PuFunction(2, 1);
        this.m_function.setParent((PsUpdateIf)this);
        this.m_function.setName("Function");
        if (((Object)((Object)this)).getClass() == (class$vgp$imageSource$PiFunctionGraph == null ? (class$vgp$imageSource$PiFunctionGraph = PiFunctionGraph.class$("vgp.imageSource.PiFunctionGraph")) : class$vgp$imageSource$PiFunctionGraph)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_pixIter.setSize(0);
        this.m_maxValue.setDefBounds(0.0, 2.0, 0.01, 0.02);
        this.m_maxValue.setDefValue(1.0);
        this.m_maxValue.init();
        this.m_colMap.setSize(256);
        this.m_hueOffset.setDefBounds(0, 255, 1, 5);
        this.m_hueOffset.setDefValue(0);
        this.m_hueOffset.init();
        this.m_function.setVariables(new String[]{"u", "v"});
        this.m_function.setExpression("100*cos(u)*cos(v)");
        this.setDomainBounds(-3.0, -3.0, 3.0, 3.0);
        this.m_function.setExpression("cos((u*u+v*v)*10)*exp(-(u*u+v*v)/50)");
        this.setDomainBounds(-15.0, -15.0, 15.0, 15.0);
    }

    public boolean update(Object object) {
        if (object == this.m_maxValue) {
            this.computeColors();
            return super.update((Object)this);
        }
        if (object == this.m_hueOffset) {
            this.computeColors();
            return super.update((Object)this);
        }
        if (object == this.m_function) {
            this.compute();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    protected boolean setImageSize(int n, int n2) {
        if (!super.setImageSize(n, n2)) {
            return false;
        }
        this.m_pixIter.setSize(this.m_imageWidth * this.m_imageHeight);
        return true;
    }

    public synchronized void compute() {
        if (this.m_imageWidth <= 0 || this.m_imageHeight <= 0) {
            return;
        }
        int n = this.m_blockSize.getValue();
        double d = this.m_domainBounds.m_data[0];
        double d2 = this.m_domainBounds.m_data[2];
        double d3 = this.m_domainBounds.m_data[1];
        double d4 = this.m_domainBounds.m_data[3];
        this.compute(this.m_pixIter.m_data, this.m_imageWidth, this.m_imageHeight, n, d, d3, d2, d4);
        this.computeColors();
    }

    private void compute(double[] dArray, int n, int n2, int n3, double d, double d2, double d3, double d4) {
        if (n <= 1 || n2 <= 1) {
            return;
        }
        double d5 = (double)n3 * (d3 - d) / ((double)n - 1.0);
        double d6 = (double)n3 * (d4 - d2) / ((double)n2 - 1.0);
        int n4 = 0;
        double d7 = d4 - d6 / 2.0;
        for (int i = 0; i < n2; i += n3) {
            int n5;
            int n6 = n4;
            double d8 = d + d5 / 2.0;
            for (n5 = 0; n5 < n; n5 += n3) {
                double d9 = this.m_function.eval(d8, d7);
                int n7 = Math.min(n3, n - n5);
                for (int j = 0; j < n7; ++j) {
                    dArray[n4++] = d9;
                }
                d8 += d5;
            }
            n5 = Math.min(n3, n2 - i) - 1;
            for (int j = 0; j < n5; ++j) {
                System.arraycopy(dArray, n6, dArray, n4, n);
                n4 += n;
            }
            d7 -= d6;
        }
    }

    public void computeColors() {
        if (this.m_imageWidth <= 0 || this.m_imageHeight <= 0) {
            return;
        }
        int n = this.m_hueOffset.getValue();
        double d = this.m_maxValue.getValue();
        int n2 = this.m_imageWidth * this.m_imageHeight;
        this.computeColors(this.m_pix.m_data, this.m_pixIter.m_data, n2, d, 4, n);
        super.computeColors();
    }

    private void computeColors(int[] nArray, double[] dArray, int n, double d, int n2, int n3) {
        int n4;
        for (n4 = 0; n4 < 256; ++n4) {
            int n5 = 0;
            if (n4 == 0) {
                n5 = -13158601;
            } else {
                int n6 = 0;
                switch (n2) {
                    case 2: {
                        n5 = 0xFF000000 | (50 + 205 * n4 / 256) % 255 << 16 | 0 | 0;
                        break;
                    }
                    case 4: {
                        n6 += n3;
                    }
                    case 3: {
                        if ((n6 += 205 * n4 / 256) > 255) {
                            n6 -= 255;
                        }
                        n5 = PdColor.hsv2rgbAsInt((int)n6, (int)255, (int)255);
                        break;
                    }
                    case 1: {
                        n5 = 0;
                    }
                }
            }
            this.m_colMap.m_data[n4] = n5;
        }
        for (n4 = 0; n4 < n; ++n4) {
            double d2 = Math.min(Math.abs(dArray[n4]), d) / d;
            nArray[n4] = this.m_colMap.m_data[(int)(255.0 * d2)];
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

