/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.parser;

import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fife.io.DocumentReader;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser
extends AbstractParser {
    private SAXParserFactory spf;
    private DefaultParseResult result = new DefaultParseResult(this);

    public XmlParser() {
        try {
            this.spf = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError fce) {
            fce.printStackTrace();
        }
    }

    @Override
    public ParseResult parse(RSyntaxDocument doc, String style) {
        this.result.clearNotices();
        Element root = doc.getDefaultRootElement();
        this.result.setParsedLines(0, root.getElementCount() - 1);
        if (this.spf == null) {
            return this.result;
        }
        try {
            SAXParser sp = this.spf.newSAXParser();
            Handler handler = new Handler(doc);
            DocumentReader r = new DocumentReader(doc);
            InputSource input = new InputSource(r);
            sp.parse(input, (DefaultHandler)handler);
            r.close();
        }
        catch (SAXParseException sp) {
        }
        catch (Exception e) {
            e.printStackTrace();
            this.result.addNotice(new DefaultParserNotice(this, "Error parsing XML: " + e.getMessage(), 0, -1, -1));
        }
        return this.result;
    }

    private class Handler
    extends DefaultHandler {
        private Document doc;

        private Handler(Document doc) {
            this.doc = doc;
        }

        private void doError(SAXParseException e, int level) {
            int line = e.getLineNumber() - 1;
            Element root = this.doc.getDefaultRootElement();
            Element elem = root.getElement(line);
            int offs = elem.getStartOffset();
            int len = elem.getEndOffset() - offs;
            if (line == root.getElementCount() - 1) {
                ++len;
            }
            DefaultParserNotice pn = new DefaultParserNotice(XmlParser.this, e.getMessage(), line, offs, len);
            pn.setLevel(level);
            XmlParser.this.result.addNotice(pn);
        }

        @Override
        public void error(SAXParseException e) {
            this.doError(e, 0);
        }

        @Override
        public void fatalError(SAXParseException e) {
            this.doError(e, 0);
        }

        @Override
        public void warning(SAXParseException e) {
            this.doError(e, 1);
        }
    }
}

