/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.statistics.distribution;

import net.doodleproject.numerics4j.exception.NumericException;
import net.doodleproject.numerics4j.special.Beta;
import net.doodleproject.numerics4j.statistics.distribution.ContinuousDistribution;

public class TDistribution
extends ContinuousDistribution {
    private double degreesOfFreedom;

    public TDistribution() {
        this(1.0);
    }

    public TDistribution(double df) {
        this.setDegreesOfFreedom(df);
    }

    @Override
    public double cumulativeProbability(double x) throws NumericException {
        double ret;
        if (x == 0.0) {
            ret = 0.5;
        } else {
            double df = this.getDegreesOfFreedom();
            double t = Beta.regularizedBeta(df / (df + x * x), 0.5 * df, 0.5);
            ret = x < 0.0 ? 0.5 * t : 1.0 - 0.5 * t;
        }
        return ret;
    }

    public double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    @Override
    public double inverseCumulativeProbability(double p) throws NumericException {
        double ret = p < 0.0 || p > 1.0 || Double.isNaN(p) ? Double.NaN : (p == 0.0 ? Double.NEGATIVE_INFINITY : (p == 1.0 ? Double.POSITIVE_INFINITY : (p <= 0.5 ? this.findInverseCumulativeProbability(p, Double.NEGATIVE_INFINITY, -this.getDegreesOfFreedom(), 0.0) : this.findInverseCumulativeProbability(p, 0.0, this.getDegreesOfFreedom(), Double.POSITIVE_INFINITY))));
        return ret;
    }

    public void setDegreesOfFreedom(double df) {
        if (df <= 0.0 || Double.isNaN(df)) {
            throw new IllegalArgumentException("Degrees of freedom must be positive.");
        }
        this.degreesOfFreedom = df;
    }
}

