/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.special;

import net.doodleproject.numerics4j.continuedfraction.ContinuedFraction;
import net.doodleproject.numerics4j.exception.NumericException;
import net.doodleproject.numerics4j.special.Gamma;

public final class Beta {
    private Beta() {
    }

    public static double logBeta(double a, double b) {
        double ret = Double.isNaN(a) || Double.isNaN(b) || a <= 0.0 || b <= 0.0 ? Double.NaN : Gamma.logGamma(a) + Gamma.logGamma(b) - Gamma.logGamma(a + b);
        return ret;
    }

    public static double regularizedBeta(double x, final double a, final double b) throws NumericException {
        double ret;
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b) || x < 0.0 || x > 1.0 || a <= 0.0 || b <= 0.0) {
            ret = Double.NaN;
        } else if (x > (a + 1.0) / (a + b + 2.0)) {
            ret = 1.0 - Beta.regularizedBeta(1.0 - x, b, a);
        } else {
            ContinuedFraction fraction = new ContinuedFraction(){

                @Override
                protected double getA(int n, double x) {
                    return 1.0;
                }

                @Override
                protected double getB(int n, double x) {
                    double ret;
                    if (n % 2 == 0) {
                        double m = (double)n / 2.0;
                        ret = m * (b - m) * x / ((a + 2.0 * m - 1.0) * (a + 2.0 * m));
                    } else {
                        double m = ((double)n - 1.0) / 2.0;
                        ret = -((a + m) * (a + b + m) * x) / ((a + 2.0 * m) * (a + 2.0 * m + 1.0));
                    }
                    return ret;
                }
            };
            ret = Math.exp(a * Math.log(x) + b * Math.log(1.0 - x) - Math.log(a) - Beta.logBeta(a, b)) / fraction.evaluate(x);
        }
        return ret;
    }
}

