/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.series;

import net.doodleproject.numerics4j.IterativeMethod;
import net.doodleproject.numerics4j.exception.ConvergenceException;
import net.doodleproject.numerics4j.exception.NumericException;

public abstract class PowerSeries
extends IterativeMethod {
    private int firstIndex;

    protected PowerSeries() {
        this(100, 1.0E-15);
    }

    protected PowerSeries(int iterations, double error) {
        this(0, iterations, error);
    }

    protected PowerSeries(int index, int iterations, double error) {
        super(iterations, error);
        this.setFirstIndex(index);
    }

    public double evaluate(double x) throws NumericException {
        double t;
        double s;
        int n = this.getFirstIndex();
        double z = Math.pow(x, n);
        double sn = s = (t = this.getTerm(n) * z);
        double error = Double.MAX_VALUE;
        do {
            sn = s + this.getTerm(++n) * (z *= x);
            error = Math.abs(sn / s - 1.0);
            s = sn;
        } while (n < this.getMaximumIterations() && Math.abs(error) > this.getMaximumRelativeError());
        if (n >= this.getMaximumIterations()) {
            throw new ConvergenceException("Power series failed to converge.");
        }
        return s;
    }

    protected abstract double getTerm(int var1);

    private int getFirstIndex() {
        return this.firstIndex;
    }

    private void setFirstIndex(int index) {
        this.firstIndex = index;
    }
}

