/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.root;

import net.doodleproject.numerics4j.exception.ConvergenceException;
import net.doodleproject.numerics4j.exception.NumericException;
import net.doodleproject.numerics4j.function.Function;

public class Bracket {
    private static final int DEFAULT_MAXIMUM_ITERATIONS = 100;
    private Function function;
    private int maximumIterations;

    public Bracket(Function f) {
        this(f, 100);
    }

    public Bracket(Function f, int iterations) {
        this.setFunction(f);
        this.setMaximumIterations(iterations);
    }

    public double[] bracketOut(double lower, double initial, double upper) throws NumericException {
        double[] ret;
        if (lower > initial) {
            throw new IllegalArgumentException("Lower bound must be less than initial value.");
        }
        if (initial > upper) {
            throw new IllegalArgumentException("Upper bound must be greater than initial value.");
        }
        if (Double.isNaN(lower) || Double.isNaN(initial) || Double.isNaN(upper)) {
            ret = new double[]{Double.NaN, Double.NaN};
        } else {
            double fb;
            double fa;
            double a;
            double b = a = initial;
            int n = 0;
            double factor = Math.abs(a * 0.1);
            double change = 0.0;
            do {
                a = Math.max(a - (change += factor), lower);
                b = Math.min(b + change, upper);
            } while ((fa = this.getFunction().evaluate(a)) * (fb = this.getFunction().evaluate(b)) > 0.0 && ++n < this.getMaximumIterations());
            if (n >= this.getMaximumIterations()) {
                throw new ConvergenceException("the initial bounds do not bracket a root.");
            }
            ret = new double[]{a, b};
        }
        return ret;
    }

    public Function getFunction() {
        return this.function;
    }

    public int getMaximumIterations() {
        return this.maximumIterations;
    }

    public void setFunction(Function f) {
        if (f == null) {
            throw new IllegalArgumentException("Function can not be null.");
        }
        this.function = f;
    }

    public void setMaximumIterations(int iterations) {
        if (iterations <= 0) {
            throw new IllegalArgumentException("Maximum iterations must be positive.");
        }
        this.maximumIterations = iterations;
    }
}

