/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.root;

import net.doodleproject.numerics4j.IterativeMethod;
import net.doodleproject.numerics4j.exception.NumericException;
import net.doodleproject.numerics4j.function.Function;

public class BisectionRootFinder
extends IterativeMethod {
    private Function function;

    public BisectionRootFinder(Function f) {
        this(f, 100, 1.0E-15);
    }

    public BisectionRootFinder(Function f, int iterations, double error) {
        super(iterations, error);
        this.setFunction(f);
    }

    public double findRoot(double min, double max) throws NumericException {
        IterativeState state = new IterativeState(min, max);
        this.iterate(state);
        return state.getResult();
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function f) {
        if (f == null) {
            throw new IllegalArgumentException("Function can not be null.");
        }
        this.function = f;
    }

    private class IterativeState
    implements IterativeMethod.IterativeState {
        private double fm;
        private double fmin;
        private double m;
        private double max;
        private double min;
        private int n;

        IterativeState(double mn, double mx) {
            this.min = mn;
            this.max = mx;
        }

        @Override
        public int getIterations() {
            return this.n;
        }

        @Override
        public double getRelativeError() {
            return Math.max(Math.abs(this.fm), this.m / this.min - 1.0);
        }

        @Override
        public void initialize() {
            this.n = 0;
        }

        @Override
        public void iterate() throws NumericException {
            ++this.n;
            this.m = this.min + (this.max - this.min) / 2.0;
            this.fmin = BisectionRootFinder.this.getFunction().evaluate(this.min);
            this.fm = BisectionRootFinder.this.getFunction().evaluate(this.m);
            if (this.fm * this.fmin > 0.0) {
                this.min = this.m;
                this.fmin = this.fm;
            } else {
                this.max = this.m;
            }
        }

        double getResult() throws NumericException {
            this.iterate();
            return this.min + (this.max - this.min) / 2.0;
        }
    }
}

