/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.random;

import net.doodleproject.numerics4j.random.AbstractContinuousRandomVariable;
import net.doodleproject.numerics4j.random.RNG;
import net.doodleproject.numerics4j.random.RandomRNG;

public class NormalRandomVariable
extends AbstractContinuousRandomVariable {
    private static final double P1 = 0.86385546;
    private static final double P2 = 0.9746734273000001;
    private static final double P3 = 0.9973001997500001;
    private double mean;
    private double standardDeviation;

    public NormalRandomVariable() {
        this(0.0, 1.0);
    }

    public NormalRandomVariable(double m, double s) {
        this(m, s, new RandomRNG());
    }

    public NormalRandomVariable(double m, double s, RNG source) {
        super(source);
        this.setMean(m);
        this.setStandardDeviation(s);
    }

    public static double nextRandomVariable(double m, double s, RNG source) {
        double x;
        double u = source.nextRandomNumber();
        if (u <= 0.86385546) {
            double v = source.nextRandomNumber() * 2.0 - 1.0;
            double w = source.nextRandomNumber() * 2.0 - 1.0;
            x = 2.3153508 * u - 1.0 + v + w;
        } else if (u <= 0.9746734273000001) {
            double v = source.nextRandomNumber();
            x = 1.5 * (v - 1.0 + 9.0334237 * (u - 0.86385546));
        } else if (u <= 0.9973001997500001) {
            double w;
            double sum;
            double v;
            double u1;
            do {
                x = source.nextRandomNumber() * 6.0 - 3.0;
                u1 = source.nextRandomNumber();
                v = Math.abs(x);
                w = 6.6313339 * (9.0 - 6.0 * v + v * v);
                sum = 0.0;
                if (v < 1.5) {
                    sum = 6.0432809 * (1.5 - v);
                }
                if (!(v < 1.0)) continue;
                sum = sum + 13.2626678 * (3.0 - v * v) - w;
            } while (u1 > 4.90024445E8 * Math.exp(-(v * v) / 2.0) - sum - w);
        } else {
            double v;
            double w;
            do {
                v = source.nextRandomNumber();
            } while ((x = 4.5 - Math.log(w = source.nextRandomNumber())) * v * v > 4.5);
            x = Math.sqrt(2.0 * x) * Math.signum(u - 0.9986501);
        }
        return x * s + m;
    }

    private double getMean() {
        return this.mean;
    }

    private double getStandardDeviation() {
        return this.standardDeviation;
    }

    @Override
    public double nextRandomVariable() {
        return NormalRandomVariable.nextRandomVariable(this.getMean(), this.getStandardDeviation(), this.getSource());
    }

    private void setMean(double m) {
        if (Double.isNaN(m)) {
            throw new IllegalArgumentException("Mean must be a valid number.");
        }
        this.mean = m;
    }

    private void setStandardDeviation(double std) {
        if (std <= 0.0 || Double.isNaN(std)) {
            throw new IllegalArgumentException("Standard deviation must be positive.");
        }
        this.standardDeviation = std;
    }
}

