/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.random;

import net.doodleproject.numerics4j.random.AbstractContinuousRandomVariable;
import net.doodleproject.numerics4j.random.ChiSquaredRandomVariable;
import net.doodleproject.numerics4j.random.RNG;
import net.doodleproject.numerics4j.random.RandomRNG;

public class FRandomVariable
extends AbstractContinuousRandomVariable {
    private double denominatorDegreesOfFreedom;
    private double numeratorDegreesOfFreedom;

    public FRandomVariable() {
        this(1.0, 1.0);
    }

    public FRandomVariable(double dfn, double dfd) {
        this(dfn, dfd, new RandomRNG());
    }

    public FRandomVariable(double dfn, double dfd, RNG source) {
        super(source);
        this.setNumeratorDegreesOfFreedom(dfn);
        this.setDenominatorDegreesOfFreedom(dfd);
    }

    public static double nextRandomVariable(double dfn, double dfd, RNG source) {
        double x1 = ChiSquaredRandomVariable.nextRandomVariable(dfn, source) / dfn;
        double x2 = ChiSquaredRandomVariable.nextRandomVariable(dfd, source);
        return x1 / x2;
    }

    private double getDenominatorDegreesOfFreedom() {
        return this.denominatorDegreesOfFreedom;
    }

    private double getNumeratorDegreesOfFreedom() {
        return this.numeratorDegreesOfFreedom;
    }

    @Override
    public double nextRandomVariable() {
        return FRandomVariable.nextRandomVariable(this.getNumeratorDegreesOfFreedom(), this.getDenominatorDegreesOfFreedom(), this.getSource());
    }

    private void setDenominatorDegreesOfFreedom(double degreesOfFreedom) {
        if (degreesOfFreedom <= 0.0 || Double.isNaN(degreesOfFreedom)) {
            throw new IllegalArgumentException("degrees of freedom must be positive.");
        }
        this.denominatorDegreesOfFreedom = degreesOfFreedom;
    }

    private void setNumeratorDegreesOfFreedom(double degreesOfFreedom) {
        if (degreesOfFreedom <= 0.0 || Double.isNaN(degreesOfFreedom)) {
            throw new IllegalArgumentException("degrees of freedom must be positive.");
        }
        this.numeratorDegreesOfFreedom = degreesOfFreedom;
    }
}

