/*
 * Decompiled with CFR 0.152.
 */
package jmatmain;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import jmatmain.ConsoleService;
import jmatmain.OutDialog;
import jmatmain.OutText;
import jmatmain.SetEnv;
import jmatmain.mainGUI;

public class MainAppletInline
extends JApplet {
    private static final long serialVersionUID = 1L;
    private JSplitPane jsplit;
    private mainGUI maingui;
    private int asize = 500;
    private String input = "";
    private String control = "none";
    private int fontsize = 12;
    private int nrlines = 1;
    private OutText jconsole;
    private String eol = System.getProperty("line.separator");
    private JButton jrun;
    private boolean editMode;
    private final Color cborder = new Color(66, 194, 70);
    private Thread trun;
    private ConsoleService jasymcaConsole;

    @Override
    public void init() {
        this.editMode = false;
        String paramSize = this.getParameter("asize");
        if (paramSize != null) {
            try {
                this.asize = Integer.parseInt(paramSize);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.input = this.getParameter("input");
        this.input = this.input.replace("&newline;", "\n");
        this.input = this.input.replace("&quote;", "\"");
        String[] number_array = this.input.split(this.eol);
        this.nrlines = number_array.length;
        this.control = this.getParameter("control");
        if (this.control.indexOf("edit") > -1) {
            this.editMode = true;
        }
        SetEnv.outputString = "";
        String fontSize = this.getParameter("fontsize");
        if (paramSize != null) {
            try {
                this.fontsize = Integer.parseInt(fontSize);
                String name = SetEnv.globalFont.getFamily();
                SetEnv.globalFont = new Font(name, 1, this.fontsize);
            }
            catch (NumberFormatException name) {
                // empty catch block
            }
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MainAppletInline.this.getGUI();
                }
            });
        }
        catch (Exception e) {
            System.err.println("createGUI didn't complete successfully");
        }
    }

    public void getGUI() {
        this.jconsole = new OutText();
        this.jconsole.setFont(SetEnv.globalFont);
        JScrollPane scrollingArea = new JScrollPane(this.jconsole);
        scrollingArea.getVerticalScrollBar().setPreferredSize(new Dimension(10, 0));
        scrollingArea.getHorizontalScrollBar().setPreferredSize(new Dimension(0, 10));
        this.jconsole.setEditable(false);
        this.jconsole.setBorder(BorderFactory.createEmptyBorder());
        this.maingui = new mainGUI(false);
        this.maingui.getEditor().setHighlightCurrentLine(false);
        this.maingui.getEditor().setEditable(false);
        this.maingui.setBorder(BorderFactory.createEmptyBorder());
        this.maingui.getScrollPane().setHorizontalScrollBarPolicy(31);
        this.maingui.getScrollPane().setVerticalScrollBarPolicy(21);
        this.maingui.getScrollPane().setBorder(BorderFactory.createEmptyBorder());
        this.jsplit = new JSplitPane(1, this.maingui, scrollingArea);
        this.jsplit.setBorder(BorderFactory.createEmptyBorder());
        if (this.editMode) {
            this.maingui.getEditor().setEditable(true);
            this.jsplit.setBorder(BorderFactory.createLineBorder(this.cborder));
            this.maingui.setBorder(BorderFactory.createLineBorder(this.cborder));
        }
        this.jsplit.setBackground(Color.white);
        this.jsplit.setResizeWeight(0.6);
        this.jsplit.setDividerLocation(0.6);
        this.jsplit.setDividerSize(4);
        this.maingui.getEditor().setText(this.input);
        this.jconsole.setText("");
        this.add((Component)this.jsplit, "Center");
        this.jrun = new JButton("Run");
        this.jrun.setOpaque(true);
        this.jrun.setBackground(new Color(197, 237, 250));
        if (this.control.indexOf("member") == -1) {
            this.jrun.setBackground(new Color(245, 172, 172));
        }
        this.jrun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainAppletInline.this.control.indexOf("member") > -1) {
                    String s = MainAppletInline.this.maingui.getEditor().getText();
                    MainAppletInline.this.evalSymb(s);
                } else {
                    MainAppletInline.this.ErrorMessage("Non-members cannot run this example!");
                }
            }
        });
        this.add((Component)this.jrun, "East");
    }

    @Override
    public void start() {
        SetEnv.outputString = "";
        this.jconsole.setText("");
    }

    private void ErrorMessage(String a) {
        JOptionPane dialogError = new JOptionPane();
        JOptionPane.showMessageDialog(dialogError, a, "Error", 0);
    }

    public void evalSymb(final String s) {
        this.trun = new Thread("Evaluate symbolic calculations"){

            @Override
            public void run() {
                try {
                    String[] number_array;
                    int outlines;
                    MainAppletInline.this.jasymcaConsole = new ConsoleService();
                    MainAppletInline.this.jasymcaConsole.clear();
                    MainAppletInline.this.jconsole.setText("");
                    String sout = MainAppletInline.this.jasymcaConsole.exec(s);
                    String serr = MainAppletInline.this.jasymcaConsole.getError();
                    if (serr.length() > 1) {
                        MainAppletInline.this.ErrorMessage(serr);
                    }
                    if ((outlines = (number_array = sout.split(MainAppletInline.this.eol)).length) <= MainAppletInline.this.nrlines) {
                        MainAppletInline.this.jconsole.setText(sout);
                    } else {
                        OutDialog da = new OutDialog(MainAppletInline.this.jconsole);
                        da.setText(sout);
                        da.setVisible(true);
                    }
                }
                catch (Exception ie) {
                    MainAppletInline.this.ErrorMessage(ie.toString());
                }
            }
        };
        this.trun.start();
    }
}

