/*
 * Decompiled with CFR 0.152.
 */
package jmatmain;

import jasymca.JasymcaConsoleText;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import jmatmain.ConsoleService;
import jmatmain.OutSysIn;
import jmatmain.OutText;
import jmatmain.SetEnv;
import jmatmain.mainGUI;

public class MainAll {
    private static JTabbedPane jtab;
    private static mainGUI maingui;
    private static OutText jconsole;
    private static OutSysIn jconsolesys;
    private static Thread trun;
    private static ConsoleService jasymcaConsole;

    public static void main(String[] args) {
        if (args.length != 0) {
            String filename = args[0];
            JasymcaConsoleText jasymcaConsoletext = new JasymcaConsoleText(System.in, System.out);
            String s = MainAll.getContents(new File(filename));
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes("UTF-8"));
                jasymcaConsoletext.readStream(is);
            }
            catch (Exception ie) {
                System.out.println(ie.toString());
            }
            return;
        }
        JButton button = new JButton("Run");
        JButton reload = new JButton("Reload");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = maingui.getEditor().getText();
                MainAll.evalSymb(s);
            }
        });
        reload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jasymcaConsole.clear();
                jconsole.setText("");
                jtab.setSelectedIndex(0);
            }
        });
        JFrame frame = new JFrame("JMathLab");
        frame.setPreferredSize(new Dimension(500, 500));
        MainAll.getGUI();
        frame.add((Component)jtab, "Center");
        frame.add((Component)button, "North");
        frame.add((Component)reload, "South");
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    private static void ErrorMessage(String a) {
        JOptionPane dialogError = new JOptionPane();
        JOptionPane.showMessageDialog(dialogError, a, "Error", 0);
    }

    public static void evalSymb(final String s) {
        trun = new Thread(){

            @Override
            public void run() {
                try {
                    String sout = jasymcaConsole.exec(s);
                    jconsole.setText(sout);
                    jtab.setSelectedIndex(1);
                    String serr = jasymcaConsole.getError();
                    if (serr.length() > 1) {
                        MainAll.ErrorMessage(serr);
                    }
                }
                catch (Exception ie) {
                    MainAll.ErrorMessage(ie.toString());
                }
            }
        };
        trun.start();
    }

    public static void getGUI() {
        jconsole = new OutText();
        jconsole.setFont(SetEnv.globalFont);
        JScrollPane scrollingArea = new JScrollPane(jconsole);
        maingui = new mainGUI(true);
        jtab = new JTabbedPane();
        jtab.addTab("Editor", maingui);
        jtab.addTab("Output", scrollingArea);
        jasymcaConsole = new ConsoleService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents(File aFile) {
        StringBuilder contents = new StringBuilder();
        try (BufferedReader input = new BufferedReader(new FileReader(aFile));){
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return contents.toString();
    }
}

