/*
 * Decompiled with CFR 0.152.
 */
package jmathlab.math;

import jmathlab.math.Random;
import jmathlab.math.Statistics;

public class StatisticSample {
    public static int[][] randomInt(int m, int n, int i0, int i1) {
        int[][] A = new int[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.randInt(i0, i1);
            }
        }
        return A;
    }

    public static int[] randomInt(int m, int i0, int i1) {
        int[] A = new int[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.randInt(i0, i1);
        }
        return A;
    }

    public static double[] randUniform(int m, double min, double max) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.uniform(min, max);
        }
        return A;
    }

    public static double[][] randUniform(int m, int n, double min, double max) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.uniform(min, max);
            }
        }
        return A;
    }

    public static double[][] randomDirac(int m, int n, double[] values, double[] prob) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.dirac(values, prob);
            }
        }
        return A;
    }

    public static double[] randomDirac(int m, double[] values, double[] prob) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.dirac(values, prob);
        }
        return A;
    }

    public static double[][] randomNormal(int m, int n, double mu, double sigma) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.normal(mu, sigma);
            }
        }
        return A;
    }

    public static double[] randomNormal(int m, double mu, double sigma) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.normal(mu, sigma);
        }
        return A;
    }

    public static double[][] randomChi2(int m, int n, int d) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.chi2(d);
            }
        }
        return A;
    }

    public static double[] randomChi2(int m, int d) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.chi2(d);
        }
        return A;
    }

    public static double[][] randomLogNormal(int m, int n, double mu, double sigma) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.logNormal(mu, sigma);
            }
        }
        return A;
    }

    public static double[] randomLogNormal(int m, double mu, double sigma) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.logNormal(mu, sigma);
        }
        return A;
    }

    public static double[][] randomExponential(int m, int n, double lambda) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.exponential(lambda);
            }
        }
        return A;
    }

    public static double[] randomExponential(int m, double lambda) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.exponential(lambda);
        }
        return A;
    }

    public static double[][] randomTriangular(int m, int n, double min, double max) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.triangular(min, max);
            }
        }
        return A;
    }

    public static double[] randomTriangular(int m, double min, double max) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.triangular(min, max);
        }
        return A;
    }

    public static double[][] randomTriangular(int m, int n, double min, double med, double max) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.triangular(min, med, max);
            }
        }
        return A;
    }

    public static double[] randomTriangular(int m, double min, double med, double max) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.triangular(min, med, max);
        }
        return A;
    }

    public static double[][] randomBeta(int m, int n, double a, double b) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.beta(a, b);
            }
        }
        return A;
    }

    public static double[] randomBeta(int m, double a, double b) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.beta(a, b);
        }
        return A;
    }

    public static double[][] randomCauchy(int m, int n, double mu, double sigma) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.cauchy(mu, sigma);
            }
        }
        return A;
    }

    public static double[] randomCauchy(int m, double mu, double sigma) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.cauchy(mu, sigma);
        }
        return A;
    }

    public static double[][] randomWeibull(int m, int n, double lambda, double c) {
        double[][] A = new double[m][n];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                A[i][j] = Random.weibull(lambda, c);
            }
        }
        return A;
    }

    public static double[] randomWeibull(int m, double lambda, double c) {
        double[] A = new double[m];
        for (int i = 0; i < A.length; ++i) {
            A[i] = Random.weibull(lambda, c);
        }
        return A;
    }

    public static double mean(double[] v) {
        double mean = 0.0;
        int m = v.length;
        for (int i = 0; i < m; ++i) {
            mean += v[i];
        }
        return mean /= (double)m;
    }

    public static double[] mean(double[][] v) {
        int m = v.length;
        int n = v[0].length;
        double[] mean = new double[n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                mean[n2] = mean[n2] + v[i][j];
            }
        }
        int j = 0;
        while (j < n) {
            int n3 = j++;
            mean[n3] = mean[n3] / (double)m;
        }
        return mean;
    }

    public static double stddeviation(double[] v) {
        return Math.sqrt(StatisticSample.variance(v));
    }

    public static double variance(double[] v) {
        return Statistics.variance(v);
    }

    public static double[] stddeviation(double[][] v) {
        return Statistics.stddeviation(v);
    }

    public static double[] variance(double[][] v) {
        return Statistics.variance(v);
    }

    public static double covariance(double[] v1, double[] v2) {
        return Statistics.covariance(v1, v2);
    }

    public static double[][] covariance(double[][] v1, double[][] v2) {
        return Statistics.covariance(v1, v2);
    }

    public static double[][] covariance(double[][] v) {
        return Statistics.covariance(v);
    }

    public static double correlation(double[] v1, double[] v2) {
        return Statistics.correlation(v1, v2);
    }

    public static double[][] correlation(double[][] v1, double[][] v2) {
        return Statistics.correlation(v1, v2);
    }

    public static double[][] correlation(double[][] v) {
        return Statistics.correlation(v);
    }
}

