/*
 * Decompiled with CFR 0.152.
 */
package jmathlab;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;

class JasymcaSyntaxDocument
extends DefaultStyledDocument {
    private static final long serialVersionUID = 1L;
    private DefaultStyledDocument doc = this;
    private Element rootElement = this.doc.getDefaultRootElement();
    private boolean multiLineComment;
    private MutableAttributeSet normal;
    private MutableAttributeSet keyword;
    private MutableAttributeSet keyword1;
    private MutableAttributeSet keyword2;
    private MutableAttributeSet keyword3;
    private MutableAttributeSet comment;
    private MutableAttributeSet comment1;
    private MutableAttributeSet comment2;
    private MutableAttributeSet quote;
    private HashSet<String> keywords;
    private HashSet<String> keywords1;
    private HashSet<String> keywords2;
    private HashSet<String> keywords3;
    private boolean highlighting = true;

    public JasymcaSyntaxDocument() {
        this.putProperty("__EndOfLine__", "\n");
        this.normal = new SimpleAttributeSet();
        StyleConstants.setForeground(this.normal, Color.black);
        this.comment = new SimpleAttributeSet();
        StyleConstants.setForeground(this.comment, Color.gray);
        StyleConstants.setItalic(this.comment, true);
        this.comment1 = new SimpleAttributeSet();
        StyleConstants.setForeground(this.comment1, Color.gray);
        StyleConstants.setItalic(this.comment1, true);
        this.comment2 = new SimpleAttributeSet();
        StyleConstants.setForeground(this.comment2, Color.red);
        StyleConstants.setItalic(this.comment2, true);
        this.keyword = new SimpleAttributeSet();
        StyleConstants.setForeground(this.keyword, new Color(0, 105, 0));
        this.keyword1 = new SimpleAttributeSet();
        StyleConstants.setForeground(this.keyword1, new Color(38400));
        this.keyword2 = new SimpleAttributeSet();
        StyleConstants.setForeground(this.keyword2, Color.red);
        this.keyword3 = new SimpleAttributeSet();
        StyleConstants.setForeground(this.keyword3, Color.blue);
        this.quote = new SimpleAttributeSet();
        StyleConstants.setForeground(this.quote, new Color(6619289));
        this.keywords1 = new HashSet();
        this.keywords1.add("rat");
        this.keywords1.add("realpart");
        this.keywords1.add("imagpart");
        this.keywords1.add("float");
        this.keywords1.add("int");
        this.keywords1.add("long");
        this.keywords1.add("format");
        this.keywords1.add("abs");
        this.keywords1.add("sign");
        this.keywords1.add("conj");
        this.keywords1.add("angle");
        this.keywords1.add("cfs");
        this.keywords1.add("sqrt");
        this.keywords1.add("exp");
        this.keywords1.add("log");
        this.keywords1.add("sinh");
        this.keywords1.add("cosh");
        this.keywords1.add("asinh");
        this.keywords1.add("acosh");
        this.keywords1.add("sech");
        this.keywords1.add("csch");
        this.keywords1.add("asech");
        this.keywords1.add("acsch");
        this.keywords1.add("sin");
        this.keywords1.add("cos");
        this.keywords1.add("tan");
        this.keywords1.add("asin");
        this.keywords1.add("acos");
        this.keywords1.add("atan");
        this.keywords1.add("acscatan2");
        this.keywords1.add("sec");
        this.keywords1.add("csc");
        this.keywords1.add("asec");
        this.keywords1.add("acsc");
        this.keywords1.add("factorial");
        this.keywords1.add("nchoosek");
        this.keywords1.add("gamma");
        this.keywords1.add("gammaln");
        this.keywords1.add("divide");
        this.keywords1.add("prod");
        this.keywords1.add("length");
        this.keywords1.add("zeros");
        this.keywords1.add("linspace");
        this.keywords1.add("ones");
        this.keywords1.add("size");
        this.keywords1.add("eye");
        this.keywords1.add("rand");
        this.keywords1.add("hilb");
        this.keywords1.add("find");
        this.keywords1.add("invhilb");
        this.keywords1.add("max");
        this.keywords1.add("min");
        this.keywords1.add("diag");
        this.keywords1.add("det");
        this.keywords1.add("eigen");
        this.keywords1.add("qr");
        this.keywords1.add("lu");
        this.keywords1.add("inv");
        this.keywords1.add("eig");
        this.keywords1.add("primes");
        this.keywords1.add("subst");
        this.keywords1.add("trigrat");
        this.keywords1.add("algsys");
        this.keywords1.add("linsolve2");
        this.keywords1.add("linsolve");
        this.keywords1.add("linlstsq");
        this.keywords1.add("factorial");
        this.keywords2 = new HashSet();
        this.keywords2.add("Exception");
        this.keywords2.add("StandardError");
        this.keywords2.add("Error");
        this.keywords2.add("ArithmeticError");
        this.keywords2.add("LookupError");
        this.keywords2.add("EnvironmentError");
        this.keywords2.add("AssertionError");
        this.keywords2.add("AttributeError");
        this.keywords2.add("FloatingPointError");
        this.keywords2.add("ParseException");
        this.keywords2.add("jasymca.ParseException");
        this.keywords2.add("JasymcaException");
        this.keywords2.add("ParseException");
        this.keywords2.add("RuntimeError");
        this.keywords2.add("SystemExit");
        this.keywords2.add("ZeroDivisionError");
        this.keywords2.add("ValueError");
        this.keywords2.add("TypeError");
        this.keywords2.add("NotImplementedError");
        this.keywords = new HashSet();
        this.keywords.add("fzero");
        this.keywords.add("ode");
        this.keywords.add("taylor");
        this.keywords.add("quad");
        this.keywords.add("romberg");
        this.keywords.add("solve");
        this.keywords.add("integrate");
        this.keywords.add("diff");
        this.keywords.add("lsum");
        this.keywords.add("sum");
        this.keywords.add("plot");
        this.keywords.add("loglog");
        this.keywords.add("linlog");
        this.keywords.add("loglin");
        this.keywords.add("print");
        this.keywords.add("printf");
        this.keywords.add("for");
        this.keywords.add("format");
        this.keywords.add("allroots");
        this.keywords.add("qcd");
        this.keywords.add("syms");
        this.keywords.add("function");
        this.keywords.add("end");
        this.keywords.add("xlabel");
        this.keywords.add("ylabel");
        this.keywords.add("title");
        this.keywords.add("continue");
        this.keywords.add("break");
        this.keywords.add("end");
        this.keywords.add("for");
        this.keywords.add("while");
        this.keywords.add("if");
        this.keywords.add("addpath");
        this.keywords.add("clear");
        this.keywords.add("hold");
        this.keywords3 = new HashSet();
        this.keywords3.add("ans");
    }

    public void setHighlighting(boolean h) {
        this.highlighting = h;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        if (str.equals("{")) {
            str = this.addMatchingBrace(offset);
        }
        super.insertString(offset, str, a);
        if (this.highlighting) {
            this.processChangedLines(offset, str.length());
        }
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        if (this.highlighting) {
            this.processChangedLines(offset, 0);
        }
    }

    public void processChangedLines(int offset, int length) throws BadLocationException {
        if (!this.highlighting) {
            return;
        }
        String content = this.doc.getText(0, this.doc.getLength());
        int startLine = this.rootElement.getElementIndex(offset);
        int endLine = this.rootElement.getElementIndex(offset + length);
        this.setMultiLineComment(this.commentLinesBefore(content, startLine));
        for (int i = startLine; i <= endLine; ++i) {
            this.applyHighlighting(content, i);
        }
        if (this.isMultiLineComment()) {
            this.commentLinesAfter(content, endLine);
        } else {
            this.highlightLinesAfter(content, endLine);
        }
    }

    private boolean commentLinesBefore(String content, int line) {
        if (!this.highlighting) {
            return false;
        }
        int offset = this.rootElement.getElement(line).getStartOffset();
        int startDelimiter = this.lastIndexOf(content, this.getStartDelimiter(), offset - 2);
        if (startDelimiter < 0) {
            return false;
        }
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), startDelimiter);
        if (endDelimiter < offset & endDelimiter != -1) {
            return false;
        }
        this.doc.setCharacterAttributes(startDelimiter, offset - startDelimiter + 1, this.comment, false);
        return true;
    }

    private void commentLinesAfter(String content, int line) {
        if (!this.highlighting) {
            return;
        }
        int offset = this.rootElement.getElement(line).getEndOffset();
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), offset);
        if (endDelimiter < 0) {
            return;
        }
        int startDelimiter = this.lastIndexOf(content, this.getStartDelimiter(), endDelimiter);
        if (startDelimiter < 0 || startDelimiter <= offset) {
            this.doc.setCharacterAttributes(offset, endDelimiter - offset + 1, this.comment, false);
        }
    }

    private void highlightLinesAfter(String content, int line) throws BadLocationException {
        int delimiter;
        if (!this.highlighting) {
            return;
        }
        int offset = this.rootElement.getElement(line).getEndOffset();
        int startDelimiter = this.indexOf(content, this.getStartDelimiter(), offset);
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), offset);
        if (startDelimiter < 0) {
            startDelimiter = content.length();
        }
        if (endDelimiter < 0) {
            endDelimiter = content.length();
        }
        if ((delimiter = Math.min(startDelimiter, endDelimiter)) < offset) {
            return;
        }
        int endLine = this.rootElement.getElementIndex(delimiter);
        for (int i = line + 1; i < endLine; ++i) {
            Element branch = this.rootElement.getElement(i);
            Element leaf = this.doc.getCharacterElement(branch.getStartOffset());
            AttributeSet as = leaf.getAttributes();
            if (!as.isEqual(this.comment)) continue;
            this.applyHighlighting(content, i);
        }
    }

    private void applyHighlighting(String content, int line) throws BadLocationException {
        int index2;
        int index1;
        if (!this.highlighting) {
            return;
        }
        int startOffset = this.rootElement.getElement(line).getStartOffset();
        int endOffset = this.rootElement.getElement(line).getEndOffset() - 1;
        int lineLength = endOffset - startOffset;
        int contentLength = content.length();
        if (endOffset >= contentLength) {
            endOffset = contentLength - 1;
        }
        if (this.endingMultiLineComment(content, startOffset, endOffset) || this.isMultiLineComment() || this.startingMultiLineComment(content, startOffset, endOffset)) {
            this.doc.setCharacterAttributes(startOffset, endOffset - startOffset + 1, this.comment, false);
            return;
        }
        this.doc.setCharacterAttributes(startOffset, lineLength, this.normal, true);
        int index = content.indexOf(this.getSingleLineDelimiter(), startOffset);
        if (index > -1 && index < endOffset) {
            this.doc.setCharacterAttributes(index, endOffset - index + 1, this.comment, false);
            endOffset = index - 1;
        }
        if ((index1 = content.indexOf(this.getSingleLineDelimiter1(), startOffset)) > -1 && index1 < endOffset) {
            this.doc.setCharacterAttributes(index1, endOffset - index1 + 1, this.comment1, false);
            endOffset = index1 - 1;
        }
        if ((index2 = content.indexOf(this.getSingleLineDelimiter2(), startOffset)) > -1 && index2 < endOffset) {
            this.doc.setCharacterAttributes(index2, endOffset - index2 + 1, this.comment2, false);
            endOffset = index2 - 1;
        }
        this.checkForTokens(content, startOffset, endOffset);
    }

    private boolean startingMultiLineComment(String content, int startOffset, int endOffset) throws BadLocationException {
        if (!this.highlighting) {
            return false;
        }
        int index = this.indexOf(content, this.getStartDelimiter(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setMultiLineComment(true);
        return true;
    }

    private boolean endingMultiLineComment(String content, int startOffset, int endOffset) throws BadLocationException {
        if (!this.highlighting) {
            return false;
        }
        int index = this.indexOf(content, this.getEndDelimiter(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setMultiLineComment(false);
        return true;
    }

    private boolean isMultiLineComment() {
        return this.multiLineComment;
    }

    private void setMultiLineComment(boolean value) {
        this.multiLineComment = value;
    }

    private void checkForTokens(String content, int startOffset, int endOffset) {
        while (startOffset <= endOffset) {
            while (this.isDelimiter(content.substring(startOffset, startOffset + 1))) {
                if (startOffset < endOffset) {
                    ++startOffset;
                    continue;
                }
                return;
            }
            if (this.isQuoteDelimiter(content.substring(startOffset, startOffset + 1))) {
                startOffset = this.getQuoteToken(content, startOffset, endOffset);
                continue;
            }
            startOffset = this.getOtherToken(content, startOffset, endOffset);
        }
    }

    private int getQuoteToken(String content, int startOffset, int endOffset) {
        String quoteDelimiter = content.substring(startOffset, startOffset + 1);
        String escapeString = this.getEscapeString(quoteDelimiter);
        int endOfQuote = startOffset;
        int index = content.indexOf(escapeString, endOfQuote + 1);
        while (index > -1 && index < endOffset) {
            endOfQuote = index + 1;
            index = content.indexOf(escapeString, endOfQuote);
        }
        index = content.indexOf(quoteDelimiter, endOfQuote + 1);
        endOfQuote = index < 0 || index > endOffset ? endOffset : index;
        this.doc.setCharacterAttributes(startOffset, endOfQuote - startOffset + 1, this.quote, false);
        return endOfQuote + 1;
    }

    private int getOtherToken(String content, int startOffset, int endOffset) {
        int endOfToken;
        for (endOfToken = startOffset + 1; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1)); ++endOfToken) {
        }
        String token = content.substring(startOffset, endOfToken);
        if (this.isKeyword(token)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.keyword, false);
        }
        if (this.isKeyword1(token)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.keyword1, false);
        }
        if (this.isKeyword2(token)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.keyword2, false);
        }
        if (this.isKeyword3(token)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.keyword3, false);
        }
        return endOfToken + 1;
    }

    private int indexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.indexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index + 1;
        }
        return index;
    }

    private int lastIndexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.lastIndexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index - 1;
        }
        return index;
    }

    private String getLine(String content, int offset) {
        int line = this.rootElement.getElementIndex(offset);
        Element lineElement = this.rootElement.getElement(line);
        int start = lineElement.getStartOffset();
        int end = lineElement.getEndOffset();
        return content.substring(start, end - 1);
    }

    protected boolean isDelimiter(String character) {
        String operands = ";:{}()[]+-/%<=>!&|^~*";
        return Character.isWhitespace(character.charAt(0)) || operands.indexOf(character) != -1;
    }

    protected boolean isQuoteDelimiter(String character) {
        String quoteDelimiters = "\"'";
        return quoteDelimiters.indexOf(character) >= 0;
    }

    protected boolean isKeyword(String token) {
        return this.keywords.contains(token);
    }

    protected boolean isKeyword1(String token) {
        return this.keywords1.contains(token);
    }

    protected boolean isKeyword2(String token) {
        return this.keywords2.contains(token);
    }

    protected boolean isKeyword3(String token) {
        return this.keywords3.contains(token);
    }

    protected String getStartDelimiter() {
        return "/*";
    }

    protected String getEndDelimiter() {
        return "*/";
    }

    protected String getSingleLineDelimiter() {
        return "%";
    }

    protected String getSingleLineDelimiter1() {
        return "<--";
    }

    protected String getSingleLineDelimiter2() {
        return "Traceback";
    }

    protected String getEscapeString(String quoteDelimiter) {
        return "\\" + quoteDelimiter;
    }

    protected String addMatchingBrace(int offset) throws BadLocationException {
        String temp;
        StringBuffer whiteSpace = new StringBuffer();
        int line = this.rootElement.getElementIndex(offset);
        int i = this.rootElement.getElement(line).getStartOffset();
        while ((temp = this.doc.getText(i, 1)).equals(" ") || temp.equals("\t")) {
            whiteSpace.append(temp);
            ++i;
        }
        return "{\n" + whiteSpace.toString() + "\t\n" + whiteSpace.toString() + "}";
    }

    public static void main(String[] a) {
        StyledEditorKit editorKit = new StyledEditorKit(){
            private static final long serialVersionUID = 1L;

            @Override
            public Document createDefaultDocument() {
                return new JasymcaSyntaxDocument();
            }
        };
        final JEditorPane edit = new JEditorPane();
        edit.setEditorKitForContentType("text/java", editorKit);
        edit.setContentType("text/java");
        JButton button = new JButton("Load SyntaxDocument.java");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FileInputStream fis = new FileInputStream("SyntaxDocument.java");
                    edit.read((InputStream)fis, (Object)null);
                    edit.requestFocus();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JFrame frame = new JFrame("Syntax Highlighting");
        frame.getContentPane().add(new JScrollPane(edit));
        frame.getContentPane().add((Component)button, "South");
        frame.setDefaultCloseOperation(3);
        frame.setSize(800, 300);
        frame.setVisible(true);
    }
}

