/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.Environment;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.Matrix;
import jasymca.ParseException;
import jasymca.Polynomial;
import jasymca.Processor;
import jasymca.SimpleVariable;
import jasymca.Vektor;
import java.util.List;
import jhplot.H1D;
import jhplot.H2D;

public class XProcessor
extends Processor {
    static final int LIST = 1;
    static final int MATRIX = 2;
    static final int SCALAR = 3;
    static final int STRING = 4;
    static final int FUNCTION = 5;
    static final int LVALUE = 6;
    static final int SYMBOL = 7;
    static final int NARG = 8;
    static final int PDIR = 9;
    static final int COLON = 10;
    static final int H1D = 20;
    static final int H2D = 21;
    static final int BREAK = 1;
    static final int CONTINUE = 2;
    static final int RETURN = 3;
    static final int EXIT = 4;
    static final int ERROR = 5;
    int result = 1;

    public XProcessor(Environment env) {
        super(env);
    }

    @Override
    int instruction_type(Object x) {
        if (x instanceof List) {
            return 1;
        }
        if (x instanceof Matrix || x instanceof Vektor) {
            return 2;
        }
        if (x instanceof Algebraic) {
            return 3;
        }
        if (x instanceof H1D) {
            return 20;
        }
        if (x instanceof H2D) {
            return 21;
        }
        if (x.equals(":")) {
            return 10;
        }
        if (x instanceof String) {
            String s = (String)x;
            if (s.startsWith(" ")) {
                return 4;
            }
            if (s.startsWith("@")) {
                return 5;
            }
            if (s.startsWith("jasymca.Lambda")) {
                return 5;
            }
            if (s.startsWith("$")) {
                return 6;
            }
            if (s.startsWith("#")) {
                return 9;
            }
            return 7;
        }
        if (x instanceof Integer) {
            return 8;
        }
        if (x instanceof Lambda) {
            return 5;
        }
        return 0;
    }

    @Override
    public int process_instruction(Object x, boolean canon) throws ParseException, JasymcaException {
        if (this.interrupt_flag) {
            this.set_interrupt(false);
            throw new JasymcaException("Interrupted.");
        }
        switch (this.instruction_type(x)) {
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                this.stack.push(x);
                return 0;
            }
            case 2: {
                this.stack.push(x);
                return 0;
            }
            case 5: {
                if (!(x instanceof Lambda)) {
                    x = this.env.getValue((String)x);
                }
                return ((Lambda)x).lambda(this.stack);
            }
            case 7: {
                Object val = this.env.getValue((String)x);
                if (val != null) {
                    return this.process_instruction(val, canon);
                }
                if (canon) {
                    x = new Polynomial(new SimpleVariable((String)x));
                    this.stack.push(x);
                } else {
                    this.stack.push(x);
                }
                return 0;
            }
            case 9: {
                String selector = ((String)x).substring(1);
                if (selector.equals(";")) {
                    this.printStack();
                } else if (selector.equals(",")) {
                    this.clearStack();
                } else {
                    int nout;
                    if (selector.equals("brk")) {
                        return 1;
                    }
                    if (selector.equals("exit")) {
                        return 4;
                    }
                    if (selector.equals("cont")) {
                        return 2;
                    }
                    if (selector.equals("ret")) {
                        return 3;
                    }
                    Lambda.length = nout = Integer.parseInt(selector);
                }
                return 0;
            }
        }
        throw new JasymcaException("Unrecognized instruction type: " + x);
    }

    @Override
    void clearStack() {
        while (!this.stack.empty()) {
            Object e = this.stack.pop();
        }
    }

    @Override
    public void printStack() {
        while (!this.stack.empty()) {
            Object x = this.stack.pop();
            if (x instanceof Algebraic) {
                String vname;
                if (((Algebraic)x).name != null) {
                    vname = ((Algebraic)x).name;
                } else {
                    vname = "d" + this.result++;
                    this.env.putValue(vname, x);
                }
                if (this.ps == null) continue;
                String s = "    " + vname + " = ";
                this.ps.print(s);
                ((Algebraic)x).print(this.ps);
                this.ps.println("");
                continue;
            }
            if (!(x instanceof String)) continue;
            this.ps.println((String)x);
        }
    }
}

