/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.Exakt;
import jasymca.Jasymca;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.ParseException;
import jasymca.Zahl;
import org.apache.commons.math3.util.FastMath;

public class Unexakt
extends Zahl {
    public double real;
    public double imag;

    public Unexakt() {
    }

    public Unexakt(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public Unexakt(double real) {
        this(real, 0.0);
    }

    @Override
    public double norm() {
        double r;
        if (FastMath.abs((double)this.real) > FastMath.abs((double)this.imag)) {
            r = this.imag / this.real;
            r = FastMath.abs((double)this.real) * FastMath.sqrt((double)(1.0 + r * r));
        } else if (this.imag != 0.0) {
            r = this.real / this.imag;
            r = FastMath.abs((double)this.imag) * FastMath.sqrt((double)(1.0 + r * r));
        } else {
            r = 0.0;
        }
        return r;
    }

    public Unexakt arg() {
        return new Unexakt(FastMath.atan2((double)this.imag, (double)this.real));
    }

    @Override
    public Algebraic add(Algebraic x) throws JasymcaException {
        if (x instanceof Unexakt) {
            return new Unexakt(this.real + ((Unexakt)x).real, this.imag + ((Unexakt)x).imag);
        }
        return x.add(this);
    }

    @Override
    public Algebraic mult(Algebraic x) throws JasymcaException {
        if (x instanceof Unexakt) {
            return new Unexakt(this.real * ((Unexakt)x).real - this.imag * ((Unexakt)x).imag, this.real * ((Unexakt)x).imag + this.imag * ((Unexakt)x).real);
        }
        return x.mult(this);
    }

    @Override
    public Algebraic div(Algebraic x) throws JasymcaException {
        if (x instanceof Unexakt) {
            double cr;
            double d;
            double d2;
            Unexakt a = this;
            Unexakt b = (Unexakt)x;
            Unexakt c = new Unexakt(0.0);
            double abr = b.real;
            if (d2 < 0.0) {
                abr = -abr;
            }
            double abi = b.imag;
            if (d < 0.0) {
                abi = -abi;
            }
            if (abr <= abi) {
                if (abi == 0.0) {
                    throw new JasymcaException("Division by Zero.");
                }
                double ratio = b.real / b.imag;
                double den = b.imag * (1.0 + ratio * ratio);
                cr = (a.real * ratio + a.imag) / den;
                c.imag = (a.imag * ratio - a.real) / den;
            } else {
                double ratio = b.imag / b.real;
                double den = b.real * (1.0 + ratio * ratio);
                cr = (a.real + a.imag * ratio) / den;
                c.imag = (a.imag - a.real * ratio) / den;
            }
            c.real = cr;
            return c;
        }
        if (x instanceof Exakt) {
            return new Exakt(this.real, this.imag).div(x);
        }
        return super.div(x);
    }

    public String toString() {
        if (this.imag == 0.0) {
            return Jasymca.fmt.toString(this.real);
        }
        if (this.real == 0.0) {
            return Jasymca.fmt.toString(this.imag) + "i";
        }
        return "(" + Jasymca.fmt.toString(this.real) + (this.imag > 0.0 ? "+" : "") + Jasymca.fmt.toString(this.imag) + "i)";
    }

    @Override
    public boolean integerq() {
        return this.imag == 0.0 && (double)Math.round(this.real) == this.real;
    }

    @Override
    public boolean komplexq() {
        return this.imag != 0.0;
    }

    @Override
    public boolean imagq() {
        return this.imag != 0.0 && this.real == 0.0;
    }

    @Override
    public Algebraic realpart() throws JasymcaException {
        return new Unexakt(this.real);
    }

    @Override
    public Algebraic imagpart() throws JasymcaException {
        return new Unexakt(this.imag);
    }

    @Override
    public boolean equals(Object x) {
        if (x instanceof Unexakt) {
            return ((Unexakt)x).real == this.real && ((Unexakt)x).imag == this.imag;
        }
        if (x instanceof Exakt) {
            return ((Exakt)x).tofloat().equals(this);
        }
        return false;
    }

    @Override
    public boolean smaller(Zahl x) throws JasymcaException {
        Unexakt xu = x.unexakt();
        if (this.real == xu.real) {
            return this.imag < xu.imag;
        }
        return this.real < xu.real;
    }

    @Override
    public int intval() {
        return (int)this.real;
    }

    @Override
    public Zahl abs() {
        return new Unexakt(this.z_abs(this.real, this.imag));
    }

    private double z_abs(double real, double imag) {
        double temp;
        if (real < 0.0) {
            real = -real;
        }
        if (imag < 0.0) {
            imag = -imag;
        }
        if (imag > real) {
            temp = real;
            real = imag;
            imag = temp;
        }
        if (real + imag == real) {
            return real;
        }
        temp = imag / real;
        temp = real * FastMath.sqrt((double)(1.0 + temp * temp));
        return temp;
    }

    @Override
    public Algebraic map_lambda(LambdaAlgebraic lambda, Algebraic arg2) throws ParseException, JasymcaException {
        Zahl r;
        if (arg2 == null && (r = lambda.f(this)) != null) {
            return r;
        }
        return super.map_lambda(lambda, arg2);
    }

    @Override
    public Algebraic rat() {
        return new Exakt(this.real, this.imag);
    }
}

