/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.FunctionVariable;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.Poly;
import jasymca.Polynomial;
import jasymca.Rational;
import jasymca.SqrtExpand;
import jasymca.Unexakt;
import jasymca.Variable;
import jasymca.Zahl;

class TrigInverseExpand
extends LambdaAlgebraic {
    TrigInverseExpand() {
    }

    public Algebraic divExponential(Algebraic x, FunctionVariable fv, int n) throws JasymcaException {
        Algebraic[] a = new Algebraic[2];
        a[1] = x;
        Algebraic xk = Zahl.ZERO;
        for (int i = n; i >= 0; --i) {
            Algebraic kf = FunctionVariable.create("exp", fv.arg).pow_n(i);
            a[0] = a[1];
            a[1] = kf;
            Poly.polydiv(a, fv);
            if (!a[0].equals(Zahl.ZERO)) {
                Algebraic kfi = FunctionVariable.create("exp", fv.arg.mult(Zahl.MINUS)).pow_n(n - i);
                xk = xk.add(a[0].mult(kfi));
            }
            if (a[1].equals(Zahl.ZERO)) break;
        }
        return this.f_exakt(xk);
    }

    @Override
    Algebraic f_exakt(Algebraic x) throws JasymcaException {
        if (x instanceof Rational) {
            Rational xr = (Rational)x;
            if (xr.den.var instanceof FunctionVariable && ((FunctionVariable)xr.den.var).fname.equals("exp") && ((FunctionVariable)xr.den.var).arg.komplexq()) {
                FunctionVariable fv = (FunctionVariable)xr.den.var;
                int maxdeg = Math.max(Poly.degree(xr.nom, fv), Poly.degree(xr.den, fv));
                if (maxdeg % 2 == 0) {
                    return this.divExponential(xr.nom, fv, maxdeg / 2).div(this.divExponential(xr.den, fv, maxdeg / 2));
                }
                FunctionVariable fv2 = new FunctionVariable("exp", ((FunctionVariable)xr.den.var).arg.div(Zahl.TWO), ((FunctionVariable)xr.den.var).la);
                Polynomial ex = new Polynomial((Variable)fv2, new Algebraic[]{Zahl.ZERO, Zahl.ZERO, Zahl.ONE});
                Algebraic xr1 = xr.nom.value(xr.den.var, ex).div(xr.den.value(xr.den.var, ex));
                return this.f_exakt(xr1);
            }
        }
        if (x instanceof Polynomial && ((Polynomial)x).var instanceof FunctionVariable) {
            Polynomial xp = (Polynomial)x;
            Algebraic xf = null;
            FunctionVariable var = (FunctionVariable)xp.var;
            if (var.fname.equals("exp")) {
                Algebraic re = var.arg.realpart();
                Algebraic im = var.arg.imagpart();
                if (!im.equals(Zahl.ZERO)) {
                    boolean minus = TrigInverseExpand.minus(im);
                    if (minus) {
                        im = im.mult(Zahl.MINUS);
                    }
                    Algebraic a = FunctionVariable.create("exp", re);
                    Algebraic b = FunctionVariable.create("cos", im);
                    Algebraic c = FunctionVariable.create("sin", im).mult(Zahl.IONE);
                    xf = a.mult(minus ? b.sub(c) : b.add(c));
                }
            }
            if (var.fname.equals("log")) {
                Algebraic arg = var.arg;
                Zahl factor = Zahl.ONE;
                Algebraic sum = Zahl.ZERO;
                if (arg instanceof Polynomial && ((Polynomial)arg).degree() == 1 && ((Polynomial)arg).var instanceof FunctionVariable && ((Polynomial)arg).a[0].equals(Zahl.ZERO) && ((FunctionVariable)((Polynomial)arg).var).fname.equals("sqrt")) {
                    sum = FunctionVariable.create("log", ((Polynomial)arg).a[1]);
                    factor = new Unexakt(0.5);
                    arg = ((FunctionVariable)((Polynomial)arg).var).arg;
                    xf = FunctionVariable.create("log", arg);
                }
                try {
                    Algebraic re = arg.realpart();
                    Algebraic im = arg.imagpart();
                    if (!im.equals(Zahl.ZERO)) {
                        boolean min_im = TrigInverseExpand.minus(im);
                        if (min_im) {
                            im = im.mult(Zahl.MINUS);
                        }
                        Algebraic a1 = new SqrtExpand().f_exakt(arg.mult(arg.cc()));
                        Algebraic a = FunctionVariable.create("log", a1).div(Zahl.TWO);
                        Algebraic b1 = this.f_exakt(re.div(im));
                        Algebraic b = FunctionVariable.create("atan", b1).mult(Zahl.IONE);
                        xf = min_im ? a.add(b) : a.sub(b);
                        Algebraic pi2 = Zahl.PI.mult(Zahl.IONE).div(Zahl.TWO);
                        xf = min_im ? xf.sub(pi2) : xf.add(pi2);
                    }
                }
                catch (JasymcaException jasymcaException) {
                    // empty catch block
                }
                if (xf != null) {
                    xf = xf.mult(factor).add(sum);
                }
            }
            if (xf == null) {
                return x.map(this);
            }
            Algebraic r = Zahl.ZERO;
            for (int i = xp.a.length - 1; i > 0; --i) {
                r = r.add(this.f_exakt(xp.a[i])).mult(xf);
            }
            if (xp.a.length > 0) {
                r = r.add(this.f_exakt(xp.a[0]));
            }
            return r;
        }
        return x.map(this);
    }

    static boolean minus(Algebraic x) throws JasymcaException {
        if (x instanceof Zahl) {
            return ((Zahl)x).smaller(Zahl.ZERO);
        }
        if (x instanceof Polynomial) {
            return TrigInverseExpand.minus(((Polynomial)x).a[((Polynomial)x).degree()]);
        }
        if (x instanceof Rational) {
            boolean a = TrigInverseExpand.minus(((Rational)x).nom);
            boolean b = TrigInverseExpand.minus(((Rational)x).den);
            return a && !b || !a && b;
        }
        throw new JasymcaException("minus not implemented for " + x);
    }
}

