/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.Constant;
import jasymca.JasymcaException;
import jasymca.Polynomial;
import jasymca.SimpleVariable;
import jasymca.Variable;
import jasymca.Vektor;

class Root
extends Constant {
    Vektor poly;
    int n;

    public Root(Vektor poly, int n) {
        super("Root", 0.0);
        this.poly = poly;
        this.n = n;
    }

    @Override
    public boolean smaller(Variable v) {
        if (!(v instanceof Root)) {
            return super.smaller(v);
        }
        if (!this.poly.equals(((Root)v).poly)) {
            return this.poly.norm() < ((Root)v).poly.norm();
        }
        return this.n < ((Root)v).n;
    }

    @Override
    public boolean equals(Object x) {
        return x instanceof Root && ((Root)x).poly.equals(this.poly) && ((Root)x).n == this.n;
    }

    @Override
    public String toString() {
        return "Root(" + new Vektor(this.poly) + ", " + this.n + ")";
    }

    @Override
    Algebraic getValue() throws JasymcaException {
        Vektor roots = new Polynomial((Variable)new SimpleVariable("x"), this.poly).roots();
        return roots.get(this.n);
    }
}

