/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.Exponential;
import jasymca.FunctionVariable;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.LambdaLINSOLVE;
import jasymca.Matrix;
import jasymca.Poly;
import jasymca.Polynomial;
import jasymca.SimpleVariable;
import jasymca.TrigInverseExpand;
import jasymca.Variable;
import jasymca.Vektor;
import jasymca.Zahl;

public class Rational
extends Algebraic {
    Algebraic nom;
    Polynomial den;

    public Rational(Algebraic nom, Polynomial den) throws JasymcaException {
        Algebraic norm = den.a[den.degree()];
        if (norm instanceof Zahl) {
            this.nom = nom.div(norm);
            this.den = (Polynomial)den.div(norm);
        } else {
            this.nom = nom;
            this.den = den;
        }
    }

    @Override
    public boolean ratfunc(Variable v) {
        return this.nom.ratfunc(v) && this.den.ratfunc(v);
    }

    @Override
    public Algebraic reduce() throws JasymcaException {
        Algebraic gcd;
        if (this.nom instanceof Zahl) {
            if (this.nom.equals(Zahl.ZERO)) {
                return Zahl.ZERO;
            }
            return this;
        }
        Algebraic[] pq = new Algebraic[]{this.nom, this.den};
        if (!this.nom.equals((pq = Exponential.reduce_exp(pq))[0]) || !this.den.equals(pq[1])) {
            return pq[0].div(pq[1]).reduce();
        }
        if (this.exaktq() && !(gcd = Poly.poly_gcd(this.den, this.nom)).equals(Zahl.ONE)) {
            Algebraic n = Poly.polydiv(this.nom, gcd);
            Algebraic d = Poly.polydiv(this.den, gcd);
            if (d.equals(Zahl.ONE)) {
                return n;
            }
            if (d instanceof Zahl) {
                return n.div(d);
            }
            return new Rational(n, (Polynomial)d);
        }
        return this;
    }

    @Override
    public boolean exaktq() {
        return this.nom.exaktq() && this.den.exaktq();
    }

    @Override
    public Algebraic add(Algebraic x) throws JasymcaException {
        if (x instanceof Rational) {
            return this.nom.mult(((Rational)x).den).add(((Rational)x).nom.mult(this.den)).div(this.den.mult(((Rational)x).den)).reduce();
        }
        return this.nom.add(x.mult(this.den)).div(this.den).reduce();
    }

    @Override
    public Algebraic mult(Algebraic x) throws JasymcaException {
        if (x instanceof Rational) {
            return this.nom.mult(((Rational)x).nom).div(this.den.mult(((Rational)x).den)).reduce();
        }
        return this.nom.mult(x).div(this.den).reduce();
    }

    @Override
    public Algebraic div(Algebraic x) throws JasymcaException {
        if (x instanceof Rational) {
            return this.nom.mult(((Rational)x).den).div(this.den.mult(((Rational)x).nom)).reduce();
        }
        return this.nom.div(this.den.mult(x)).reduce();
    }

    public String toString() {
        return "(" + this.nom + "/" + this.den + ")";
    }

    @Override
    public boolean equals(Object x) {
        return x instanceof Rational && ((Rational)x).nom.equals(this.nom) && ((Rational)x).den.equals(this.den);
    }

    @Override
    public Algebraic deriv(Variable var) throws JasymcaException {
        return this.nom.deriv(var).mult(this.den).sub(this.den.deriv(var).mult(this.nom)).div(this.den.mult(this.den)).reduce();
    }

    @Override
    public Algebraic integrate(Variable var) throws JasymcaException {
        if (!this.den.depends(var)) {
            return this.nom.integrate(var).div(this.den);
        }
        Algebraic quot = this.den.deriv(var).div(this.nom);
        if (quot.deriv(var).equals(Zahl.ZERO)) {
            return FunctionVariable.create("log", this.den).div(quot);
        }
        Algebraic[] q = new Algebraic[]{this.nom, this.den};
        Poly.polydiv(q, var);
        if (!q[0].equals(Zahl.ZERO) && this.nom.ratfunc(var) && this.den.ratfunc(var)) {
            return q[0].integrate(var).add(q[1].div(this.den).integrate(var));
        }
        if (this.ratfunc(var)) {
            Algebraic r = Zahl.ZERO;
            Vektor h = Rational.horowitz(this.nom, this.den, var);
            if (h.get(0) instanceof Rational) {
                r = r.add(h.get(0));
            }
            if (h.get(1) instanceof Rational) {
                r = r.add(new TrigInverseExpand().f_exakt(((Rational)h.get(1)).intrat(var)));
            }
            return r;
        }
        throw new JasymcaException("Could not integrate Function " + this);
    }

    @Override
    public double norm() {
        return this.nom.norm() / this.den.norm();
    }

    @Override
    public Algebraic cc() throws JasymcaException {
        return this.nom.cc().div(this.den.cc());
    }

    @Override
    public boolean depends(Variable var) {
        return this.nom.depends(var) || this.den.depends(var);
    }

    @Override
    public Algebraic value(Variable var, Algebraic x) throws JasymcaException {
        return this.nom.value(var, x).div(this.den.value(var, x));
    }

    @Override
    public Algebraic map(LambdaAlgebraic f) throws JasymcaException {
        return f.f_exakt(this.nom).div(f.f_exakt(this.den));
    }

    public static Vektor horowitz(Algebraic p, Polynomial q, Variable x) throws JasymcaException {
        int i;
        Algebraic d;
        if (Poly.degree(p, x) >= Poly.degree(q, x)) {
            throw new JasymcaException("Degree of p must be smaller than degree of q");
        }
        p = p.rat();
        Algebraic b = Poly.polydiv(q = (Polynomial)q.rat(), d = Poly.poly_gcd(q, q.deriv(x)));
        int m = b instanceof Polynomial ? ((Polynomial)b).degree() : 0;
        int n = d instanceof Polynomial ? ((Polynomial)d).degree() : 0;
        SimpleVariable[] a = new SimpleVariable[m];
        Polynomial X = new Polynomial(x);
        Algebraic A = Zahl.ZERO;
        for (int i2 = a.length - 1; i2 >= 0; --i2) {
            a[i2] = new SimpleVariable("a" + i2);
            A = A.add(new Polynomial(a[i2]));
            if (i2 <= 0) continue;
            A = A.mult(X);
        }
        SimpleVariable[] c = new SimpleVariable[n];
        Algebraic C = Zahl.ZERO;
        for (int i3 = c.length - 1; i3 >= 0; --i3) {
            c[i3] = new SimpleVariable("c" + i3);
            C = C.add(new Polynomial(c[i3]));
            if (i3 <= 0) continue;
            C = C.mult(X);
        }
        Algebraic r = Poly.polydiv(C.mult(b).mult(d.deriv(x)), d);
        r = b.mult(C.deriv(x)).sub(r).add(d.mult(A));
        Algebraic[][] aik = new Algebraic[m + n][m + n];
        Algebraic[] co = new Algebraic[m + n];
        for (int i4 = 0; i4 < m + n; ++i4) {
            int k;
            co[i4] = Poly.coefficient(p, x, i4);
            Algebraic cf = Poly.coefficient(r, x, i4);
            for (k = 0; k < m; ++k) {
                aik[i4][k] = cf.deriv(a[k]);
            }
            for (k = 0; k < n; ++k) {
                aik[i4][k + m] = cf.deriv(c[k]);
            }
        }
        Vektor s = LambdaLINSOLVE.Gauss(new Matrix(aik), new Vektor(co));
        A = Zahl.ZERO;
        for (i = m - 1; i >= 0; --i) {
            A = A.add(s.get(i));
            if (i <= 0) continue;
            A = A.mult(X);
        }
        C = Zahl.ZERO;
        for (i = n - 1; i >= 0; --i) {
            C = C.add(s.get(i + m));
            if (i <= 0) continue;
            C = C.mult(X);
        }
        co = new Algebraic[]{C.div(d), A.div(b)};
        return new Vektor(co);
    }

    Algebraic intrat(Variable x) throws JasymcaException {
        Algebraic de = this.den.deriv(x);
        if (de instanceof Zahl) {
            return this.makelog(this.nom.div(de), x, this.den.a[0].mult(Zahl.MINUS).div(de));
        }
        Algebraic r = this.nom.div(de);
        Vektor xi = this.den.monic().roots();
        Algebraic rs = Zahl.ZERO;
        for (int i = 0; i < xi.length(); ++i) {
            Algebraic c = r.value(x, xi.get(i));
            rs = rs.add(this.makelog(c, x, xi.get(i)));
        }
        return rs;
    }

    Algebraic makelog(Algebraic c, Variable x, Algebraic a) throws JasymcaException {
        Algebraic arg = new Polynomial(x).sub(a);
        return FunctionVariable.create("log", arg).mult(c);
    }
}

