/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

public class Pzeros {
    static Pzeros pz = new Pzeros();
    static int c__9 = 9;
    static int c__1 = 1;
    doublecomplex c_b35 = new doublecomplex(1.0, 0.0);
    static int c__3 = 3;
    static int c__2 = 2;

    public static void main(String[] args) {
        double[] ar = new double[]{0.0, 1.0, 1.0, 1.0};
        double[] ai = new double[]{0.0, 0.0, 1.0, 0.0};
        boolean[] err = new boolean[]{true, true, true, true};
        Pzeros.aberth(ar, ai, err);
        for (int i = 0; i < ar.length - 1; ++i) {
            System.out.println(i + ": " + ar[i] + "+i*" + ai[i] + "  " + err[i]);
        }
    }

    public static void aberth(double[] ar, double[] ai, boolean[] err) {
        int i;
        int n_zero;
        for (int i2 = 0; i2 < err.length; ++i2) {
            err[i2] = true;
        }
        if (ar.length != ai.length || ar.length != err.length) {
            return;
        }
        for (n_zero = 0; n_zero < ar.length && ar[n_zero] == 0.0 && ai[n_zero] == 0.0; ++n_zero) {
        }
        if (n_zero == ar.length) {
            return;
        }
        doublecomplex[] poly = new doublecomplex[ar.length - n_zero];
        for (int i3 = 0; i3 < poly.length; ++i3) {
            poly[i3] = pz.dc(ar[i3 + n_zero], ai[i3 + n_zero]);
        }
        int n = poly.length - 1;
        double eps = 2.22044604925031E-16;
        double big = Double.MAX_VALUE;
        double theSmall = Double.MIN_VALUE;
        int nitmax = 100;
        doublecomplex[] root = new doublecomplex[n];
        double[] radius = new double[n];
        boolean[] errs = new boolean[n + 1];
        for (int i4 = 0; i4 < n; ++i4) {
            root[i4] = pz.dc();
            radius[i4] = 1.0;
            errs[i4] = true;
        }
        int[] iter = new int[]{0};
        double[] apoly = new double[n + 1];
        double[] apolyr = new double[n + 1];
        for (i = 0; i < n + 1; ++i) {
            apoly[i] = 1.0;
            apolyr[i] = 1.0;
        }
        pz.polzeros_(n, poly, eps, big, theSmall, nitmax, root, radius, errs, iter, apoly, apolyr);
        for (i = 0; i < n_zero; ++i) {
            ar[i] = 0.0;
            ai[i] = 0.0;
            err[i] = false;
        }
        for (i = n_zero; i < ar.length - 1; ++i) {
            ar[i] = root[i - n_zero].r;
            ai[i] = root[i - n_zero].i;
            err[i] = errs[i - n_zero];
        }
    }

    public static void bairstow(double[] ar, double[] ai, boolean[] err) {
        int n;
        for (int i = 0; i < err.length; ++i) {
            err[i] = true;
        }
        if (ar.length != ai.length || ar.length != err.length) {
            return;
        }
        double[] a = new double[ar.length];
        for (int i = 0; i < ar.length; ++i) {
            a[i] = ar[ar.length - i - 1] / ar[ar.length - 1];
        }
        double[] b = new double[n + 1];
        double[] c = new double[n + 1];
        c[0] = 1.0;
        b[0] = 1.0;
        for (n = ar.length - 1; n > 2; n -= 2) {
            int i;
            double s = 0.0;
            double r = 0.0;
            double dr = 1.0;
            double ds = 0.0;
            double eps = 1.0E-14;
            int iter = 1;
            boolean precision_error_flag = false;
            while (Math.abs(dr) + Math.abs(ds) > eps) {
                if (iter % 200 == 0) {
                    r = Math.random() * 1000.0;
                }
                if (iter % 500 == 0) {
                    eps *= 10.0;
                    precision_error_flag = true;
                }
                b[1] = a[1] - r;
                c[1] = b[1] - r;
                for (i = 2; i <= n; ++i) {
                    b[i] = a[i] - r * b[i - 1] - s * b[i - 2];
                    c[i] = b[i] - r * c[i - 1] - s * c[i - 2];
                }
                double dn = c[n - 1] * c[n - 3] - c[n - 2] * c[n - 2];
                double drn = b[n] * c[n - 3] - b[n - 1] * c[n - 2];
                double dsn = b[n - 1] * c[n - 1] - b[n] * c[n - 2];
                if (Math.abs(dn) < 1.0E-16) {
                    dn = 1.0;
                    drn = 1.0;
                    dsn = 1.0;
                }
                dr = drn / dn;
                ds = dsn / dn;
                r += dr;
                s += ds;
                ++iter;
            }
            for (i = 0; i < n - 1; ++i) {
                a[i] = b[i];
            }
            a[n] = s;
            a[n - 1] = r;
            err[n - 1] = precision_error_flag;
            err[n - 2] = precision_error_flag;
        }
        double[] real = new double[2];
        double[] imag = new double[2];
        for (int i = a.length - 1; i >= 2; i -= 2) {
            Pzeros.pqsolve(a[i - 1], a[i], real, imag);
            ar[i - 1] = real[0];
            ai[i - 1] = imag[0];
            ar[i - 2] = real[1];
            ai[i - 2] = imag[1];
        }
        if (n % 2 == 1) {
            ar[0] = -a[1];
            ai[0] = 0.0;
            err[0] = false;
        } else {
            err[1] = false;
            err[0] = false;
        }
    }

    static void pqsolve(double p, double q, double[] r, double[] i) {
        if ((q = (p = -p / 2.0) * p - q) >= 0.0) {
            q = Math.sqrt(q);
            r[0] = p + q;
            i[0] = 0.0;
            r[1] = p - q;
            i[1] = 0.0;
        } else {
            q = Math.sqrt(-q);
            r[0] = p;
            i[0] = q;
            r[1] = p;
            i[1] = -q;
        }
    }

    void PrintError(String s) {
    }

    double z_abs(doublecomplex z) {
        double temp;
        double real = z.r;
        double imag = z.i;
        if (real < 0.0) {
            real = -real;
        }
        if (imag < 0.0) {
            imag = -imag;
        }
        if (imag > real) {
            temp = real;
            real = imag;
            imag = temp;
        }
        if (real + imag == real) {
            return real;
        }
        temp = imag / real;
        temp = real * Math.sqrt(1.0 + temp * temp);
        return temp;
    }

    int pow_ii(int ap, int bp) {
        int x = ap;
        int n = bp;
        if (n <= 0) {
            if (n == 0 || x == 1) {
                return 1;
            }
            if (x != -1) {
                return x == 0 ? 1 / x : 0;
            }
            n = -n;
        }
        long u = n;
        int pow = 1;
        while (true) {
            if ((u & 1L) != 0L) {
                pow *= x;
            }
            if ((u >>= 1) == 0L) break;
            x *= x;
        }
        return pow;
    }

    void z_div(doublecomplex c, doublecomplex a, doublecomplex b) {
        double cr;
        double d;
        double d2;
        double abr = b.r;
        if (d2 < 0.0) {
            abr = -abr;
        }
        double abi = b.i;
        if (d < 0.0) {
            abi = -abi;
        }
        if (abr <= abi) {
            if (abi == 0.0) {
                this.PrintError("complex division by zero");
                c.r = 1.0;
                c.i = 1.0;
                return;
            }
            double ratio = b.r / b.i;
            double den = b.i * (1.0 + ratio * ratio);
            cr = (a.r * ratio + a.i) / den;
            c.i = (a.i * ratio - a.r) / den;
        } else {
            double ratio = b.i / b.r;
            double den = b.r * (1.0 + ratio * ratio);
            cr = (a.r + a.i * ratio) / den;
            c.i = (a.i - a.r * ratio) / den;
        }
        c.r = cr;
    }

    doublecomplex dc() {
        return new doublecomplex(0.0, 0.0);
    }

    doublecomplex dc(double r, double i) {
        return new doublecomplex(r, i);
    }

    void polzeros_(int n, doublecomplex[] poly, double eps, double big, double theSmall, int nitmax, doublecomplex[] root, double[] radius, boolean[] err, int[] iter, double[] apoly, double[] apolyr) {
        int i;
        doublecomplex z__1 = this.dc();
        doublecomplex z__2 = this.dc();
        doublecomplex z__3 = this.dc();
        doublecomplex z__4 = this.dc();
        doublecomplex corr = this.dc();
        doublecomplex abcorr = this.dc();
        int[] nzeros = new int[1];
        if (this.z_abs(poly[n]) == 0.0) {
            this.PrintError("Inconsistent data: the leading coefficient is zero");
            return;
        }
        if (this.z_abs(poly[0]) == 0.0) {
            this.PrintError("The constant term is zero: deflate the polynomial");
            return;
        }
        double amax = 0.0;
        int i__1 = n + 1;
        for (i = 1; i <= i__1; ++i) {
            apoly[i - 1] = this.z_abs(poly[i - 1]);
            double d__1 = amax;
            double d__2 = apoly[i - 1];
            amax = Math.max(d__1, d__2);
            apolyr[i - 1] = apoly[i - 1];
        }
        if (amax >= big / (double)(n + 1)) {
            this.PrintError("WARNING: COEFFICIENTS TOO BIG, OVERFLOW IS LIKELY");
        }
        i__1 = n;
        for (i = 1; i <= i__1; ++i) {
            radius[i - 1] = 0.0;
            err[i - 1] = true;
        }
        this.start_(n, apolyr, root, radius, nzeros, theSmall, big, err);
        i__1 = n + 1;
        for (i = 1; i <= i__1; ++i) {
            apolyr[n - i + 2 - 1] = eps * apoly[i - 1] * (double)((float)(n - i + 1) * 3.8f + 1.0f);
            apoly[i - 1] = eps * apoly[i - 1] * (double)((float)(i - 1) * 3.8f + 1.0f);
        }
        if (apoly[0] == 0.0 || apoly[n + 1 - 1] == 0.0) {
            this.PrintError("WARNING: THE COMPUTATION OF SOME INCLUSION RADIUS MAY FAIL. THIS IS REPORTED BY RADIUS=0");
        }
        i__1 = n;
        for (i = 1; i <= i__1; ++i) {
            err[i - 1] = true;
            if (radius[i - 1] != -1.0) continue;
            err[i - 1] = false;
        }
        i__1 = nitmax;
        iter[0] = 1;
        while (iter[0] <= i__1) {
            int i__2 = n;
            for (i = 1; i <= i__2; ++i) {
                if (!err[i - 1]) continue;
                this.newton_(n, poly, apoly, apolyr, root[i - 1], theSmall, radius, corr, err, i - 1);
                if (err[i - 1]) {
                    this.aberth_(n, i, root, abcorr);
                    int i__3 = i;
                    int i__4 = i;
                    z__4.r = corr.r * abcorr.r - corr.i * abcorr.i;
                    z__4.i = corr.r * abcorr.i + corr.i * abcorr.r;
                    z__3.r = 1.0 - z__4.r;
                    z__3.i = -z__4.i;
                    this.z_div(z__2, corr, z__3);
                    z__1.r = root[i__4 - 1].r - z__2.r;
                    z__1.i = root[i__4 - 1].i - z__2.i;
                    root[i__3 - 1].r = z__1.r;
                    root[i__3 - 1].i = z__1.i;
                    continue;
                }
                nzeros[0] = nzeros[0] + 1;
                if (nzeros[0] != n) continue;
                return;
            }
            iter[0] = iter[0] + 1;
        }
    }

    void newton_(int n, doublecomplex[] poly, double[] apoly, double[] apolyr, doublecomplex z, double theSmall, double[] radius, doublecomplex corr, boolean[] again, int ik) {
        int i__1;
        doublecomplex z__1 = this.dc();
        doublecomplex z__2 = this.dc();
        doublecomplex ppsp = this.dc();
        doublecomplex p = this.dc();
        doublecomplex p1 = this.dc();
        doublecomplex zi = this.dc();
        doublecomplex den = this.dc();
        double az = this.z_abs(z);
        if (az <= 1.0) {
            int i__12 = n + 1;
            p.r = poly[i__12 - 1].r;
            p.i = poly[i__12 - 1].i;
            double ap = apoly[n + 1 - 1];
            p1.r = p.r;
            p1.i = p.i;
            for (int i = n; i >= 2; --i) {
                z__2.r = p.r * z.r - p.i * z.i;
                z__2.i = p.r * z.i + p.i * z.r;
                i__12 = i;
                z__1.r = z__2.r + poly[i__12 - 1].r;
                z__1.i = z__2.i + poly[i__12 - 1].i;
                p.r = z__1.r;
                p.i = z__1.i;
                z__2.r = p1.r * z.r - p1.i * z.i;
                z__2.i = p1.r * z.i + p1.i * z.r;
                z__1.r = z__2.r + p.r;
                z__1.i = z__2.i + p.i;
                p1.r = z__1.r;
                p1.i = z__1.i;
                ap = ap * az + apoly[i - 1];
            }
            z__2.r = p.r * z.r - p.i * z.i;
            z__2.i = p.r * z.i + p.i * z.r;
            z__1.r = z__2.r + poly[0].r;
            z__1.i = z__2.i + poly[0].i;
            p.r = z__1.r;
            p.i = z__1.i;
            ap = ap * az + apoly[0];
            this.z_div(z__1, p, p1);
            corr.r = z__1.r;
            corr.i = z__1.i;
            double absp = this.z_abs(p);
            boolean bl = again[ik] = absp > theSmall + ap;
            if (!again[ik]) {
                radius[ik] = (double)n * (absp + ap) / this.z_abs(p1);
            }
            return;
        }
        this.z_div(z__1, this.c_b35, z);
        zi.r = z__1.r;
        zi.i = z__1.i;
        double azi = 1.0 / az;
        p.r = poly[0].r;
        p.i = poly[0].i;
        p1.r = p.r;
        p1.i = p.i;
        double ap = apolyr[n + 1 - 1];
        for (int i = n; i >= 2; --i) {
            z__2.r = p.r * zi.r - p.i * zi.i;
            z__2.i = p.r * zi.i + p.i * zi.r;
            i__1 = n - i + 2;
            z__1.r = z__2.r + poly[i__1 - 1].r;
            z__1.i = z__2.i + poly[i__1 - 1].i;
            p.r = z__1.r;
            p.i = z__1.i;
            z__2.r = p1.r * zi.r - p1.i * zi.i;
            z__2.i = p1.r * zi.i + p1.i * zi.r;
            z__1.r = z__2.r + p.r;
            z__1.i = z__2.i + p.i;
            p1.r = z__1.r;
            p1.i = z__1.i;
            ap = ap * azi + apolyr[i - 1];
        }
        z__2.r = p.r * zi.r - p.i * zi.i;
        z__2.i = p.r * zi.i + p.i * zi.r;
        i__1 = n + 1;
        z__1.r = z__2.r + poly[i__1 - 1].r;
        z__1.i = z__2.i + poly[i__1 - 1].i;
        p.r = z__1.r;
        p.i = z__1.i;
        ap = ap * azi + apolyr[0];
        double absp = this.z_abs(p);
        again[ik] = absp > theSmall + ap;
        z__2.r = p.r * z.r - p.i * z.i;
        z__2.i = p.r * z.i + p.i * z.r;
        this.z_div(z__1, z__2, p1);
        ppsp.r = z__1.r;
        ppsp.i = z__1.i;
        double d__1 = n;
        z__2.r = d__1 * ppsp.r;
        z__2.i = d__1 * ppsp.i;
        z__1.r = z__2.r - 1.0;
        z__1.i = z__2.i;
        den.r = z__1.r;
        den.i = z__1.i;
        this.z_div(z__2, ppsp, den);
        z__1.r = z.r * z__2.r - z.i * z__2.i;
        z__1.i = z.r * z__2.i + z.i * z__2.r;
        corr.r = z__1.r;
        corr.i = z__1.i;
        if (again[ik]) {
            return;
        }
        radius[ik] = this.z_abs(ppsp) + ap * az / this.z_abs(p1);
        radius[ik] = (double)n * radius[ik] / this.z_abs(den);
        int n2 = ik;
        radius[n2] = radius[n2] * az;
    }

    void aberth_(int n, int j, doublecomplex[] root, doublecomplex abcorr) {
        int i__2;
        doublecomplex z__1 = this.dc();
        doublecomplex z__2 = this.dc();
        doublecomplex z = this.dc();
        doublecomplex zj = this.dc();
        abcorr.r = 0.0;
        abcorr.i = 0.0;
        int i__1 = j;
        zj.r = root[i__1 - 1].r;
        zj.i = root[i__1 - 1].i;
        i__1 = j - 1;
        int i = 1;
        while (i <= i__1) {
            i__2 = i++;
            z__1.r = zj.r - root[i__2 - 1].r;
            z__1.i = zj.i - root[i__2 - 1].i;
            z.r = z__1.r;
            z.i = z__1.i;
            this.z_div(z__2, this.c_b35, z);
            z__1.r = abcorr.r + z__2.r;
            z__1.i = abcorr.i + z__2.i;
            abcorr.r = z__1.r;
            abcorr.i = z__1.i;
        }
        i__1 = n;
        i = j + 1;
        while (i <= i__1) {
            i__2 = i++;
            z__1.r = zj.r - root[i__2 - 1].r;
            z__1.i = zj.i - root[i__2 - 1].i;
            z.r = z__1.r;
            z.i = z__1.i;
            this.z_div(z__2, this.c_b35, z);
            z__1.r = abcorr.r + z__2.r;
            z__1.i = abcorr.i + z__2.i;
            abcorr.r = z__1.r;
            abcorr.i = z__1.i;
        }
    }

    int start_(int n, double[] a, doublecomplex[] y, double[] radius, int[] nz, double theSmall, double big, boolean[] h) {
        int i;
        doublecomplex z__1 = this.dc();
        doublecomplex z__2 = this.dc();
        doublecomplex z__3 = this.dc();
        double r = 0.0;
        double xsmall = Math.log(theSmall);
        double xbig = Math.log(big);
        nz[0] = 0;
        int i__1 = n + 1;
        for (i = 1; i <= i__1; ++i) {
            a[i - 1] = a[i - 1] != 0.0 ? Math.log(a[i - 1]) : -1.0E30;
        }
        i__1 = n + 1;
        this.cnvex_(i__1, a, h);
        int iold = 1;
        double th = 6.2831853071796 / (double)n;
        i__1 = n + 1;
        for (i = 2; i <= i__1; ++i) {
            if (!h[i - 1]) continue;
            int nzeros = i - iold;
            double temp = (a[iold - 1] - a[i - 1]) / (double)nzeros;
            if (temp < -xbig && temp >= xsmall) {
                nz[0] = nz[0] + nzeros;
                r = 1.0 / big;
            }
            if (temp < xsmall) {
                nz[0] = nz[0] + nzeros;
            }
            if (temp > xbig) {
                r = big;
                nz[0] = nz[0] + nzeros;
            }
            double d__1 = -xbig;
            if (temp <= xbig && temp > Math.max(d__1, xsmall)) {
                r = Math.exp(temp);
            }
            double ang = 6.2831853071796 / (double)nzeros;
            int i__2 = i - 1;
            int j = iold;
            while (j <= i__2) {
                int jj = j - iold + 1;
                if (r <= 1.0 / big || r == big) {
                    radius[j - 1] = -1.0;
                }
                int i__3 = j++;
                d__1 = Math.cos(ang * (double)jj + th * (double)i + 0.7);
                double d__2 = Math.sin(ang * (double)jj + th * (double)i + 0.7);
                z__3.r = d__2 * 0.0;
                z__3.i = d__2 * 1.0;
                z__2.r = d__1 + z__3.r;
                z__2.i = z__3.i;
                z__1.r = r * z__2.r;
                z__1.i = r * z__2.i;
                y[i__3 - 1].r = z__1.r;
                y[i__3 - 1].i = z__1.i;
            }
            iold = i;
        }
        return 0;
    }

    int cnvex_(int n, double[] a, boolean[] h) {
        int i;
        int i__1 = n;
        for (i = 1; i <= i__1; ++i) {
            h[i - 1] = true;
        }
        int k = (int)(Math.log((double)n - 2.0) / Math.log(2.0));
        i__1 = k + 1;
        if (this.pow_ii(c__2, i__1) <= n - 2) {
            ++k;
        }
        int m = 1;
        i__1 = k;
        for (i = 0; i <= i__1; ++i) {
            int nj;
            int i__2 = 0;
            int i__3 = (n - 2 - m) / (m + m);
            i__2 = nj = Math.max(i__2, i__3);
            for (int j = 0; j <= i__2; ++j) {
                int jc = (j + j + 1) * m + 1;
                this.cmerge_(n, a, jc, m, h);
            }
            m += m;
        }
        return 0;
    }

    int left_(int n, boolean[] h, int i, int[] il) {
        il[0] = i - 1;
        while (il[0] >= 0) {
            if (h[il[0] - 1]) {
                return 0;
            }
            il[0] = il[0] - 1;
        }
        return 0;
    }

    int right_(int n, boolean[] h, int i, int[] ir) {
        int i__1 = n;
        ir[0] = i + 1;
        while (ir[0] <= i__1) {
            if (h[ir[0] - 1]) {
                return 0;
            }
            ir[0] = ir[0] + 1;
        }
        return 0;
    }

    int cmerge_(int n, double[] a, int i, int m, boolean[] h) {
        int[] ill = new int[1];
        int[] irr = new int[1];
        int[] il = new int[1];
        int[] ir = new int[1];
        this.left_(n, h, i, il);
        this.right_(n, h, i, ir);
        if (this.ctest_(n, a, il[0], i, ir[0])) {
            return 0;
        }
        h[i - 1] = false;
        while (true) {
            boolean tstr;
            boolean tstl;
            if (il[0] == i - m) {
                tstl = true;
            } else {
                this.left_(n, h, il[0], ill);
                tstl = this.ctest_(n, a, ill[0], il[0], ir[0]);
            }
            int i__1 = n;
            int i__2 = i + m;
            if (ir[0] == Math.min(i__1, i__2)) {
                tstr = true;
            } else {
                this.right_(n, h, ir[0], irr);
                tstr = this.ctest_(n, a, il[0], ir[0], irr[0]);
            }
            h[il[0] - 1] = tstl;
            h[ir[0] - 1] = tstr;
            if (tstl && tstr) {
                return 0;
            }
            if (!tstl) {
                il[0] = ill[0];
            }
            if (tstr) continue;
            ir[0] = irr[0];
        }
    }

    boolean ctest_(int n, double[] a, int il, int i, int ir) {
        double s1 = a[i - 1] - a[il - 1];
        double s2 = a[ir - 1] - a[i - 1];
        s1 *= (double)(ir - i);
        s2 *= (double)(i - il);
        boolean ret_val = false;
        if (s1 > s2 + 0.4) {
            ret_val = true;
        }
        return ret_val;
    }

    class doublecomplex {
        double r;
        double i;

        public doublecomplex(double r, double i) {
            this.r = r;
            this.i = i;
        }

        public String toString() {
            return this.r + " + i*" + this.i;
        }
    }
}

