/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.FunctionVariable;
import jasymca.JasymcaException;
import jasymca.Polynomial;
import jasymca.Rational;
import jasymca.SimpleVariable;
import jasymca.Variable;
import jasymca.Zahl;

public final class Poly {
    public static Polynomial top = new Polynomial(SimpleVariable.top);

    static Algebraic[] pqsolve(Algebraic p, Algebraic q) throws JasymcaException {
        Algebraic r = p.mult(Zahl.MINUS).div(Zahl.TWO);
        Algebraic s = FunctionVariable.create("sqrt", r.mult(r).sub(q));
        Algebraic[] result = new Algebraic[]{r.add(s), r.sub(s)};
        return result;
    }

    public static int degree(Algebraic p, Variable v) {
        if (p instanceof Polynomial) {
            return ((Polynomial)p).degree(v);
        }
        if (p instanceof Rational) {
            Rational r = (Rational)p;
            if (r.den.depends(v)) {
                return 0;
            }
            return Poly.degree(r.nom, v);
        }
        return 0;
    }

    public static Algebraic coefficient(Algebraic p, Variable v, int n) throws JasymcaException {
        if (p instanceof Polynomial) {
            return ((Polynomial)p).coefficient(v, n);
        }
        if (p instanceof Rational) {
            Rational r = (Rational)p;
            if (r.den.depends(v)) {
                throw new JasymcaException("Cannot determine coefficient of " + v + " in " + r);
            }
            return Poly.coefficient(r.nom, v, n).div(r.den);
        }
        return n == 0 ? p : Zahl.ZERO;
    }

    public static void polydiv(Algebraic[] a, Variable v) throws JasymcaException {
        int d1;
        int d0 = Poly.degree(a[0], v);
        int d = d0 - (d1 = Poly.degree(a[1], v));
        if (d < 0) {
            a[1] = a[0];
            a[0] = Zahl.ZERO;
            return;
        }
        if (d1 == 0) {
            a[1] = Zahl.ZERO;
            return;
        }
        Algebraic[] cdiv = new Algebraic[d + 1];
        Algebraic[] nom = new Algebraic[d0 + 1];
        for (int i = 0; i < nom.length; ++i) {
            nom[i] = Poly.coefficient(a[0], v, i);
        }
        Algebraic den = Poly.coefficient(a[1], v, d1);
        int i = d;
        int k = d0;
        while (i >= 0) {
            Algebraic cd;
            cdiv[i] = cd = nom[k].div(den);
            nom[k] = Zahl.ZERO;
            int j = k - 1;
            int l = d1 - 1;
            while (j > k - (d1 + 1)) {
                nom[j] = nom[j].sub(cd.mult(Poly.coefficient(a[1], v, l)));
                --j;
                --l;
            }
            --i;
            --k;
        }
        a[0] = Poly.horner(v, cdiv, d + 1);
        a[1] = Poly.horner(v, nom, d1);
    }

    public static Algebraic horner(Variable x, Algebraic[] c, int n) throws JasymcaException {
        if (n == 0) {
            return Zahl.ZERO;
        }
        if (n > c.length) {
            throw new JasymcaException("Can not create horner polynomial.");
        }
        Polynomial X = new Polynomial(x);
        Algebraic p = c[n - 1];
        for (int i = n - 2; i >= 0; --i) {
            p = p.mult(X).add(c[i]);
        }
        return p;
    }

    public static Algebraic horner(Variable x, Algebraic[] c) throws JasymcaException {
        return Poly.horner(x, c, c.length);
    }

    public static Algebraic[] clone(Algebraic[] x) {
        Algebraic[] c = new Algebraic[x.length];
        for (int i = 0; i < x.length; ++i) {
            c[i] = x[i];
        }
        return c;
    }

    public static Algebraic[] reduce(Algebraic[] x) {
        int len;
        for (len = x.length; len > 0 && (x[len - 1] == null || x[len - 1].equals(Zahl.ZERO)); --len) {
        }
        if (len == 0) {
            len = 1;
        }
        if (len != x.length) {
            Algebraic[] na = new Algebraic[len];
            for (int i = 0; i < len; ++i) {
                na[i] = x[i];
            }
            return na;
        }
        return x;
    }

    public static Algebraic polydiv(Algebraic p1, Algebraic q1) throws JasymcaException {
        if (q1 instanceof Zahl) {
            return p1.div(q1);
        }
        if (p1.equals(Zahl.ZERO)) {
            return Zahl.ZERO;
        }
        if (!(p1 instanceof Polynomial) || !(q1 instanceof Polynomial)) {
            throw new JasymcaException("Polydiv is implemented for polynomials only.Got " + p1 + " / " + q1);
        }
        Polynomial p = (Polynomial)p1;
        Polynomial q = (Polynomial)q1;
        if (p.var.equals(q.var)) {
            int len = p.degree() - q.degree();
            if (len < 0) {
                throw new JasymcaException("Polydiv requires zero rest.");
            }
            Algebraic[] cdiv = new Algebraic[len + 1];
            Algebraic[] nom = Poly.clone(p.a);
            Algebraic den = q.a[q.a.length - 1];
            int i = len;
            int k = nom.length - 1;
            while (i >= 0) {
                cdiv[i] = Poly.polydiv(nom[k], den);
                nom[k] = Zahl.ZERO;
                int j = k - 1;
                int l = q.a.length - 2;
                while (j > k - q.a.length) {
                    nom[j] = nom[j].sub(cdiv[i].mult(q.a[l]));
                    --j;
                    --l;
                }
                --i;
                --k;
            }
            return Poly.horner(p.var, cdiv);
        }
        Algebraic[] cn = new Algebraic[p.a.length];
        for (int i = 0; i < p.a.length; ++i) {
            cn[i] = Poly.polydiv(p.a[i], q1);
        }
        return Poly.horner(p.var, cn);
    }

    public static Algebraic mod(Algebraic p, Algebraic q, Variable r) throws JasymcaException {
        int len = Poly.degree(p, r) - Poly.degree(q, r);
        if (len < 0) {
            return p;
        }
        Algebraic[] cdiv = new Algebraic[len + 1];
        Algebraic[] nom = new Algebraic[Poly.degree(p, r) + 1];
        for (int i = 0; i < nom.length; ++i) {
            nom[i] = Poly.coefficient(p, r, i);
        }
        Algebraic den = Poly.coefficient(q, r, Poly.degree(q, r));
        int i = len;
        int k = nom.length - 1;
        while (i >= 0) {
            cdiv[i] = Poly.polydiv(nom[k], den);
            nom[k] = Zahl.ZERO;
            int j = k - 1;
            int l = Poly.degree(q, r) + 1 - 2;
            while (j > k - (Poly.degree(q, r) + 1)) {
                nom[j] = nom[j].sub(cdiv[i].mult(Poly.coefficient(q, r, l)));
                --j;
                --l;
            }
            --i;
            --k;
        }
        return Poly.horner(r, nom, nom.length - 1 - len);
    }

    public static Algebraic euclid(Algebraic p, Algebraic q, Variable r) throws JasymcaException {
        int dq;
        int dp = Poly.degree(p, r);
        Algebraic a = dp < (dq = Poly.degree(q, r)) ? p : p.mult(Poly.coefficient(q, r, dq).pow_n(dp - dq + 1));
        Algebraic b = q;
        Algebraic c = Poly.mod(a, b, r);
        Algebraic result = c.equals(Zahl.ZERO) ? b : Poly.euclid(b, c, r);
        return result;
    }

    public static Algebraic poly_gcd(Algebraic p, Algebraic q) throws JasymcaException {
        Polynomial rp;
        if (p.equals(Zahl.ZERO)) {
            return q;
        }
        if (q.equals(Zahl.ZERO)) {
            return p;
        }
        if (p instanceof Zahl || q instanceof Zahl) {
            return Zahl.ONE;
        }
        Variable r = ((Polynomial)q).var.smaller(((Polynomial)p).var) ? ((Polynomial)p).var : ((Polynomial)q).var;
        Algebraic pc = Poly.content(p, r);
        Algebraic qc = Poly.content(q, r);
        Algebraic eu = Poly.euclid(Poly.polydiv(p, pc), Poly.polydiv(q, qc), r);
        Algebraic re = Poly.polydiv(eu, Poly.content(eu, r)).mult(Poly.poly_gcd(pc, qc));
        if (re instanceof Zahl) {
            return Zahl.ONE;
        }
        Algebraic res = rp = (Polynomial)re;
        if (rp.a[rp.degree()] instanceof Zahl) {
            res = rp.div(rp.a[rp.degree()]);
        }
        return res;
    }

    public static Algebraic content(Algebraic p, Variable r) throws JasymcaException {
        if (p instanceof Zahl) {
            return p;
        }
        Algebraic result = Poly.coefficient(p, r, 0);
        for (int i = 0; i <= Poly.degree(p, r) && !result.equals(Zahl.ONE); ++i) {
            result = Poly.poly_gcd(result, Poly.coefficient(p, r, i));
        }
        return result;
    }

    static int gcd(int a, int b) {
        int c = 1;
        while (c != 0) {
            c = a % b;
            a = b;
            b = c;
        }
        return a;
    }
}

