/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.JasymcaException;
import jasymca.NumFmt;
import jasymca.NumFmtVar;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.net.URL;
import java.util.Vector;
import org.apache.commons.math3.util.FastMath;

public class PlotGraph
extends Frame
implements Runnable,
ComponentListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    Vector PlotLines = new Vector();
    public static final int LINEAR = 0;
    static final int LOGLIN = 1;
    static final int LINLOG = 2;
    static final int LOGLOG = 3;
    int plotmode = 0;
    NumFmt fmt = new NumFmtVar(10, 4);
    int xp = -1;
    int yp;
    int dx = 0;
    int dy = 0;
    double a0;
    double a1;
    boolean movePointer = false;
    Thread moveP = null;
    static final int PMODE_POINT = 0;
    static final int PMODE_LINE = 1;
    static final int PMODE_LINE_POINT = 2;
    int pointerMode = 0;
    double minx = Double.POSITIVE_INFINITY;
    double maxx = Double.NEGATIVE_INFINITY;
    int ntx = 10;
    int nty = 10;
    double miny = Double.POSITIVE_INFINITY;
    double maxy = Double.NEGATIVE_INFINITY;
    Image ShowLine = null;
    int width;
    int height;
    int xleft;
    int ytop;
    int xright;
    int ybottom;
    int yXlabel;
    int yTlabel;
    String Xlabel = null;
    String Ylabel = null;
    String Tlabel = null;
    static final Color BLACK = Color.black;
    static final Color RED = Color.red;
    static final Color GREEN = new Color(0x228B22);
    static final Color BLUE = Color.blue;
    static final Color CYAN = Color.cyan;
    static final Color MAGENTA = Color.magenta;
    static final Color YELLOW = Color.yellow;
    static final Color WHITE = Color.white;
    static final Color LIGHTGRAY = new Color(0xC0C0C0);
    boolean Hold_b = false;
    static final Stroke DOTTED = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f}, 0.0f);
    static final Stroke DASHED = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{10.0f}, 0.0f);
    static final Stroke SOLID = new BasicStroke();
    static final Font fontAxis = new Font("Arial", 1, 14);

    public void setmode(int mode) {
        if (mode != this.plotmode) {
            this.reset();
        }
        this.plotmode = mode;
    }

    void setparam() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.xleft = this.Ylabel == null ? 50 : 70;
        this.xright = 25;
        this.ytop = this.Tlabel == null ? 40 : 60;
        this.ybottom = this.Xlabel == null ? 30 : 50;
    }

    public void setXlabel(String s) {
        this.Xlabel = s;
        this.repaint();
    }

    public void setYlabel(String s) {
        this.Ylabel = s;
        this.repaint();
    }

    public void setTlabel(String s) {
        this.Tlabel = s;
        this.repaint();
    }

    @Override
    public void run() {
        while (this.movePointer) {
            try {
                int yneu;
                if (this.xp < 0) {
                    this.movePointer = false;
                    return;
                }
                int xneu = this.xp + this.dx;
                if (xneu >= this.getScreenX(this.maxx)) {
                    xneu = this.getScreenX(this.minx);
                }
                if (xneu < this.getScreenX(this.minx)) {
                    xneu = this.getScreenX(this.maxx);
                }
                if ((yneu = this.yp + this.dy) >= this.getScreenY(this.miny)) {
                    yneu = this.getScreenY(this.maxy);
                }
                if (yneu < this.getScreenY(this.maxy)) {
                    yneu = this.getScreenY(this.miny);
                }
                this.xp = xneu;
                this.yp = yneu;
                this.repaint();
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    public PlotGraph(int mode) {
        this.plotmode = mode;
        this.setSize(600, 400);
        this.setparam();
        try {
            final PlotGraph f = this;
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    f.setVisible(false);
                }
            });
            this.addComponentListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            URL url = this.getClass().getResource("icons/fav.png");
            this.ShowLine = Toolkit.getDefaultToolkit().createImage(url);
        }
        catch (Exception e) {
            System.out.println("Could not load Images.");
        }
    }

    public PlotGraph() {
        this(0);
    }

    void drawStraightLine(Graphics g) {
        double xl = this.minx;
        double yl = this.a1 * xl + this.a0;
        if (yl > this.maxy) {
            yl = this.maxy;
            xl = (yl - this.a0) / this.a1;
        } else if (yl < this.miny) {
            yl = this.miny;
            xl = (yl - this.a0) / this.a1;
        }
        double xr = this.maxx;
        double yr = this.a1 * xr + this.a0;
        if (yr > this.maxy) {
            yr = this.maxy;
            xr = (yr - this.a0) / this.a1;
        } else if (yr < this.miny) {
            yr = this.miny;
            xr = (yr - this.a0) / this.a1;
        }
        if (this.xp >= 0 && this.pointerMode == 1) {
            int Yl;
            int Xl;
            int Yr;
            double xm = this.getXCoordinate(this.xp);
            double ym = this.getYCoordinate(this.yp);
            int Xr = this.getScreenX(xr);
            if ((this.xp - Xr) * (this.xp - Xr) + (this.yp - (Yr = this.getScreenY(yr))) * (this.yp - Yr) < (this.xp - (Xl = this.getScreenX(xl))) * (this.xp - Xl) + (this.yp - (Yl = this.getScreenY(yl))) * (this.yp - Yl)) {
                this.a1 = (ym - yl) / (xm - xl);
                this.a0 = yl - this.a1 * xl;
                xr = this.maxx;
                yr = this.a1 * xr + this.a0;
                if (yr > this.maxy) {
                    yr = this.maxy;
                    xr = (yr - this.a0) / this.a1;
                } else if (yr < this.miny) {
                    yr = this.miny;
                    xr = (yr - this.a0) / this.a1;
                }
            } else {
                this.a1 = (yr - ym) / (xr - xm);
                this.a0 = yr - this.a1 * xr;
                xl = this.minx;
                yl = this.a1 * xl + this.a0;
                if (yl > this.maxy) {
                    yl = this.maxy;
                    xl = (yl - this.a0) / this.a1;
                } else if (yl < this.miny) {
                    yl = this.miny;
                    xl = (yl - this.a0) / this.a1;
                }
            }
        }
        g.setColor(GREEN);
        g.drawLine(this.getScreenX(xl), this.getScreenY(yl), this.getScreenX(xr), this.getScreenY(yr));
        g.setColor(BLACK);
        if (this.pointerMode == 1) {
            this.drawMessage(g, this.xp, this.yp, new String[]{"a1=" + this.fmt.toString(this.a1), "a0=" + this.fmt.toString(this.a0)});
        }
    }

    void drawMessage(Graphics g, int xp, int yp, String[] msg) {
        double[] sw = new double[msg.length];
        for (int i = 0; i < sw.length; ++i) {
            sw[i] = (int)Math.round(g.getFont().getStringBounds(msg[i], ((Graphics2D)g).getFontRenderContext()).getWidth());
        }
        int fh = (int)FastMath.round((double)g.getFont().getStringBounds("A", ((Graphics2D)g).getFontRenderContext()).getHeight());
        int mw = (int)this.max(sw) + 10;
        int mh = msg.length * fh + 6;
        int xw = xp < this.width / 2 ? this.width - this.xright - mw : this.xleft;
        int yw = yp < this.height / 2 ? this.height - this.ybottom - mh : this.ytop;
        g.setColor(LIGHTGRAY);
        g.fillRect(xw, yw, mw, mh);
        g.setColor(BLACK);
        for (int i = 0; i < msg.length; ++i) {
            g.drawString(msg[i], xw + 5, yw + (i + 1) * fh + 3);
        }
    }

    void drawPointer(Graphics g) {
        g.setColor(RED);
        this.fillCircle(g, this.xp, this.yp, 3);
        g.setColor(LIGHTGRAY);
        g.fillRect(this.xp, this.yp, 1, 1);
        double X = this.getXCoordinate(this.xp);
        if (this.plotmode == 1 || this.plotmode == 3) {
            X = FastMath.pow((double)10.0, (double)X);
        }
        double Y = this.getYCoordinate(this.yp);
        if (this.plotmode == 2 || this.plotmode == 3) {
            Y = FastMath.pow((double)10.0, (double)Y);
        }
        this.drawMessage(g, this.xp, this.yp, new String[]{"X=" + this.fmt.toString(X), "Y=" + this.fmt.toString(Y)});
    }

    public double getXCoordinate(int x) {
        double a = (this.maxx - this.minx) / (double)(this.width - this.xleft - this.xright);
        double b = this.minx - a * (double)this.xleft;
        return a * (double)x + b;
    }

    public double getYCoordinate(int y) {
        double a = (this.miny - this.maxy) / (double)(this.height - this.ytop - this.ybottom);
        double b = this.maxy - a * (double)this.ytop;
        return a * (double)y + b;
    }

    public int getScreenX(double x) {
        double a = (double)(this.width - this.xleft - this.xright) / (this.maxx - this.minx);
        double b = (double)this.xleft - a * this.minx;
        return (int)(a * x + b + 0.5);
    }

    public int getScreenY(double y) {
        double a = (double)(this.height - this.ytop - this.ybottom) / (this.miny - this.maxy);
        double b = (double)this.ytop - a * this.maxy;
        return (int)(a * y + b + 0.5);
    }

    private void reset() {
        this.PlotLines.removeAllElements();
        this.minx = Double.POSITIVE_INFINITY;
        this.maxx = Double.NEGATIVE_INFINITY;
        this.miny = Double.POSITIVE_INFINITY;
        this.maxy = Double.NEGATIVE_INFINITY;
        this.Xlabel = null;
        this.Ylabel = null;
        this.Tlabel = null;
    }

    void log10(double[] x) throws JasymcaException {
        for (int i = 0; i < x.length; ++i) {
            if (x[i] <= 0.0) {
                throw new JasymcaException("Log from negative number.");
            }
            x[i] = FastMath.log((double)x[i]) / FastMath.log((double)10.0);
        }
    }

    public void addLine(Object[] params) throws JasymcaException {
        if (!this.Hold_b) {
            this.reset();
        }
        int i = 0;
        while (i < params.length) {
            double[] x;
            PlotLine line = new PlotLine();
            if (i < params.length - 1 && !(params[i + 1] instanceof String)) {
                x = (double[])params[i];
                if (this.plotmode == 1 || this.plotmode == 3) {
                    this.log10(x);
                }
                line.lineMaxx = FastMath.max((double)this.max(x), (double)this.maxx);
                line.lineMinx = FastMath.min((double)this.min(x), (double)this.minx);
                double[] y = (double[])params[i + 1];
                if (this.plotmode == 2 || this.plotmode == 3) {
                    this.log10(y);
                }
                line.lineMaxy = FastMath.max((double)this.max(y), (double)this.maxy);
                line.lineMiny = FastMath.min((double)this.min(y), (double)this.miny);
                if (x.length != y.length) {
                    throw new JasymcaException("X and Y must be same length");
                }
                line.setPoints(x, y);
                i += 2;
            } else {
                x = (double[])params[i];
                if (this.plotmode == 2 || this.plotmode == 3) {
                    this.log10(x);
                }
                this.maxx = x.length;
                this.minx = 1.0;
                this.maxy = this.max(x);
                this.miny = this.min(x);
                line.x = new double[x.length];
                for (int ind = 0; ind < x.length; ++ind) {
                    line.x[ind] = ind + 1;
                }
                line.setPoints(line.x, x);
                ++i;
            }
            this.maxx = FastMath.max((double)line.lineMaxx, (double)this.maxx);
            this.minx = FastMath.min((double)line.lineMinx, (double)this.minx);
            this.maxy = FastMath.max((double)line.lineMaxy, (double)this.maxy);
            this.miny = FastMath.min((double)line.lineMiny, (double)this.miny);
            if (i < params.length && params[i] instanceof String) {
                line.setLineAttributes(params[i].toString());
                ++i;
            }
            this.PlotLines.addElement(line);
        }
        this.setMinMax();
        this.repaint();
    }

    void addLineErrorbars(Object[] params) throws JasymcaException {
        double[] el;
        if (!this.Hold_b) {
            this.reset();
        }
        if (params.length < 3) {
            throw new JasymcaException("At least 3 arguments required.");
        }
        PlotLine line = new PlotLine();
        double[] x = (double[])params[0];
        line.lineMaxx = FastMath.max((double)this.max(x), (double)this.maxx);
        line.lineMinx = FastMath.min((double)this.min(x), (double)this.minx);
        double[] y = (double[])params[1];
        line.lineMaxy = FastMath.max((double)this.max(y), (double)this.maxy);
        line.lineMiny = FastMath.min((double)this.min(y), (double)this.miny);
        if (x.length != y.length) {
            throw new JasymcaException("X and Y must be same length");
        }
        line.setPoints(x, y);
        double[] eu = el = (double[])params[2];
        if (el.length != y.length) {
            throw new JasymcaException("Errors and Y must be same length");
        }
        int i = 3;
        if (params.length > 3 && !(params[3] instanceof String)) {
            eu = (double[])params[3];
            if (eu.length != y.length) {
                throw new JasymcaException("Errors and Y must be same length");
            }
            ++i;
        }
        line.eu = eu;
        line.el = el;
        this.maxx = FastMath.max((double)line.lineMaxx, (double)this.maxx);
        this.minx = FastMath.min((double)line.lineMinx, (double)this.minx);
        this.maxy = FastMath.max((double)line.lineMaxy, (double)this.maxy);
        this.miny = FastMath.min((double)line.lineMiny, (double)this.miny);
        if (i < params.length && params[i] instanceof String) {
            line.setLineAttributes(params[i].toString());
            ++i;
        }
        this.PlotLines.addElement(line);
        this.setMinMax();
        this.repaint();
    }

    void drawGraph(Graphics g) {
        Color old = g.getColor();
        g.setColor(WHITE);
        g.fillRect(0, 0, this.width, this.height);
        for (int i = 0; i < this.PlotLines.size(); ++i) {
            PlotLine line = (PlotLine)this.PlotLines.elementAt(i);
            line.paint(g);
        }
        g.setColor(old);
        this.drawAxis(g);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        this.setparam();
        if (this.width < 100 || this.height < 100) {
            return;
        }
        this.drawGraph(g);
        if (this.pointerMode != 0) {
            this.drawStraightLine(g);
        }
        if (this.pointerMode != 1 && this.xp >= 0) {
            this.drawPointer(g);
        }
        g.drawImage(this.ShowLine, this.width - this.xright + 3, this.ytop, this);
    }

    boolean inShowLine(int x, int y) {
        return this.ShowLine != null && x > this.width - this.xright + 3 && x < this.width - this.xright + 3 + this.ShowLine.getWidth(this) && y > this.ytop && y < this.ytop + this.ShowLine.getHeight(this);
    }

    public void fillCircle(Graphics g, int x, int y, int r) {
        int r2 = r * r;
        for (int yd = y - r; yd < y + r; ++yd) {
            if (yd < 0 || yd >= this.height) continue;
            int y2 = (yd - y) * (yd - y);
            for (int xd = x - r; xd < x + r; ++xd) {
                if (xd < 0 || xd >= this.width || y2 + (xd - x) * (xd - x) > r2) continue;
                g.fillRect(xd, yd, 1, 1);
            }
        }
    }

    double max(double[] x) {
        double max = x[0];
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] > max)) continue;
            max = x[i];
        }
        return max;
    }

    double min(double[] x) {
        double min = x[0];
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] < min)) continue;
            min = x[i];
        }
        return min;
    }

    void drawAxis(Graphics g) {
        g.setColor(BLACK);
        int x2 = this.width - this.xright;
        int y2 = this.height - this.ybottom;
        g.drawLine(this.xleft, this.ytop, x2, this.ytop);
        g.drawLine(this.xleft, this.ytop, this.xleft, y2);
        g.drawLine(x2, this.ytop, x2, y2);
        g.drawLine(this.xleft, y2, x2, y2);
        if (this.minx < 0.0 && 0.0 < this.maxx) {
            ((Graphics2D)g).setStroke(DOTTED);
            g.drawLine(this.getScreenX(0.0), this.getScreenY(this.miny), this.getScreenX(0.0), this.getScreenY(this.maxy));
            ((Graphics2D)g).setStroke(SOLID);
        }
        if (this.miny < 0.0 && 0.0 < this.maxy) {
            ((Graphics2D)g).setStroke(DOTTED);
            g.drawLine(this.getScreenX(this.minx), this.getScreenY(0.0), this.getScreenX(this.maxx), this.getScreenY(0.0));
            ((Graphics2D)g).setStroke(SOLID);
        }
        this.drawOrnaments(g);
    }

    static int decExp(double x) {
        return (int)(FastMath.log((double)x) / FastMath.log((double)10.0));
    }

    double largestp10(double x) {
        double p;
        for (p = 1.0; p < x; p *= 10.0) {
        }
        while (p > x) {
            p /= 10.0;
        }
        return p;
    }

    void setMinMax() {
        if (this.maxx == this.minx) {
            this.maxx += 1.0;
        }
        double div = this.largestp10(this.maxx - this.minx) / 10.0;
        int ntx1 = (int)FastMath.ceil((double)(this.maxx / div));
        int ntx2 = (int)FastMath.floor((double)(this.minx / div));
        this.ntx = ntx1 - ntx2;
        this.maxx = (double)ntx1 * div;
        this.minx = (double)ntx2 * div;
        if (this.maxy == this.miny) {
            this.maxy += 1.0;
        }
        div = this.largestp10(this.maxy - this.miny) / 10.0;
        int nty1 = (int)FastMath.ceil((double)(this.maxy / div));
        int nty2 = (int)FastMath.floor((double)(this.miny / div));
        this.nty = nty1 - nty2;
        this.maxy = (double)nty1 * div;
        this.miny = (double)nty2 * div;
        this.a1 = 0.0;
        this.a0 = (this.maxy + this.miny) / 2.0;
    }

    void drawOrnaments(Graphics g) {
        String label;
        int exponent;
        g.setFont(fontAxis);
        int lenMajor = this.height / 40;
        double x = 0.0;
        double y = 0.0;
        int axis_w = this.width - this.xleft - this.xright;
        int axis_h = this.height - this.ytop - this.ybottom;
        int lenlabel = (int)FastMath.round((double)g.getFont().getStringBounds(" 00.00 ", ((Graphics2D)g).getFontRenderContext()).getWidth());
        int maxnumtics = axis_w / lenlabel;
        double dX = (this.maxx - this.minx) / (double)this.ntx;
        double startx = this.minx;
        while ((this.maxx - this.minx) / dX > (double)maxnumtics) {
            startx = (double)((int)(startx / (dX *= 2.0) + 0.5)) * dX;
            if (!((this.maxx - this.minx) / dX > (double)maxnumtics)) continue;
            startx = (double)((int)(startx / (dX *= 2.5) + 0.5)) * dX;
        }
        if (this.plotmode == 1 || this.plotmode == 3) {
            while (FastMath.abs((double)(startx / dX - (double)FastMath.round((double)(startx / dX)))) > 0.01) {
                startx += dX;
            }
            if (dX < 1.0) {
                dX = 1.0;
            } else if (dX == 2.5) {
                dX = 2.0;
            }
            startx = dX * FastMath.floor((double)(startx / dX));
        }
        if (FastMath.abs((int)(exponent = FastMath.max((int)PlotGraph.decExp(this.maxx), (int)PlotGraph.decExp(this.minx)) - 1)) < 2) {
            exponent = 0;
        }
        double scf = FastMath.pow((double)10.0, (double)exponent);
        int i = 0;
        for (x = startx; x <= this.maxx; x += dX) {
            int xworld;
            if (FastMath.abs((double)x) < 1.0E-15 && dX > 1.0E-14) {
                x = 0.0;
            }
            if ((xworld = this.getScreenX(x)) >= this.xleft) {
                g.drawLine(xworld, this.ytop, xworld, this.ytop + lenMajor);
                g.drawLine(xworld, this.height - this.ybottom - lenMajor, xworld, this.height - this.ybottom);
                if ((this.plotmode == 1 || this.plotmode == 3) && dX < 1.5) {
                    for (int k = 2; k <= 9; ++k) {
                        int xk = this.getScreenX(x + FastMath.log((double)k) / FastMath.log((double)10.0));
                        if (xk <= this.xleft || xk >= this.xleft + this.width) continue;
                        g.drawLine(xk, this.ytop, xk, this.ytop + lenMajor / 2);
                        g.drawLine(xk, this.height - this.ybottom - lenMajor / 2, xk, this.height - this.ybottom);
                    }
                }
                label = this.plotmode == 1 || this.plotmode == 3 ? "10^" : "";
                label = x + dX > this.maxx && exponent != 0 ? "E" + exponent : label + this.fmt.toString(x / scf);
                PlotGraph.centerText(g, label, (double)(this.height - this.ybottom) + 1.5 * (double)((int)FastMath.round((double)g.getFont().getStringBounds("A", ((Graphics2D)g).getFontRenderContext()).getHeight())), xworld);
            }
            ++i;
        }
        if (this.Xlabel != null) {
            PlotGraph.centerText(g, this.Xlabel, this.height - this.ybottom + 3 * (int)FastMath.round((double)g.getFont().getStringBounds("A", ((Graphics2D)g).getFontRenderContext()).getHeight()), this.xleft + (this.width - this.xleft - this.xright) / 2);
        }
        if (this.Tlabel != null) {
            PlotGraph.centerText(g, this.Tlabel, this.ytop - (int)FastMath.round((double)g.getFont().getStringBounds("A", ((Graphics2D)g).getFontRenderContext()).getHeight()) / 2, this.xleft + (this.width - this.xleft - this.xright) / 2);
        }
        if (this.Ylabel != null) {
            PlotGraph.centerTextV(g, this.Ylabel, (int)FastMath.round((double)g.getFont().getStringBounds("A", ((Graphics2D)g).getFontRenderContext()).getHeight()), this.ytop + (this.height - this.ytop - this.ybottom) / 2);
        }
        int hilabel = (int)FastMath.round((double)g.getFont().getStringBounds("A", ((Graphics2D)g).getFontRenderContext()).getHeight());
        maxnumtics = (int)((double)axis_h / (1.5 * (double)hilabel));
        double dY = (this.maxy - this.miny) / (double)this.nty;
        double starty = this.miny;
        while ((this.maxy - this.miny) / dY > (double)maxnumtics) {
            starty = (double)((int)(starty / (dY *= 2.0) + 0.5)) * dY;
            if (!((this.maxy - this.miny) / dY > (double)maxnumtics)) continue;
            starty = (double)((int)(starty / (dY *= 2.5) + 0.5)) * dY;
        }
        if (this.plotmode == 2 || this.plotmode == 3) {
            if (dY < 1.0) {
                dY = 1.0;
            } else if (dY == 2.5) {
                dY = 2.0;
            }
            starty = dY * FastMath.floor((double)(starty / dY));
        }
        if (FastMath.abs((int)(exponent = FastMath.max((int)PlotGraph.decExp(this.maxy), (int)PlotGraph.decExp(this.miny)) - 1)) < 2) {
            exponent = 0;
        }
        scf = FastMath.pow((double)10.0, (double)exponent);
        i = 0;
        for (y = starty; y <= this.maxy; y += dY) {
            int yworld;
            if (FastMath.abs((double)y) < 1.0E-15 && dY > 1.0E-14) {
                y = 0.0;
            }
            if ((yworld = this.getScreenY(y)) <= this.height - this.ybottom) {
                g.drawLine(this.xleft, yworld, this.xleft + lenMajor, yworld);
                g.drawLine(this.xleft + axis_w, yworld, this.xleft + axis_w - lenMajor, yworld);
                if ((this.plotmode == 2 || this.plotmode == 3) && dY < 1.5) {
                    for (int k = 2; k <= 9; ++k) {
                        int yk = this.getScreenY(y + FastMath.log((double)k) / FastMath.log((double)10.0));
                        if (yk <= this.ytop || yk >= this.ytop + this.height) continue;
                        g.drawLine(this.xleft, yk, this.xleft + lenMajor / 2, yk);
                        g.drawLine(this.xleft + axis_w, yk, this.xleft + axis_w - lenMajor / 2, yk);
                    }
                }
                label = this.plotmode == 2 || this.plotmode == 3 ? "10^" : "";
                label = y + dY > this.maxy && exponent != 0 ? "E" + exponent : label + this.fmt.toString(y / scf);
                g.drawString(label, this.xleft - (int)FastMath.round((double)g.getFont().getStringBounds(label, ((Graphics2D)g).getFontRenderContext()).getWidth()) - 3, yworld + hilabel / 2 - 3);
            }
            ++i;
        }
    }

    public static void centerText(Graphics g, String msg, double posY, double centerPos) {
        int sw = (int)FastMath.round((double)g.getFont().getStringBounds(msg, ((Graphics2D)g).getFontRenderContext()).getWidth());
        double posX = centerPos - (double)(sw / 2);
        double dy = 4.0;
        double dx = 0.0;
        g.drawString(msg, (int)FastMath.round((double)(posX - dx)), (int)FastMath.round((double)(posY - dy)));
    }

    public static void centerTextV(Graphics g, String msg, double posX, double centerPos) {
        int sw = (int)FastMath.round((double)g.getFont().getStringBounds(msg, ((Graphics2D)g).getFontRenderContext()).getWidth());
        double posY = centerPos + (double)(sw / 2);
        double dy = 0.0;
        double dx = 0.0;
        Font oldFont = g.getFont();
        Font f = oldFont.deriveFont(AffineTransform.getRotateInstance(-1.5707963267948966));
        g.setFont(f);
        g.drawString(msg, (int)posX, (int)posY);
        g.setFont(oldFont);
    }

    void startMovePointer() {
        if (this.moveP != null && this.moveP.isAlive()) {
            return;
        }
        this.movePointer = true;
        this.moveP = new Thread(this);
        this.moveP.start();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.inShowLine(e.getX(), e.getY())) {
            this.xp = -1;
            this.pointerMode = this.pointerMode == 0 ? 1 : (this.pointerMode == 1 ? 2 : 0);
        } else {
            this.xp = e.getX();
            this.yp = e.getY();
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.xp = -1;
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.xp != -1) {
            this.xp = e.getX();
            this.yp = e.getY();
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    class PlotLine {
        double lineMinx;
        double lineMaxx;
        double lineMiny;
        double lineMaxy;
        char marker = (char)32;
        double[] x;
        double[] y;
        double[] eu = null;
        double[] el = null;
        Color color = BLUE;

        PlotLine() {
        }

        void setPoints(double[] xp, double[] yp) {
            this.x = xp;
            this.y = yp;
            this.lineMaxx = PlotGraph.this.max(this.x);
            this.lineMinx = PlotGraph.this.min(this.x);
            this.lineMaxy = PlotGraph.this.max(this.y);
            this.lineMiny = PlotGraph.this.min(this.y);
        }

        void paint(Graphics g) {
            int i;
            Color old = g.getColor();
            g.setColor(this.color);
            if (this.marker == ' ') {
                for (i = 0; i < this.x.length - 1; ++i) {
                    g.drawLine(PlotGraph.this.getScreenX(this.x[i]), PlotGraph.this.getScreenY(this.y[i]), PlotGraph.this.getScreenX(this.x[i + 1]), PlotGraph.this.getScreenY(this.y[i + 1]));
                }
            } else {
                for (i = 0; i < this.x.length - 1; ++i) {
                    this.drawSymbol(g, PlotGraph.this.getScreenX(this.x[i]), PlotGraph.this.getScreenY(this.y[i]), this.marker);
                }
            }
            if (this.eu != null) {
                for (i = 0; i < this.x.length - 1; ++i) {
                    g.drawLine(PlotGraph.this.getScreenX(this.x[i]), PlotGraph.this.getScreenY(this.y[i] - this.el[i]), PlotGraph.this.getScreenX(this.x[i]), PlotGraph.this.getScreenY(this.y[i] + this.eu[i]));
                    g.drawLine(PlotGraph.this.getScreenX(this.x[i]) - 3, PlotGraph.this.getScreenY(this.y[i] - this.el[i]), PlotGraph.this.getScreenX(this.x[i]) + 3, PlotGraph.this.getScreenY(this.y[i] - this.el[i]));
                    g.drawLine(PlotGraph.this.getScreenX(this.x[i]) - 3, PlotGraph.this.getScreenY(this.y[i] + this.eu[i]), PlotGraph.this.getScreenX(this.x[i]) + 3, PlotGraph.this.getScreenY(this.y[i] + this.eu[i]));
                }
            }
            g.setColor(old);
        }

        void drawSymbol(Graphics g, int x, int y, char marker) {
            switch (marker) {
                case '+': {
                    g.drawLine(x, y - 3, x, y + 3);
                    g.drawLine(x - 3, y, x + 3, y);
                    break;
                }
                case 'o': {
                    g.drawLine(x - 1, y - 3, x + 1, y - 3);
                    g.drawLine(x + 1, y - 3, x + 3, y - 1);
                    g.drawLine(x + 3, y - 1, x + 3, y + 1);
                    g.drawLine(x + 3, y + 1, x + 1, y + 3);
                    g.drawLine(x + 1, y + 3, x - 1, y + 3);
                    g.drawLine(x - 1, y + 3, x - 3, y + 1);
                    g.drawLine(x - 3, y + 1, x - 3, y - 1);
                    g.drawLine(x - 3, y - 1, x - 1, y - 3);
                    break;
                }
                case 'x': {
                    g.drawLine(x - 3, y - 3, x + 3, y + 3);
                    g.drawLine(x + 3, y - 3, x - 3, y + 3);
                    break;
                }
                default: {
                    g.drawLine(x, y - 3, x, y + 3);
                    g.drawLine(x - 3, y, x + 3, y);
                    g.drawLine(x - 2, y - 2, x + 2, y + 2);
                    g.drawLine(x + 2, y - 2, x - 2, y + 2);
                }
            }
        }

        public void setLineAttributes(String options) {
            block10: for (int i = 0; i < options.length(); ++i) {
                switch (options.charAt(i)) {
                    case 'r': {
                        this.color = RED;
                        continue block10;
                    }
                    case 'g': {
                        this.color = GREEN;
                        continue block10;
                    }
                    case 'b': {
                        this.color = BLUE;
                        continue block10;
                    }
                    case 'y': {
                        this.color = YELLOW;
                        continue block10;
                    }
                    case 'm': {
                        this.color = MAGENTA;
                        continue block10;
                    }
                    case 'c': {
                        this.color = CYAN;
                        continue block10;
                    }
                    case 'w': {
                        this.color = WHITE;
                        continue block10;
                    }
                    case 'k': {
                        this.color = BLACK;
                        continue block10;
                    }
                    default: {
                        this.marker = options.charAt(i);
                    }
                }
            }
        }
    }
}

