/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.Index;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.ParseException;
import jasymca.Polynomial;
import jasymca.SimpleVariable;
import jasymca.StringFmt;
import jasymca.Unexakt;
import jasymca.Variable;
import jasymca.Vektor;
import jasymca.Zahl;
import java.io.PrintStream;
import java.util.Vector;

public class Matrix
extends Algebraic {
    private Algebraic[][] a;

    public Matrix(Algebraic[][] a) {
        this.a = a;
    }

    public Matrix(Algebraic x, int nrow, int ncol) {
        this.a = new Algebraic[nrow][ncol];
        for (int i = 0; i < nrow; ++i) {
            for (int k = 0; k < ncol; ++k) {
                this.a[i][k] = x;
            }
        }
    }

    public Matrix(int nrow, int ncol) {
        this(Zahl.ZERO, nrow, ncol);
    }

    public Matrix(double[][] b, int nr, int nc) {
        this.a = new Algebraic[nr][nc];
        nr = Math.min(nr, b.length);
        nc = Math.min(nc, b[0].length);
        for (int i = 0; i < nr; ++i) {
            for (int k = 0; k < nc; ++k) {
                this.a[i][k] = new Unexakt(b[i][k]);
            }
        }
    }

    public Matrix(double[][] b) {
        this(b, b.length, b[0].length);
    }

    public Matrix(Algebraic x) {
        this.a = x == null ? new Algebraic[][]{{Zahl.ZERO}} : (x instanceof Vektor ? new Algebraic[][]{((Vektor)x).get()} : (x instanceof Matrix ? ((Matrix)x).a : new Algebraic[][]{{x}}));
    }

    public Algebraic get(int i, int k) throws JasymcaException {
        if (i < 0 || i >= this.a.length || k < 0 || k >= this.a[0].length) {
            throw new JasymcaException("Index out of bounds.");
        }
        return this.a[i][k];
    }

    public void set(int i, int k, Algebraic x) throws JasymcaException {
        if (i < 0 || i >= this.a.length || k < 0 || k >= this.a[0].length) {
            throw new JasymcaException("Index out of bounds.");
        }
        this.a[i][k] = x;
    }

    public int nrow() {
        return this.a.length;
    }

    public int ncol() {
        return this.a[0].length;
    }

    public double[][] getDouble(int nr, int nc) throws JasymcaException {
        if (nr == 0) {
            nr = this.a.length;
        }
        if (nc == 0) {
            nc = this.a[0].length;
        }
        double[][] b = new double[nr][nc];
        nr = Math.min(nr, this.a.length);
        nc = Math.min(nc, this.a[0].length);
        for (int i = 0; i < nr; ++i) {
            for (int k = 0; k < nc; ++k) {
                Algebraic x = this.a[i][k];
                if (!(x instanceof Unexakt) || x.komplexq()) {
                    throw new JasymcaException("Not a real, double Matrix");
                }
                b[i][k] = ((Unexakt)x).real;
            }
        }
        return b;
    }

    public double[][] getDouble() throws JasymcaException {
        return this.getDouble(0, 0);
    }

    public Algebraic col(int k) {
        Algebraic[][] c = new Algebraic[this.a.length][1];
        for (int i = 0; i < this.a.length; ++i) {
            c[i][0] = this.a[i][k - 1];
        }
        return new Matrix(c).reduce();
    }

    public Algebraic row(int k) {
        Algebraic[] c = new Algebraic[this.a[0].length];
        for (int i = 0; i < this.a[0].length; ++i) {
            c[i] = this.a[k - 1][i];
        }
        return new Vektor(c).reduce();
    }

    public void insert(Matrix x, Index idx) throws JasymcaException {
        int k;
        if (idx.row_max > this.nrow() || idx.col_max > this.ncol()) {
            Matrix e = new Matrix(Math.max(idx.row_max, this.nrow()), Math.max(idx.col_max, this.ncol()));
            for (int i = 0; i < this.nrow(); ++i) {
                for (int k2 = 0; k2 < this.ncol(); ++k2) {
                    e.a[i][k2] = this.a[i][k2];
                }
            }
            this.a = e.a;
        }
        if (x.nrow() == 1 && x.ncol() == 1) {
            for (int i = 0; i < idx.row.length; ++i) {
                for (k = 0; k < idx.col.length; ++k) {
                    this.a[idx.row[i] - 1][idx.col[k] - 1] = x.a[0][0];
                }
            }
            return;
        }
        if (x.nrow() == idx.row.length && x.ncol() == idx.col.length) {
            for (int i = 0; i < idx.row.length; ++i) {
                for (k = 0; k < idx.col.length; ++k) {
                    this.a[idx.row[i] - 1][idx.col[k] - 1] = x.a[i][k];
                }
            }
            return;
        }
        throw new JasymcaException("Wrong index dimension.");
    }

    public Matrix extract(Index idx) throws JasymcaException {
        if (idx.row_max > this.nrow() || idx.col_max > this.ncol()) {
            throw new JasymcaException("Index out of range.");
        }
        Matrix x = new Matrix(idx.row.length, idx.col.length);
        for (int i = 0; i < idx.row.length; ++i) {
            for (int k = 0; k < idx.col.length; ++k) {
                x.a[i][k] = this.a[idx.row[i] - 1][idx.col[k] - 1];
            }
        }
        return x;
    }

    public static Matrix column(Vektor x) throws JasymcaException {
        return new Matrix(x).transpose();
    }

    public static Matrix row(Vektor x) throws JasymcaException {
        return new Matrix(x);
    }

    @Override
    public Algebraic cc() throws JasymcaException {
        Algebraic[][] b = new Algebraic[this.a.length][this.a[0].length];
        for (int i = 0; i < this.a.length; ++i) {
            for (int k = 0; k < this.a[0].length; ++k) {
                b[i][k] = this.a[i][k].cc();
            }
        }
        return new Matrix(b);
    }

    @Override
    public Algebraic add(Algebraic x) throws JasymcaException {
        if (x.scalarq()) {
            x = x.promote(this);
        }
        if (x instanceof Matrix && this.equalsized((Matrix)x)) {
            Algebraic[][] b = new Algebraic[this.a.length][this.a[0].length];
            for (int i = 0; i < this.a.length; ++i) {
                for (int k = 0; k < this.a[0].length; ++k) {
                    b[i][k] = this.a[i][k].add(((Matrix)x).a[i][k]);
                }
            }
            return new Matrix(b);
        }
        throw new JasymcaException("Wrong arguments for add:" + this + "," + x);
    }

    @Override
    public boolean scalarq() {
        return false;
    }

    public boolean equalsized(Matrix x) {
        return this.nrow() == x.nrow() && this.ncol() == x.ncol();
    }

    @Override
    public Algebraic mult(Algebraic x) throws JasymcaException {
        if (x.scalarq()) {
            Algebraic[][] b = new Algebraic[this.a.length][this.a[0].length];
            for (int i = 0; i < this.a.length; ++i) {
                for (int k = 0; k < this.a[0].length; ++k) {
                    b[i][k] = this.a[i][k].mult(x);
                }
            }
            return new Matrix(b);
        }
        Matrix xm = new Matrix(x);
        if (this.ncol() != xm.nrow()) {
            throw new JasymcaException("Matrix dimensions wrong.");
        }
        Algebraic[][] b = new Algebraic[this.a.length][xm.a[0].length];
        for (int i = 0; i < this.a.length; ++i) {
            for (int k = 0; k < xm.a[0].length; ++k) {
                b[i][k] = this.a[i][0].mult(xm.a[0][k]);
                for (int l = 1; l < xm.a.length; ++l) {
                    b[i][k] = b[i][k].add(this.a[i][l].mult(xm.a[l][k]));
                }
            }
        }
        return new Matrix(b);
    }

    @Override
    public Algebraic div(Algebraic x) throws JasymcaException {
        if (x.scalarq()) {
            Algebraic[][] b = new Algebraic[this.a.length][this.a[0].length];
            for (int i = 0; i < this.a.length; ++i) {
                for (int k = 0; k < this.a[0].length; ++k) {
                    b[i][k] = this.a[i][k].div(x);
                }
            }
            return new Matrix(b);
        }
        return this.mult(new Matrix(x).pseudoinverse());
    }

    public static Matrix eye(int nr, int nc) {
        Algebraic[][] b = new Algebraic[nr][nc];
        for (int i = 0; i < nr; ++i) {
            for (int k = 0; k < nc; ++k) {
                b[i][k] = i == k ? Zahl.ONE : Zahl.ZERO;
            }
        }
        return new Matrix(b);
    }

    public Algebraic mpow(int n) throws JasymcaException {
        if (n == 0) {
            return Matrix.eye(this.a.length, this.a[0].length);
        }
        if (n == 1) {
            return this;
        }
        if (n > 1) {
            return this.pow_n(n);
        }
        return new Matrix(this.mpow(-n)).invert();
    }

    @Override
    public Algebraic reduce() {
        if (this.a.length == 1) {
            return new Vektor(this.a[0]).reduce();
        }
        return this;
    }

    @Override
    public Algebraic deriv(Variable var) throws JasymcaException {
        Algebraic[][] b = new Algebraic[this.nrow()][this.ncol()];
        for (int i = 0; i < this.a.length; ++i) {
            for (int k = 0; k < this.a[0].length; ++k) {
                b[i][k] = this.a[i][k].deriv(var);
            }
        }
        return new Matrix(b);
    }

    @Override
    public Algebraic integrate(Variable var) throws JasymcaException {
        Algebraic[][] b = new Algebraic[this.nrow()][this.ncol()];
        for (int i = 0; i < this.a.length; ++i) {
            for (int k = 0; k < this.a[0].length; ++k) {
                b[i][k] = this.a[i][k].integrate(var);
            }
        }
        return new Matrix(b);
    }

    @Override
    public double norm() {
        double n = 0.0;
        for (int i = 0; i < this.a.length; ++i) {
            for (int k = 0; k < this.a[0].length; ++k) {
                n += this.a[i][k].norm();
            }
        }
        return n;
    }

    @Override
    public boolean constantq() {
        for (int i = 0; i < this.a.length; ++i) {
            for (int k = 0; k < this.a[0].length; ++k) {
                if (this.a[i][k].constantq()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(Object x) {
        if (!(x instanceof Matrix) || !this.equalsized((Matrix)x)) {
            return false;
        }
        for (int i = 0; i < this.a.length; ++i) {
            for (int k = 0; k < this.a[0].length; ++k) {
                if (this.a[i][k].equals(((Matrix)x).a[i][k])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Algebraic map_lambda(LambdaAlgebraic f, Algebraic arg2) throws ParseException, JasymcaException {
        Algebraic[][] b = new Algebraic[this.a.length][this.a[0].length];
        if (arg2 instanceof Matrix && this.equalsized((Matrix)arg2)) {
            for (int i = 0; i < this.a.length; ++i) {
                for (int k = 0; k < this.a[0].length; ++k) {
                    Algebraic c = ((Matrix)arg2).get(i, k);
                    Algebraic r = this.a[i][k].map_lambda(f, c);
                    if (!(r instanceof Algebraic)) {
                        throw new JasymcaException("Cannot evaluate function to algebraic.");
                    }
                    b[i][k] = r;
                }
            }
        } else {
            for (int i = 0; i < this.a.length; ++i) {
                for (int k = 0; k < this.a[0].length; ++k) {
                    Algebraic r = this.a[i][k].map_lambda(f, arg2);
                    if (!(r instanceof Algebraic)) {
                        throw new JasymcaException("Cannot evaluate function to algebraic.");
                    }
                    b[i][k] = r;
                }
            }
        }
        return new Matrix(b);
    }

    @Override
    public Algebraic value(Variable var, Algebraic x) throws JasymcaException {
        Algebraic[][] b = new Algebraic[this.a.length][this.a[0].length];
        for (int i = 0; i < this.a.length; ++i) {
            for (int k = 0; k < this.a[0].length; ++k) {
                b[i][k] = this.a[i][k].value(var, x);
            }
        }
        return new Matrix(b);
    }

    public String toString() {
        int k;
        int i;
        int max = 0;
        String r = "";
        for (i = 0; i < this.a.length; ++i) {
            for (k = 0; k < this.a[0].length; ++k) {
                int l = StringFmt.compact(this.a[i][k].toString()).length();
                if (l <= max) continue;
                max = l;
            }
        }
        max += 2;
        for (i = 0; i < this.a.length; ++i) {
            r = r + "\n  ";
            for (k = 0; k < this.a[0].length; ++k) {
                String c = StringFmt.compact(this.a[i][k].toString());
                r = r + c;
                for (int m = 0; m < max - c.length(); ++m) {
                    r = r + " ";
                }
            }
        }
        return r;
    }

    @Override
    public void print(PrintStream p) {
        int k;
        int i;
        int max = 0;
        for (i = 0; i < this.a.length; ++i) {
            for (k = 0; k < this.a[0].length; ++k) {
                int l = StringFmt.compact(this.a[i][k].toString()).length();
                if (l <= max) continue;
                max = l;
            }
        }
        max += 2;
        for (i = 0; i < this.a.length; ++i) {
            p.print("\n  ");
            for (k = 0; k < this.a[0].length; ++k) {
                String r = StringFmt.compact(this.a[i][k].toString());
                p.print(r);
                for (int m = 0; m < max - r.length(); ++m) {
                    p.print(" ");
                }
            }
        }
    }

    @Override
    public Algebraic map(LambdaAlgebraic f) throws JasymcaException {
        Algebraic[][] cn = new Algebraic[this.a.length][this.a[0].length];
        for (int i = 0; i < this.a.length; ++i) {
            for (int k = 0; k < this.a[0].length; ++k) {
                cn[i][k] = f.f_exakt(this.a[i][k]);
            }
        }
        return new Matrix(cn);
    }

    public Matrix transpose() throws JasymcaException {
        Algebraic[][] b = new Algebraic[this.a[0].length][this.a.length];
        for (int i = 0; i < this.a.length; ++i) {
            for (int k = 0; k < this.a[0].length; ++k) {
                b[k][i] = this.a[i][k];
            }
        }
        return new Matrix(b);
    }

    public Matrix adjunkt() throws JasymcaException {
        Algebraic[][] b = new Algebraic[this.a[0].length][this.a.length];
        for (int i = 0; i < this.a.length; ++i) {
            for (int k = 0; k < this.a[0].length; ++k) {
                b[k][i] = this.a[i][k].cc();
            }
        }
        return new Matrix(b);
    }

    public Matrix invert() throws JasymcaException {
        Algebraic det = this.det();
        if (det.equals(Zahl.ZERO)) {
            throw new JasymcaException("Matrix not invertible.");
        }
        Algebraic[][] b = new Algebraic[this.a.length][this.a.length];
        if (this.a.length == 1) {
            b[0][0] = Zahl.ONE.div(det);
        } else {
            for (int i = 0; i < this.a.length; ++i) {
                for (int k = 0; k < this.a[0].length; ++k) {
                    b[i][k] = this.unterdet(k, i).div(det);
                }
            }
        }
        return new Matrix(b);
    }

    public Algebraic min() throws JasymcaException {
        Algebraic[] r = new Algebraic[this.ncol()];
        for (int i = 0; i < this.ncol(); ++i) {
            Algebraic min = this.a[0][i];
            if (!(min instanceof Zahl)) {
                throw new JasymcaException("MIN requires constant arguments.");
            }
            for (int k = 1; k < this.nrow(); ++k) {
                Algebraic x = this.a[k][i];
                if (!(x instanceof Zahl)) {
                    throw new JasymcaException("MIN requires constant arguments.");
                }
                if (!((Zahl)x).smaller((Zahl)min)) continue;
                min = x;
            }
            r[i] = min;
        }
        return new Vektor(r).reduce();
    }

    public Algebraic max() throws JasymcaException {
        Algebraic[] r = new Algebraic[this.ncol()];
        for (int i = 0; i < this.ncol(); ++i) {
            Algebraic max = this.a[0][i];
            if (!(max instanceof Zahl)) {
                throw new JasymcaException("MAX requires constant arguments.");
            }
            for (int k = 1; k < this.nrow(); ++k) {
                Algebraic x = this.a[k][i];
                if (!(x instanceof Zahl)) {
                    throw new JasymcaException("MAX requires constant arguments.");
                }
                if (!((Zahl)max).smaller((Zahl)x)) continue;
                max = x;
            }
            r[i] = max;
        }
        return new Vektor(r).reduce();
    }

    public Algebraic find() throws JasymcaException {
        Vector<Unexakt> v = new Vector<Unexakt>();
        for (int i = 0; i < this.nrow(); ++i) {
            for (int k = 0; k < this.ncol(); ++k) {
                if (Zahl.ZERO.equals(this.a[i][k])) continue;
                v.addElement(new Unexakt((double)(i * this.nrow() + k) + 1.0));
            }
        }
        Vektor vx = Vektor.create(v);
        if (this.nrow() == 1) {
            return vx;
        }
        return Matrix.column(vx);
    }

    public Polynomial charpoly(Variable x) throws JasymcaException {
        Polynomial p = new Polynomial(x);
        Matrix m = (Matrix)this.sub(Matrix.eye(this.a.length, this.a[0].length).mult(p));
        p = (Polynomial)m.det2();
        p = (Polynomial)p.rat();
        return p;
    }

    public Vektor eigenvalues() throws JasymcaException {
        SimpleVariable x = SimpleVariable.top;
        Polynomial p = this.charpoly(x);
        Algebraic[] ps = p.square_free_dec(p.var);
        Vector<Algebraic> v = new Vector<Algebraic>();
        for (int i = 0; i < ps.length; ++i) {
            if (!(ps[i] instanceof Polynomial)) continue;
            Vektor r = ((Polynomial)ps[i]).monic().roots();
            for (int k = 0; r != null && k < r.length(); ++k) {
                for (int j = 0; j <= i; ++j) {
                    v.addElement(r.get(k));
                }
            }
        }
        return Vektor.create(v);
    }

    public Algebraic det() throws JasymcaException {
        if (this.a.length != this.a[0].length) {
            return Zahl.ZERO;
        }
        switch (this.a.length) {
            case 1: {
                return this.a[0][0];
            }
            case 2: {
                return this.a[0][0].mult(this.a[1][1]).sub(this.a[0][1].mult(this.a[1][0]));
            }
            case 3: {
                return this.a[0][0].mult(this.a[1][1]).mult(this.a[2][2]).add(this.a[0][1].mult(this.a[1][2]).mult(this.a[2][0])).add(this.a[0][2].mult(this.a[1][0]).mult(this.a[2][1])).sub(this.a[0][2].mult(this.a[1][1]).mult(this.a[2][0])).sub(this.a[0][0].mult(this.a[1][2]).mult(this.a[2][1])).sub(this.a[0][1].mult(this.a[1][0]).mult(this.a[2][2]));
            }
        }
        Matrix c = this.copy();
        int perm = c.rank_decompose(null, null);
        Algebraic r = c.get(0, 0);
        for (int i = 1; i < c.nrow(); ++i) {
            r = r.mult(c.get(i, i));
        }
        return perm % 2 == 0 ? r : r.mult(Zahl.MINUS);
    }

    Algebraic det2() throws JasymcaException {
        if (this.a.length != this.a[0].length) {
            return Zahl.ZERO;
        }
        if (this.a.length < 4) {
            return this.det();
        }
        Algebraic d = this.unterdet(0, 0).mult(this.a[0][0]);
        for (int i = 1; i < this.a.length; ++i) {
            d = d.add(this.unterdet(i, 0).mult(this.a[i][0]));
        }
        return d;
    }

    public Algebraic unterdet(int i, int k) throws JasymcaException {
        if (i < 0 || i > this.a.length || k < 0 || k > this.a[0].length) {
            throw new JasymcaException("Operation not possible.");
        }
        Algebraic[][] b = new Algebraic[this.a.length - 1][this.a[0].length - 1];
        int i1 = 0;
        int i2 = 0;
        while (i1 < this.a.length - 1) {
            if (i2 == i) {
                ++i2;
            }
            int k1 = 0;
            int k2 = 0;
            while (k1 < this.a[0].length - 1) {
                if (k2 == k) {
                    ++k2;
                }
                b[i1][k1] = this.a[i2][k2];
                ++k1;
                ++k2;
            }
            ++i1;
            ++i2;
        }
        Algebraic u = new Matrix(b).det2();
        if ((i + k) % 2 == 0) {
            return u;
        }
        return u.mult(Zahl.MINUS);
    }

    int pivot(int k) throws JasymcaException {
        if (k >= this.ncol()) {
            return k;
        }
        int pivot = k;
        double maxa = this.a[k][k].norm();
        for (int i = k + 1; i < this.nrow(); ++i) {
            double dummy = this.a[i][k].norm();
            if (!(dummy > maxa)) continue;
            maxa = dummy;
            pivot = i;
        }
        if (maxa == 0.0) {
            int kn = this.pivot(k + 1);
            if (kn == k + 1) {
                return k;
            }
            return kn;
        }
        if (pivot != k) {
            for (int j = k; j < this.ncol(); ++j) {
                Algebraic dummy = this.a[pivot][j];
                this.a[pivot][j] = this.a[k][j];
                this.a[k][j] = dummy;
            }
        }
        return pivot;
    }

    private boolean row_zero(int k) {
        if (k >= this.nrow()) {
            return true;
        }
        for (int i = 0; i < this.ncol(); ++i) {
            if (this.a[k][i] == Zahl.ZERO) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean exaktq() {
        boolean exakt = true;
        for (int i = 0; i < this.a.length; ++i) {
            for (int k = 0; k < this.a[0].length; ++k) {
                exakt = exakt && this.a[i][k].exaktq();
            }
        }
        return exakt;
    }

    private void remove_row(int i) {
        int k;
        if (i >= this.nrow()) {
            return;
        }
        Algebraic[][] b = new Algebraic[this.nrow() - 1][];
        for (k = 0; k < i; ++k) {
            b[k] = this.a[k];
        }
        for (k = i + 1; k < this.nrow(); ++k) {
            b[k - 1] = this.a[k];
        }
        this.a = b;
    }

    void remove_col(int i) {
        if (i >= this.ncol()) {
            return;
        }
        Algebraic[][] b = new Algebraic[this.nrow()][this.ncol() - 1];
        for (int j = 0; j < this.nrow(); ++j) {
            int k;
            for (k = 0; k < i; ++k) {
                b[j][k] = this.a[j][k];
            }
            for (k = i + 1; k < this.ncol(); ++k) {
                b[j][k - 1] = this.a[j][k];
            }
        }
        this.a = b;
    }

    static Matrix elementary(int n, int i, int k, Algebraic m) throws JasymcaException {
        Matrix t = Matrix.eye(n, n);
        t.a[i][k] = m;
        return t;
    }

    static Matrix elementary(int n, int i, int k) throws JasymcaException {
        Matrix t = Matrix.eye(n, n);
        Zahl zahl = Zahl.ZERO;
        t.a[i][i] = zahl;
        t.a[k][k] = zahl;
        Zahl zahl2 = Zahl.ONE;
        t.a[k][i] = zahl2;
        t.a[i][k] = zahl2;
        return t;
    }

    public int rank_decompose(Matrix B, Matrix P) throws JasymcaException {
        int m = this.nrow();
        int n = this.ncol();
        int perm = 0;
        Matrix C = Matrix.eye(m, m);
        Matrix D = Matrix.eye(m, m);
        for (int k = 0; k < m - 1; ++k) {
            int pivot = this.pivot(k);
            if (pivot != k) {
                Matrix E = Matrix.elementary(m, k, pivot);
                C = (Matrix)C.mult(E);
                D = (Matrix)D.mult(E);
                ++perm;
            }
            int p = k;
            for (p = k; p < n && this.a[k][p].equals(Zahl.ZERO); ++p) {
            }
            if (p >= n) continue;
            for (int i = k + 1; i < m; ++i) {
                if (this.a[i][p].equals(Zahl.ZERO)) continue;
                Algebraic f = this.a[i][p].div(this.a[k][p]);
                this.a[i][p] = Zahl.ZERO;
                for (int j = p + 1; j < n; ++j) {
                    this.a[i][j] = this.a[i][j].sub(f.mult(this.a[k][j]));
                }
                C = (Matrix)C.mult(Matrix.elementary(m, i, k, f));
            }
        }
        int nm = Math.max(n, m);
        for (int i = nm - 1; i >= 0; --i) {
            if (!this.row_zero(i)) continue;
            this.remove_row(i);
            C.remove_col(i);
        }
        if (B != null) {
            B.a = C.a;
        }
        if (P != null) {
            P.a = D.a;
        }
        return perm;
    }

    public Matrix copy() {
        int nr = this.nrow();
        int nc = this.ncol();
        Algebraic[][] b = new Algebraic[nr][nc];
        for (int i = 0; i < nr; ++i) {
            for (int k = 0; k < nc; ++k) {
                b[i][k] = this.a[i][k];
            }
        }
        return new Matrix(b);
    }

    public Matrix pseudoinverse() throws JasymcaException {
        if (!this.det().equals(Zahl.ZERO)) {
            return this.invert();
        }
        Matrix c = this.copy();
        Matrix b = new Matrix(1, 1);
        c.rank_decompose(b, null);
        int rank = c.nrow();
        if (rank == this.nrow()) {
            Matrix ad = this.adjunkt();
            return (Matrix)ad.mult(((Matrix)this.mult(ad)).invert());
        }
        if (rank == this.ncol()) {
            Matrix ad = this.adjunkt();
            return (Matrix)((Matrix)ad.mult(this)).invert().mult(ad);
        }
        Matrix ca = c.adjunkt();
        Matrix ba = b.adjunkt();
        return (Matrix)ca.mult(((Matrix)c.mult(ca)).invert()).mult(((Matrix)ba.mult(b)).invert()).mult(ba);
    }
}

