/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.Matrix;
import jasymca.ParseException;
import jasymca.Unexakt;
import jasymca.Variable;
import jasymca.Zahl;
import java.util.Stack;

class LambdaSUM
extends Lambda {
    LambdaSUM() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        int narg = LambdaSUM.getNarg(st);
        if (narg == 1) {
            boolean addcols;
            Algebraic x = LambdaSUM.getAlgebraic(st);
            if (x.scalarq() && !x.constantq()) {
                throw new JasymcaException("Unknown variable dimension: " + x);
            }
            Matrix m = new Matrix(x);
            boolean bl = addcols = m.ncol() > 1;
            if (narg > 1 && LambdaSUM.getInteger(st) == 2) {
                addcols = false;
            }
            if (addcols) {
                Algebraic s = m.col(1);
                for (int i = 2; i <= m.ncol(); ++i) {
                    s = s.add(m.col(i));
                }
                st.push(s);
            } else {
                Algebraic s = m.row(1);
                for (int i = 2; i <= m.nrow(); ++i) {
                    s = s.add(m.row(i));
                }
                st.push(s);
            }
            return 0;
        }
        if (narg != 4) {
            throw new ParseException("Usage: SUM (exp, ind, lo, hi)");
        }
        Algebraic exp = LambdaSUM.getAlgebraic(st);
        Variable v = LambdaSUM.getVariable(st);
        int hi = LambdaSUM.getInteger(st);
        Algebraic sum = Zahl.ZERO;
        for (int lo = LambdaSUM.getInteger(st); lo <= hi; ++lo) {
            sum = sum.add(exp.value(v, new Unexakt(lo)));
        }
        st.push(sum);
        return 0;
    }
}

