/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.CollectExp;
import jasymca.ExpandUser;
import jasymca.FunctionVariable;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.LambdaRAT;
import jasymca.NormExp;
import jasymca.ParseException;
import jasymca.Polynomial;
import jasymca.Rational;
import jasymca.SqrtExpand;
import jasymca.TrigExpand;
import jasymca.Variable;
import jasymca.Vektor;
import jasymca.Zahl;
import java.util.Stack;
import java.util.Vector;

class LambdaSOLVE
extends Lambda {
    LambdaSOLVE() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        int narg = LambdaSOLVE.getNarg(st);
        if (narg != 2) {
            throw new ParseException("solve requires 2 arguments.");
        }
        Algebraic expr = LambdaSOLVE.getAlgebraic(st).rat();
        if (!(expr instanceof Polynomial) && !(expr instanceof Rational)) {
            throw new JasymcaException("Wrong format for Expression in solve.");
        }
        Variable var = LambdaSOLVE.getVariable(st);
        Algebraic r = LambdaSOLVE.solve(expr, var).reduce();
        st.push(r);
        return 0;
    }

    public static Algebraic linfaktor(Algebraic expr, Variable var) throws JasymcaException {
        if (expr instanceof Vektor) {
            Algebraic[] cn = new Algebraic[((Vektor)expr).length()];
            for (int i = 0; i < ((Vektor)expr).length(); ++i) {
                cn[i] = LambdaSOLVE.linfaktor(((Vektor)expr).get(i), var);
            }
            return new Vektor(cn);
        }
        return new Polynomial(var).sub(expr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Vektor solve(Algebraic expr, Variable var) throws JasymcaException {
        LambdaSOLVE.p("Solve: " + expr + " = 0, Variable: " + var);
        expr = new ExpandUser().f_exakt(expr);
        expr = new TrigExpand().f_exakt(expr);
        LambdaSOLVE.p("TrigExpand: " + expr);
        expr = new NormExp().f_exakt(expr);
        LambdaSOLVE.p("Norm: " + expr);
        expr = new CollectExp(expr).f_exakt(expr);
        LambdaSOLVE.p("Collect: " + expr);
        expr = new SqrtExpand().f_exakt(expr);
        LambdaSOLVE.p("SqrtExpand: " + expr);
        if (expr instanceof Rational && (expr = new LambdaRAT().f_exakt(expr)) instanceof Rational) {
            expr = ((Rational)expr).nom;
        }
        LambdaSOLVE.p("Canonic Expression: " + expr);
        if (!(expr instanceof Polynomial)) throw new JasymcaException("Expression does not depend of variable.");
        if (!((Polynomial)expr).depends(var)) {
            throw new JasymcaException("Expression does not depend of variable.");
        }
        Polynomial p = (Polynomial)expr;
        Vektor sol = null;
        Vector dep = LambdaSOLVE.depvars(p, var);
        if (dep.size() == 0) {
            throw new JasymcaException("Expression does not depend of variable.");
        }
        if (dep.size() == 1) {
            Variable dvar = (Variable)dep.elementAt(0);
            LambdaSOLVE.p("Found one Variable: " + dvar);
            sol = p.solve(dvar);
            LambdaSOLVE.p("Solution: " + dvar + " = " + sol);
            if (dvar.equals(var)) return sol;
            Vector<Algebraic> s = new Vector<Algebraic>();
            int i = 0;
            while (i < sol.length()) {
                LambdaSOLVE.p("Invert: " + sol.get(i) + " = " + dvar);
                Algebraic sl = LambdaSOLVE.finvert((FunctionVariable)dvar, sol.get(i));
                LambdaSOLVE.p("Result: " + sl + " = 0");
                Vektor t = LambdaSOLVE.solve(sl, var);
                LambdaSOLVE.p("Solution: " + var + " = " + t);
                for (int k = 0; k < t.length(); ++k) {
                    Algebraic tn = t.get(k);
                    if (s.contains(tn)) continue;
                    s.addElement(tn);
                }
                ++i;
            }
            return Vektor.create(s);
        }
        if (dep.size() != 2) throw new JasymcaException("Can not solve equation.");
        LambdaSOLVE.p("Found two Variables: " + dep.elementAt(0) + ", " + dep.elementAt(1));
        if (!dep.contains(var)) throw new JasymcaException("Can not solve equation.");
        FunctionVariable f = (FunctionVariable)(dep.elementAt(0).equals(var) ? dep.elementAt(1) : dep.elementAt(0));
        if (!f.fname.equals("sqrt")) throw new JasymcaException("Can not solve equation.");
        LambdaSOLVE.p("Solving " + p + " for " + f);
        sol = p.solve(f);
        LambdaSOLVE.p("Solution: " + f + " = " + sol);
        Vector<Algebraic> s = new Vector<Algebraic>();
        int i = 0;
        while (i < sol.length()) {
            LambdaSOLVE.p("Invert: " + sol.get(i) + " = " + f);
            Algebraic sl = LambdaSOLVE.finvert(f, sol.get(i));
            LambdaSOLVE.p("Result: " + sl + " = 0");
            if (!(sl instanceof Polynomial)) throw new JasymcaException("Could not solve equation.");
            if (LambdaSOLVE.depvars((Polynomial)sl, var).size() != 1) throw new JasymcaException("Could not solve equation.");
            LambdaSOLVE.p("Solving " + sl + " for " + var);
            Vektor t = LambdaSOLVE.solve(sl, var);
            LambdaSOLVE.p("Solution: " + var + " = " + t);
            for (int k = 0; k < t.length(); ++k) {
                Algebraic tn = t.get(k);
                if (s.contains(tn)) continue;
                s.addElement(tn);
            }
            ++i;
        }
        return Vektor.create(s);
    }

    private static Vector depvars(Polynomial p, Variable var) throws JasymcaException {
        Vector<Variable> r = new Vector<Variable>();
        if (!p.var.deriv(var).equals(Zahl.ZERO)) {
            r.addElement(p.var);
        }
        for (int i = 0; i < p.a.length; ++i) {
            Vector c;
            if (!(p.a[i] instanceof Polynomial) || (c = LambdaSOLVE.depvars((Polynomial)p.a[i], var)).size() <= 0) continue;
            for (int k = 0; k < c.size(); ++k) {
                Object v = c.elementAt(k);
                if (r.contains(v)) continue;
                r.addElement((Variable)v);
            }
        }
        return r;
    }

    static Algebraic finvert(FunctionVariable f, Algebraic b) throws JasymcaException {
        if (f.fname.equals("sqrt")) {
            return b.mult(b).sub(f.arg);
        }
        if (f.fname.equals("exp")) {
            return FunctionVariable.create("log", b).sub(f.arg);
        }
        if (f.fname.equals("log")) {
            return FunctionVariable.create("exp", b).sub(f.arg);
        }
        if (f.fname.equals("tan")) {
            return FunctionVariable.create("atan", b).sub(f.arg);
        }
        if (f.fname.equals("atan")) {
            return FunctionVariable.create("tan", b).sub(f.arg);
        }
        throw new JasymcaException("Could not invert " + f);
    }
}

