/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.ExpandUser;
import jasymca.FunctionVariable;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.LambdaEXP;
import jasymca.LambdaINTEGRATE;
import jasymca.LambdaRAT;
import jasymca.NormExp;
import jasymca.ParseException;
import jasymca.Poly;
import jasymca.Polynomial;
import jasymca.Rational;
import jasymca.SimpleVariable;
import jasymca.SqrtExpand;
import jasymca.TrigExpand;
import jasymca.TrigInverseExpand;
import jasymca.Variable;
import java.util.Stack;

class LambdaODE
extends Lambda {
    LambdaODE() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        FunctionVariable vexp;
        Polynomial dn;
        Algebraic qi;
        int narg = LambdaODE.getNarg(st);
        Algebraic dgl = LambdaODE.getAlgebraic(st);
        Variable y = LambdaODE.getVariable(st);
        Variable x = LambdaODE.getVariable(st);
        Algebraic p = Poly.coefficient(dgl, y, 1);
        Algebraic q = Poly.coefficient(dgl, y, 0);
        Algebraic pi = LambdaINTEGRATE.integrate(p, x);
        if (pi instanceof Rational && !pi.exaktq()) {
            pi = new LambdaRAT().f_exakt(pi);
        }
        if ((qi = LambdaINTEGRATE.integrate(q.div(dn = new Polynomial(vexp = new FunctionVariable("exp", pi, new LambdaEXP()))), x)) instanceof Rational && !qi.exaktq()) {
            qi = new LambdaRAT().f_exakt(qi);
        }
        Polynomial cn = new Polynomial(new SimpleVariable("C"));
        Algebraic res = qi.add(cn).mult(dn);
        res = new ExpandUser().f_exakt(res);
        LambdaODE.p("User Function expand: " + res);
        res = new TrigExpand().f_exakt(res);
        LambdaODE.p("Trigexpand: " + res);
        res = new NormExp().f_exakt(res);
        LambdaODE.p("Norm: " + res);
        if (res instanceof Rational) {
            res = new LambdaRAT().f_exakt(res);
        }
        res = new TrigInverseExpand().f_exakt(res);
        LambdaODE.p("Triginverse: " + res);
        res = new SqrtExpand().f_exakt(res);
        st.push(res);
        return 0;
    }
}

