/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.Matrix;
import jasymca.ParseException;
import jasymca.Unexakt;
import jasymca.Vektor;
import java.util.Stack;
import jhplot.stat.Statistics;

class LambdaMEAN
extends Lambda {
    LambdaMEAN() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        Object values;
        Algebraic mx;
        int narg = LambdaMEAN.getNarg(st);
        Algebraic b_in = LambdaMEAN.getAlgebraic(st);
        if (!(b_in instanceof Matrix) && !(b_in instanceof Vektor)) {
            throw new JasymcaException("Must be a Matrix or Vector");
        }
        if (b_in != null && b_in instanceof Vektor) {
            mx = new Vektor(b_in);
            values = ((Vektor)mx).getDouble();
            double m = Statistics.mean((double[])values);
            st.push(new Unexakt(m));
        }
        if (b_in != null && b_in instanceof Matrix) {
            mx = new Matrix(b_in);
            values = ((Matrix)mx).getDouble();
            double[] m = Statistics.mean((double[][])values);
            st.push(new Vektor(m).reduce());
        }
        return 0;
    }
}

