/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.Matrix;
import jasymca.ParseException;
import jasymca.Vektor;
import java.util.Stack;
import org.netlib.lapack.DGESV;
import org.netlib.util.intW;

class LambdaLINSOLVE2
extends LambdaAlgebraic {
    LambdaLINSOLVE2() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        try {
            Class<?> clazz = Class.forName("org.netlib.lapack.DGESV");
        }
        catch (ClassNotFoundException ce) {
            throw new JasymcaException("JLAPACK not available.");
        }
        int narg = LambdaLINSOLVE2.getNarg(st);
        if (narg != 2) {
            throw new JasymcaException("Usage: LINSOLVE2( A, b ).");
        }
        Matrix mx = new Matrix(LambdaLINSOLVE2.getAlgebraic(st));
        Algebraic b_in = LambdaLINSOLVE2.getAlgebraic(st);
        Matrix bx = b_in instanceof Vektor ? Matrix.column((Vektor)b_in) : new Matrix(b_in);
        double[][] a = mx.getDouble();
        double[][] b = bx.getDouble();
        int n = mx.nrow();
        int nrhs = bx.ncol();
        int[] ipiv = new int[n];
        intW info = new intW(1);
        if (n != mx.ncol() || n != bx.nrow()) {
            throw new JasymcaException("Matrix must be square.");
        }
        DGESV.DGESV((int)n, (int)nrhs, (double[][])a, (int[])ipiv, (double[][])b, (intW)info);
        if (info.val != 0) {
            throw new JasymcaException("jlapack DGESV failed.");
        }
        st.push(new Matrix(b).reduce());
        return 0;
    }
}

