/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.Unexakt;
import jasymca.Zahl;

class LambdaCOS
extends LambdaAlgebraic {
    public LambdaCOS() {
        this.diffrule = "-sin(x)";
        this.intrule = "sin(x)";
        this.trigrule = "1/2 *(exp(i*x)+exp(-i*x))";
    }

    @Override
    Zahl f(Zahl x) throws JasymcaException {
        Unexakt z = x.unexakt();
        if (z.imag == 0.0) {
            return new Unexakt(Math.cos(z.real));
        }
        return (Zahl)LambdaCOS.evalx(this.trigrule, z);
    }

    @Override
    Algebraic f_exakt(Algebraic x) throws JasymcaException {
        if (x.equals(Zahl.ZERO)) {
            return Zahl.ONE;
        }
        return null;
    }
}

