/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.Unexakt;
import jasymca.Zahl;

class LambdaASIN
extends LambdaAlgebraic {
    public LambdaASIN() {
        this.diffrule = "1/sqrt(1-x^2)";
        this.intrule = "x*asin(x)+sqrt(1-x^2)";
        this.trigrule = "-i*log(i*x+i*sqrt(1-x^2))";
    }

    @Override
    Zahl f(Zahl x) throws JasymcaException {
        Unexakt z = x.unexakt();
        if (z.imag == 0.0) {
            return new Unexakt(Math.asin(z.real));
        }
        return (Zahl)LambdaASIN.evalx(this.trigrule, z);
    }
}

