/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.text.renderers;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.gl2.GLUT;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.text.AbstractTextRenderer;
import org.jzy3d.plot3d.text.ITextRenderer;
import org.jzy3d.plot3d.text.align.Halign;
import org.jzy3d.plot3d.text.align.Valign;

public class TextBitmapRenderer
extends AbstractTextRenderer
implements ITextRenderer {
    protected static GLUT glut = new GLUT();
    protected int fontHeight = 12;
    protected int font1 = 6;
    protected int font2 = 8;

    public TextBitmapRenderer(int font1, int font2) {
        this.font1 = font1;
        this.font2 = font2;
        this.fontHeight = 12;
    }

    public TextBitmapRenderer() {
        this.font1 = 6;
        this.font2 = 8;
        this.fontHeight = 12;
    }

    public void setFontAxisTicks(int font) {
        this.font1 = font;
    }

    public void setFontAxisLabels(int font) {
        this.font2 = font;
    }

    public int getFontAxisTicks() {
        return this.font1;
    }

    public int getFontAxisLabels() {
        return this.font2;
    }

    @Override
    public void drawSimpleText(GL gl, GLU glu, Camera cam, String s, Coord3d position, Color color, int type) {
        int font = this.font1;
        if (type == 1) {
            font = this.font2;
        }
        if (gl.isGL2()) {
            gl.getGL2().glColor3f(color.r, color.g, color.b);
            gl.getGL2().glRasterPos3f(position.x, position.y, position.z);
        } else {
            GLES2CompatUtils.glColor3f(color.r, color.g, color.b);
            GLES2CompatUtils.glRasterPos3f(position.x, position.y, position.z);
        }
        glut.glutBitmapString(font, s);
    }

    @Override
    public BoundingBox3d drawText(GL gl, GLU glu, Camera cam, String text, Coord3d position, Halign halign, Valign valign, Color color, Coord2d screenOffset, Coord3d sceneOffset, int type) {
        Coord3d posReal;
        this.color(gl, color);
        int font = this.font1;
        if (type == 1) {
            font = this.font2;
        }
        Coord3d posScreen = cam.modelToScreen(gl, glu, position);
        float strlen = glut.glutBitmapLength(font, text);
        float x = this.computeXWithAlign(halign, posScreen, strlen, 0.0f);
        float y = this.computeYWithAlign(valign, posScreen, 0.0f);
        Coord3d posScreenShifted = new Coord3d(x + screenOffset.x, y + screenOffset.y, posScreen.z);
        try {
            posReal = cam.screenToModel(gl, glu, posScreenShifted);
        }
        catch (RuntimeException e) {
            System.err.println("TextBitmap.drawText(): could not process text position: " + posScreen + " " + posScreenShifted);
            return new BoundingBox3d();
        }
        this.glRasterPos(gl, sceneOffset, posReal);
        glut.glutBitmapString(font, text);
        return this.computeTextBounds(gl, glu, cam, posScreenShifted, strlen);
    }

    public void glRasterPos(GL gl, Coord3d sceneOffset, Coord3d posReal) {
        if (gl.isGL2()) {
            gl.getGL2().glRasterPos3f(posReal.x + sceneOffset.x, posReal.y + sceneOffset.y, posReal.z + sceneOffset.z);
        } else {
            GLES2CompatUtils.glRasterPos3f(posReal.x + sceneOffset.x, posReal.y + sceneOffset.y, posReal.z + sceneOffset.z);
        }
    }

    public BoundingBox3d computeTextBounds(GL gl, GLU glu, Camera cam, Coord3d posScreenShifted, float strlen) {
        Coord3d botLeft = new Coord3d();
        Coord3d topRight = new Coord3d();
        botLeft.x = posScreenShifted.x;
        botLeft.y = posScreenShifted.y;
        botLeft.z = posScreenShifted.z;
        topRight.x = botLeft.x + strlen;
        topRight.y = botLeft.y + (float)this.fontHeight;
        topRight.z = botLeft.z;
        BoundingBox3d txtBounds = new BoundingBox3d();
        txtBounds.add(cam.screenToModel(gl, glu, botLeft));
        txtBounds.add(cam.screenToModel(gl, glu, topRight));
        return txtBounds;
    }

    public void color(GL gl, Color color) {
        if (gl.isGL2()) {
            gl.getGL2().glColor3f(color.r, color.g, color.b);
        } else {
            GLES2CompatUtils.glColor3f(color.r, color.g, color.b);
        }
    }

    public float computeYWithAlign(Valign valign, Coord3d posScreen, float y) {
        if (valign == Valign.TOP) {
            y = posScreen.y;
        } else if (valign == Valign.GROUND) {
            y = posScreen.y;
        } else if (valign == Valign.CENTER) {
            y = posScreen.y - (float)(this.fontHeight / 2);
        } else if (valign == Valign.BOTTOM) {
            y = posScreen.y - (float)this.fontHeight;
        }
        return y;
    }

    public float computeXWithAlign(Halign halign, Coord3d posScreen, float strlen, float x) {
        if (halign == Halign.RIGHT) {
            x = posScreen.x;
        } else if (halign == Halign.CENTER) {
            x = posScreen.x - strlen / 2.0f;
        } else if (halign == Halign.LEFT) {
            x = posScreen.x - strlen;
        }
        return x;
    }
}

