/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.text.drawable.cells;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.IntegerCoord2d;
import org.jzy3d.plot3d.rendering.textures.BufferedImageTexture;
import org.jzy3d.plot3d.text.align.Halign;
import org.jzy3d.plot3d.text.drawable.TextImageRenderer;

public class TextCellRenderer
extends TextImageRenderer {
    protected static int OFFSET_CONSTANT = 13;
    protected int n;
    protected Halign h = Halign.LEFT;
    protected Color borderColor = Color.RED;
    protected Color backgroundColor = Color.WHITE;
    protected Color textColor = Color.BLACK;
    protected boolean drawBorder = true;
    protected boolean drawText = true;
    protected Coord3d sceneOffset;

    public TextCellRenderer(int n, String txt, Font font) {
        this(n, txt, font, Halign.LEFT, true);
    }

    public TextCellRenderer(int n, String txt, Font font, Halign halign, boolean drawBorder) {
        super(txt, font);
        this.n = n;
        this.h = halign;
        this.drawBorder = drawBorder;
        this.drawText = true;
        this.borderColor = Color.BLACK;
        this.textColor = Color.BLACK;
    }

    @Override
    public BufferedImageTexture getImage(float ratio) {
        IntegerCoord2d c = this.guessImageDimension(this.n, this.font);
        c.x += OFFSET_CONSTANT;
        BufferedImage img = new BufferedImage((int)((float)c.x * ratio), (int)((float)c.y * ratio), 2);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.scale(ratio, ratio);
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, c.x, c.y);
        if (this.drawBorder) {
            g.setColor(this.borderColor);
            g.drawRect(0, 0, c.x - 1, c.y - 1);
        }
        if (this.drawText) {
            g.setFont(this.font);
            int width = g.getFontMetrics().stringWidth(this.text);
            int height = g.getFontMetrics().getHeight();
            g.setColor(this.textColor);
            if (this.h == Halign.LEFT) {
                g.drawString(this.text, 1, c.y - 1 - height / 5);
            } else if (this.h == Halign.RIGHT) {
                g.drawString(this.text, c.x - width, c.y - 1 - height / 5);
            } else if (this.h == Halign.CENTER) {
                g.drawString(this.text, c.x / 2 - width / 2, c.y - 1 - height / 5);
            }
        }
        return new BufferedImageTexture(img);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public boolean isBorderDisplayed() {
        return this.drawBorder;
    }

    public void setBorderDisplayed(boolean drawBorder) {
        this.drawBorder = drawBorder;
    }

    public boolean isTextDisplayed() {
        return this.drawText;
    }

    public void setTextDisplayed(boolean drawText) {
        this.drawText = drawText;
    }

    public int getCharacterWidth() {
        return this.n;
    }

    public void setCharacterWidth(int n) {
        this.n = n;
    }

    public Halign getHorizontalAlignement() {
        return this.h;
    }

    public void setHorizontalAlignement(Halign h) {
        this.h = h;
    }

    public Coord3d getSceneOffset() {
        return this.sceneOffset;
    }

    public void setSceneOffset(Coord3d sceneOffset) {
        this.sceneOffset = sceneOffset;
    }

    protected IntegerCoord2d guessImageDimension(int n, Font font) {
        BufferedImage img = new BufferedImage(1, 1, 2);
        Graphics g = img.getGraphics();
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D r = fm.getMaxCharBounds(g);
        return new IntegerCoord2d((int)((double)n * r.getWidth()), fm.getHeight());
    }
}

