/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.tooltips;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.IntegerCoord2d;
import org.jzy3d.plot3d.rendering.tooltips.IAction;
import org.jzy3d.plot3d.rendering.tooltips.IInteractiveTooltipRenderer;

public class InteractiveTooltip
implements IInteractiveTooltipRenderer {
    protected Coord3d target;
    protected String content;
    protected IAction action;
    protected IntegerCoord2d screenLocation;
    protected Rectangle lastBounds;

    public InteractiveTooltip(Coord3d target, String content, IntegerCoord2d screenLocation) {
        this(target, content, screenLocation, null);
    }

    public InteractiveTooltip(Coord3d target, String content, IntegerCoord2d screenLocation, IAction action) {
        this.target = target;
        this.action = action;
        this.content = content;
        this.screenLocation = screenLocation;
    }

    @Override
    public Rectangle getLastBounds() {
        return this.lastBounds;
    }

    @Override
    public void render(Graphics2D g2d) {
        this.lastBounds = new Rectangle(this.screenLocation.x - 10, this.screenLocation.y - 13, 10 + this.content.length() * 6, 16);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(this.lastBounds.x, this.lastBounds.y, this.lastBounds.width, this.lastBounds.height);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(this.lastBounds.x, this.lastBounds.y, this.lastBounds.width, this.lastBounds.height);
        g2d.drawString(this.content, this.screenLocation.x, this.screenLocation.y);
    }

    @Override
    public void updateScreenPosition(IntegerCoord2d position) {
        this.screenLocation = position;
    }
}

