/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.scene;

import java.util.List;
import java.util.Vector;
import org.jzy3d.chart.factories.ChartComponentFactory;
import org.jzy3d.chart.factories.IChartComponentFactory;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.lights.Light;
import org.jzy3d.plot3d.rendering.lights.LightSet;
import org.jzy3d.plot3d.rendering.scene.Graph;
import org.jzy3d.plot3d.rendering.view.View;

public class Scene {
    protected Vector<View> views;
    protected Graph graph;
    protected LightSet lightSet;
    protected IChartComponentFactory factory;

    public Scene() {
        this(false);
    }

    public Scene(boolean graphsort) {
        this(graphsort, new ChartComponentFactory());
    }

    public Scene(boolean graphsort, IChartComponentFactory factory) {
        this.graph = factory.newGraph(this, factory.newOrderingStrategy(), graphsort);
        this.lightSet = new LightSet();
        this.views = new Vector();
        this.factory = factory;
    }

    public void dispose() {
        this.graph.dispose();
        for (View v : this.views) {
            v.dispose();
        }
        this.views.clear();
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setLightSet(LightSet lightSet) {
        this.lightSet = lightSet;
    }

    public LightSet getLightSet() {
        return this.lightSet;
    }

    public void add(List<AbstractDrawable> drawables) {
        this.graph.add(drawables);
    }

    public void add(AbstractDrawable drawable) {
        this.graph.add(drawable);
    }

    public void add(AbstractDrawable drawable, boolean updateViews) {
        this.graph.add(drawable, updateViews);
    }

    public void remove(AbstractDrawable drawable, boolean updateViews) {
        this.graph.remove(drawable, updateViews);
    }

    public void remove(AbstractDrawable drawable) {
        this.graph.remove(drawable);
    }

    public void add(Light drawable) {
        this.lightSet.add(drawable);
    }

    public void remove(Light drawable) {
        this.lightSet.remove(drawable);
    }

    public View newView(ICanvas canvas, Quality quality) {
        View view = this.factory.newView(this, canvas, quality);
        this.views.add(view);
        return view;
    }

    public void clearView(View view) {
        this.views.remove(view);
        view.dispose();
    }

    public String toString() {
        return this.graph.toString();
    }
}

