/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class GLImage {
    protected static final int SIZE_BYTE = 1;

    public static ByteBuffer getImageAsGlByteBuffer(Image image, int width, int height) {
        int[] px = GLImage.getImagePixels(image, width, height);
        return GLImage.convertImagePixels(px, width, height, true);
    }

    public static int[] getImagePixels(Image image, int width, int height) {
        int[] pixels = null;
        if (image != null) {
            pixels = new int[width * height];
            PixelGrabber pg = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
            try {
                pg.grabPixels();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return pixels;
    }

    public static ByteBuffer convertImagePixels(int[] jpixels, int imgw, int imgh, boolean flipVertically) {
        if (flipVertically) {
            jpixels = GLImage.flipPixels(jpixels, imgw, imgh);
        }
        byte[] bytes = GLImage.convertARGBtoRGBA(jpixels);
        return GLImage.allocBytes(bytes);
    }

    public static int[] flipPixels(int[] imgPixels, int imgw, int imgh) {
        int[] flippedPixels = null;
        if (imgPixels != null) {
            flippedPixels = new int[imgw * imgh];
            for (int y = 0; y < imgh; ++y) {
                for (int x = 0; x < imgw; ++x) {
                    flippedPixels[(imgh - y - 1) * imgw + x] = imgPixels[y * imgw + x];
                }
            }
        }
        return flippedPixels;
    }

    public static byte[] convertARGBtoRGBA(int[] jpixels) {
        byte[] bytes = new byte[jpixels.length * 4];
        int j = 0;
        for (int i = 0; i < jpixels.length; ++i) {
            int p = jpixels[i];
            int a = p >> 24 & 0xFF;
            int r = p >> 16 & 0xFF;
            int g = p >> 8 & 0xFF;
            int b = p >> 0 & 0xFF;
            bytes[j + 0] = (byte)r;
            bytes[j + 1] = (byte)g;
            bytes[j + 2] = (byte)b;
            bytes[j + 3] = (byte)a;
            j += 4;
        }
        return bytes;
    }

    public static byte[] getRGBABytes(int[] jpixels) {
        byte[] bytes = new byte[jpixels.length * 4];
        int j = 0;
        for (int i = 0; i < jpixels.length; ++i) {
            int p = jpixels[i];
            int r = p >> 24 & 0xFF;
            int g = p >> 16 & 0xFF;
            int b = p >> 8 & 0xFF;
            int a = p >> 0 & 0xFF;
            bytes[j + 0] = (byte)r;
            bytes[j + 1] = (byte)g;
            bytes[j + 2] = (byte)b;
            bytes[j + 3] = (byte)a;
            j += 4;
        }
        return bytes;
    }

    public static ByteBuffer allocBytes(byte[] bytearray) {
        ByteBuffer bb = ByteBuffer.allocateDirect(bytearray.length * 1).order(ByteOrder.nativeOrder());
        bb.put(bytearray).flip();
        return bb;
    }

    public static ByteBuffer toByteBuffer(Image img, int imgWidth, int imgHeight) {
        WritableRaster raster = Raster.createInterleavedRaster(0, imgWidth, imgHeight, 4, null);
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
        BufferedImage bufImg = new BufferedImage(colorModel, raster, false, null);
        Graphics2D g = bufImg.createGraphics();
        AffineTransform gt = new AffineTransform();
        gt.translate(0.0, imgHeight);
        gt.scale(1.0, -1.0);
        g.transform(gt);
        g.drawImage(img, null, null);
        DataBufferByte imgBuf = (DataBufferByte)raster.getDataBuffer();
        byte[] imgRGBA = imgBuf.getData();
        ByteBuffer bb = ByteBuffer.allocateDirect(imgRGBA.length).order(ByteOrder.nativeOrder());
        bb.put(imgRGBA).flip();
        return bb;
    }
}

