/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.canvas;

import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Panel;
import java.io.File;
import java.io.IOException;
import org.jzy3d.chart.factories.IChartComponentFactory;
import org.jzy3d.plot3d.rendering.canvas.IScreenCanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.view.Renderer3d;
import org.jzy3d.plot3d.rendering.view.View;

public class CanvasNewtAwt
extends Panel
implements IScreenCanvas {
    protected View view;
    protected Renderer3d renderer;
    protected Animator animator;
    protected GLWindow window;
    protected NewtCanvasAWT canvas;
    private static final long serialVersionUID = 8578690050666237742L;

    public CanvasNewtAwt(IChartComponentFactory factory, Scene scene, Quality quality, GLCapabilitiesImmutable glci) {
        this(factory, scene, quality, glci, false, false);
    }

    public CanvasNewtAwt(IChartComponentFactory factory, Scene scene, Quality quality, GLCapabilitiesImmutable glci, boolean traceGL, boolean debugGL) {
        this.window = GLWindow.create(glci);
        this.canvas = new NewtCanvasAWT(this.window);
        this.view = scene.newView(this, quality);
        this.renderer = factory.newRenderer(this.view, traceGL, debugGL);
        this.window.addGLEventListener(this.renderer);
        if (quality.isPreserveViewportSize()) {
            this.setPixelScale(new float[]{1.0f, 1.0f});
        }
        this.setFocusable(true);
        this.requestFocusInWindow();
        this.window.setAutoSwapBufferMode(quality.isAutoSwapBuffer());
        if (quality.isAnimated()) {
            this.animator = new Animator(this.window);
            this.getAnimator().start();
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.canvas, "Center");
    }

    @Override
    public void setPixelScale(float[] scale) {
        if (scale != null) {
            this.window.setSurfaceScale(scale);
        } else {
            this.window.setSurfaceScale(new float[]{1.0f, 1.0f});
        }
    }

    public GLWindow getWindow() {
        return this.window;
    }

    public NewtCanvasAWT getCanvas() {
        return this.canvas;
    }

    @Override
    public GLDrawable getDrawable() {
        return this.window;
    }

    @Override
    public void dispose() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (CanvasNewtAwt.this.animator != null && CanvasNewtAwt.this.animator.isStarted()) {
                    CanvasNewtAwt.this.animator.stop();
                }
                if (CanvasNewtAwt.this.renderer != null) {
                    CanvasNewtAwt.this.renderer.dispose(CanvasNewtAwt.this.window);
                }
                CanvasNewtAwt.this.canvas.destroy();
                CanvasNewtAwt.this.window = null;
                CanvasNewtAwt.this.renderer = null;
                CanvasNewtAwt.this.view = null;
                CanvasNewtAwt.this.animator = null;
            }
        }).start();
    }

    @Override
    public void display() {
        this.window.display();
    }

    @Override
    public void forceRepaint() {
        this.display();
    }

    @Override
    public GLAnimatorControl getAnimator() {
        return this.window.getAnimator();
    }

    @Override
    public TextureData screenshot() {
        this.renderer.nextDisplayUpdateScreenshot();
        this.display();
        return this.renderer.getLastScreenshot();
    }

    @Override
    public TextureData screenshot(File file) throws IOException {
        TextureData screen = this.screenshot();
        TextureIO.write(screen, file);
        return screen;
    }

    @Override
    public String getDebugInfo() {
        GL gl = this.getView().getCurrentGL();
        StringBuffer sb = new StringBuffer();
        sb.append("Chosen GLCapabilities: " + this.window.getChosenGLCapabilities() + "\n");
        sb.append("GL_VENDOR: " + gl.glGetString(7936) + "\n");
        sb.append("GL_RENDERER: " + gl.glGetString(7937) + "\n");
        sb.append("GL_VERSION: " + gl.glGetString(7938) + "\n");
        return sb.toString();
    }

    @Override
    public int getRendererWidth() {
        return this.renderer != null ? this.renderer.getWidth() : 0;
    }

    @Override
    public int getRendererHeight() {
        return this.renderer != null ? this.renderer.getHeight() : 0;
    }

    @Override
    public Renderer3d getRenderer() {
        return this.renderer;
    }

    @Override
    public View getView() {
        return this.view;
    }

    public synchronized void addKeyListener(KeyListener l) {
        this.getWindow().addKeyListener(l);
    }

    public void addMouseListener(MouseListener l) {
        this.getWindow().addMouseListener(l);
    }

    public void removeMouseListener(MouseListener l) {
        this.getWindow().removeMouseListener(l);
    }

    public void removeKeyListener(KeyListener l) {
        this.getWindow().removeKeyListener(l);
    }

    @Override
    public void addMouseController(Object o) {
        this.addMouseListener((MouseListener)o);
    }

    @Override
    public void addKeyController(Object o) {
        this.addKeyListener((KeyListener)o);
    }

    @Override
    public void removeMouseController(Object o) {
        this.removeMouseListener((MouseListener)o);
    }

    @Override
    public void removeKeyController(Object o) {
        this.removeKeyListener((KeyListener)o);
    }
}

