/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.canvas;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.IOException;
import org.jzy3d.chart.Settings;
import org.jzy3d.chart.factories.IChartComponentFactory;
import org.jzy3d.plot3d.rendering.canvas.IScreenCanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.view.Renderer3d;
import org.jzy3d.plot3d.rendering.view.View;

public class CanvasAWT
extends GLCanvas
implements IScreenCanvas {
    protected View view;
    protected Renderer3d renderer;
    protected Animator animator;
    private static final long serialVersionUID = 980088854683562436L;

    public CanvasAWT(IChartComponentFactory factory, Scene scene, Quality quality) {
        this(factory, scene, quality, Settings.getInstance().getGLCapabilities());
    }

    public CanvasAWT(IChartComponentFactory factory, Scene scene, Quality quality, GLCapabilitiesImmutable glci) {
        this(factory, scene, quality, glci, false, false);
    }

    public CanvasAWT(IChartComponentFactory factory, Scene scene, Quality quality, GLCapabilitiesImmutable glci, boolean traceGL, boolean debugGL) {
        super(glci);
        this.view = scene.newView(this, quality);
        this.renderer = factory.newRenderer(this.view, traceGL, debugGL);
        this.addGLEventListener(this.renderer);
        this.setAutoSwapBufferMode(quality.isAutoSwapBuffer());
        if (quality.isAnimated()) {
            this.animator = new Animator(this);
            this.getAnimator().start();
        }
        if (quality.isPreserveViewportSize()) {
            this.setPixelScale(new float[]{1.0f, 1.0f});
        }
    }

    @Override
    public void setPixelScale(float[] scale) {
        if (scale != null) {
            this.setSurfaceScale(scale);
        } else {
            this.setSurfaceScale(new float[]{1.0f, 1.0f});
        }
    }

    @Override
    public void dispose() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (CanvasAWT.this.animator != null) {
                    CanvasAWT.this.animator.stop();
                }
                CanvasAWT.this.renderer = null;
                CanvasAWT.this.view = null;
            }
        }).start();
    }

    @Override
    public String getDebugInfo() {
        GL gl = this.getView().getCurrentGL();
        StringBuffer sb = new StringBuffer();
        sb.append("Chosen GLCapabilities: " + this.getChosenGLCapabilities() + "\n");
        sb.append("GL_VENDOR: " + gl.glGetString(7936) + "\n");
        sb.append("GL_RENDERER: " + gl.glGetString(7937) + "\n");
        sb.append("GL_VERSION: " + gl.glGetString(7938) + "\n");
        return sb.toString();
    }

    @Override
    public void forceRepaint() {
        this.display();
    }

    @Override
    public TextureData screenshot(File file) throws IOException {
        TextureData screen = this.screenshot();
        TextureIO.write(screen, file);
        return screen;
    }

    @Override
    public TextureData screenshot() {
        this.renderer.nextDisplayUpdateScreenshot();
        this.display();
        return this.renderer.getLastScreenshot();
    }

    public void triggerMouseEvent(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void triggerMouseMotionEvent(MouseEvent e) {
        this.processMouseMotionEvent(e);
    }

    public void triggerMouseWheelEvent(MouseWheelEvent e) {
        this.processMouseWheelEvent(e);
    }

    @Override
    public void addMouseController(Object o) {
        this.addMouseListener((MouseListener)o);
        if (o instanceof MouseWheelListener) {
            this.addMouseWheelListener((MouseWheelListener)o);
        }
        if (o instanceof MouseMotionListener) {
            this.addMouseMotionListener((MouseMotionListener)o);
        }
    }

    @Override
    public void addKeyController(Object o) {
        this.addKeyListener((KeyListener)o);
    }

    @Override
    public void removeMouseController(Object o) {
        this.removeMouseListener((MouseListener)o);
        if (o instanceof MouseWheelListener) {
            this.removeMouseWheelListener((MouseWheelListener)o);
        }
        if (o instanceof MouseMotionListener) {
            this.removeMouseMotionListener((MouseMotionListener)o);
        }
    }

    @Override
    public void removeKeyController(Object o) {
        this.removeKeyListener((KeyListener)o);
    }

    @Override
    public GLDrawable getDrawable() {
        return this;
    }

    @Override
    public Renderer3d getRenderer() {
        return this.renderer;
    }

    @Override
    public View getView() {
        return this.view;
    }

    @Override
    public int getRendererWidth() {
        return this.renderer != null ? this.renderer.getWidth() : 0;
    }

    @Override
    public int getRendererHeight() {
        return this.renderer != null ? this.renderer.getHeight() : 0;
    }
}

