/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.textured;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.ConvexHull;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.PlaneAxis;
import org.jzy3d.maths.Polygon2d;
import org.jzy3d.plot3d.primitives.AbstractComposite;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.selectable.Selectable;
import org.jzy3d.plot3d.primitives.textured.DrawableTexture;
import org.jzy3d.plot3d.primitives.textured.ITranslucent;
import org.jzy3d.plot3d.primitives.textured.MaskPair;
import org.jzy3d.plot3d.rendering.view.Camera;

public class TexturedCube
extends AbstractComposite
implements Selectable,
ITranslucent {
    protected AbstractDrawable north;
    protected AbstractDrawable south;
    protected AbstractDrawable west;
    protected AbstractDrawable east;
    protected AbstractDrawable near;
    protected AbstractDrawable far;
    protected AbstractDrawable northBg;
    protected AbstractDrawable southBg;
    protected AbstractDrawable westBg;
    protected AbstractDrawable eastBg;
    protected AbstractDrawable nearBg;
    protected AbstractDrawable farBg;
    protected List<Coord3d> lastProjection;
    protected Polygon2d lastHull;
    protected float alpha;

    public TexturedCube(MaskPair masks) {
        this(new Coord3d(), Color.CYAN, Color.RED, masks);
    }

    public TexturedCube(Coord3d position, MaskPair masks) {
        this(position, Color.CYAN, Color.RED, masks);
    }

    public TexturedCube(Coord3d position, Color color, Color bgcolor, MaskPair masks) {
        float width = 0.5f;
        ArrayList<Coord2d> zmapping = new ArrayList<Coord2d>(4);
        zmapping.add(new Coord2d(position.x - width, position.y - width));
        zmapping.add(new Coord2d(position.x + width, position.y - width));
        zmapping.add(new Coord2d(position.x + width, position.y + width));
        zmapping.add(new Coord2d(position.x - width, position.y + width));
        ArrayList<Coord2d> ymapping = new ArrayList<Coord2d>(4);
        ymapping.add(new Coord2d(position.x - width, position.z - width));
        ymapping.add(new Coord2d(position.x + width, position.z - width));
        ymapping.add(new Coord2d(position.x + width, position.z + width));
        ymapping.add(new Coord2d(position.x - width, position.z + width));
        ArrayList<Coord2d> xmapping = new ArrayList<Coord2d>(4);
        xmapping.add(new Coord2d(position.y - width, position.z - width));
        xmapping.add(new Coord2d(position.y + width, position.z - width));
        xmapping.add(new Coord2d(position.y + width, position.z + width));
        xmapping.add(new Coord2d(position.y - width, position.z + width));
        this.northBg = new DrawableTexture(masks.bgMask, PlaneAxis.Z, position.z + width, zmapping, bgcolor);
        this.southBg = new DrawableTexture(masks.bgMask, PlaneAxis.Z, position.z - width, zmapping, bgcolor);
        this.westBg = new DrawableTexture(masks.bgMask, PlaneAxis.X, position.x - width, xmapping, bgcolor);
        this.eastBg = new DrawableTexture(masks.bgMask, PlaneAxis.X, position.x + width, xmapping, bgcolor);
        this.nearBg = new DrawableTexture(masks.bgMask, PlaneAxis.Y, position.y - width, ymapping, bgcolor);
        this.farBg = new DrawableTexture(masks.bgMask, PlaneAxis.Y, position.y + width, ymapping, bgcolor);
        this.north = new DrawableTexture(masks.symbolMask, PlaneAxis.Z, position.z + width, zmapping, color);
        this.south = new DrawableTexture(masks.symbolMask, PlaneAxis.Z, position.z - width, zmapping, color);
        this.west = new DrawableTexture(masks.symbolMask, PlaneAxis.X, position.x - width, xmapping, color);
        this.east = new DrawableTexture(masks.symbolMask, PlaneAxis.X, position.x + width, xmapping, color);
        this.near = new DrawableTexture(masks.symbolMask, PlaneAxis.Y, position.y - width, ymapping, color);
        this.far = new DrawableTexture(masks.symbolMask, PlaneAxis.Y, position.y + width, ymapping, color);
        this.add(this.north);
        this.add(this.south);
        this.add(this.west);
        this.add(this.east);
        this.add(this.near);
        this.add(this.far);
        this.add(this.northBg);
        this.add(this.southBg);
        this.add(this.westBg);
        this.add(this.eastBg);
        this.add(this.nearBg);
        this.add(this.farBg);
        this.bbox = new BoundingBox3d(position, width * 2.0f);
    }

    @Override
    public BoundingBox3d getBounds() {
        return this.bbox;
    }

    @Override
    public void project(GL gl, GLU glu, Camera cam) {
        this.lastProjection = cam.modelToScreen(gl, glu, this.getBounds().getVertices());
        this.lastHull = ConvexHull.hull(this.lastProjection);
    }

    @Override
    public Polygon2d getHull2d() {
        return this.lastHull;
    }

    @Override
    public List<Coord3d> getLastProjection() {
        return this.lastProjection;
    }

    @Override
    public void setAlphaFactor(float a) {
        this.alpha = a;
        ((DrawableTexture)this.northBg).setAlphaFactor(this.alpha);
        ((DrawableTexture)this.southBg).setAlphaFactor(this.alpha);
        ((DrawableTexture)this.westBg).setAlphaFactor(this.alpha);
        ((DrawableTexture)this.eastBg).setAlphaFactor(this.alpha);
        ((DrawableTexture)this.nearBg).setAlphaFactor(this.alpha);
        ((DrawableTexture)this.farBg).setAlphaFactor(this.alpha);
        ((DrawableTexture)this.north).setAlphaFactor(this.alpha);
        ((DrawableTexture)this.south).setAlphaFactor(this.alpha);
        ((DrawableTexture)this.west).setAlphaFactor(this.alpha);
        ((DrawableTexture)this.east).setAlphaFactor(this.alpha);
        ((DrawableTexture)this.near).setAlphaFactor(this.alpha);
        ((DrawableTexture)this.far).setAlphaFactor(this.alpha);
    }
}

